/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jmdns.DNSOutgoing;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;
import javax.jmdns.JmDNS;

public class ServiceInfo
extends JmDNS.Listener {
    public static final byte[] NO_VALUE = new byte[0];
    String type;
    String name;
    String server;
    int port;
    int weight;
    int priority;
    byte[] text;
    Hashtable props;
    InetAddress addr;

    public ServiceInfo(String type, String name, int port, String text) {
        this(type, name, port, 0, 0, text);
    }

    public ServiceInfo(String type, String name, int port, int weight, int priority, String text) {
        this(type, name, port, weight, priority, (byte[])null);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            this.writeUTF(out, text);
            this.text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfo(String type, String name, int port, int weight, int priority, Hashtable props) {
        this(type, name, port, weight, priority, new byte[0]);
        if (props != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object val = props.get(key);
                    ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                    this.writeUTF(out2, key);
                    if (val instanceof String) {
                        out2.write(61);
                        this.writeUTF(out2, (String)val);
                    } else if (val instanceof byte[]) {
                        out2.write(61);
                        byte[] bval = (byte[])val;
                        out2.write(bval, 0, bval.length);
                    } else if (val != NO_VALUE) {
                        throw new IllegalArgumentException("invalid property value: " + val);
                    }
                    byte[] data = out2.toByteArray();
                    out.write(data.length);
                    out.write(data, 0, data.length);
                }
                this.text = out.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception: " + e);
            }
        }
    }

    public ServiceInfo(String type, String name, int port, int weight, int priority, byte[] text) {
        this.type = type;
        this.name = name;
        this.port = port;
        this.weight = weight;
        this.priority = priority;
        this.text = text;
    }

    ServiceInfo(String type, String name) {
        if (!type.endsWith(".")) {
            throw new IllegalArgumentException("type must be fully qualified DNS name ending in '.': " + type);
        }
        if (name.endsWith(".")) {
            if (!name.endsWith("." + type)) {
                throw new IllegalArgumentException("service name has the wrong type: name=" + name + ", type=" + type);
            }
        } else {
            name = String.valueOf(name) + "." + type;
        }
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        if (this.type != null && this.name.endsWith("." + this.type)) {
            return this.name.substring(0, this.name.length() - (this.type.length() + 1));
        }
        return this.name;
    }

    public String getServer() {
        return this.server;
    }

    public String getAddress() {
        byte[] data = this.getInetAddress().getAddress();
        return String.valueOf(data[0] & 0xFF) + "." + (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF);
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.text;
    }

    public String getTextString() {
        if (this.text == null || this.text.length == 0 || this.text.length == 1 && this.text[0] == 0) {
            return null;
        }
        return this.readUTF(this.text, 0, this.text.length);
    }

    public String getURL() {
        return this.getURL("http");
    }

    public String getURL(String protocol) {
        String url = String.valueOf(protocol) + "://" + this.getAddress() + ":" + this.getPort();
        String path = this.getPropertyString("path");
        if (path != null) {
            url = path.indexOf("://") >= 0 ? path : String.valueOf(url) + (path.startsWith("/") ? path : "/" + path);
        }
        return url;
    }

    public synchronized byte[] getPropertyBytes(String name) {
        return (byte[])this.getProperties().get(name);
    }

    public synchronized String getPropertyString(String name) {
        byte[] data = (byte[])this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == NO_VALUE) {
            return "true";
        }
        return this.readUTF(data, 0, data.length);
    }

    public Enumeration getPropertyNames() {
        Hashtable props = this.getProperties();
        return props != null ? props.keys() : new Vector().elements();
    }

    void writeUTF(OutputStream out, String str) throws IOException {
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c & 0x3F);
            }
            ++i;
        }
    }

    String readUTF(byte[] data, int off, int len) {
        StringBuffer buf = new StringBuffer();
        int end = off + len;
        while (off < end) {
            int ch = data[off++] & 0xFF;
            switch (ch >> 4) {
                case 12: 
                case 13: {
                    if (off >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[off++] & 0x3F;
                    break;
                }
                case 14: {
                    if (off + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[off++] & 0x3F) << 6 | data[off++] & 0x3F;
                    break;
                }
                default: {
                    if (off + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[off++] & 0xF;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    synchronized Hashtable getProperties() {
        if (this.props == null && this.text != null) {
            Hashtable<String, byte[]> props = new Hashtable<String, byte[]>();
            int off = 0;
            while (off < this.text.length) {
                int len;
                if ((len = this.text[off++] & 0xFF) == 0 || off + len > this.text.length) {
                    props.clear();
                    break;
                }
                int i = 0;
                while (i < len && this.text[off + i] != 61) {
                    ++i;
                }
                String name = this.readUTF(this.text, off, i);
                if (name == null) {
                    props.clear();
                    break;
                }
                if (i == len) {
                    props.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - ++i];
                System.arraycopy(this.text, off + i, value, 0, len - i);
                props.put(name, value);
                off += len;
            }
            this.props = props;
        }
        return this.props;
    }

    void updateRecord(JmDNS jmdns, long now, DNSRecord rec) {
        if (rec != null && !rec.isExpired(now)) {
            switch (rec.type) {
                case 1: {
                    if (!rec.name.equals(this.server)) break;
                    this.addr = ((DNSRecord.Address)rec).getInetAddress();
                    break;
                }
                case 33: {
                    if (!rec.name.equals(this.name)) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    this.server = srv.server;
                    this.port = srv.port;
                    this.weight = srv.weight;
                    this.priority = srv.priority;
                    this.addr = null;
                    this.updateRecord(jmdns, now, (DNSRecord)jmdns.cache.get(this.server, 1, 1));
                    break;
                }
                case 16: {
                    if (!rec.name.equals(this.name)) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this.text = txt.text;
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean request(JmDNS jmdns, long timeout) {
        boolean $return;
        long now = System.currentTimeMillis();
        int delay = 200;
        long next = now + (long)delay;
        long last = now + timeout;
        try {
            try {
                jmdns.addListener(this, new DNSQuestion(this.name, 255, 1));
                while (true) {
                    if (this.server != null && this.addr != null && this.text != null) {
                        $return = true;
                        break;
                    }
                    if (last <= now) {
                        boolean $return2 = false;
                        Object var13_12 = null;
                        jmdns.removeListener(this);
                        return $return2;
                    }
                    if (next <= now) {
                        DNSOutgoing out = new DNSOutgoing(0);
                        out.addQuestion(new DNSQuestion(this.name, 33, 1));
                        out.addQuestion(new DNSQuestion(this.name, 16, 1));
                        if (this.server != null) {
                            out.addQuestion(new DNSQuestion(this.server, 1, 1));
                        }
                        out.addAnswer((DNSRecord)jmdns.cache.get(this.name, 33, 1), now);
                        out.addAnswer((DNSRecord)jmdns.cache.get(this.name, 16, 1), now);
                        if (this.server != null) {
                            out.addAnswer((DNSRecord)jmdns.cache.get(this.server, 1, 1), now);
                        }
                        jmdns.send(out);
                        next = now + (long)delay;
                        delay *= 2;
                    }
                    JmDNS jmDNS = jmdns;
                    synchronized (jmDNS) {
                        jmdns.wait(Math.min(next, last) - now);
                    }
                    now = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {
                boolean $return3 = false;
                Object var13_14 = null;
                jmdns.removeListener(this);
                return $return3;
            }
            catch (InterruptedException interruptedException) {
                boolean $return4 = false;
                Object var13_15 = null;
                jmdns.removeListener(this);
                return $return4;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            jmdns.removeListener(this);
            throw throwable;
        }
        Object var13_13 = null;
        jmdns.removeListener(this);
        return $return;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfo && this.name.equals(((ServiceInfo)obj).name);
    }

    public String getNiceTextString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int len = this.text.length;
        while (i < len) {
            if (i >= 20) {
                buf.append("...");
                break;
            }
            int ch = this.text[i] & 0xFF;
            if (ch < 32 || ch > 127) {
                buf.append("\\0");
                buf.append(Integer.toString(ch, 8));
            } else {
                buf.append((char)ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("service[");
        buf.append(this.name);
        buf.append(',');
        buf.append(this.getAddress());
        buf.append(':');
        buf.append(this.port);
        buf.append(',');
        buf.append(this.getNiceTextString());
        buf.append(']');
        return buf.toString();
    }
}

