/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.GUIFactory;
import com.apple.gui.table.DefaultTableHeaderRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.ViewportUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AlternatingTable
extends JTable {
    public static final int DEFAULT_ROW_HEIGHT = 20;
    private JScrollPane scrollPane;
    private MouseAdapter scrollPaneMouseListener;
    static /* synthetic */ Class class$java$lang$Object;

    public AlternatingTable() {
        this.init();
    }

    public AlternatingTable(TableModel model) {
        super(model);
        this.init();
    }

    public AlternatingTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public AlternatingTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public AlternatingTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public AlternatingTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public AlternatingTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public void columnMoved(TableColumnModelEvent e) {
        super.columnMoved(e);
        if (this.scrollPane != null) {
            this.scrollPane.repaint();
        }
    }

    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        if (this.scrollPane != null) {
            this.scrollPane.repaint();
        }
    }

    protected void init() {
        this.setRowHeight(20);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getSelectionModel().setSelectionMode(2);
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new DefaultTableHeaderRenderer());
        header.setFont(GUIFactory.FONT_SMALL);
        this.setDefaultRenderer(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AlternatingTable.class$("java.lang.Object")), new StringRenderer());
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)gp;
            JViewport viewport = this.scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            JPanel topRight = new JPanel();
            topRight.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.scrollPane.setCorner("UPPER_RIGHT_CORNER", topRight);
            JPanel bottomRight = new JPanel();
            bottomRight.setBackground(UIManager.getColor("TableHeader.background"));
            this.scrollPane.setCorner("LOWER_RIGHT_CORNER", bottomRight);
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.getHSBColor(0.0f, 0.0f, 0.67f), 1));
            this.scrollPane.getViewport().setUI(new LinedViewportUI(this, this.scrollPane));
            if (this.scrollPaneMouseListener == null) {
                this.scrollPaneMouseListener = new 1();
            }
            this.scrollPane.addMouseListener(this.scrollPaneMouseListener);
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        Container gp;
        super.unconfigureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.getViewport().updateUI();
            if (this.scrollPaneMouseListener != null) {
                scrollPane.removeMouseListener(this.scrollPaneMouseListener);
            }
        }
        this.scrollPane = null;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (AlternatingTable.this.rowAtPoint(e.getPoint()) == -1) {
                AlternatingTable.this.clearSelection();
                if (AlternatingTable.this.getEditingRow() != -1) {
                    AlternatingTable.this.getCellEditor().stopCellEditing();
                }
            }
        }

        /* synthetic */ 1() {
        }
    }

    public static class CellBorder
    implements Border {
        static final Insets INSETS = new Insets(1, 1, 1, 1);
        static final Color darkBlue = new Color(0.239f, 0.502f, 0.875f);
        static final Color darkGray = new Color(0.753f, 0.753f, 0.753f);
        static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        static final Color blueHLine = new Color(0.49f, 0.667f, 0.918f);
        static final Color grayHLine = new Color(0.878f, 0.878f, 0.878f);
        static final Color blueVLine = new Color(0.204f, 0.427f, 0.745f);
        static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        boolean selected = false;
        boolean focus = false;
        boolean rowStyle = false;

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.selected ? darkBlue : (this.rowStyle ? Color.white : lightBlue));
            g.fillRect(x, y, width, height);
            g.setColor(this.selected ? blueVLine : grayVLine);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            if (this.selected) {
                g.setColor(blueHLine);
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }

        public void setAttributes(boolean selected, boolean focus, int row) {
            this.selected = selected;
            this.focus = focus;
            this.rowStyle = (row & 1) > 0;
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        CellBorder border;
        JLabel label;

        public StringRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.border = new CellBorder();
            this.setBorder(this.border);
            this.setOpaque(false);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            this.label.setText((String)value);
            this.label.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    static class LinedViewportUI
    extends ViewportUI {
        static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        JTable table;
        JScrollPane scrollpane;

        LinedViewportUI(JTable table, JScrollPane scrollpane) {
            this.table = table;
            this.scrollpane = scrollpane;
        }

        public void paint(Graphics g, JComponent c) {
            int rowHeight = this.table.getRowHeight();
            int viewWidth = c.getWidth();
            int viewHeight = c.getHeight();
            TableColumnModel model = this.table.getColumnModel();
            int columns = model.getColumnCount();
            Point position = this.scrollpane.getViewport().getViewPosition();
            int index = 0;
            int y = -position.y;
            while (y < viewHeight) {
                g.setColor(index % 2 == 0 ? lightBlue : Color.white);
                g.fillRect(0, y, viewWidth, rowHeight);
                ++index;
                y += rowHeight;
            }
            g.setColor(grayVLine);
            int x = -position.x;
            index = 0;
            while (index < columns) {
                g.drawLine((x += model.getColumn(index).getWidth()) - 1, 0, x - 1, viewHeight);
                ++index;
            }
        }
    }

    static class AlternatingTableUI
    extends TableUI {
        private static final Color darkBlue = new Color(0.239f, 0.502f, 0.875f);
        private static final Color darkGray = new Color(0.753f, 0.753f, 0.753f);
        private static final Color lightBlue = new Color(0.929f, 0.953f, 0.996f);
        private static final Color blueHLine = new Color(0.49f, 0.667f, 0.918f);
        private static final Color grayHLine = new Color(0.878f, 0.878f, 0.878f);
        private static final Color blueVLine = new Color(0.204f, 0.427f, 0.745f);
        private static final Color grayVLine = new Color(0.851f, 0.851f, 0.851f);
        protected TableUI tableUI;
        protected JTable table;

        public AlternatingTableUI(TableUI tableUI) {
            if (tableUI == null) {
                throw new NullPointerException("UI cannot be null");
            }
            this.tableUI = tableUI;
        }

        public void installUI(JComponent c) {
            System.out.println("installUI called (table = " + c);
            this.tableUI.installUI(c);
            this.table = (JTable)c;
        }

        public void uninstallUI(JComponent c) {
            System.out.println("uninstallUI called (table = " + c);
            this.tableUI.uninstallUI(c);
            this.table = null;
        }

        public void paint(Graphics g, JComponent c) {
            if (this.table != null) {
                if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
                    return;
                }
                Rectangle clip = g.getClipBounds();
                Point minLocation = clip.getLocation();
                Point maxLocation = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
                int rMin = this.table.rowAtPoint(minLocation);
                int rMax = this.table.rowAtPoint(maxLocation);
                if (rMin == -1) {
                    rMin = 0;
                }
                if (rMax == -1) {
                    rMax = this.table.getRowCount() - 1;
                }
                int cMin = this.table.columnAtPoint(minLocation);
                int cMax = this.table.columnAtPoint(maxLocation);
                if (cMin == -1) {
                    cMin = 0;
                }
                if (cMax == -1) {
                    cMax = this.table.getColumnCount() - 1;
                }
                this.paintCells(g, rMin, rMax, cMin, cMax);
            }
            this.tableUI.paint(g, c);
        }

        public void update(Graphics g, JComponent c) {
            this.paint(g, c);
        }

        public Dimension getPreferredSize(JComponent c) {
            return this.tableUI.getPreferredSize(c);
        }

        public Dimension getMinimumSize(JComponent c) {
            return this.tableUI.getMinimumSize(c);
        }

        public Dimension getMaximumSize(JComponent c) {
            return this.tableUI.getMaximumSize(c);
        }

        public boolean contains(JComponent c, int x, int y) {
            return this.tableUI.contains(c, x, y);
        }

        public int getAccessibleChildrenCount(JComponent c) {
            return this.tableUI.getAccessibleChildrenCount(c);
        }

        public Accessible getAccessibleChild(JComponent c, int i) {
            return this.tableUI.getAccessibleChild(c, i);
        }

        private void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
            Color oldColor = g.getColor();
            JTableHeader header = this.table.getTableHeader();
            TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
            TableColumnModel cm = this.table.getColumnModel();
            int columnMargin = cm.getColumnMargin();
            int row = rMin;
            while (row <= rMax) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                int column = cMin;
                while (column <= cMax) {
                    TableColumn tableColumn = cm.getColumn(column);
                    int columnWidth = tableColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (tableColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column);
                    }
                    cellRect.x += columnWidth;
                    ++column;
                }
                ++row;
            }
            if (draggedColumn != null) {
                this.paintDraggedArea(g, rMin, rMax, draggedColumn, header.getDraggedDistance());
            }
            g.setColor(oldColor);
        }

        private void paintDraggedArea(Graphics g, int rMin, int rMax, TableColumn draggedColumn, int distance) {
            int draggedColumnIndex = this.viewIndexForColumn(draggedColumn);
            Rectangle minCell = this.table.getCellRect(rMin, draggedColumnIndex, true);
            Rectangle maxCell = this.table.getCellRect(rMax, draggedColumnIndex, true);
            Rectangle vacatedColumnRect = minCell.union(maxCell);
            vacatedColumnRect.x += distance;
            int row = rMin;
            while (row <= rMax) {
                Rectangle r = this.table.getCellRect(row, draggedColumnIndex, true);
                r.x += distance;
                this.paintCell(g, r, row, draggedColumnIndex);
                ++row;
            }
        }

        private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
            if (!this.table.isEditing() || this.table.getEditingRow() != row || this.table.getEditingColumn() != column) {
                boolean rowStyle = (row & 1) > 0;
                boolean selected = this.table.isCellSelected(row, column);
                int x = cellRect.x;
                int y = cellRect.y;
                int width = cellRect.width;
                int height = cellRect.height;
                g.setColor(darkBlue);
                g.fillRect(x, y, width, height);
                g.setColor(selected ? blueVLine : grayVLine);
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                if (selected) {
                    g.setColor(blueHLine);
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            }
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel cm = this.table.getColumnModel();
            int column = 0;
            while (column < cm.getColumnCount()) {
                if (cm.getColumn(column) == tableColumn) {
                    return column;
                }
                ++column;
            }
            return -1;
        }
    }
}

