/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.gui.PasswordField;
import com.apple.gui.RestrictedTextField;
import com.apple.gui.TextField;
import com.apple.gui.TextPane;
import com.apple.gui.menu.Menu;
import com.apple.gui.menu.MenuBar;
import com.apple.gui.menu.MenuItem;
import com.apple.util.Gestalt;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.table.TableModel;

public class GUIFactory {
    public static final Font FONT_NORMAL = new JLabel().getFont();
    public static final Font FONT_NORMAL_BOLD = FONT_NORMAL.deriveFont(1);
    public static final Font FONT_SMALL = FONT_NORMAL.deriveFont(11.0f);
    public static final Font FONT_LABEL = FONT_NORMAL.deriveFont(10.0f);
    public static final Font FONT_TINY = FONT_NORMAL.deriveFont(9.0f);
    public static final Font FONT_BADGE = FONT_NORMAL.deriveFont(9.0f);
    public static final Font FONT_PRINT = new Font(Resources.getString("eventLog.print.fontFaceName"), 0, 9);
    public static final Border TEXT_FIELD_BORDER_FIELD = new JTextField().getBorder();
    public static final Border TEXT_FIELD_BORDER_LABEL = BorderFactory.createEmptyBorder(2, 5, 2, 0);

    public static JPanel newPanel() {
        return (JPanel)GUIFactory.configureComponentForPlatform(new JPanel());
    }

    public static JPanel newPanel(LayoutManager layout) {
        return (JPanel)GUIFactory.configureComponentForPlatform(new JPanel(layout));
    }

    public static JCheckBox newCheckBox() {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox());
    }

    public static JCheckBox newCheckBox(String title) {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox(title));
    }

    public static JCheckBox newCheckBox(String title, boolean initialState) {
        return (JCheckBox)GUIFactory.configureComponentForPlatform(new JCheckBox(title, initialState));
    }

    public static JRadioButton newRadioButton() {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton());
    }

    public static JRadioButton newRadioButton(String title) {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton(title));
    }

    public static JRadioButton newRadioButton(String title, boolean initialState) {
        return (JRadioButton)GUIFactory.configureComponentForPlatform(new JRadioButton(title, initialState));
    }

    public static JButton newButton() {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton());
    }

    public static JButton newButton(String title) {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton(title));
    }

    public static JButton newButton(ImageIcon icon) {
        return (JButton)GUIFactory.configureComponentForPlatform(new JButton(icon));
    }

    public static JComboBox newComboBox() {
        return (JComboBox)GUIFactory.configureComponentForPlatform(new JComboBox());
    }

    public static JTextField newTextField() {
        return new TextField();
    }

    public static JTextField newTextField(String text) {
        return new TextField(text);
    }

    public static JTextField newTextField(int columns) {
        return new TextField(columns);
    }

    public static JTextField newTextField(String text, int columns) {
        return new TextField(text, columns);
    }

    public static RestrictedTextField newRestrictedTextField() {
        return new RestrictedTextField();
    }

    public static RestrictedTextField newRestrictedTextField(String text) {
        return new RestrictedTextField(text);
    }

    public static RestrictedTextField newRestrictedTextField(int columns) {
        return new RestrictedTextField(columns);
    }

    public static RestrictedTextField newRestrictedTextField(String text, int columns) {
        return new RestrictedTextField(text, columns);
    }

    public static JPasswordField newPasswordField() {
        return new PasswordField();
    }

    public static JPasswordField newPasswordField(int columns) {
        return new PasswordField(columns);
    }

    public static JTextPane newTextPane() {
        return new TextPane();
    }

    public static JTextPane newTextPane(String text) {
        return new TextPane(text);
    }

    public static JTextPane newTextPane(String text, int minLines) {
        return new TextPane(text, minLines);
    }

    public static JTable newTable() {
        return (JTable)GUIFactory.configureComponentForPlatform(new AlternatingTable());
    }

    public static JTable newTable(TableModel model) {
        return (JTable)GUIFactory.configureComponentForPlatform(new AlternatingTable(model));
    }

    public static JButton newOKButton() {
        return GUIFactory.newButton(Resources.getString("ok"));
    }

    public static JButton newCancelButton() {
        return GUIFactory.newButton(Resources.getString("cancel"));
    }

    public static JButton newContinueButton() {
        return GUIFactory.newButton(Resources.getString("continue"));
    }

    public static JButton newGoBackButton() {
        return GUIFactory.newButton(Resources.getString("goBack"));
    }

    public static JMenuBar newMenuBar() {
        return new MenuBar();
    }

    public static JMenu newMenu() {
        return new Menu();
    }

    public static JMenuItem newMenuItem() {
        return new MenuItem();
    }

    public static JTextField configureTextFieldAsLabel(JTextField textField) {
        if (textField != null) {
            textField.setEditable(false);
            textField.setOpaque(false);
            textField.setBorder(TEXT_FIELD_BORDER_LABEL);
        }
        return textField;
    }

    public static JTextField configureTextFieldAsField(JTextField textField) {
        if (textField != null) {
            textField.setEditable(true);
            textField.setOpaque(true);
            textField.setBorder(TEXT_FIELD_BORDER_FIELD);
        }
        return textField;
    }

    public static Component configureComponentForPlatform(Component c) {
        if (c instanceof JTextField && !(c instanceof TextField) && !(c instanceof PasswordField)) {
            new TextField.TextSelector((JTextField)c);
        } else if (c instanceof Frame) {
            GUIFactory.imposeMinimumSize(c);
        }
        if (Gestalt.isAquaLookAndFeel) {
            if (c instanceof JButton || c instanceof JCheckBox || c instanceof JRadioButton) {
                ((AbstractButton)c).setFocusPainted(Gestalt.showFocusRings);
                ((AbstractButton)c).setContentAreaFilled(false);
            } else if (c instanceof JPanel) {
                ((JPanel)c).setOpaque(false);
            } else if (c instanceof JComboBox) {
                ((JComboBox)c).setOpaque(false);
            }
        }
        return c;
    }

    private static void imposeMinimumSize(Component component) {
        component.addComponentListener(new 1());
    }

    private final class 1
    extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            this.componentResized(e);
        }

        public void componentResized(ComponentEvent e) {
            int height;
            Component c = e.getComponent();
            Dimension minSize = c.getMinimumSize();
            boolean needsResize = false;
            int width = c.getWidth();
            if (width < minSize.width) {
                width = minSize.width;
                needsResize = true;
            }
            if ((height = c.getHeight()) < minSize.height) {
                height = minSize.height;
                needsResize = true;
            }
            if (needsResize) {
                int newWidth = width;
                int newHeight = height;
                EventQueue.invokeLater(new 2(c, newHeight, newWidth));
            }
        }

        /* synthetic */ 1() {
        }
    }
}

