/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class HyperTextPane
extends JTextPane
implements MouseListener,
MouseMotionListener {
    static final int LINK_STYLE_NORMAL = 0;
    static final int LINK_STYLE_ENTERED = 1;
    static final int LINK_STYLE_ACTIVATED = 2;
    static final int LINK_STYLE_VISITED = 3;
    final Cursor NORMAL_CURSOR = Cursor.getDefaultCursor();
    final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Color DEFAULT_LINK_COLOR = Color.blue;
    static final Color DEFAULT_ACTIVE_LINK_COLOR = Color.red;
    static final Color DEFAULT_VISITED_LINK_COLOR = DEFAULT_LINK_COLOR;
    protected DefaultStyledDocument document = new DefaultStyledDocument();
    protected List links = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();
    protected Link activeLink = null;
    protected Link previousLink = null;
    protected final SimpleAttributeSet normalLinkAttribs;
    protected final SimpleAttributeSet activeLinkAttribs;
    protected final SimpleAttributeSet visitedLinkAttribs;

    public HyperTextPane(String text) {
        this.setDocument(this.document);
        this.setBackground(null);
        this.setEditable(false);
        this.normalLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.normalLinkAttribs, true);
        StyleConstants.setForeground(this.normalLinkAttribs, DEFAULT_LINK_COLOR);
        this.activeLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.activeLinkAttribs, true);
        StyleConstants.setForeground(this.activeLinkAttribs, DEFAULT_ACTIVE_LINK_COLOR);
        this.visitedLinkAttribs = new SimpleAttributeSet();
        StyleConstants.setUnderline(this.visitedLinkAttribs, true);
        StyleConstants.setForeground(this.visitedLinkAttribs, DEFAULT_VISITED_LINK_COLOR);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setText(text);
    }

    public void setText(String text) {
        HyperTextPane hyperTextPane = this;
        synchronized (hyperTextPane) {
            this.links.clear();
        }
        super.setText(text);
        this.parseText(text);
    }

    public void addLink(String text, String url) throws ParseException {
        this.addLink(text, 0, url);
    }

    public void addLink(String text, int fromIndex, String url) throws ParseException {
        int pos = this.getText().indexOf(text, fromIndex);
        if (pos == -1) {
            throw new ParseException("Text not found \"" + text + "\"", -1);
        }
        this.addLink(pos, text.length(), url);
    }

    public synchronized void addLink(int start, int len, String url) {
        if (this.getText() == null) {
            throw new IllegalArgumentException("No text inserted");
        }
        if (start < 0) {
            throw new IllegalArgumentException("Illegal start (" + start + ")");
        }
        if (len < 1) {
            throw new IllegalArgumentException("Illegal length (" + len + ")");
        }
        if (start + len > this.getText().length()) {
            throw new IllegalArgumentException("Illegal start (" + start + ") or length (" + len + ")");
        }
        Link l = new Link(start, len, url);
        this.links.add(l);
        this.setLinkStyle(l, 0);
    }

    public synchronized void removeAllLinks() {
        Style defaultStyle = this.document.getStyle("default");
        Iterator iter = this.links.iterator();
        while (iter.hasNext()) {
            Link l = (Link)iter.next();
            if (defaultStyle == null) continue;
            this.document.setCharacterAttributes(l.start, l.length, defaultStyle, true);
        }
        this.links.clear();
    }

    public synchronized void setLinkColor(Color c) {
        if (c == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.normalLinkAttribs, c);
        if (this.links.size() != 0) {
            Iterator iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = (Link)iter.next();
                if (l == this.activeLink) continue;
                this.setLinkStyle(l, 0);
            }
        }
    }

    public synchronized void setActiveLinkColor(Color c) {
        if (c == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.activeLinkAttribs, c);
        if (this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 2);
        }
    }

    public synchronized void setVisitedLinkColor(Color c) {
        if (c == null) {
            throw new NullPointerException("color cannot be null");
        }
        StyleConstants.setForeground(this.visitedLinkAttribs, c);
        if (this.links.size() != 0) {
            Iterator iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = (Link)iter.next();
                if (l == this.activeLink) continue;
                this.setLinkStyle(l, 0);
            }
        }
    }

    public void addHyperlinkListener(HyperlinkListener l) {
        this.listenerList.add(l.getClass(), l);
    }

    public void removeHyperlinkListener(HyperlinkListener l) {
        this.listenerList.remove(l.getClass(), l);
    }

    protected void fireHyperlinkEvent(HyperlinkEvent.EventType type, Link l) {
        URL u = null;
        try {
            u = new URL(l.url);
        }
        catch (MalformedURLException malformedURLException) {}
        this.fireHyperlinkEvent(new HyperlinkEvent(this, type, u, l.url));
    }

    protected void fireHyperlinkEvent(HyperlinkEvent e) {
        if (e == null) {
            throw new NullPointerException("event cannot be null");
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            HyperlinkListener listener = (HyperlinkListener)listeners[i + 1];
            EventQueue.invokeLater(new 1(e, listener));
            i -= 2;
        }
    }

    protected void setLinkStyle(Link l, int style) {
        if (style == 0) {
            SimpleAttributeSet attribs = l.visited ? this.visitedLinkAttribs : this.normalLinkAttribs;
            this.document.setCharacterAttributes(l.start, l.length, attribs, false);
        } else if (style != 1) {
            if (style == 2) {
                this.document.setCharacterAttributes(l.start, l.length, this.activeLinkAttribs, false);
            } else if (style == 3) {
                this.document.setCharacterAttributes(l.start, l.length, this.visitedLinkAttribs, false);
            }
        }
    }

    protected void parseText(String text) {
        this.parseHyperlinks(text);
    }

    private synchronized void parseHyperlinks(String text) {
        int length = text.length();
        int index = 0;
        while (index < length) {
            int start = text.indexOf("http://", index);
            if (start == -1) {
                start = text.indexOf("HTTP://", index);
            }
            if (start == -1) break;
            index = start + 7;
            while (index < length) {
                if (!Character.isLetterOrDigit(text.charAt(index)) && text.charAt(index) != '.' && text.charAt(index) != '/' && text.charAt(index) != '@' && text.charAt(index) != '-') break;
                ++index;
            }
            if (index == start) continue;
            int end = index - 1;
            if (text.charAt(end) == '.' || text.charAt(end) == '@' || text.charAt(end) == '-') {
                --end;
            }
            this.addLink(start, end - start + 1, text.substring(start, end));
        }
    }

    public synchronized void mouseDragged(MouseEvent e) {
        Link link = null;
        if (this.links.size() != 0) {
            Point p = e.getPoint();
            Iterator iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = (Link)iter.next();
                if (!l.contains(p)) continue;
                link = l;
                break;
            }
        }
        if (this.activeLink != null && (link == null || link != this.activeLink)) {
            this.previousLink = this.activeLink;
            this.activeLink = null;
        }
    }

    public synchronized void mouseMoved(MouseEvent e) {
        Link link = null;
        if (this.links.size() != 0) {
            Point p = e.getPoint();
            Iterator iter = this.links.iterator();
            while (iter.hasNext()) {
                Link l = (Link)iter.next();
                if (!l.contains(p)) continue;
                link = l;
                break;
            }
        }
        if (link == null && this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 0);
            this.setCursor(this.NORMAL_CURSOR);
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.EXITED, this.activeLink);
            this.activeLink = null;
        } else if (link != this.activeLink) {
            if (this.activeLink != null) {
                this.setLinkStyle(this.activeLink, 0);
                this.fireHyperlinkEvent(HyperlinkEvent.EventType.EXITED, this.activeLink);
            }
            this.activeLink = link;
            this.setLinkStyle(this.activeLink, 1);
            this.setCursor(this.HAND_CURSOR);
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.ENTERED, this.activeLink);
        }
    }

    public synchronized void mousePressed(MouseEvent e) {
        if (this.activeLink != null) {
            this.setLinkStyle(this.activeLink, 2);
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        if (this.activeLink != null) {
            this.fireHyperlinkEvent(HyperlinkEvent.EventType.ACTIVATED, this.activeLink);
            this.activeLink.visited = true;
            this.setLinkStyle(this.activeLink, 0);
        } else if (this.previousLink != null) {
            this.setLinkStyle(this.previousLink, 0);
            this.previousLink = null;
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ HyperlinkEvent val$e;
        private final /* synthetic */ HyperlinkListener val$listener;

        public void run() {
            this.val$listener.hyperlinkUpdate(this.val$e);
        }

        /* synthetic */ 1(HyperlinkEvent val$e, HyperlinkListener val$listener) {
            this.val$e = val$e;
            this.val$listener = val$listener;
        }
    }

    protected class Link {
        int start;
        int length;
        String url;
        boolean visited = false;
        Rectangle[] regions;

        public Link(int start, int length, String url) {
            this.start = start;
            this.length = length;
            this.url = url;
        }

        public boolean contains(Point p) {
            if (this.regions == null || this.regions.length == 0) {
                this.regions = this.calcRegions();
            }
            int i = 0;
            while (i < this.regions.length) {
                if (this.regions[i].contains(p)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link l = (Link)o;
            return l.start == this.start && l.length == this.length;
        }

        public int hashCode() {
            int result = 13;
            result = 37 * result + this.start;
            result = 37 * result + this.length;
            return result;
        }

        private Rectangle[] calcRegions() {
            ArrayList<Rectangle> regionList = new ArrayList<Rectangle>();
            Rectangle region = null;
            double y = 0.0;
            int i = this.start;
            while (i <= this.start + this.length) {
                try {
                    Rectangle r = HyperTextPane.this.modelToView(i);
                    if (r.getY() == y) {
                        region.add(r);
                    } else {
                        if (region != null) {
                            regionList.add(region);
                        }
                        region = new Rectangle(r);
                        y = region.getY();
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            if (region != null) {
                regionList.add(region);
            }
            return regionList.toArray(new Rectangle[0]);
        }
    }
}

