/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui.menu;

import com.apple.gui.menu.Menu;
import com.apple.gui.menu.MenuItem;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemMonitorWindow;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class WindowMenu
extends Menu {
    private final int STATIC_ITEM_COUNT;
    protected JMenuItem minimizeItem = new MenuItem(new MinimizeAction(this));
    protected JMenuItem toolbarItem = new MenuItem(new ToolbarAction(this));
    protected JMenuItem bringAllToFrontItem = new MenuItem(new BringAllToFrontAction());

    public WindowMenu() {
        this.add(this.minimizeItem);
        this.addSeparator();
        this.add(this.toolbarItem);
        this.addSeparator();
        this.add(this.bringAllToFrontItem);
        this.addSeparator();
        this.STATIC_ITEM_COUNT = this.getItemCount();
    }

    public void setEnabled(boolean enabled) {
        this.menuEnabled = enabled;
    }

    protected void fireMenuSelected() {
        this.updateMenu();
        super.fireMenuSelected();
    }

    protected void updateMenu() {
        Container container = this.getTopLevelAncestor();
        if (this.isMenuEnabled()) {
            if (container != null && container instanceof Frame) {
                this.minimizeItem.setEnabled(((Frame)container).getState() == 0);
            }
            this.toolbarItem.setEnabled(container != null && container instanceof SystemMonitorWindow);
        } else {
            this.minimizeItem.setEnabled(false);
            this.toolbarItem.setEnabled(false);
        }
        this.removeDynamicItems();
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            ArrayList<WindowMenuItem> sortedFrames = new ArrayList<WindowMenuItem>();
            int i = 0;
            while (i < frames.length) {
                if (frames[i].isShowing()) {
                    boolean selected = false;
                    if (container != null) {
                        selected = container.equals(frames[i]);
                    }
                    WindowMenuItem item = new WindowMenuItem(frames[i], selected);
                    item.setEnabled(this.isMenuEnabled());
                    sortedFrames.add(item);
                }
                ++i;
            }
            if (sortedFrames.size() > 0) {
                Collections.sort(sortedFrames);
                Iterator iterator = ((AbstractList)sortedFrames).iterator();
                while (iterator.hasNext()) {
                    this.add((WindowMenuItem)iterator.next());
                }
            }
        }
    }

    protected void removeDynamicItems() {
        int i = this.getItemCount() - 1;
        while (i > this.STATIC_ITEM_COUNT - 1) {
            this.remove(i);
            --i;
        }
    }

    protected JMenuBar getParentMenuBar() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JMenuBar) {
            return (JMenuBar)parent;
        }
        return null;
    }

    static class WindowMenuItem
    extends JRadioButtonMenuItem
    implements Comparable {
        protected Frame frame;

        public WindowMenuItem(Frame frame, boolean selected) {
            super(frame.getTitle(), selected);
            this.frame = frame;
        }

        protected void fireActionPerformed(ActionEvent e) {
            this.frame.toFront();
            super.fireActionPerformed(e);
        }

        public int compareTo(Object item) {
            return this.frame.getTitle().compareTo(((WindowMenuItem)item).frame.getTitle());
        }
    }

    static class MinimizeAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "minimize";
        protected JMenu parentMenu;

        public MinimizeAction(JMenu parentMenu) {
            this.parentMenu = parentMenu;
            this.putValue("Name", Resources.getString("application.menu.window.minimize"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.minimize.accelerator"));
        }

        public void actionPerformed(ActionEvent e) {
            Container c;
            if (this.parentMenu != null && (c = this.parentMenu.getTopLevelAncestor()) != null && c instanceof Frame) {
                ((Frame)c).setState(1);
            }
        }
    }

    static class BringAllToFrontAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "bringalltofront";

        public BringAllToFrontAction() {
            this.putValue("Name", Resources.getString("application.menu.window.bringAllToFront"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.bringAllToFront.accelerator"));
        }

        public void actionPerformed(ActionEvent e) {
            Frame[] frames = Frame.getFrames();
            if (frames != null) {
                int i = 0;
                while (i < frames.length) {
                    if (frames[i].isShowing()) {
                        frames[i].toFront();
                    }
                    ++i;
                }
            }
        }
    }

    static class ToolbarAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "toolbar";
        protected JMenu parentMenu;

        public ToolbarAction(JMenu parentMenu) {
            this.parentMenu = parentMenu;
            this.putValue("Name", Resources.getString("application.menu.window.toolbar.hide"));
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("AcceleratorKey", Resources.getKeyStroke("application.menu.window.toolbar.accelerator"));
        }

        public void actionPerformed(ActionEvent e) {
            Container c;
            if (this.parentMenu != null && (c = this.parentMenu.getTopLevelAncestor()) != null && c instanceof SystemMonitorWindow) {
                ((SystemMonitorWindow)c).toggleToolbar();
                if (((SystemMonitorWindow)c).isToolbarVisible()) {
                    this.putValue("Name", Resources.getString("application.menu.window.toolbar.hide"));
                } else {
                    this.putValue("Name", Resources.getString("application.menu.window.toolbar.show"));
                }
            }
        }
    }
}

