/*
 * Decompiled with CFR 0.152.
 */
package com.apple.gui.text;

import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RestrictedDocument
extends PlainDocument {
    public static final int LENGTH_UNLIMITED = 0;
    public static final int LOWERCASE_CAPITALIZATION = -1;
    public static final int NORMAL_CAPITALIZATION = 0;
    public static final int UPPERCASE_CAPITALIZATION = 1;
    public static final String ENCODING = "UTF-8";
    private int maxLength = 0;
    private int maxBytes = 0;
    private String allowedCharacters = null;
    private int capitalizationMode = 0;
    private boolean errorFeedbackEnabled = true;

    public RestrictedDocument() {
        this(null, 0);
    }

    public RestrictedDocument(String allowedCharacters, int maxLength) {
        this.allowedCharacters = allowedCharacters;
        this.maxLength = maxLength;
    }

    public void setAllowedCharacters(String allowedCharacters) {
        this.allowedCharacters = allowedCharacters;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maximum length must be positive (" + maxLength + ")");
        }
        this.maxLength = maxLength;
    }

    public void setMaxLengthBytes(int maxBytes) {
        if (maxBytes < 0) {
            throw new IllegalArgumentException("maximum bytes must be positive (" + maxBytes + ")");
        }
        this.maxBytes = maxBytes;
    }

    public void setCapitalizationMode(int mode) {
        if (mode != 0 && mode != -1 && mode != 1) {
            throw new IllegalArgumentException("illegal capitalization mode (" + mode + ")");
        }
        this.capitalizationMode = mode;
    }

    public void setErrorFeedbackEnabled(boolean enabled) {
        this.errorFeedbackEnabled = enabled;
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (this.allowedCharacters != null) {
            char[] chars = str.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (this.allowedCharacters.indexOf(chars[i]) == -1) {
                    this.rejectInsert();
                    return;
                }
                ++i;
            }
        }
        if (!(this.maxBytes == 0 && this.maxLength == 0 || this.lengthPermitted(str))) {
            this.rejectInsert();
            return;
        }
        if (this.capitalizationMode == 1) {
            str = str.toUpperCase();
        } else if (this.capitalizationMode == -1) {
            str = str.toLowerCase();
        }
        super.insertString(offset, str, a);
    }

    private void rejectInsert() {
        if (this.errorFeedbackEnabled) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean lengthPermitted(String s) throws BadLocationException {
        int length;
        String text;
        if (this.maxBytes != 0 && (text = this.getText(0, this.getLength())) != null) {
            int bytes;
            try {
                bytes = text.getBytes(ENCODING).length + s.getBytes(ENCODING).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = text.getBytes().length + s.getBytes().length;
            }
            if (bytes > this.maxBytes) {
                return false;
            }
        }
        return this.maxLength == 0 || (length = this.getLength() + s.length()) <= this.maxLength;
    }
}

