/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.util.plist.PropertyListUtilities;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class AcpEventLog {
    public static final boolean DEBUG = false;
    protected ArrayList events = new ArrayList();

    public AcpEventLog() {
    }

    public AcpEventLog(String inXML) throws Exception {
        this(inXML, -1);
    }

    public AcpEventLog(String inXML, int inControllerID) throws Exception {
        ArrayList array = (ArrayList)PropertyListUtilities.readXML(new StringReader(inXML));
        Iterator iter = ((AbstractList)array).iterator();
        while (iter.hasNext()) {
            Event event = new Event((String)iter.next());
            this.events.add(event);
        }
    }

    public AcpEventLog(Iterator inIterator) throws Exception {
        this.appendEvents(inIterator);
    }

    public AcpEventLog(Iterator inIterator, int inControllerID) throws Exception {
        this.appendEvents(inIterator, inControllerID);
    }

    public synchronized void appendEvents(Iterator inIterator) throws Exception {
        while (inIterator.hasNext()) {
            Event event = new Event((String)inIterator.next());
            this.events.add(event);
        }
    }

    public synchronized void appendEvents(Iterator inIterator, int inControllerID) throws Exception {
        while (inIterator.hasNext()) {
            Event event = new Event((String)inIterator.next(), inControllerID);
            this.events.add(event);
        }
    }

    public synchronized void clearEvents() {
        this.events.clear();
    }

    public synchronized int getEventCount() {
        return this.events.size();
    }

    public synchronized Event getEvent(int index) {
        if (index < 0 || index >= this.events.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        return (Event)this.events.get(index);
    }

    public synchronized Iterator getEvents() {
        return Collections.unmodifiableList(this.events).iterator();
    }

    public synchronized Iterator getEvents(int index) {
        return Collections.unmodifiableList(this.events).listIterator(index);
    }

    public synchronized Event getFirstEvent() {
        if (this.events.isEmpty()) {
            return null;
        }
        return (Event)this.events.get(0);
    }

    public synchronized Event getLastEvent() {
        if (this.events.isEmpty()) {
            return null;
        }
        return (Event)this.events.get(this.events.size() - 1);
    }

    public static void main(String[] inArgs) {
    }

    public static class Event
    implements Comparable {
        public static final int CONTROLLER_ID_NONE = -1;
        protected static final String DATA_FORMAT = "yyyy-MM-dd HH:mm:ss";
        protected Date time;
        protected int sequenceId;
        protected int priority;
        protected int type;
        protected String message;
        protected String localizedMessage;
        protected int controllerId = -1;
        protected String description;

        public Event(String inEventString) throws Exception {
            this.parse(inEventString);
        }

        public Event(String inEventString, int inControllerId) throws Exception {
            this.parse(inEventString);
            this.controllerId = inControllerId;
        }

        protected void parse(String inString) throws Exception {
            int i = inString.indexOf(44);
            if (i < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log time");
            }
            String s = inString.substring(0, i);
            SimpleDateFormat dateFormatter = new SimpleDateFormat(DATA_FORMAT);
            dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.time = dateFormatter.parse(s);
            int j = inString.indexOf(44, ++i);
            if (j < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log sequence ID");
            }
            s = inString.substring(i, j);
            this.sequenceId = Integer.parseInt(s);
            i = j + 1;
            if ((j = inString.indexOf(44, i)) < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log priority");
            }
            s = inString.substring(i, j);
            this.priority = Integer.parseInt(s);
            i = j + 1;
            if ((j = inString.indexOf(44, i)) < 0) {
                throw new StringIndexOutOfBoundsException("invalid event log type");
            }
            s = inString.substring(i, j);
            this.type = Integer.parseInt(s);
            i = j + 1;
            this.message = inString.substring(i);
        }

        public Date getTime() {
            return this.time;
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocalizedMessage() {
            return this.localizedMessage != null ? this.localizedMessage : this.message;
        }

        public int getControllerId() {
            return this.controllerId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setLocalizedMessage(String inMessage) {
            this.localizedMessage = inMessage;
        }

        public void setDescription(String inDescription) {
            this.description = inDescription;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Event)) {
                return false;
            }
            Event e = (Event)o;
            return e.controllerId == this.controllerId && e.time.equals(this.time) && e.sequenceId == this.sequenceId && e.priority == this.priority && e.message.equals(this.message);
        }

        public int compareTo(Object o) {
            Event e = (Event)o;
            int timeDiff = this.time.compareTo(e.time);
            if (timeDiff != 0) {
                return timeDiff * -1;
            }
            if (this.controllerId < e.controllerId) {
                return -1;
            }
            if (this.controllerId > e.controllerId) {
                return 1;
            }
            if (this.sequenceId < e.sequenceId) {
                return -1;
            }
            if (this.sequenceId > e.sequenceId) {
                return 1;
            }
            if (this.priority < e.priority) {
                return -1;
            }
            if (this.priority > e.priority) {
                return 1;
            }
            int msgDiff = this.message.compareToIgnoreCase(e.message);
            if (msgDiff != 0) {
                return msgDiff;
            }
            return 0;
        }

        public String paramString() {
            String s = "";
            s = String.valueOf(s) + "sequenceId=" + this.sequenceId + ",";
            s = String.valueOf(s) + "time=" + this.time + ",";
            s = String.valueOf(s) + "controllerId=" + this.controllerId + ",";
            s = String.valueOf(s) + "type=" + this.type + ",";
            s = String.valueOf(s) + "priority=" + this.priority + ",";
            s = String.valueOf(s) + "message=" + this.message + ",";
            s = String.valueOf(s) + "localizedMessage=" + this.localizedMessage + ",";
            s = String.valueOf(s) + "description=" + this.description;
            return s;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
        }
    }
}

