/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.net.acp.SimpleCryptCoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleCryptInputStream
extends FilterInputStream {
    private int keyIndex = 0;
    private int byteCount = 0;

    public SimpleCryptInputStream(InputStream in) {
        super(in);
        if (in == null) {
            throw new NullPointerException("in cannot be null");
        }
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b == -1) {
            return b;
        }
        if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
            this.keyIndex = 0;
        }
        b = b ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount;
        ++this.keyIndex;
        ++this.byteCount;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        int i = off;
        while (i < read) {
            if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
                this.keyIndex = 0;
            }
            b[i] = (byte)(b[i] ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount);
            ++this.keyIndex;
            ++this.byteCount;
            ++i;
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void newBlock() {
        this.keyIndex = 0;
        this.byteCount = 0;
    }
}

