/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.net.acp.SimpleCryptCoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SimpleCryptOutputStream
extends FilterOutputStream {
    private int keyIndex = 0;
    private int byteCount = 0;

    public SimpleCryptOutputStream(OutputStream out) {
        super(out);
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
    }

    public void write(int b) throws IOException {
        if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
            this.keyIndex = 0;
        }
        this.out.write((b ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount) & 0xFF);
        ++this.keyIndex;
        ++this.byteCount;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Buffer cannot be null.");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            String msg = "buffer length=" + b.length + ", off=" + off + ", len=" + len;
            throw new IndexOutOfBoundsException(msg);
        }
        int i = off;
        while (i < len) {
            if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
                this.keyIndex = 0;
            }
            b[i] = (byte)(b[i] ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount);
            ++this.keyIndex;
            ++this.byteCount;
            ++i;
        }
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void newBlock() {
        this.keyIndex = 0;
        this.byteCount = 0;
    }
}

