/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.text.NumberFormat;

public class CapacityConverter {
    public static final int BINARY = 0;
    public static final int DECIMAL = 1;
    private static final double BINARY_KB = 1024.0;
    private static final double DECIMAL_KB = 1000.0;
    private static double kb = 1024.0;
    private long bytes;

    public CapacityConverter(long bytes) {
        this.bytes = bytes;
    }

    public static double toTerabytes(long bytes) {
        double tb = (double)bytes / kb / kb / kb / kb;
        return tb;
    }

    public static double toGigabytes(long bytes) {
        double gb = (double)bytes / kb / kb / kb;
        return gb;
    }

    public static double toMegabytes(long bytes) {
        double mb = (double)bytes / kb / kb;
        return mb;
    }

    public static double toKilobytes(long bytes) {
        double kbytes = (double)bytes / kb;
        return kbytes;
    }

    public void setConversionUnits(int units) {
        if (units != 0 && units != 1) {
            throw new IllegalArgumentException("Illegal units " + units);
        }
        kb = units == 0 ? 1024.0 : 1000.0;
    }

    public static String toTerabyteString(long bytes) {
        return CapacityConverter.toString(CapacityConverter.toTerabytes(bytes), 2);
    }

    public static String toGigabyteString(long bytes) {
        return CapacityConverter.toString(CapacityConverter.toGigabytes(bytes), 2);
    }

    public static String toMegabyteString(long bytes) {
        return CapacityConverter.toString(CapacityConverter.toMegabytes(bytes), 2);
    }

    public static String toKilobyteString(long bytes) {
        return CapacityConverter.toString(CapacityConverter.toKilobytes(bytes), 2);
    }

    public static String toString(double value, int fractionDigits) {
        NumberFormat f = NumberFormat.getNumberInstance();
        f.setMaximumFractionDigits(fractionDigits);
        return f.format(value);
    }
}

