/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;

public class SortedArrayList
implements Collection {
    private ArrayList mInternalArrayList = null;

    public SortedArrayList() {
        this.mInternalArrayList = new ArrayList();
    }

    public SortedArrayList(int initialCapacity) {
        this.mInternalArrayList = new ArrayList(initialCapacity);
    }

    public void add(Comparable element) {
        int currentMax = this.mInternalArrayList.size() - 1;
        if (currentMax < 0 || element.compareTo(this.mInternalArrayList.get(currentMax)) >= 0) {
            this.mInternalArrayList.add(element);
        } else if (element.compareTo(this.mInternalArrayList.get(0)) <= 0) {
            this.mInternalArrayList.add(0, element);
        } else {
            int currentMin = 0;
            boolean inserted = false;
            while (!inserted) {
                int index = (currentMax - currentMin) / 2 + currentMin;
                int comparison = element.compareTo(this.mInternalArrayList.get(index));
                if (comparison == 0 || currentMax - currentMin <= 1) {
                    this.mInternalArrayList.add(index + 1, element);
                    inserted = true;
                    continue;
                }
                if (comparison < 0) {
                    currentMax = index;
                    continue;
                }
                currentMin = index;
            }
        }
    }

    public boolean add(Object o) {
        if (!(o instanceof Comparable)) {
            throw new IllegalArgumentException("Object o must implement Comparable interface");
        }
        this.add((Comparable)o);
        return true;
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("SortedArrayList does not support the addAll method.");
    }

    public void clear() {
        this.mInternalArrayList.clear();
    }

    public boolean contains(Object o) {
        return this.mInternalArrayList.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.mInternalArrayList.containsAll(c);
    }

    public int fastIndexOf(Comparable element) {
        int foundIndex = -1;
        boolean searchComplete = false;
        int currentMin = 0;
        int currentMax = this.mInternalArrayList.size() - 1;
        while (!searchComplete) {
            int index = (currentMax - currentMin) / 2 + currentMin;
            int comparison = element.compareTo(this.mInternalArrayList.get(index));
            if (comparison == 0) {
                foundIndex = index;
                searchComplete = true;
                continue;
            }
            if (currentMax - currentMin <= 0) {
                searchComplete = true;
                continue;
            }
            if (comparison < 0) {
                currentMax = index - 1;
                continue;
            }
            currentMin = index + 1;
        }
        return foundIndex;
    }

    public Comparable get(int index) {
        return (Comparable)this.mInternalArrayList.get(index);
    }

    public int hashCode() {
        return ((AbstractList)this.mInternalArrayList).hashCode();
    }

    public boolean isEmpty() {
        return this.mInternalArrayList.isEmpty();
    }

    public Iterator iterator() {
        return ((AbstractList)this.mInternalArrayList).iterator();
    }

    public int indexOf(Comparable element) {
        return this.mInternalArrayList.indexOf(element);
    }

    public Comparable remove(int index) {
        return (Comparable)this.mInternalArrayList.remove(index);
    }

    public boolean remove(Object o) {
        return ((AbstractCollection)this.mInternalArrayList).remove(o);
    }

    public boolean removeAll(Collection c) {
        return ((AbstractCollection)this.mInternalArrayList).removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return ((AbstractCollection)this.mInternalArrayList).retainAll(c);
    }

    public int size() {
        return this.mInternalArrayList.size();
    }

    public Object[] toArray() {
        return this.mInternalArrayList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.mInternalArrayList.toArray(a);
    }

    public static void main(String[] args) {
        int arraySize = 10000;
        Random numberGenerator = new Random(new Date().getTime());
        ArrayList<Integer> unsortedArray = new ArrayList<Integer>(10000);
        SortedArrayList sortedArray = new SortedArrayList(10000);
        boolean sortedSuccessfully = true;
        Date date1 = new Date();
        int index = 0;
        while (index < 10000) {
            Integer randomInt = new Integer(numberGenerator.nextInt());
            unsortedArray.add(randomInt);
            sortedArray.add(randomInt);
            ++index;
        }
        Date date2 = new Date();
        long difference = date2.getTime() - date1.getTime();
        System.out.println("The UNSORTED array is: ");
        int index2 = 0;
        while (index2 < 10000) {
            System.out.println(unsortedArray.get(index2));
            ++index2;
        }
        System.out.println("\n\nThe SORTED array is: ");
        int index3 = 0;
        while (index3 < 10000) {
            System.out.println(sortedArray.get(index3));
            if (index3 != 0 && sortedArray.get(index3).compareTo(sortedArray.get(index3 - 1)) < 0) {
                sortedSuccessfully = false;
            }
            ++index3;
        }
        if (sortedSuccessfully) {
            System.out.println("\n\nInteger sorting SUCCEEDED!\nSorting time = " + difference + " ms");
        } else {
            System.out.println("\n\nInteger sorting FAILED!\nSorting time = " + difference + " ms");
        }
        boolean allSearchesCorrect = true;
        int searchSize = 5000;
        int index4 = 0;
        while (index4 < searchSize) {
            Integer randomNumber;
            int indexOfIndex;
            int arrayIndexNumber = numberGenerator.nextInt(10000);
            int fastIndexOfIndex = sortedArray.fastIndexOf(sortedArray.get(arrayIndexNumber));
            if (fastIndexOfIndex != arrayIndexNumber) {
                System.out.println("\n\nfastIndexOf() FAILED!!!\nfastIndexOfIndex SHOULD BE: " + arrayIndexNumber + "\nfastIndexOfIndex actually is: " + fastIndexOfIndex);
                allSearchesCorrect = false;
            }
            if ((indexOfIndex = sortedArray.indexOf(randomNumber = new Integer(numberGenerator.nextInt()))) != (fastIndexOfIndex = sortedArray.fastIndexOf(randomNumber))) {
                System.out.println("\n\nfastIndexOf() FAILED!!! Searches returned different results!\nindexOfIndex = " + indexOfIndex + " fastIndexOfIndex = " + fastIndexOfIndex);
                allSearchesCorrect = false;
            }
            ++index4;
        }
        int numFastIndexOfCalls = 2 * searchSize;
        if (allSearchesCorrect) {
            System.out.println("\n\nAll " + numFastIndexOfCalls + " calls to fastIndexOf() SUCCEEDED!");
        } else {
            System.out.println("\n\nOne or more of the " + numFastIndexOfCalls + " calls to fastIndexOf() FAILED!");
        }
    }
}

