/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.jni;

public class PasswordManager {
    private static final String LIBRARY_NAME = new String("PasswordManager");
    public static final String PASSWORD_MANAGER_ACCESS_GUEST = new String("guest");
    public static final String PASSWORD_MANAGER_ACCESS_ADMIN = new String("admin");
    public static final int LIBRARY_NOT_LOADED = -1;
    public static final int LIBRARY_NOT_AVAILABLE = -2;
    public static final int LIBRARY_LOADED = 0;
    private static boolean mLibraryLoaded;
    private static PasswordManager mSharedInstance;

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            mLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mLibraryLoaded = false;
        }
    }

    public static PasswordManager getPasswordManager() {
        if (mSharedInstance == null) {
            mSharedInstance = new PasswordManager();
        }
        return mSharedInstance;
    }

    public static int isPasswordManagerAvailable() {
        int retVal = 0;
        if (mSharedInstance == null) {
            retVal = -1;
        } else if (!mLibraryLoaded) {
            retVal = -2;
        }
        return retVal;
    }

    public String getPassword(String serverName, String accountName) throws PasswordManagerAccessException {
        if (!mLibraryLoaded) {
            throw new PasswordManagerAccessException("PasswordManagerLibraryNotLoaded");
        }
        String string = this.getPasswordInternal(serverName, accountName);
        if (string == null) {
            throw new PasswordManagerAccessException("PasswordNotFound");
        }
        if (string.length() == 0) {
            throw new PasswordManagerAccessException("PasswordNotFound");
        }
        return string;
    }

    public int setPassword(String serverName, String accountName, String password) {
        int error = 0;
        if (!mLibraryLoaded) {
            return -1;
        }
        error = this.setPasswordInternal(serverName, accountName, password);
        if (error != 0) {
            System.out.println("error = " + new Integer(error));
        }
        return error;
    }

    public native String getPasswordInternal(String var1, String var2);

    public native int setPasswordInternal(String var1, String var2, String var3);

    public class PasswordManagerAccessException
    extends Exception {
        public String exceptionType;

        PasswordManagerAccessException(String exception) {
            this.exceptionType = exception;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }
    }
}

