/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.plist;

import com.apple.util.plist.PropertyListException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PListUtils {
    private PListUtils() {
    }

    public static Map toDictionary(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\" was null");
        }
        Map result = null;
        try {
            result = (Map)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not a Dictionary: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static Map toDictionary(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        Map result = null;
        try {
            result = (Map)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not a Dictionary: " + source.getClass());
        }
        return result;
    }

    public static List toArray(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        List result = null;
        try {
            result = (List)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not an array: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static List toArray(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        List result = null;
        try {
            result = (List)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not an Array: " + source.getClass());
        }
        return result;
    }

    public static String toString(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        String result = null;
        try {
            result = (String)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not a String: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static String toString(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        String result = null;
        try {
            result = (String)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not a String: " + source.getClass());
        }
        return result;
    }

    public static Long toInteger(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        Long result = null;
        try {
            result = (Long)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not an Integer: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static Long toInteger(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        Long result = null;
        try {
            result = (Long)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not an Integer: " + source.getClass() + " (" + source + ")");
        }
        return result;
    }

    public static Double toReal(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        Double result = null;
        try {
            result = (Double)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not a Real Number: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static Double toReal(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        Double result = null;
        try {
            result = (Double)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not a Real Number: " + source.getClass());
        }
        return result;
    }

    public static byte[] toData(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        byte[] result = null;
        try {
            result = (byte[])value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not Data: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static byte[] toData(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        byte[] result = null;
        try {
            result = (byte[])source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not Data: " + source.getClass());
        }
        return result;
    }

    public static Date toDate(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        Date result = null;
        try {
            result = (Date)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not a Date: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static Date toDate(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        Date result = null;
        try {
            result = (Date)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not a Date: " + source.getClass());
        }
        return result;
    }

    public static Boolean toBoolean(Object value, String key) throws PropertyListException {
        if (key == null) {
            throw new NullPointerException("key was null");
        }
        if (value == null) {
            throw new PropertyListException("value for key \"" + key + "\"  was null");
        }
        Boolean result = null;
        try {
            result = (Boolean)value;
        }
        catch (ClassCastException classCastException) {
            String msg = "Value for key \"" + key + "\" is not a Boolean: " + value.getClass() + " (value = \"" + value + "\")";
            throw new PropertyListException(msg);
        }
        return result;
    }

    public static Boolean toBoolean(Object source) throws PropertyListException {
        if (source == null) {
            throw new PropertyListException("Source element null");
        }
        Boolean result = null;
        try {
            result = (Boolean)source;
        }
        catch (ClassCastException classCastException) {
            throw new PropertyListException("Source element is not a Boolean: " + source.getClass());
        }
        return result;
    }
}

