/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.plist;

import com.apple.util.plist.PropertyListException;
import com.apple.util.plist.PropertyListUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class PropertyList {
    private Object rootElement;
    private static final Logger logger = Logger.getLogger(class$com$apple$util$plist$PropertyList != null ? class$com$apple$util$plist$PropertyList : (class$com$apple$util$plist$PropertyList = PropertyList.class$("com.apple.util.plist.PropertyList")));
    static /* synthetic */ Class class$com$apple$util$plist$PropertyList;

    public PropertyList(InputStream in) throws IOException, PropertyListException {
        if (in == null) {
            throw new NullPointerException("in cannot be null");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            this.rootElement = PropertyListUtilities.readXML(reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new PropertyListException("Error reading XML: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new PropertyListException("Error parsing XML: " + e.getMessage());
        }
    }

    public PropertyList(Reader in) throws IOException, PropertyListException {
        if (in == null) {
            throw new NullPointerException("in cannot be null");
        }
        try {
            this.rootElement = PropertyListUtilities.readXML(in);
        }
        catch (SAXException e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new PropertyListException("Error configuring XML parser: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new PropertyListException("Error parsing XML: " + e.getMessage());
        }
    }

    public PropertyList(Object root) {
        if (root == null) {
            throw new NullPointerException("root cannot be null");
        }
        if (!PropertyList.isValidElement(root)) {
            throw new IllegalArgumentException("illegal plist element " + root.getClass());
        }
        this.rootElement = root;
    }

    public PropertyList(PropertyList plist) {
        if (plist == null) {
            throw new NullPointerException("plist cannot be null");
        }
        if (plist.rootElement != null) {
            this.rootElement = PropertyListUtilities.deepCopy(plist.rootElement);
        }
    }

    public Object getRootElement() {
        return this.rootElement;
    }

    public void writeTo(OutputStream out) throws PropertyListException, IOException {
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        this.writeTo(writer);
        ((Writer)writer).flush();
    }

    public void writeTo(Writer writer) throws PropertyListException, IOException {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null");
        }
        if (this.rootElement == null) {
            throw new NullPointerException("root element is null");
        }
        PropertyListUtilities.writeXML(this.rootElement, writer);
    }

    public static boolean isValidElement(Object o) {
        return o != null && (o instanceof Map || o instanceof List || o instanceof String || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof byte[] || o instanceof Date || o instanceof Boolean);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringWriter writer = new StringWriter();
        String xml = null;
        try {
            try {
                PropertyListUtilities.writeXML(this.rootElement, writer);
                xml = writer.toString();
            }
            catch (IOException iOException) {
            }
            Object var4_3 = null;
            if (writer == null) return xml;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            writer.close();
            return xml;
        }
        catch (IOException iOException) {}
        return xml;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

