/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.ImageUtilities;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.RadioButtonGroup;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractChooserMgmtPane
extends AbstractManagementPane {
    public static final String CHOOSER_PANE_TAG = "chooser";
    protected ChooserPanel chooserPanel;
    protected ChooserButtonPanel chooserButtonPanel;
    protected String chooseText;
    protected CardLayout cardLayout = new CardLayout();

    public AbstractChooserMgmtPane(int preferredWidth, int preferredHeight, String chooseText) {
        super(preferredWidth, preferredHeight);
        this.setLayout(this.cardLayout);
        this.chooseText = chooseText;
    }

    public void goBackToChooser() {
        this.cardLayout.show(this, CHOOSER_PANE_TAG);
    }

    public ManagementPane getCurrentlyShowingManagementPane() {
        ManagementPane pane = null;
        Component comp = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            int count = this.getComponentCount();
            int i = 0;
            while (i < count) {
                comp = this.getComponent(i);
                if (comp.isVisible()) break;
                ++i;
            }
        }
        if (comp != null && comp instanceof ManagementPane) {
            pane = (ManagementPane)((Object)comp);
        }
        return pane;
    }

    public String getSelectedPaneTag() {
        return this.chooserPanel.getSelectedPaneTag();
    }

    public void showPane(String tag) {
        this.cardLayout.show(this, tag != null ? tag : CHOOSER_PANE_TAG);
    }

    protected void setPanes(ManagementPane[] panes) {
        this.setPanes(panes, true);
    }

    protected void setPanes(ManagementPane[] panes, boolean useIcons) {
        this.chooserButtonPanel = this.createChooserButtonPanel();
        this.chooserPanel = new ChooserPanel(this.chooseText, panes, this.chooserButtonPanel, useIcons);
        this.add((Component)this.chooserPanel, CHOOSER_PANE_TAG);
        int i = 0;
        while (i < panes.length) {
            if (!(panes[i] instanceof Component)) {
                String s = "ManagmentPane \"" + panes[i].getTag() + "\" must be an instance of java.awt.Component";
                throw new IllegalArgumentException(s);
            }
            this.add((Component)((Object)panes[i]), panes[i].getTag());
            ++i;
        }
    }

    protected ChooserButtonPanel createChooserButtonPanel() {
        ChooserButtonPanel buttonPanel = new ChooserButtonPanel(false);
        buttonPanel.cancelButton.addActionListener(new 1());
        buttonPanel.okButton.addActionListener(new 2());
        return buttonPanel;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(AbstractChooserMgmtPane.this, 1001, "CANCEL");
            AbstractChooserMgmtPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String tag = AbstractChooserMgmtPane.this.chooserPanel.getSelectedPaneTag();
            if (tag != null) {
                AbstractChooserMgmtPane.this.cardLayout.show(AbstractChooserMgmtPane.this, tag);
            }
        }

        /* synthetic */ 2() {
        }
    }

    public static class ChooserPanel
    extends JPanel {
        private RadioButtonGroup radioGroup = new RadioButtonGroup();
        private static final Insets LABEL_INSETS = new Insets(0, 0, 24, 0);
        private static final Insets RADIO_INSETS = new Insets(10, 0, 0, 0);
        private static final Insets EXPLANATION_INSETS = new Insets(0, 24, 16, 0);
        private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
        private static final String XSR_CHOICE_BUTTON_PROP = "XSR_CHOICE_BUTTON";
        private static final String XSR_CHOICE_EXPLANATION_PROP = "XSR_CHOICE_EXPLANATION";

        public ChooserPanel(String chooseText, ManagementPane[] panes, ChooserButtonPanel buttonPanel, boolean useIcons) {
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            JLabel chooseLabel = new JLabel(chooseText);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = LABEL_INSETS;
            this.add((Component)chooseLabel, constraints);
            int i = 0;
            while (i < panes.length) {
                ImageIcon icon = panes[i].getIcon();
                String title = panes[i].getTitle();
                String explanation = panes[i].getExplanation();
                String tag = panes[i].getTag();
                int col = 0;
                JButton button = null;
                if (useIcons) {
                    button = icon != null ? GUIFactory.newButton(icon) : GUIFactory.newButton("?");
                    button.setPressedIcon(new ImageIcon(this.createImage(new FilteredImageSource(icon.getImage().getSource(), ImageUtilities.getDimmingFilterInstance()))));
                    button.setDisabledIcon(new ImageIcon(this.createImage(new FilteredImageSource(icon.getImage().getSource(), ImageUtilities.getFadingFilterInstance()))));
                    button.setBorderPainted(false);
                    button.setActionCommand(tag);
                    constraints.gridx = col++;
                    constraints.gridy = i * 2 + 1;
                    constraints.gridwidth = 1;
                    constraints.gridheight = 2;
                    constraints.weightx = 0.0;
                    constraints.weighty = 0.0;
                    constraints.anchor = 17;
                    constraints.fill = 0;
                    constraints.insets = ZERO_INSETS;
                    this.add((Component)button, constraints);
                }
                JRadioButton radio = GUIFactory.newRadioButton(title);
                radio.setSelected(i == 0);
                radio.setActionCommand(tag);
                this.radioGroup.add(radio);
                constraints.gridx = col;
                constraints.gridy = i * 2 + 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.anchor = 17;
                constraints.fill = 0;
                constraints.insets = RADIO_INSETS;
                this.add((Component)radio, constraints);
                JLabel explanationLabel = new JLabel(explanation);
                explanationLabel.setFont(GUIFactory.FONT_SMALL);
                constraints.gridx = col;
                ++constraints.gridy;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.anchor = 17;
                constraints.fill = 0;
                constraints.insets = EXPLANATION_INSETS;
                this.add((Component)explanationLabel, constraints);
                radio.putClientProperty(XSR_CHOICE_BUTTON_PROP, button);
                radio.putClientProperty(XSR_CHOICE_EXPLANATION_PROP, explanationLabel);
                if (button != null) {
                    button.addActionListener(new 3(radio));
                }
                ++i;
            }
            constraints.gridx = 1;
            ++constraints.gridy;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 14;
            constraints.fill = 2;
            constraints.insets = ZERO_INSETS;
            this.add((Component)buttonPanel, constraints);
        }

        public void setSelectedPane(ManagementPane pane) {
            String tag = pane.getTag();
            JRadioButton radio = this.getRadioForTag(pane.getTag());
            if (radio != null) {
                radio.setSelected(true);
            }
        }

        public String getSelectedPaneTag() {
            String cmd = null;
            ButtonModel model = this.radioGroup.getSelection();
            if (model != null) {
                cmd = model.getActionCommand();
            }
            return cmd;
        }

        public void setPaneEnabled(ManagementPane pane, boolean enabled) {
            String tag = pane.getTag();
            JRadioButton radio = this.getRadioForTag(pane.getTag());
            if (radio != null) {
                AbstractButton button = (AbstractButton)radio.getClientProperty(XSR_CHOICE_BUTTON_PROP);
                JLabel label = (JLabel)radio.getClientProperty(XSR_CHOICE_EXPLANATION_PROP);
                radio.setEnabled(enabled);
                if (button != null) {
                    button.setEnabled(enabled);
                }
                if (label != null) {
                    label.setEnabled(enabled);
                }
            }
        }

        private JRadioButton getRadioForTag(String tag) {
            Enumeration<AbstractButton> enumeration = this.radioGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton button = (JRadioButton)enumeration.nextElement();
                if (!button.getActionCommand().equals(tag)) continue;
                return button;
            }
            return null;
        }
    }
}

