/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.Timer;

class AquaProgressClock
extends JComponent {
    public static final int FRAME_INTERVAL = 66;
    private static final Dimension dimensions = new Dimension(20, 20);
    private static final double innerRadius = 5.0;
    private static final double outerRadius = 8.5;
    private static final Line2D.Double[] line = new Line2D.Double[12];
    private static final Color[] colorTableNormal = new Color[12];
    private static final Color[] colorTableSelected = new Color[12];
    private static final Stroke stroke = new BasicStroke(1.5f, 2, 1);
    private int frame = 0;
    private Timer timer = null;
    private boolean selected = false;

    static {
        int hour = 0;
        while (hour < 12) {
            double radians = (double)hour / 6.0 * Math.PI;
            double startX = 9.25 + (double)((int)(5.0 * Math.cos(radians)));
            double startY = 9.25 + (double)((int)(5.0 * Math.sin(radians)));
            double endX = 9.25 + (double)((int)(8.5 * Math.cos(radians)));
            double endY = 9.25 + (double)((int)(8.5 * Math.sin(radians)));
            AquaProgressClock.line[hour] = new Line2D.Double(startX, startY, endX, endY);
            AquaProgressClock.colorTableNormal[hour] = Color.getHSBColor(0.0f, 0.0f, 0.7f - (float)hour / 11.0f * 0.55f);
            AquaProgressClock.colorTableSelected[hour] = Color.getHSBColor(0.5972222f, 0.73f - (float)hour / 11.0f * 0.73f, 1.0f - (float)hour / 11.0f * 0.13f);
            ++hour;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke save = ((Graphics2D)g).getStroke();
        ((Graphics2D)g).setStroke(stroke);
        if (this.selected) {
            int hour = 0;
            while (hour < 12) {
                g.setColor(colorTableSelected[(hour + this.frame) % 12]);
                ((Graphics2D)g).draw(line[hour]);
                ++hour;
            }
        } else {
            int hour = 0;
            while (hour < 12) {
                g.setColor(colorTableNormal[(hour + this.frame) % 12]);
                ((Graphics2D)g).draw(line[hour]);
                ++hour;
            }
        }
        ((Graphics2D)g).setStroke(save);
    }

    public void startAnimation() {
        if (this.timer == null) {
            this.timer = new Timer(66, new 1());
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    public void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void advanceFrame() {
        this.frame = this.frame == 0 ? 11 : this.frame - 1;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Dimension getMinimumSize() {
        return dimensions;
    }

    public Dimension getPreferredSize() {
        return dimensions;
    }

    public Dimension getMaximumSize() {
        return dimensions;
    }

    AquaProgressClock() {
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            AquaProgressClock.this.frame = AquaProgressClock.this.frame == 0 ? 11 : AquaProgressClock.this.frame - 1;
            AquaProgressClock.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }
}

