/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AquaToolBar
extends JToolBar {
    private static final Insets MARGIN = new Insets(0, 10, 0, 10);
    private static final Insets BUTTON_MARGIN = new Insets(0, 1, 0, 1);
    private static final Color LIGHT_LINE = Color.getHSBColor(0.0f, 0.0f, 0.969f);
    private static final Color DARK_LINE = Color.getHSBColor(0.0f, 0.0f, 0.957f);
    private static final Color LAST_LINE = Color.getHSBColor(0.0f, 0.0f, 0.67f);
    private static final Color SEPARATOR_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.54f);
    private static int SEPARATOR_MARGIN = 8;
    private boolean macLookAndFeel = false;

    public AquaToolBar() {
        super(null, 0);
        this.setOpaque(false);
        this.setFloatable(false);
        this.setMargin(MARGIN);
        if (Gestalt.isMacLookAndFeel) {
            this.setBorderPainted(true);
        }
    }

    public void addButton(AbstractButton button) {
        button.setBorderPainted(false);
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setContentAreaFilled(false);
        button.setFont(GUIFactory.FONT_SMALL);
        button.setMargin(BUTTON_MARGIN);
        this.add(button);
    }

    public void addSeparator() {
        this.add(this.makeSeparator(null));
    }

    public void addSeparator(Dimension size) {
        this.add(this.makeSeparator(size));
    }

    private Component makeSeparator(Dimension size) {
        JComponent separator = Gestalt.isMacLookAndFeel ? new AquaToolBarSeparator() : (size != null ? new JToolBar.Separator(size) : new JToolBar.Separator());
        return separator;
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            if (Gestalt.isMacLookAndFeel) {
                int width = this.getWidth();
                int height = this.getHeight();
                g.setColor(LAST_LINE);
                g.drawLine(0, height - 1, width, height - 1);
            } else {
                super.paintBorder(g);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        if (Gestalt.isMacLookAndFeel) {
            int width = this.getWidth();
            int height = this.getHeight();
            int y = 0;
            while (y < height - 1) {
                g.setColor(LIGHT_LINE);
                g.drawLine(0, y, width, y++);
                g.drawLine(0, y, width, y++);
                g.setColor(DARK_LINE);
                g.drawLine(0, y, width, y++);
                g.drawLine(0, y, width, y);
                ++y;
            }
        }
        super.paintComponent(g);
    }

    class AquaToolBarSeparator
    extends JPanel {
        public void paint(Graphics g) {
            int midpointx = 1 + this.getWidth() / 2;
            int height = this.getHeight();
            g.setColor(SEPARATOR_COLOR);
            int y = 1;
            while (y < height - 1) {
                g.fillRect(midpointx, y, 1, 1);
                y += 3;
            }
        }

        public Dimension getMaximumSize() {
            return new Dimension(1 + SEPARATOR_MARGIN * 2, 128);
        }

        AquaToolBarSeparator() {
        }
    }
}

