/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaInformationPanel;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayModel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.RestartRequiredLabel;
import com.apple.xsr.StepByStepPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class CreateArrayPane
extends AbstractManagementPane {
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private final int LEFT_INDENT_1 = 20;
    private final int LEFT_INDENT_2 = 22;
    private final int STEP_VSPACE = 15;
    static final int DRIVE_EMPTY = -4;
    static final int DRIVE_OFFLINE = -3;
    static final int DRIVE_ASSIGNED = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int RAID_0 = 0;
    static final int RAID_1 = 1;
    static final int RAID_3 = 2;
    static final int RAID_5 = 3;
    static final int RAID_01 = 4;
    static final int JBOD = 255;
    static final int[] levels;
    static String[] levelNames;
    static String[] levelDescriptions;
    static ImageIcon[] levelIcons;
    int[] driveAssignments = new int[14];
    int[] driveCapacities = new int[14];
    String[] arrayDescriptions = new String[0];
    RadioButtonGroup levelButtonGroup;
    AquaInformationPanel levelInfo;
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JButton createButton;
    JCheckBox backgroundCheckBox;
    JTextArea backgroundLabel;
    private static final int preferredWidth = 664;
    private static final int preferredHeight;
    static /* synthetic */ Class class$com$apple$xsr$CreateArrayModel;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 255;
        levels = nArray;
        levelNames = new String[]{Resources.getString("management.create.raid0"), Resources.getString("management.create.raid1"), Resources.getString("management.create.raid3"), Resources.getString("management.create.raid5"), Resources.getString("management.create.raid01"), Resources.getString("management.create.jbod")};
        levelDescriptions = new String[]{Resources.getString("management.create.raid0.note"), Resources.getString("management.create.raid1.note"), Resources.getString("management.create.raid3.note"), Resources.getString("management.create.raid5.note"), Resources.getString("management.create.raid01.note"), Resources.getString("management.create.jbod.note")};
        levelIcons = new ImageIcon[]{new ImageIcon(Resources.getImage("icon.raid0")), new ImageIcon(Resources.getImage("icon.raid1")), new ImageIcon(Resources.getImage("icon.raid3")), new ImageIcon(Resources.getImage("icon.raid5")), new ImageIcon(Resources.getImage("icon.raid01")), new ImageIcon(Resources.getImage("icon.jbod"))};
        preferredHeight = Gestalt.isAquaLookAndFeel ? 644 : 678;
    }

    public CreateArrayPane() {
        super(664, preferredHeight);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        boolean row = false;
        StepByStepPanel summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.four"), Resources.getString("management.create.summary"));
        this.summaryLabel = GUIFactory.newTextPane("", 2);
        this.createButton = GUIFactory.newButton(Resources.getString("management.create.createButton"));
        StepByStepPanel stepOne = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("management.create.selectLevel"));
        this.add((Component)stepOne, constraints);
        ++constraints.gridy;
        this.levelInfo = new AquaInformationPanel(null, levelDescriptions[0]);
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel levelGroup = GUIFactory.newPanel();
        levelGroup.setLayout(new GridBagLayout());
        GridBagConstraints levelGroupConstraints = new GridBagConstraints();
        levelGroupConstraints.anchor = 17;
        levelGroupConstraints.fill = 2;
        this.levelButtonGroup = new RadioButtonGroup();
        JRadioButton[] levelRadio = new JRadioButton[levelNames.length];
        int index = 0;
        while (index < levelNames.length) {
            levelRadio[index] = GUIFactory.newRadioButton(levelNames[index], true);
            levelRadio[index].setFont(GUIFactory.FONT_SMALL);
            this.levelButtonGroup.add(levelRadio[index]);
            levelGroupConstraints.gridx = 0;
            levelGroupConstraints.gridy = index;
            levelGroupConstraints.insets = new Insets(0, 0, 0, 20);
            levelGroupConstraints.anchor = 11;
            levelGroupConstraints.fill = 1;
            levelGroup.add((Component)levelRadio[index], levelGroupConstraints);
            levelGroupConstraints.anchor = 17;
            levelGroupConstraints.insets = zeroInsets;
            levelGroupConstraints.fill = 0;
            levelRadio[index].addActionListener(new RaidLevelGroupActionListener(levels[index]));
            ++index;
        }
        levelGroupConstraints.gridx = 1;
        levelGroupConstraints.gridy = 0;
        levelGroupConstraints.gridheight = 6;
        levelGroupConstraints.fill = 1;
        levelGroupConstraints.weightx = 1.0;
        levelGroup.add((Component)this.levelInfo, levelGroupConstraints);
        levelGroupConstraints.weightx = 0.0;
        levelGroupConstraints.gridheight = 1;
        levelGroupConstraints.fill = 0;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)levelGroup, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        StepByStepPanel stepTwo = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("management.create.selectDrives"));
        this.add((Component)stepTwo, constraints);
        ++constraints.gridy;
        JPanel driveGroup = GUIFactory.newPanel();
        driveGroup.setLayout(new GridBagLayout());
        GridBagConstraints driveGroupConstraints = new GridBagConstraints();
        driveGroupConstraints.anchor = 17;
        driveGroupConstraints.fill = 2;
        driveGroupConstraints.gridx = 1;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.fill = 1;
        driveGroupConstraints.insets = new Insets(0, 0, 6, 0);
        driveGroupConstraints.weightx = 1.0;
        driveGroup.add((Component)driveInfo, driveGroupConstraints);
        driveGroupConstraints.weightx = 0.0;
        driveGroupConstraints.insets = zeroInsets;
        driveGroupConstraints.fill = 0;
        this.drivePanel = new DriveSelectionPanel(1, driveInfo, summaryHeader, this.summaryLabel, this.createButton);
        driveGroupConstraints.gridx = 0;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.insets = new Insets(0, 0, 0, 20);
        driveGroup.add((Component)this.drivePanel, driveGroupConstraints);
        driveGroupConstraints.insets = zeroInsets;
        constraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)driveGroup, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("management.create.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        constraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        this.legend = new ArraySelectionPanel(0);
        constraints.insets = new Insets(0, 21, 15, 0);
        this.add((Component)this.legend, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        StepByStepPanel stepThree = new StepByStepPanel(Resources.getImage("icon.step.three"), Resources.getString("management.create.options"));
        this.add((Component)stepThree, constraints);
        ++constraints.gridy;
        JPanel optionsGroup = GUIFactory.newPanel();
        optionsGroup.setLayout(new GridBagLayout());
        GridBagConstraints optionsGroupConstraints = new GridBagConstraints();
        optionsGroupConstraints.gridwidth = 1;
        optionsGroupConstraints.anchor = 17;
        optionsGroupConstraints.fill = 2;
        int optionsRow = 0;
        this.backgroundCheckBox = GUIFactory.newCheckBox(Resources.getString("management.create.background"));
        this.backgroundCheckBox.setFont(GUIFactory.FONT_SMALL);
        optionsGroupConstraints.gridx = 0;
        optionsGroupConstraints.gridy = optionsRow++;
        optionsGroup.add((Component)this.backgroundCheckBox, optionsGroupConstraints);
        this.backgroundLabel = new JTextArea(Resources.getString("management.create.background.note"));
        this.backgroundLabel.setEditable(false);
        this.backgroundLabel.setOpaque(false);
        this.backgroundLabel.setHighlighter(null);
        this.backgroundLabel.setFont(GUIFactory.FONT_SMALL);
        optionsGroupConstraints.gridx = 0;
        optionsGroupConstraints.gridy = optionsRow++;
        optionsGroupConstraints.insets = new Insets(2, 22, 6, 0);
        optionsGroup.add((Component)this.backgroundLabel, optionsGroupConstraints);
        optionsGroupConstraints.insets = zeroInsets;
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 0;
        this.add((Component)optionsGroup, constraints);
        constraints.insets = zeroInsets;
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)summaryHeader, constraints);
        ++constraints.gridy;
        JPanel summaryGroup = GUIFactory.newPanel();
        GridBagLayout summaryGroupLayout = new GridBagLayout();
        summaryGroup.setLayout(summaryGroupLayout);
        GridBagConstraints summaryGroupConstraints = new GridBagConstraints();
        summaryGroupConstraints.anchor = 17;
        summaryGroupConstraints.fill = 2;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        summaryGroupConstraints.weightx = 1.0;
        summaryGroupConstraints.weighty = 1.0;
        summaryGroupConstraints.fill = 1;
        summaryGroup.add((Component)this.summaryLabel, summaryGroupConstraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)summaryGroup, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        JPanel buttonPane = GUIFactory.newPanel();
        buttonPane.setLayout(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonConstraints.gridwidth = 1;
        buttonConstraints.gridheight = 1;
        buttonConstraints.anchor = 17;
        buttonConstraints.fill = 1;
        buttonConstraints.weightx = 1.0;
        buttonConstraints.insets = new Insets(0, 3, 0, 0);
        buttonPane.add((Component)new RestartRequiredLabel(), buttonConstraints);
        buttonConstraints.weightx = 0.0;
        buttonConstraints.insets = new Insets(0, 0, 0, 0);
        ++buttonConstraints.gridx;
        JButton cancelButton = GUIFactory.newButton(Resources.getString("management.cancelButton"));
        buttonPane.add((Component)cancelButton, buttonConstraints);
        ++buttonConstraints.gridx;
        cancelButton.addActionListener(new 1());
        buttonPane.add(Box.createHorizontalStrut(10), buttonConstraints);
        ++buttonConstraints.gridx;
        buttonPane.add((Component)this.createButton, buttonConstraints);
        ++buttonConstraints.gridx;
        this.createButton.addActionListener(new 2());
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 15;
        constraints.fill = 2;
        this.add((Component)buttonPane, constraints);
        ++constraints.gridy;
    }

    public void populateUI(DataModel data) throws IllegalArgumentException {
        if (data != null) {
            if (data.getClass() != (class$com$apple$xsr$CreateArrayModel != null ? class$com$apple$xsr$CreateArrayModel : (class$com$apple$xsr$CreateArrayModel = CreateArrayPane.class$("com.apple.xsr.CreateArrayModel")))) {
                throw new IllegalArgumentException("illegal data model type " + data.getClass());
            }
            CreateArrayModel model = (CreateArrayModel)data;
            this.levelButtonGroup.setSelectedIndex(model.getLevel());
            this.drivePanel.setRaidSystem(model.getRaidSystem());
            this.legend.setRaidSystem(model.getRaidSystem());
            this.legendLabel.setVisible(model.getRaidSystem().hasRaidOrJbodDisks());
            this.backgroundCheckBox.setSelected(model.getBackgroundInitEnabled());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel data) {
        if (data != null) {
            CreateArrayModel model = (CreateArrayModel)data;
            model.setLevel(this.drivePanel.getLevel());
            model.setDriveStates(this.drivePanel.getDriveStates());
            model.setDriveArrays(this.drivePanel.getDriveArrays());
            model.setBackgroundInitEnabled(this.backgroundCheckBox.isSelected());
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    class RaidLevelGroupActionListener
    implements ActionListener {
        int level;

        RaidLevelGroupActionListener(int level) {
            this.level = level;
        }

        public void actionPerformed(ActionEvent e) {
            int index = CreateArrayPane.this.levelButtonGroup.getSelectedIndex();
            if (index == -1) {
                return;
            }
            CreateArrayPane.this.levelInfo.setIcon(levelIcons[index]);
            CreateArrayPane.this.levelInfo.setText(levelDescriptions[index]);
            CreateArrayPane.this.drivePanel.setLevel(this.level);
            CreateArrayPane.this.drivePanel.syncSummary();
            String createBtnTitle = Resources.getString(this.level != 255 ? "management.create.createButton" : "management.create.createButton.jbod");
            CreateArrayPane.this.createButton.setText(createBtnTitle);
            boolean raidNowCheckBoxEnabled = this.level != 255;
            CreateArrayPane.this.backgroundCheckBox.setEnabled(raidNowCheckBoxEnabled);
            CreateArrayPane.this.backgroundLabel.setEnabled(raidNowCheckBoxEnabled);
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(CreateArrayPane.this, 1001, "CANCEL");
            CreateArrayPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(CreateArrayPane.this, 1001, "APPLY");
            CreateArrayPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 2() {
        }
    }
}

