/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.prefs.Preferences;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SystemRegistry;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.RaidSystem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;

public class DefaultSystemRegistry
extends SystemRegistry
implements CommunicationHandler {
    public DefaultSystemRegistry() {
        ArrayList prefsList;
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (prefs.exists("Systems") && (prefsList = prefs.getArray("Systems", null)) != null) {
            Map dict = null;
            ListIterator iter = ((AbstractList)prefsList).listIterator();
            while (iter.hasNext()) {
                String string = null;
                RaidSystem rs = null;
                ArrayList ipList = null;
                dict = (Map)iter.next();
                ipList = (ArrayList)dict.get("IPAddress");
                if (ipList == null) continue;
                boolean err = false;
                string = (String)ipList.get(0);
                rs = new RaidSystem(string);
                rs.setName((String)dict.get("Name"));
                Object rate = dict.get("Rate");
                if (rate != null) {
                    rs.setPollDelay(((Long)rate).intValue());
                }
                rs.setUserMessageIndex(2);
                string = (String)dict.get("Attributes");
                if (string == null) {
                    string = "";
                } else {
                    rs.setMonitoringPassword(string);
                }
                rs.connect(this, "guest", string, false);
                this.add(rs);
            }
        }
    }

    public void handleResponse(RaidSystem system, Response response, Object context) {
        int result = response.getResultCode();
        if (result == 0) {
            system.setUserMessageIndex(3);
        } else if (result == -101) {
            system.setUserMessageIndex(4);
        } else if (result == -16 || result == -27 || result == -28) {
            system.setUserMessageIndex(11);
        }
    }

    public void update(Observable system, Object arg) {
        super.update(system, arg);
        this.synchronizePrefs();
    }

    public void synchronizePrefs() {
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        ArrayList<Map> newList = new ArrayList<Map>();
        ArrayList oldList = prefs.getArray("Systems", null);
        List list = this.list;
        synchronized (list) {
            Iterator i = this.list.iterator();
            while (i.hasNext()) {
                RaidSystem system = (RaidSystem)i.next();
                Map item = SOMLocalizer.toPrefsContainer(system);
                newList.add(item);
            }
        }
        if (((AbstractList)newList).equals(oldList)) {
            return;
        }
        prefs.setArray("Systems", newList);
        prefs.synchronize();
    }

    public void remove(String name) {
        super.remove(name);
        this.synchronizePrefs();
    }

    public void remove(RaidSystem system) {
        super.remove(system);
        this.synchronizePrefs();
    }

    public void remove(RaidSystem[] systems) {
        super.remove(systems);
        this.synchronizePrefs();
    }
}

