/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.DeleteArrayModel;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.RestartRequiredLabel;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class DeleteArrayPane
extends AbstractManagementPane {
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private final int LEFT_INDENT_1 = 20;
    private final int LEFT_INDENT_2 = 22;
    private final int STEP_VSPACE = 15;
    static final int DRIVE_EMPTY = -3;
    static final int DRIVE_OFFLINE = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int RAID_0 = 0;
    static final int RAID_1 = 1;
    static final int RAID_3 = 2;
    static final int RAID_5 = 3;
    static final int RAID_01 = 4;
    static final int[] levels;
    static String[] levelNames;
    static String[] levelDescriptions;
    int[] driveAssignments = new int[14];
    int[] driveCapacities = new int[14];
    DriveSelectionPanel drivePanel;
    JLabel legendLabel;
    ArraySelectionPanel legend;
    StepByStepPanel summaryHeader;
    JTextPane summaryLabel;
    JCheckBox confirmCheckBox;
    JButton deleteButton;
    RestartRequiredLabel restartLabel;
    private RaidSystem system;
    private static final int preferredWidth = 664;
    private static final int preferredHeight = 474;
    static /* synthetic */ Class class$com$apple$xsr$DeleteArrayModel;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        levels = nArray;
        levelNames = new String[]{Resources.getString("management.create.raid0"), Resources.getString("management.create.raid1"), Resources.getString("management.create.raid3"), Resources.getString("management.create.raid5"), Resources.getString("management.create.raid01")};
        levelDescriptions = new String[]{Resources.getString("management.create.raid0.note"), Resources.getString("management.create.raid1.note"), Resources.getString("management.create.raid3.note"), Resources.getString("management.create.raid5.note"), Resources.getString("management.create.raid01.note")};
    }

    public DeleteArrayPane() {
        super(664, 474);
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        boolean row = false;
        StepByStepPanel summaryHeader = new StepByStepPanel(Resources.getImage("icon.step.five"), Resources.getString("management.delete.summary"));
        this.summaryLabel = GUIFactory.newTextPane(Resources.getString("management.delete.summary.cannot"), 2);
        this.deleteButton = GUIFactory.newButton(Resources.getString("management.delete.deleteButton"));
        this.deleteButton.setEnabled(false);
        StepByStepPanel stepOne = new StepByStepPanel(Resources.getImage("icon.step.one"), Resources.getString("management.delete.selectArray"));
        this.add((Component)stepOne, constraints);
        ++constraints.gridy;
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        JPanel driveGroup = GUIFactory.newPanel();
        driveGroup.setLayout(new GridBagLayout());
        GridBagConstraints driveGroupConstraints = new GridBagConstraints();
        driveGroupConstraints.anchor = 17;
        driveGroupConstraints.fill = 2;
        driveGroupConstraints.gridx = 1;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.fill = 1;
        driveGroupConstraints.insets = new Insets(0, 0, 6, 0);
        driveGroupConstraints.weightx = 1.0;
        driveGroup.add((Component)driveInfo, driveGroupConstraints);
        driveGroupConstraints.weightx = 0.0;
        driveGroupConstraints.insets = zeroInsets;
        driveGroupConstraints.fill = 0;
        this.drivePanel = new DriveSelectionPanel(2, driveInfo, summaryHeader, this.summaryLabel, this.deleteButton);
        driveGroupConstraints.gridx = 0;
        driveGroupConstraints.gridy = 0;
        driveGroupConstraints.insets = new Insets(0, 0, 0, 20);
        driveGroup.add((Component)this.drivePanel, driveGroupConstraints);
        driveGroupConstraints.insets = zeroInsets;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)driveGroup, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        this.legendLabel = new JLabel(Resources.getString("management.delete.legendNote"));
        this.legendLabel.setVisible(false);
        this.legendLabel.setFont(GUIFactory.FONT_SMALL);
        constraints.insets = new Insets(0, 22, 0, 0);
        this.add((Component)this.legendLabel, constraints);
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        this.legend = new ArraySelectionPanel(1);
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.fill = 0;
        this.add((Component)this.legend, constraints);
        constraints.fill = 2;
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        this.legend.addPropertyChangeListener("ArrayIndex", new 1());
        this.drivePanel.addPropertyChangeListener("ArrayIndex", new 2());
        StepByStepPanel stepTwo = new StepByStepPanel(Resources.getImage("icon.step.two"), Resources.getString("management.delete.confirmation"));
        this.add((Component)stepTwo, constraints);
        ++constraints.gridy;
        JPanel confirmGroup = GUIFactory.newPanel();
        confirmGroup.setLayout(new GridBagLayout());
        GridBagConstraints confirmGroupConstraints = new GridBagConstraints();
        confirmGroupConstraints.gridwidth = 1;
        confirmGroupConstraints.anchor = 17;
        confirmGroupConstraints.fill = 2;
        int optionsRow = 0;
        this.confirmCheckBox = GUIFactory.newCheckBox(Resources.getString("management.delete.iUnderstand"));
        this.confirmCheckBox.setFont(GUIFactory.FONT_SMALL);
        confirmGroupConstraints.gridx = 0;
        confirmGroupConstraints.gridy = optionsRow++;
        confirmGroup.add((Component)this.confirmCheckBox, confirmGroupConstraints);
        this.confirmCheckBox.addActionListener(new 3());
        constraints.insets = new Insets(0, 20, 15, 0);
        constraints.anchor = 17;
        constraints.fill = 0;
        this.add((Component)confirmGroup, constraints);
        constraints.insets = zeroInsets;
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)summaryHeader, constraints);
        ++constraints.gridy;
        this.summaryLabel.setFont(GUIFactory.FONT_SMALL);
        this.summaryLabel.setEditable(false);
        this.summaryLabel.setOpaque(false);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 20, 15, 0);
        this.add((Component)this.summaryLabel, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = zeroInsets;
        ++constraints.gridy;
        JPanel buttonPane = GUIFactory.newPanel();
        buttonPane.setLayout(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.gridx = 0;
        buttonConstraints.gridy = 0;
        buttonConstraints.gridwidth = 1;
        buttonConstraints.gridheight = 1;
        buttonConstraints.anchor = 17;
        buttonConstraints.fill = 1;
        this.restartLabel = new RestartRequiredLabel();
        this.restartLabel.setVisible(false);
        buttonConstraints.weightx = 1.0;
        buttonConstraints.insets = new Insets(0, 3, 0, 0);
        buttonPane.add((Component)this.restartLabel, buttonConstraints);
        buttonConstraints.weightx = 0.0;
        buttonConstraints.insets = new Insets(0, 0, 0, 0);
        ++buttonConstraints.gridx;
        JButton cancelButton = GUIFactory.newCancelButton();
        buttonPane.add((Component)cancelButton, buttonConstraints);
        ++buttonConstraints.gridx;
        cancelButton.addActionListener(new 4());
        buttonPane.add(Box.createHorizontalStrut(10), buttonConstraints);
        ++buttonConstraints.gridx;
        buttonPane.add((Component)this.deleteButton, buttonConstraints);
        ++buttonConstraints.gridx;
        this.deleteButton.addActionListener(new 5());
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 15;
        constraints.fill = 2;
        this.add((Component)buttonPane, constraints);
        ++constraints.gridy;
    }

    public void populateUI(DataModel data) {
        if (data.getClass() != (class$com$apple$xsr$DeleteArrayModel != null ? class$com$apple$xsr$DeleteArrayModel : (class$com$apple$xsr$DeleteArrayModel = DeleteArrayPane.class$("com.apple.xsr.DeleteArrayModel")))) {
            throw new IllegalArgumentException("illegal data model type " + data.getClass());
        }
        if (data != null) {
            DeleteArrayModel model = (DeleteArrayModel)data;
            this.system = new RaidSystem(model.getRaidSystem());
            this.drivePanel.configureForRaidSystem(this.system);
            this.legend.configureForRaidSystem(this.system);
            this.legendLabel.setVisible(this.system.hasRaidOrJbodDisks());
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel data) {
        if (data != null) {
            DeleteArrayModel model = (DeleteArrayModel)data;
            model.setArrayIndex(this.drivePanel.getArrayIndex());
        }
        return true;
    }

    private void setArrayIndex(Component c, int index) {
        boolean visible = false;
        if (c == this.drivePanel) {
            this.legend.setArrayIndex(index);
        } else if (c == this.legend) {
            this.drivePanel.setArrayIndex(index);
        }
        if (index > 0) {
            RaidSet raidSet = this.system.getRaidSet(index);
            if (raidSet != null) {
                visible = raidSet.getController().getRaidSets().size() == 1;
            }
        } else if (DriveSelectionPanel.isJbod(index)) {
            visible = true;
        }
        this.restartLabel.setVisible(visible);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            DeleteArrayPane.this.setArrayIndex(DeleteArrayPane.this.legend, value);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            DeleteArrayPane.this.setArrayIndex(DeleteArrayPane.this.drivePanel, value);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            boolean selected = DeleteArrayPane.this.confirmCheckBox.isSelected();
            DeleteArrayPane.this.drivePanel.setConfirmed(selected);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(DeleteArrayPane.this, 1001, "CANCEL");
            DeleteArrayPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(DeleteArrayPane.this, 1001, "APPLY");
            DeleteArrayPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 5() {
        }
    }
}

