/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AquaInformationPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Renderer;
import javax.swing.SwingUtilities;

public class DriveInformationPanel
extends AquaInformationPanel {
    public DriveInformationPanel(Image image, String text) {
        super(image, text);
        if (!Gestalt.isAquaLookAndFeel) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 0;
            constraints.gridheight = 2;
            this.add(Box.createVerticalStrut(90), constraints);
        }
    }

    public void setText(String text) {
        this.setText((Object)text);
    }

    public void setText(Object object) {
        if (this.textRenderer != null) {
            this.textRenderer.setValue(object, false);
            this.validate();
            Window w = SwingUtilities.getWindowAncestor(this);
            if (w != null) {
                w.repaint();
            } else {
                this.repaint();
            }
        }
    }

    protected Renderer createDefaultTextRenderer() {
        return new TextTableRenderer();
    }

    private static class TextTableRenderer
    extends JPanel
    implements Renderer {
        public static final int DEFAULT_ANCHOR = 18;
        public static final int DEFAULT_CELL_SPACING = 4;
        private static final Insets INSETS_ZERO = new Insets(0, 0, 0, 0);
        private static final Insets INSETS_CELL_SPACE = new Insets(0, 0, 0, 4);

        public TextTableRenderer() {
            GUIFactory.configureComponentForPlatform(this);
            this.setBackground(AquaInformationPanel.BOX_COLOR);
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.anchor = 18;
            constraints.fill = 1;
            this.add((Component)this.createTextPane(""), constraints);
        }

        public Component getComponent() {
            return this;
        }

        public void setValue(Object value, boolean isSelected) {
            if (value == null) {
                throw new NullPointerException("value cannot be null");
            }
            if (!(value instanceof String) && !(value instanceof Object[])) {
                throw new IllegalArgumentException("value must be a String or Collection; got " + value.getClass());
            }
            if (value instanceof String) {
                if (this.getComponentCount() == 1) {
                    JTextPane textPane = (JTextPane)this.getComponent(0);
                    textPane.setText(String.valueOf(String.valueOf(value)));
                } else {
                    this.removeAll();
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.weightx = 1.0;
                    constraints.weighty = 1.0;
                    constraints.anchor = 18;
                    constraints.fill = 1;
                    this.add((Component)this.createTextPane(String.valueOf(String.valueOf(value))), constraints);
                    this.invalidate();
                }
            } else {
                this.removeAll();
                this.addCells((Object[])value);
                this.invalidate();
            }
        }

        private void addCells(Object[] cells) {
            GridBagConstraints constraints = new GridBagConstraints();
            int i = 0;
            while (i < cells.length) {
                Object o = cells[i];
                if (!(o instanceof TextCell)) {
                    throw new ClassCastException(String.valueOf(String.valueOf(o.getClass())) + " not a TextCell object");
                }
                TextCell cell = (TextCell)o;
                constraints.gridx = cell.x;
                constraints.gridy = cell.y;
                constraints.gridwidth = cell.colspan;
                constraints.gridheight = cell.rowspan;
                constraints.weightx = cell.colspan > 1 ? 1 : 0;
                constraints.weighty = 1.0;
                constraints.anchor = cell.x == 0 && cell.colspan == 1 ? 12 : 18;
                constraints.fill = 3;
                constraints.ipadx = 0;
                constraints.ipady = 0;
                constraints.insets = cell.colspan > 1 ? INSETS_ZERO : INSETS_CELL_SPACE;
                this.add((Component)this.createTextPane(cell.text), constraints);
                ++i;
            }
        }

        private JTextPane createTextPane(String text) {
            JTextPane textPane = GUIFactory.newTextPane();
            textPane.setFont(GUIFactory.FONT_SMALL);
            textPane.setEditable(false);
            textPane.setBorder(null);
            textPane.setBackground(AquaInformationPanel.BOX_COLOR);
            textPane.setText(text);
            return textPane;
        }
    }

    public static class TextCell
    implements Cloneable {
        public int x = 0;
        public int y = 0;
        public int colspan = 1;
        public int rowspan = 1;
        public String text = "";

        public TextCell() {
        }

        public TextCell(TextCell textCell) {
            this.x = textCell.x;
            this.y = textCell.y;
            this.colspan = textCell.colspan;
            this.rowspan = textCell.rowspan;
            this.text = textCell.text;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Assertion Failure");
            }
        }
    }
}

