/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.CapacityConverter;
import com.apple.util.StringUtilities;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayPane;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;

public class DriveSelectionPanel
extends JPanel
implements DrivePanel {
    public static final int NO_SELECTION = 0;
    public static final int SELECT_FOR_CREATE = 1;
    public static final int SELECT_FOR_DELETE = 2;
    public static final int SELECT_FOR_DRIVE_INFO = 3;
    public static final int SELECT_FOR_ARRAY_INFO = 4;
    public static final int SELECT_FOR_EXPAND = 5;
    public static final int SELECT_FOR_VERIFY = 6;
    public static final int SELECT_FOR_REBUILD = 7;
    public static final int SELECT_FOR_SLICE = 8;
    public static final int SELECT_FOR_MERGE = 9;
    public static final int SELECT_FOR_BGRW_START = 10;
    public static final int SELECT_FOR_BGRW_PAUSE = 11;
    public static final int SELECT_FOR_BGRW_RESUME = 12;
    public static final int SELECT_FOR_BGRW_STOP = 13;
    public static final int RAID_0 = 0;
    public static final int RAID_1 = 1;
    public static final int RAID_3 = 2;
    public static final int RAID_5 = 3;
    public static final int RAID_01 = 4;
    public static final int JBOD = 255;
    public static final int INDEX_NONE = -10;
    public static final int RAID_SET_ID_JBOD_TOP = -2;
    public static final int RAID_SET_ID_JBOD_BOTTOM = -3;
    static final int DRIVE_ORPHAN = -5;
    static final int DRIVE_EMPTY = -4;
    static final int DRIVE_OFFLINE = -3;
    static final int DRIVE_ASSIGNED = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int ARRAY_VALID = 0;
    static final int ARRAY_INVALID = 1;
    static final int ARRAY_INVALID_NO_DRIVES = 2;
    static final int ARRAY_INVALID_MORE_DRIVES = 3;
    static final int ARRAY_INVALID_WRONG_DRIVES = 4;
    static final int ARRAY_INVALID_NO_LUNS = 5;
    static final int JBOD_INVALID_EXISTING_ARRAY = 6;
    static final int JBOD_INVALID_MORE_DRIVES = 7;
    private static Color hiliteColor = new JTable().getSelectionBackground();
    private static Color badgeColor = Color.getHSBColor(0.0f, 0.0f, 0.4f);
    RaidSystem system;
    int selectionMode;
    boolean expandArbitrary = false;
    int[] driveArrays;
    int[] driveStates;
    float[] driveCapacities;
    String[] arrayDescriptions;
    int[] arrayLevels;
    DriveInformationPanel infoLabel;
    StepByStepPanel summaryHeader;
    JTextPane summary;
    JButton applyButton;
    JLabel[] driveIcon;
    Image emptyImage;
    Image presentImage;
    Image availableImage;
    Image selectedImage;
    Image offlineImage;
    Image deleteImage;
    Image rebuildingImage;
    Image expandImage;
    Image orphanImage;
    int driveIndex = -10;
    int arrayIndex = -10;
    boolean confirmed;
    int level = 0;
    int[] defaultDriveStates = new int[]{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4};
    int[] defaultDriveArrays = new int[14];
    boolean addNotifyCalled = false;
    boolean inDragSelect = false;
    boolean selecting = false;

    public DriveSelectionPanel(int inSelectionMode, DriveInformationPanel infoLabel, StepByStepPanel inSummaryHeader, JTextPane inSummary, JButton inApplyButton) {
        MediaTracker tracker;
        GUIFactory.configureComponentForPlatform(this);
        this.driveStates = this.defaultDriveStates;
        this.driveArrays = this.defaultDriveArrays;
        this.selectionMode = inSelectionMode;
        this.infoLabel = infoLabel;
        this.summaryHeader = inSummaryHeader;
        this.summary = inSummary;
        this.applyButton = inApplyButton;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(false);
        }
        this.emptyImage = Resources.getImage("icon.frontpanel.drive.empty");
        this.presentImage = Resources.getImage("icon.frontpanel.drive.present");
        this.availableImage = Resources.getImage("icon.frontpanel.drive.available");
        this.selectedImage = Resources.getImage("icon.frontpanel.drive.selected");
        this.offlineImage = Resources.getImage("icon.frontpanel.drive.offline");
        this.deleteImage = Resources.getImage("icon.frontpanel.drive.delete");
        this.rebuildingImage = Resources.getImage("icon.frontpanel.drive.rebuilding");
        this.expandImage = Resources.getImage("icon.frontpanel.drive.expand");
        this.orphanImage = Resources.getImage("icon.frontpanel.drive.orphan");
        MediaTracker mediaTracker = tracker = new MediaTracker(this);
        synchronized (mediaTracker) {
            tracker.addImage(this.emptyImage, 0);
            tracker.addImage(this.presentImage, 0);
            tracker.addImage(this.availableImage, 0);
            tracker.addImage(this.selectedImage, 0);
            tracker.addImage(this.offlineImage, 0);
            tracker.addImage(this.deleteImage, 0);
            tracker.addImage(this.rebuildingImage, 0);
            tracker.addImage(this.expandImage, 0);
            tracker.addImage(this.orphanImage, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {}
            tracker.removeImage(this.emptyImage, 0);
            tracker.removeImage(this.presentImage, 0);
            tracker.removeImage(this.availableImage, 0);
            tracker.removeImage(this.selectedImage, 0);
            tracker.removeImage(this.offlineImage, 0);
            tracker.removeImage(this.deleteImage, 0);
            tracker.removeImage(this.rebuildingImage, 0);
            tracker.removeImage(this.expandImage, 0);
            tracker.removeImage(this.orphanImage, 0);
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        JLabel top = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.top")));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 17;
        constraints.gridheight = 1;
        this.add((Component)top, constraints);
        int column = 0;
        JLabel left = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.left")));
        constraints.gridx = column++;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)left, constraints);
        this.driveIcon = new JLabel[14];
        int drive = 0;
        while (drive < 14) {
            this.driveIcon[drive] = new JLabel(new ImageIcon(this.emptyImage));
            constraints.gridx = column++;
            constraints.gridy = 1;
            this.add((Component)this.driveIcon[drive], constraints);
            this.driveIcon[drive].addMouseListener(new DriveIconListener(drive, infoLabel));
            if (drive == 6) {
                JLabel center = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.center")));
                constraints.gridx = column++;
                constraints.gridy = 1;
                this.add((Component)center, constraints);
            }
            ++drive;
        }
        JLabel right = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.right")));
        constraints.gridx = column++;
        constraints.gridy = 1;
        this.add((Component)right, constraints);
        JLabel bottom = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.bottom")));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 17;
        constraints.gridheight = 1;
        this.add((Component)bottom, constraints);
    }

    public void setRaidSystem(RaidSystem raidSystem) {
        this.system = raidSystem;
        this.configureForRaidSystem(this.system);
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void setSelectionMode(int inSelectionMode) {
        this.selectionMode = inSelectionMode;
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void setDriveStates(int[] inDriveStates) {
        this.driveStates = inDriveStates != null ? inDriveStates : this.defaultDriveStates;
        this.syncDriveIcons();
    }

    public int[] getDriveStates() {
        return this.driveStates;
    }

    public void setDriveArrays(int[] inDriveArrays) {
        this.driveArrays = inDriveArrays != null ? inDriveArrays : this.defaultDriveArrays;
        this.syncDriveIcons();
    }

    public int[] getDriveArrays() {
        return this.driveArrays;
    }

    public void setDriveCapacities(float[] inDriveCapacities) {
        this.driveCapacities = inDriveCapacities;
    }

    public void setArrayDescriptions(String[] inArrayDescriptions) {
        this.arrayDescriptions = inArrayDescriptions;
    }

    public void setArrayLevels(int[] inArrayLevels) {
        this.arrayLevels = inArrayLevels;
    }

    public void setDriveSelected(int driveID, boolean selected) {
        if (selected) {
            this.selectDrive(driveID - 1);
        } else {
            this.deselectDrive(driveID - 1);
        }
    }

    public boolean isDriveSelected(int driveID) {
        return this.driveStates[driveID - 1] == -1;
    }

    public void setArraySelected(int arrayID, boolean selected) {
        this.setArrayIndex(selected ? arrayID : -10);
    }

    public boolean isArraySelected(int arrayID) {
        return arrayID - 1 == this.arrayIndex;
    }

    public void setArrayIndex(int index) {
        this.arrayIndex = index;
        if (this.selectionMode == 5) {
            int drive = 0;
            while (drive < 14) {
                if (this.driveArrays[drive] == index) {
                    this.deselectUnavailableDrives(drive);
                    break;
                }
                ++drive;
            }
        }
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void setSelectedArray(int arrayID) {
        this.setArrayIndex(arrayID);
    }

    public int getSelectedArray() {
        return this.getArrayIndex();
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public boolean isSelectedArray(int arrayID) {
        return arrayID == this.arrayIndex;
    }

    public void setLevel(int inLevel) {
        this.level = inLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSelectionJbod() {
        return DriveSelectionPanel.isJbod(this.arrayIndex);
    }

    public boolean jbodExists(int id) {
        int i = 0;
        while (i < this.driveArrays.length) {
            if (this.driveArrays[i] == id) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setConfirmed(boolean state) {
        this.confirmed = state;
        this.syncSummary();
    }

    public void setSelectedDriveCount(int count) {
        int start = 0;
        int drive = 0;
        while (drive < 14) {
            if (this.driveStates[drive] == -1) {
                this.driveStates[drive] = 0;
            }
            ++drive;
        }
        drive = 0;
        while (drive < 14) {
            if (this.driveArrays[drive] == this.arrayIndex) {
                start = drive < 7 ? 0 : 7;
                float leastCapacity = 0.0f;
                drive = start;
                while (drive < start + 7) {
                    if (this.driveArrays[drive] == this.arrayIndex && (leastCapacity == 0.0f || this.driveCapacities[drive] < leastCapacity)) {
                        leastCapacity = this.driveCapacities[drive];
                    }
                    ++drive;
                }
                drive = start;
                while (drive < start + 7) {
                    if (this.driveStates[drive] == 0 && this.driveCapacities[drive] >= leastCapacity && count-- > 0) {
                        this.driveStates[drive] = -1;
                    }
                    ++drive;
                }
                break;
            }
            ++drive;
        }
        this.syncDriveIcons();
        this.syncSummary();
    }

    public int getAvailableDriveCount() {
        int count = 0;
        if (this.arrayIndex < 1) {
            return 0;
        }
        int drive = 0;
        while (drive < 14) {
            if (this.driveArrays[drive] == this.arrayIndex) {
                int start = drive < 7 ? 0 : 7;
                float leastCapacity = 0.0f;
                drive = start;
                while (drive < start + 7) {
                    if (this.driveArrays[drive] == this.arrayIndex && (leastCapacity == 0.0f || this.driveCapacities[drive] < leastCapacity)) {
                        leastCapacity = this.driveCapacities[drive];
                    }
                    ++drive;
                }
                drive = start;
                while (drive < start + 7) {
                    if ((this.driveStates[drive] == 0 || this.driveStates[drive] == -1) && this.driveCapacities[drive] >= leastCapacity) {
                        ++count;
                    }
                    ++drive;
                }
                break;
            }
            ++drive;
        }
        return count;
    }

    public void updatePanel() {
        this.configureForRaidSystem(this.system);
    }

    public void resetPanel() {
        this.configureForRaidSystem(null);
    }

    public void configureForRaidSystem(RaidSystem system) {
        int[] states = null;
        int[] arrays = null;
        int[] levels = null;
        float[] capacities = null;
        String[] descriptions = null;
        if (system != null) {
            states = DriveSelectionPanel.getDriveStatesFromRaidSystem(system);
            arrays = DriveSelectionPanel.getDriveArraysFromRaidSystem(system);
            capacities = DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(system);
            if (this.selectionMode == 5 || this.selectionMode == 6 || this.selectionMode == 7) {
                levels = ArraySelectionPanel.getArrayLevelsFromRaidSystem(system);
            }
            if (this.infoLabel != null) {
                descriptions = ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(system);
            }
        }
        this.setDriveStates(states);
        this.setDriveArrays(arrays);
        this.setArrayLevels(levels);
        this.setDriveCapacities(capacities);
        this.setArrayDescriptions(descriptions);
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        this.syncDriveIcons();
    }

    private void syncDriveIcons() {
        if (!this.addNotifyCalled || this.driveArrays == null || this.driveStates == null) {
            return;
        }
        int drive = 0;
        while (drive < 14) {
            int width = 18;
            int height = 68;
            int badgeOffset = 49;
            int badgeHeight = 14;
            Image temp = this.createImage(width, height);
            Graphics context = temp.getGraphics();
            Image baseImage = this.driveStates[drive] == -4 ? this.emptyImage : (this.driveStates[drive] == -1 ? (this.selectionMode == 5 ? (this.expandArbitrary ? this.selectedImage : this.presentImage) : this.selectedImage) : (this.driveStates[drive] == 0 && this.selectionMode == 1 ? this.availableImage : (this.driveStates[drive] == 0 && this.selectionMode == 5 ? (this.expandArbitrary ? this.availableImage : this.presentImage) : this.presentImage)));
            context.drawImage(baseImage, 0, 0, null);
            if (baseImage == this.availableImage || baseImage == this.selectedImage) {
                badgeOffset -= 12;
            }
            if (this.selectionMode == 4 && this.driveArrays[drive] == this.arrayIndex || this.selectionMode == 3 && drive == this.driveIndex || this.selectionMode == 5 && this.driveArrays[drive] == this.arrayIndex || this.selectionMode == 6 && this.driveArrays[drive] == this.arrayIndex || this.selectionMode == 7 && this.driveArrays[drive] == this.arrayIndex || this.selectionMode == 8 && this.driveArrays[drive] == this.arrayIndex || this.selectionMode == 9 && this.driveArrays[drive] == this.arrayIndex || (this.selectionMode == 10 || this.selectionMode == 11 || this.selectionMode == 12 || this.selectionMode == 13) && this.driveArrays[drive] == this.arrayIndex) {
                this.tintIcon(context, width, height, hiliteColor, 0.7f, true);
            } else if (this.selectionMode == 2 && this.driveArrays[drive] == this.arrayIndex) {
                this.tintIcon(context, width, height, Color.red, 0.4f, false);
            }
            if (this.driveArrays[drive] != 0) {
                context.setColor(badgeColor);
                context.fillRect(4, 53, 10, 10);
                context.setColor(Color.white);
                context.setFont(GUIFactory.FONT_BADGE);
                if (this.driveArrays[drive] > 0) {
                    context.drawString(String.valueOf(this.driveArrays[drive]), 6, 62);
                } else {
                    context.drawString("J", 8, 61);
                }
                badgeOffset -= badgeHeight;
            }
            if (this.selectionMode == 5 && this.driveStates[drive] == -1) {
                context.drawImage(this.expandImage, 0, badgeOffset, null);
                badgeOffset -= badgeHeight;
            }
            if (this.selectionMode == 2 && this.driveArrays[drive] == this.arrayIndex) {
                context.drawImage(this.deleteImage, 0, badgeOffset + 1, null);
                badgeOffset -= badgeHeight;
            }
            if (this.driveStates[drive] == -3) {
                context.drawImage(this.offlineImage, 0, badgeOffset, null);
                badgeOffset -= badgeHeight;
            }
            if (this.driveStates[drive] == -5) {
                boolean useBadge = false;
                if (useBadge) {
                    boolean useQuestionMark;
                    Disk disk;
                    int arrayId = 0;
                    if (this.system != null && (disk = this.system.getDisk(drive + 1)) != null) {
                        arrayId = disk.getOrphanRaidSetId();
                    }
                    context.setColor(badgeColor);
                    context.fillRect(4, 53, 10, 10);
                    context.setColor(Color.white);
                    context.setFont(GUIFactory.FONT_BADGE);
                    if (arrayId > 0) {
                        context.drawString(String.valueOf(arrayId), 6, 62);
                    }
                    if ((useQuestionMark = false) && arrayId == 0) {
                        context.drawString("?", 7, 61);
                    }
                    context.drawImage(this.orphanImage, 4, (badgeOffset -= badgeHeight) + 6, null);
                } else {
                    context.drawImage(this.orphanImage, 4, badgeOffset + 4, null);
                    badgeOffset -= badgeHeight;
                }
            }
            this.driveIcon[drive].setIcon(new ImageIcon(temp));
            ++drive;
        }
    }

    private void tintIcon(Graphics context, int width, int height, Color color, float alpha, boolean drawFocus) {
        AlphaComposite blend = AlphaComposite.getInstance(3, alpha);
        Composite save = ((Graphics2D)context).getComposite();
        ((Graphics2D)context).setComposite(blend);
        context.setColor(color);
        context.fillRect(1, 1, width - 2, height - 2);
        ((Graphics2D)context).setComposite(save);
        if (drawFocus) {
            context.setColor(color);
            context.drawRect(1, 1, width - 3, height - 3);
            context.drawRect(2, 2, width - 5, height - 5);
        }
    }

    private boolean toggleDrive(int drive) {
        boolean result = false;
        if (this.driveStates[drive] == 0 || this.selectionMode == 5 && this.driveStates[drive] == -2) {
            this.selectDrive(drive);
            result = true;
        } else if (this.driveStates[drive] == -1) {
            this.deselectDrive(drive);
        }
        return result;
    }

    private void selectDrive(int drive) {
        if (this.selectionMode == 4 && this.driveStates[drive] == -3) {
            this.selectionMode = 3;
            this.firePropertyChange("SelectionMode", -1, this.selectionMode);
        }
        if (this.selectionMode == 3) {
            this.driveIndex = drive;
            this.syncDriveIcons();
            this.firePropertyChange("DriveIndex", -1, this.driveIndex);
        }
        if ((this.selectionMode == 4 || this.selectionMode == 2 || this.selectionMode == 5 || this.selectionMode == 6 || this.selectionMode == 7 || this.selectionMode == 8 || this.selectionMode == 9 || this.selectionMode == 10 || this.selectionMode == 11 || this.selectionMode == 12 || this.selectionMode == 13) && this.driveStates[drive] == -2) {
            this.arrayIndex = this.driveArrays[drive];
            this.syncDriveIcons();
            this.syncSummary();
            this.firePropertyChange("ArrayIndex", -1, this.arrayIndex);
            if (this.selectionMode == 5) {
                this.deselectUnavailableDrives(drive);
            }
        }
        if ((this.selectionMode == 1 || this.selectionMode == 5 && this.expandArbitrary) && this.driveStates[drive] == 0) {
            this.driveStates[drive] = -1;
            this.syncDriveIcons();
            this.deselectUnavailableDrives(drive);
        }
    }

    private void deselectDrive(int drive) {
        if (this.driveStates[drive] == -1) {
            this.driveStates[drive] = 0;
            this.syncDriveIcons();
        }
    }

    private void deselectUnavailableDrives(int selectedDrive) {
        RaidController controller = this.system.getRaidControllerForDiskSlot(selectedDrive + 1);
        if (controller != null) {
            int drive = 0;
            while (drive < 14) {
                if (this.system.getRaidControllerForDiskSlot(drive + 1) != controller) {
                    if (this.selectionMode == 5 && this.driveArrays[drive] == this.arrayIndex) {
                        this.arrayIndex = -10;
                        this.syncDriveIcons();
                        this.firePropertyChange("ArrayIndex", -1, this.arrayIndex);
                    }
                    if (this.driveStates[drive] == -1) {
                        this.deselectDrive(drive);
                    }
                }
                ++drive;
            }
        }
    }

    public void syncSummary() {
        boolean arrayOnline;
        String summaryString = null;
        boolean bl = arrayOnline = this.arrayIndex > 0 && this.arrayOnline(this.arrayIndex);
        if (this.selectionMode == 1) {
            int state = this.checkArray();
            if (state == 0) {
                float capacity = this.getArrayCapacity();
                String capacityString = this.getCapacityString(capacity);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                if (this.level != 255) {
                    summaryString = Resources.getString("management.create.summary.can");
                    summaryString = StringUtilities.replaceAll(summaryString, "{level}", CreateArrayPane.levelNames[this.level]);
                    summaryString = StringUtilities.replaceAll(summaryString, "{capacity}", capacityString);
                } else {
                    summaryString = Resources.getString("management.create.summary.can.jbod");
                }
                this.applyButton.setEnabled(true);
            } else {
                summaryString = this.level != 255 ? Resources.getString("management.create.summary.cannot") : Resources.getString("management.create.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                summaryString = state == 2 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.noDrives")) : (state == 5 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.noLuns")) : (state == 3 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.moreDrives")) : (state == 4 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.wrongDrives")) : (state == 6 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.jbod.existingArray")) : (state == 7 ? StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.jbod.moreDrives")) : StringUtilities.replaceAll(summaryString, "{reason}", Resources.getString("management.create.summary.reason.unknown")))))));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 2) {
            if ((this.arrayIndex > 0 || DriveSelectionPanel.isJbod(this.arrayIndex)) && this.confirmed) {
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                    summaryString = Resources.getString("management.delete.summary.can.jbod");
                } else {
                    summaryString = Resources.getString("management.delete.summary.can");
                    summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                }
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString("management.delete.summary.cannot");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
            String btnTitle = Resources.getString(DriveSelectionPanel.isJbod(this.arrayIndex) ? "management.delete.deleteButton.jbod" : "management.delete.deleteButton");
            this.applyButton.setText(btnTitle);
        } else if (this.selectionMode == 5) {
            int driveCount = this.countSelectedDrives();
            if (this.arrayIndex > 0 && this.arrayLevels[this.arrayIndex - 1] == 4 || DriveSelectionPanel.isJbod(this.arrayIndex)) {
                summaryString = this.arrayIndex > 0 ? Resources.getString("advanced.expansion.summary.cannot.wrongType") : Resources.getString("advanced.expansion.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !arrayOnline) {
                summaryString = Resources.getString("advanced.expansion.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                summaryString = this.arrayBusy(this.arrayIndex) ? Resources.getString("advanced.expansion.summary.cannot.busy.self") : Resources.getString("advanced.expansion.summary.cannot.busy");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && driveCount > 0 && this.confirmed) {
                this.level = this.arrayLevels[this.arrayIndex - 1];
                float capacity = this.getArrayCapacity();
                String capacityString = this.getCapacityString(capacity);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                summaryString = Resources.getString("advanced.expansion.summary.can");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                summaryString = StringUtilities.replaceAll(summaryString, "{capacity}", capacityString);
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString("advanced.expansion.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 6 || this.selectionMode == 7) {
            int driveCount = this.countSelectedDrives();
            if (this.arrayIndex > 0 && this.arrayLevels[this.arrayIndex - 1] != 2 && this.arrayLevels[this.arrayIndex - 1] != 3 || DriveSelectionPanel.isJbod(this.arrayIndex)) {
                if (!DriveSelectionPanel.isJbod(this.arrayIndex)) {
                    summaryString = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.wrongType" : "firstAid.rebuild.summary.cannot.wrongType");
                    summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                } else {
                    summaryString = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.jbod" : "firstAid.rebuild.summary.cannot.jbod");
                }
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !arrayOnline) {
                summaryString = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.online" : "firstAid.rebuild.summary.cannot.online");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                summaryString = this.arrayBusy(this.arrayIndex) ? Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.busySelf" : "firstAid.rebuild.summary.cannot.busySelf") : Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.busy" : "firstAid.rebuild.summary.cannot.busy");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                summaryString = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.can" : "firstAid.rebuild.summary.can");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.general" : "firstAid.rebuild.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 10) {
            if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                if (this.arrayBusy(this.arrayIndex)) {
                    summaryString = Resources.getString("firstAid.condition.summary.cannot.busySelf");
                    this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                    this.applyButton.setEnabled(false);
                } else {
                    RaidSet busySet = this.busyRaidSet();
                    if (busySet != null) {
                        int op = busySet.getOperation();
                        if (op == 5) {
                            summaryString = Resources.getString("firstAid.condition.summary.can.start");
                            summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                            this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                            this.applyButton.setEnabled(true);
                        } else {
                            summaryString = Resources.getString("firstAid.condition.summary.cannot.busy");
                            this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                            this.applyButton.setEnabled(false);
                        }
                    }
                }
            } else if (this.arrayIndex > 0 && !arrayOnline) {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                summaryString = Resources.getString("firstAid.condition.summary.can.start");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 12) {
            RaidSet raidSet;
            int op = -1;
            int state = -1;
            if (this.arrayIndex > 0 && (raidSet = this.system.getRaidSet(this.arrayIndex)) != null) {
                op = raidSet.getOperation();
                state = raidSet.getBackgroundConditioningState();
            }
            if (op != 5 || state != 1) {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !arrayOnline) {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                summaryString = Resources.getString("firstAid.condition.summary.can.resume");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 11 || this.selectionMode == 13) {
            if (this.arrayIndex > 0 && this.confirmed) {
                summaryString = Resources.getString(this.selectionMode == 11 ? "firstAid.condition.summary.can.pause" : "firstAid.condition.summary.can.stop");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                summaryString = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 8 || this.selectionMode == 9) {
            boolean lunsAvailable = false;
            if (this.selectionMode == 9 || this.selectionMode == 8 && this.countAvailableLuns() > 0) {
                lunsAvailable = true;
            }
            if (this.arrayIndex > 0 && this.confirmed && lunsAvailable && arrayOnline) {
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                summaryString = this.selectionMode == 8 ? Resources.getString("advanced.slicing.summary.can.slice") : Resources.getString("advanced.slicing.summary.can.merge");
                summaryString = StringUtilities.replaceAll(summaryString, "{index}", String.valueOf(this.arrayIndex));
                this.applyButton.setEnabled(true);
            } else if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                summaryString = Resources.getString("advanced.slicing.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !arrayOnline) {
                summaryString = Resources.getString("advanced.slicing.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else {
                summaryString = Resources.getString("advanced.slicing.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        }
        if (this.summary != null && summaryString != null) {
            this.summary.setText(summaryString);
        }
    }

    public int checkArray() {
        if (this.driveArrays == null) {
            return 2;
        }
        int driveCount = this.countSelectedDrives();
        if (driveCount == 0) {
            return 2;
        }
        if (this.level == 0 || this.level == 1) {
            if (driveCount < 2) {
                return 3;
            }
        } else if (this.level == 2 || this.level == 3) {
            if (driveCount < 3) {
                return 3;
            }
        } else if (this.level == 4) {
            if (driveCount != 4 && driveCount != 6) {
                return 4;
            }
        } else if (this.level == 255) {
            int start;
            int drive = this.indexOfFirstSelectedDrive();
            if (drive == -1) {
                return 2;
            }
            int i = start = drive < 7 ? 0 : 7;
            while (i < start + 7) {
                if (this.driveArrays[i] != 0) {
                    return 6;
                }
                ++i;
            }
            int i2 = start;
            while (i2 < start + 7) {
                if (this.driveStates[i2] == 0) {
                    return 7;
                }
                if (this.driveStates[i2] == -2) {
                    return 6;
                }
                ++i2;
            }
        } else {
            return 1;
        }
        if (this.countAvailableLuns() == 0) {
            return 5;
        }
        return 0;
    }

    private int indexOfFirstSelectedDrive() {
        int drive = 0;
        while (drive < this.driveStates.length) {
            if (this.driveStates[drive] == -1) break;
            ++drive;
        }
        return drive < this.driveStates.length ? drive : -1;
    }

    public boolean arrayOnline(int globalArrayId) {
        RaidSet raidSet;
        boolean online = false;
        if (this.system != null && (raidSet = this.system.getRaidSet(globalArrayId)) != null) {
            online = raidSet.getState() == 0;
        }
        return online;
    }

    public boolean arrayBusy(int globalArrayId) {
        RaidSet raidSet;
        boolean arrayActive = false;
        if (this.system != null && (raidSet = this.system.getRaidSet(globalArrayId)) != null) {
            int op = raidSet.getOperation();
            arrayActive = op == 1 || op == 2 || op == 3 || op == 4 || op == 5;
        }
        return arrayActive;
    }

    public int getSelectionCount() {
        return this.countSelectedDrives();
    }

    public int countSelectedDrives() {
        int driveCount = 0;
        int drive = 0;
        while (drive < 14) {
            if (this.driveStates[drive] == -1) {
                ++driveCount;
            }
            ++drive;
        }
        return driveCount;
    }

    public int countAvailableLuns() {
        RaidController controller;
        int drive;
        int available = 0;
        int selectedDrive = -1;
        if (this.selectionMode == 1) {
            drive = 0;
            while (drive < 14) {
                if (this.driveStates[drive] == -1) {
                    selectedDrive = drive;
                    break;
                }
                ++drive;
            }
        } else if (this.selectionMode == 8) {
            drive = 0;
            while (drive < 14) {
                if (this.driveArrays[drive] == this.arrayIndex) {
                    selectedDrive = drive;
                    break;
                }
                ++drive;
            }
        }
        if (selectedDrive != -1 && (controller = this.system.getRaidControllerForDiskSlot(selectedDrive + 1)) != null) {
            if (this.selectionMode == 1) {
                available = controller.getLunsRemainingForCreation();
            } else if (this.selectionMode == 8) {
                available = controller.getLunsRemainingForSlicing();
            }
        }
        return available;
    }

    public boolean arrayControllerAlreadyBusy() {
        RaidSet busyRaidSet = this.busyRaidSet();
        boolean busy = busyRaidSet != null;
        return busy;
    }

    private RaidSet busyRaidSet() {
        RaidController controller;
        RaidSet busyRaidSet = null;
        int selectedDrive = -1;
        int drive = 0;
        while (drive < 14) {
            if (this.driveArrays[drive] == this.arrayIndex) {
                selectedDrive = drive;
                break;
            }
            ++drive;
        }
        if (selectedDrive != -1 && (controller = this.system.getRaidControllerForDiskSlot(selectedDrive + 1)) != null) {
            Collection raidSets = controller.getRaidSets();
            Iterator iterator = raidSets.iterator();
            while (iterator.hasNext()) {
                RaidSet rs = (RaidSet)iterator.next();
                int operation = rs.getOperation();
                if (operation != 1 && operation != 4 && operation != 3 && operation != 2 && operation != 5) continue;
                busyRaidSet = rs;
                break;
            }
        }
        return busyRaidSet;
    }

    public float getArrayCapacity() {
        float capacity = 0.0f;
        int driveCount = 0;
        float leastCapacity = 0.0f;
        int drive = 0;
        while (drive < 14) {
            if (this.driveStates[drive] == -1 || this.selectionMode == 5 && this.driveArrays[drive] == this.arrayIndex) {
                ++driveCount;
            }
            ++drive;
        }
        int drive2 = 0;
        while (drive2 < 14) {
            if ((this.driveStates[drive2] == -1 || this.selectionMode == 5 && this.driveArrays[drive2] == this.arrayIndex) && ((double)leastCapacity == 0.0 || this.driveCapacities[drive2] < leastCapacity)) {
                leastCapacity = this.driveCapacities[drive2];
            }
            ++drive2;
        }
        if (this.level == 0) {
            capacity = leastCapacity * (float)driveCount;
        } else if (this.level == 1) {
            capacity = leastCapacity;
        } else if (this.level == 2 || this.level == 3) {
            capacity = leastCapacity * (float)(driveCount - 1);
        } else if (this.level == 4) {
            capacity = leastCapacity * (float)(driveCount / 2);
        } else if (this.level == 255) {
            capacity = 0.0f;
        } else {
            throw new RuntimeException("Unrecognized RAID level: " + this.level);
        }
        return capacity;
    }

    String getCapacityString(float capacity) {
        String capacityString;
        float roundedCapacity = (double)capacity < 1024.0 ? capacity : capacity / 1024.0f;
        int roundedIntCapacity = (int)((double)roundedCapacity * 10000.0);
        if (roundedIntCapacity % 100 > 49) {
            roundedIntCapacity += 100;
        }
        roundedCapacity = (float)(roundedIntCapacity /= 100) / 100.0f;
        if ((double)capacity < 1024.0) {
            capacityString = Resources.getString("management.create.capacity.gb");
            capacityString = StringUtilities.replaceAll(capacityString, "{number}", String.valueOf(roundedCapacity));
        } else {
            capacityString = Resources.getString("management.create.capacity.tb");
            capacityString = StringUtilities.replaceAll(capacityString, "{number}", String.valueOf(roundedCapacity));
        }
        return capacityString;
    }

    static int[] getDriveArraysFromRaidSystem(RaidSystem rs) {
        int[] assignments = new int[14];
        Collection slots = rs.getDiskSlots();
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            DiskSlot slot = (DiskSlot)iter.next();
            int index = slot.getId() - 1;
            if (!slot.isPopulated()) continue;
            Disk disk = slot.getDisk();
            if (disk.getType() == 1) {
                RaidSet raidSet = disk.getRaidSet();
                if (raidSet == null) continue;
                assignments[index] = raidSet.getId();
                continue;
            }
            if (disk.getType() != 3) continue;
            int n = assignments[index] = index < 7 ? -2 : -3;
        }
        return assignments;
    }

    static int[] getDriveStatesFromRaidSystem(RaidSystem rs) {
        int[] states = new int[]{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4};
        Collection slots = rs.getDiskSlots();
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            DiskSlot slot = (DiskSlot)iter.next();
            int index = slot.getId() - 1;
            if (slot.isPopulated()) {
                Disk disk = slot.getDisk();
                if (disk.getStatus() == 0) {
                    if (disk.getType() == 1) {
                        RaidSet raidSet = disk.getRaidSet();
                        if (raidSet != null) {
                            states[index] = -2;
                            continue;
                        }
                        states[index] = 0;
                        continue;
                    }
                    if (disk.getType() == 3) {
                        states[index] = -2;
                        continue;
                    }
                    if (disk.getType() == 4) {
                        states[index] = -5;
                        continue;
                    }
                    states[index] = 0;
                    continue;
                }
                states[index] = -3;
                continue;
            }
            states[index] = -4;
        }
        return states;
    }

    static float[] getDriveCapacitiesFromRaidSystem(RaidSystem rs) {
        float[] capacities = new float[14];
        Collection slots = rs.getDiskSlots();
        Iterator iter = slots.iterator();
        while (iter.hasNext()) {
            DiskSlot slot = (DiskSlot)iter.next();
            int index = slot.getId() - 1;
            if (slot.isPopulated()) {
                Disk disk = slot.getDisk();
                capacities[index] = (float)CapacityConverter.toGigabytes(disk.getCapacityBytes());
                continue;
            }
            capacities[index] = 0.0f;
        }
        return capacities;
    }

    public static boolean isJbod(int arrayId) {
        return arrayId == -2 || arrayId == -3;
    }

    class DriveIconListener
    implements MouseListener {
        int drive;
        DriveInformationPanel infoLabel;

        DriveIconListener(int index, DriveInformationPanel info) {
            this.drive = index;
            this.infoLabel = info;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            DriveSelectionPanel.this.inDragSelect = true;
            if (e.isAltDown()) {
                if (DriveSelectionPanel.this.selectionMode == 3 && DriveSelectionPanel.this.driveArrays[this.drive] > 0) {
                    DriveSelectionPanel.this.selectionMode = 4;
                    DriveSelectionPanel.this.firePropertyChange("SelectionMode", -1, DriveSelectionPanel.this.selectionMode);
                } else if (DriveSelectionPanel.this.selectionMode == 4) {
                    DriveSelectionPanel.this.selectionMode = 3;
                    DriveSelectionPanel.this.firePropertyChange("SelectionMode", -1, DriveSelectionPanel.this.selectionMode);
                }
            }
            if (DriveSelectionPanel.this.selectionMode == 1 || DriveSelectionPanel.this.selectionMode == 5 && DriveSelectionPanel.this.expandArbitrary) {
                DriveSelectionPanel.this.selecting = DriveSelectionPanel.this.toggleDrive(this.drive);
            } else {
                DriveSelectionPanel.this.selecting = true;
                DriveSelectionPanel.this.selectDrive(this.drive);
            }
            DriveSelectionPanel.this.syncSummary();
        }

        public void mouseReleased(MouseEvent e) {
            DriveSelectionPanel.this.inDragSelect = false;
            DriveSelectionPanel.this.syncSummary();
        }

        public void mouseEntered(MouseEvent e) {
            if (DriveSelectionPanel.this.inDragSelect) {
                if (DriveSelectionPanel.this.selecting) {
                    DriveSelectionPanel.this.selectDrive(this.drive);
                } else {
                    DriveSelectionPanel.this.deselectDrive(this.drive);
                }
                DriveSelectionPanel.this.syncSummary();
            }
            if (this.infoLabel != null) {
                int state = DriveSelectionPanel.this.driveStates[this.drive];
                if (state == -4) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.empty"), "{number}", String.valueOf(this.drive + 1)));
                } else if (state == -3) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.offline"), "{number}", String.valueOf(this.drive + 1)));
                } else if (state == -5) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.note"), "{number}", String.valueOf(this.drive + 1)));
                } else if (state == -2) {
                    String temp;
                    int id = DriveSelectionPanel.this.driveArrays[this.drive];
                    if (id > 0) {
                        temp = StringUtilities.replaceAll(Resources.getString("management.driveInfo.assigned"), "{number}", String.valueOf(this.drive + 1));
                        temp = StringUtilities.replaceAll(temp, "{index}", String.valueOf(id));
                        temp = StringUtilities.replaceAll(temp, "{description}", DriveSelectionPanel.this.arrayDescriptions[id - 1]);
                    } else {
                        temp = StringUtilities.replaceAll(Resources.getString("management.driveInfo.jbod"), "{number}", String.valueOf(this.drive + 1));
                        temp = StringUtilities.replaceAll(temp, "{capacity}", DriveSelectionPanel.this.getCapacityString(DriveSelectionPanel.this.driveCapacities[this.drive]));
                    }
                    this.infoLabel.setText(temp);
                } else {
                    String temp = StringUtilities.replaceAll(Resources.getString("management.driveInfo.unassigned"), "{number}", String.valueOf(this.drive + 1));
                    temp = StringUtilities.replaceAll(temp, "{capacity}", DriveSelectionPanel.this.getCapacityString(DriveSelectionPanel.this.driveCapacities[this.drive]));
                    this.infoLabel.setText(temp);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.infoLabel != null) {
                this.infoLabel.setText(Resources.getString("management.driveInfo.note"));
            }
        }
    }
}

