/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DrivePanelSelectionModel;
import com.apple.xsr.DrivePanelSelectionPolicy;
import com.apple.xsr.Resources;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;

public class DriveSelectionPanelEx
extends JPanel
implements DrivePanel,
ItemSelectable {
    static final int DRIVE_COUNT = 14;
    private RaidSystem system;
    protected DrivePanelSelectionModel selectionModel = new DrivePanel.DefaultSelectionModel();
    protected DrivePanelSelectionPolicy selectionPolicy = new DrivePanel.DefaultSelectionPolicy();
    private int[] states = new int[14];
    private int[] types = new int[14];
    private int[] raidSets = new int[14];
    private int[] badges = new int[14];
    private int selectionColor = 0;
    private boolean useCheckBoxes = false;
    private Map infoIcons = new HashMap(4);
    private boolean expandArbitrary = false;
    boolean addNotifyCalled = false;
    boolean inDragSelect = false;
    boolean selecting = false;
    private final EventListenerList listenerList = new EventListenerList();
    private DriveIcon[] driveIcon;
    static final Image emptyImage = Resources.getImage("icon.frontpanel.drive.empty");
    static final Image presentImage = Resources.getImage("icon.frontpanel.drive.present");
    static final Image availableImage = Resources.getImage("icon.frontpanel.drive.available");
    static final Image selectedImage = Resources.getImage("icon.frontpanel.drive.selected");
    static final Image offlineImage = Resources.getImage("icon.frontpanel.drive.offline");
    static final Image deleteImage = Resources.getImage("icon.frontpanel.drive.delete");
    static final Image rebuildingImage = Resources.getImage("icon.frontpanel.drive.rebuilding");
    static final Image expandImage = Resources.getImage("icon.frontpanel.drive.expand");
    static final Image orphanImage = Resources.getImage("icon.frontpanel.drive.orphan");
    private static Color hiliteColor = new JTable().getSelectionBackground();
    private static Color badgeColor = Color.getHSBColor(0.0f, 0.0f, 0.4f);
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$com$apple$xsr$DrivePanelListener;

    public DriveSelectionPanelEx(int selectionMode) {
        GUIFactory.configureComponentForPlatform(this);
        this.selectionModel.setSelectionMode(selectionMode);
        this.selectionModel.addDrivePanelListener(new SelectionModelListener());
        int i = 0;
        while (i < 14) {
            this.states[i] = 1;
            this.types[i] = 0;
            this.raidSets[i] = 0;
            this.badges[i] = 0;
            ++i;
        }
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(emptyImage, 0);
        tracker.addImage(presentImage, 0);
        tracker.addImage(availableImage, 0);
        tracker.addImage(selectedImage, 0);
        tracker.addImage(offlineImage, 0);
        tracker.addImage(deleteImage, 0);
        tracker.addImage(rebuildingImage, 0);
        tracker.addImage(expandImage, 0);
        tracker.addImage(orphanImage, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        int column = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 1;
        JLabel top = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.top")));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 17;
        constraints.gridheight = 1;
        this.add((Component)top, constraints);
        JLabel left = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.left")));
        constraints.gridx = column++;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)left, constraints);
        this.driveIcon = new DriveIcon[14];
        int drive = 0;
        while (drive < 14) {
            this.driveIcon[drive] = new DriveIcon(drive, new ImageIcon(emptyImage));
            constraints.gridx = column++;
            constraints.gridy = 1;
            this.add((Component)this.driveIcon[drive], constraints);
            if (drive == 6) {
                JLabel center = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.center")));
                constraints.gridx = column++;
                constraints.gridy = 1;
                this.add((Component)center, constraints);
            }
            ++drive;
        }
        JLabel right = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.right")));
        constraints.gridx = column++;
        constraints.gridy = 1;
        this.add((Component)right, constraints);
        JLabel bottom = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.bottom")));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 17;
        constraints.gridheight = 1;
        this.add((Component)bottom, constraints);
    }

    public void setRaidSystem(RaidSystem system) {
        int i = 0;
        while (i < 14) {
            this.states[i] = 1;
            this.types[i] = 0;
            this.raidSets[i] = 0;
            ++i;
        }
        this.selectionModel.clearSelection();
        if (system != null) {
            this.system = new RaidSystem(system);
            Collection disks = this.system.getDisks();
            Iterator iter = disks.iterator();
            while (iter.hasNext()) {
                int state = -1;
                int type = -1;
                int globalArrayID = 0;
                Disk disk = (Disk)iter.next();
                state = disk.getState();
                type = disk.getType();
                if (type == 1) {
                    RaidSet raidSet = disk.getRaidSet();
                    if (raidSet != null) {
                        globalArrayID = raidSet.getId();
                    } else {
                        state = 0;
                    }
                } else if (disk.getType() == 3) {
                    globalArrayID = disk.getRaidController().isTop() ? -2 : -3;
                } else if (disk.getType() == 4) {
                    globalArrayID = disk.getOrphanRaidSetId();
                }
                int index = disk.getId() - 1;
                this.states[index] = state;
                this.types[index] = type;
                this.raidSets[index] = globalArrayID;
            }
        } else {
            this.system = null;
        }
        this.paintDriveIcons();
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void setSelectionModel(DrivePanelSelectionModel model) {
        this.selectionModel = model;
    }

    public DrivePanelSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionPolicy(DrivePanelSelectionPolicy policy) {
        this.selectionPolicy = policy;
    }

    public DrivePanelSelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void setSelectionMode(int mode) {
        this.selectionModel.setSelectionMode(mode);
        this.paintDriveIcons();
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionStyle(int style) {
        this.selectionModel.setSelectionStyle(style);
        this.paintDriveIcons();
    }

    public int getSelectionStyle() {
        return this.selectionModel.getSelectionStyle();
    }

    public void setDriveSelected(int driveID, boolean selected) {
        this.selectionModel.setDriveSelected(driveID, selected);
    }

    public boolean isDriveSelected(int driveID) {
        return this.selectionModel.isDriveSelected(driveID);
    }

    public void setArraySelected(int arrayID, boolean selected) {
        this.selectionModel.setArraySelected(arrayID, selected);
    }

    public boolean isArraySelected(int arrayID) {
        return this.selectionModel.isArraySelected(arrayID);
    }

    public Object[] getSelectedObjects() {
        int[] selected = this.selectionModel.getSelectedDrives();
        Object[] objects = new Object[selected.length];
        int i = 0;
        while (i < selected.length) {
            objects[i] = new Integer(selected[i]);
            ++i;
        }
        return objects;
    }

    public void setSelectedDriveCount(int count) {
        this.paintDriveIcons();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public void setBadgeIcon(int index, int icon) {
        this.badges[index] = icon;
    }

    public int getBadgeIcon(int index) {
        return this.badges[index];
    }

    public void setInfoIcon(int state, InfoIcon icon) {
        this.infoIcons.put(new Integer(state), icon);
    }

    public void setUseCheckBoxes(boolean useCheckBoxes) {
        if (useCheckBoxes && this.selectionPolicy.getSelectableTypes() != 0 && this.selectionPolicy.getSelectableStates() != 1) {
            throw new IllegalStateException("selection policy selectable types must be UNASSIGNED and states must be ONLINE if using checkboxes");
        }
        this.useCheckBoxes = useCheckBoxes;
    }

    public boolean isUsingCheckBoxes() {
        return this.useCheckBoxes;
    }

    public void doClick(int driveID) {
        this.driveIcon[driveID - 1].doClick();
    }

    public void addItemListener(ItemListener listener) {
        this.listenerList.add(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = DriveSelectionPanelEx.class$("java.awt.event.ItemListener")), listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.listenerList.remove(class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : (class$java$awt$event$ItemListener = DriveSelectionPanelEx.class$("java.awt.event.ItemListener")), listener);
    }

    public void addDrivePanelListener(DrivePanelListener l) {
        this.listenerList.add(class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : (class$com$apple$xsr$DrivePanelListener = DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener")), l);
    }

    public void removeDrivePanelListener(DrivePanelListener l) {
        this.listenerList.remove(class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : (class$com$apple$xsr$DrivePanelListener = DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener")), l);
    }

    private void fireDrivePanelEvent(DrivePanelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener"))) {
                DrivePanelListener listener = (DrivePanelListener)listeners[i + 1];
                if (e.getEventID() == 0) {
                    listener.driveIconEntered(e);
                } else if (e.getEventID() == 1) {
                    listener.driveIconExited(e);
                }
                if (e.getEventID() == 2) {
                    listener.driveIconClicked(e);
                }
            }
            i -= 2;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        this.paintDriveIcons();
    }

    private boolean isAssigned(int index) {
        return this.types[index] == 1 || this.types[index] == 3 || this.types[index] == 4;
    }

    private void paintDriveIcons() {
        if (!this.addNotifyCalled) {
            return;
        }
        int driveIndex = 0;
        while (driveIndex < 14) {
            InfoIcon infoIcon;
            int mode = this.getSelectionMode();
            int state = this.states[driveIndex];
            int type = this.types[driveIndex];
            int raidSetID = this.raidSets[driveIndex];
            int width = 18;
            int height = 68;
            int badgeOffset = 49;
            int badgeHeight = 14;
            Image temp = this.createImage(width, height);
            Graphics context = temp.getGraphics();
            Image baseImage = this.isAssigned(driveIndex) ? (this.getSelectionMode() == 1 && this.useCheckBoxes ? (this.isDriveSelected(driveIndex + 1) ? selectedImage : availableImage) : presentImage) : (this.states[driveIndex] == -2 ? emptyImage : presentImage);
            context.drawImage(baseImage, 0, 0, null);
            boolean tint = false;
            if (mode == 1 || mode == 3) {
                if (!this.useCheckBoxes) {
                    tint = this.isDriveSelected(driveIndex + 1);
                }
            } else if (mode == 2) {
                tint = this.isArraySelected(this.raidSets[driveIndex]);
            }
            if (tint) {
                if (this.selectionColor == 0) {
                    this.tintIcon(context, width, height, hiliteColor, 0.7f, true);
                } else if (this.selectionColor == 1) {
                    this.tintIcon(context, width, height, Color.red, 0.4f, false);
                }
            }
            if (baseImage == availableImage || baseImage == selectedImage) {
                badgeOffset -= 12;
            }
            if (this.badges[driveIndex] == 0) {
                if (this.isAssigned(driveIndex)) {
                    if (type == 1 || type == 3) {
                        context.setColor(badgeColor);
                        context.fillRect(4, 53, 10, 10);
                        context.setColor(Color.white);
                        context.setFont(GUIFactory.FONT_BADGE);
                        if (raidSetID > 0) {
                            context.drawString(String.valueOf(raidSetID), 6, 62);
                        } else {
                            context.drawString("J", 8, 61);
                        }
                        badgeOffset -= badgeHeight;
                    } else if (type == 4) {
                        boolean useBadge = false;
                        if (useBadge) {
                            boolean useQuestionMark;
                            context.setColor(badgeColor);
                            context.fillRect(4, 53, 10, 10);
                            context.setColor(Color.white);
                            context.setFont(GUIFactory.FONT_BADGE);
                            if (raidSetID > 0) {
                                context.drawString(String.valueOf(raidSetID), 6, 62);
                            }
                            if ((useQuestionMark = false) && raidSetID == 0) {
                                context.drawString("?", 7, 61);
                            }
                            context.drawImage(orphanImage, 4, (badgeOffset -= badgeHeight) + 6, null);
                            badgeOffset -= badgeHeight;
                        } else {
                            context.drawImage(orphanImage, 4, badgeOffset + 4, null);
                            badgeOffset -= badgeHeight;
                        }
                    }
                }
                if (state == 0) {
                    context.drawImage(offlineImage, 0, badgeOffset, null);
                    badgeOffset -= badgeHeight;
                }
            } else if (this.badges[driveIndex] == 1) {
                context.drawImage(expandImage, 0, badgeOffset, null);
                badgeOffset -= badgeHeight;
            }
            if (this.infoIcons.containsKey(new Integer(state)) && ((infoIcon = (InfoIcon)this.infoIcons.get(new Integer(state))).selectionState == 1 && this.isDriveSelected(driveIndex + 1) || infoIcon.selectionState == 0 && !this.isDriveSelected(driveIndex + 1) || infoIcon.selectionState == 2) && infoIcon.icon == 0) {
                context.drawImage(deleteImage, 0, badgeOffset + 1, null);
                badgeOffset -= badgeHeight;
            }
            this.driveIcon[driveIndex].setIcon(new ImageIcon(temp));
            ++driveIndex;
        }
    }

    private void tintIcon(Graphics context, int width, int height, Color color, float alpha, boolean drawFocus) {
        AlphaComposite blend = AlphaComposite.getInstance(3, alpha);
        Composite save = ((Graphics2D)context).getComposite();
        ((Graphics2D)context).setComposite(blend);
        context.setColor(color);
        context.fillRect(1, 1, width - 2, height - 2);
        ((Graphics2D)context).setComposite(save);
        if (drawFocus) {
            context.setColor(color);
            context.drawRect(1, 1, width - 3, height - 3);
            context.drawRect(2, 2, width - 5, height - 5);
        }
    }

    private int indexOfFirstSelectedDrive() {
        int selected = -1;
        int i = 0;
        while (i < 14) {
            if (this.isDriveSelected(i + 1)) {
                selected = i;
                break;
            }
            ++i;
        }
        return selected;
    }

    public static boolean isJbod(int arrayId) {
        return arrayId == -2 || arrayId == -3;
    }

    public void setSelectedArray(int arrayID) {
    }

    public int getSelectedArray() {
        return 0;
    }

    public void setConfirmed(boolean confirmed) {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static class InfoIcon {
        public static final int NOT_SELECTED = 0;
        public static final int SELECTED = 1;
        public static final int BOTH = 2;
        private int icon;
        private int selectionState;
    }

    private class DriveIcon
    extends JLabel
    implements MouseListener {
        private int index;
        private Icon image;

        public DriveIcon(int index, Icon image) {
            super(image);
            this.index = index;
            this.addMouseListener(this);
        }

        public int getID() {
            return this.index + 1;
        }

        public void doClick() {
            this.mousePressed(new MouseEvent(this, 501, System.currentTimeMillis(), 0, 0, 0, 0, false));
            this.mouseReleased(new MouseEvent(this, 502, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            DrivePanelEvent evt = new DrivePanelEvent(0, DriveSelectionPanelEx.this, this.getID(), false);
            DriveSelectionPanelEx.this.fireDrivePanelEvent(evt);
            if (DriveSelectionPanelEx.this.inDragSelect && DriveSelectionPanelEx.this.getSelectionMode() == 1) {
                DriveSelectionPanelEx.this.setDriveSelected(this.index + 1, DriveSelectionPanelEx.this.selecting);
            }
        }

        public void mouseExited(MouseEvent e) {
            DrivePanelEvent evt = new DrivePanelEvent(1, DriveSelectionPanelEx.this, this.getID(), false);
            DriveSelectionPanelEx.this.fireDrivePanelEvent(evt);
        }

        public void mousePressed(MouseEvent e) {
            block9: {
                block11: {
                    block10: {
                        int type;
                        int state = DriveSelectionPanelEx.this.states[this.index];
                        if (!DriveSelectionPanelEx.this.selectionPolicy.isSelectable(state, type = DriveSelectionPanelEx.this.types[this.index])) break block9;
                        if (DriveSelectionPanelEx.this.getSelectionMode() != 1) break block10;
                        if (DriveSelectionPanelEx.this.selectionModel.getSelectionStyle() == 0) {
                            DriveSelectionPanelEx.this.inDragSelect = false;
                            DriveSelectionPanelEx.this.selecting = DriveSelectionPanelEx.this.isDriveSelected(this.index + 1) ^ true;
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                            int i = 0;
                            while (i < 14) {
                                if (i == 13) {
                                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                                }
                                DriveSelectionPanelEx.this.setDriveSelected(i + 1, i != this.index ? false : DriveSelectionPanelEx.this.selecting);
                                ++i;
                            }
                        } else {
                            DriveSelectionPanelEx.this.inDragSelect = true;
                            DriveSelectionPanelEx.this.selecting = DriveSelectionPanelEx.this.isDriveSelected(this.index + 1) ^ true;
                            DriveSelectionPanelEx.this.setDriveSelected(this.index + 1, DriveSelectionPanelEx.this.selecting);
                        }
                        break block9;
                    }
                    if (DriveSelectionPanelEx.this.getSelectionMode() != 2) break block11;
                    DriveSelectionPanelEx.this.inDragSelect = true;
                    DriveSelectionPanelEx.this.selecting = DriveSelectionPanelEx.this.isArraySelected(DriveSelectionPanelEx.this.raidSets[this.index]) ^ true;
                    DriveSelectionPanelEx.this.setArraySelected(DriveSelectionPanelEx.this.raidSets[this.index], DriveSelectionPanelEx.this.selecting);
                    break block9;
                }
                if (DriveSelectionPanelEx.this.getSelectionMode() != 3) break block9;
                DriveSelectionPanelEx.this.inDragSelect = false;
                DriveSelectionPanelEx.this.selecting = DriveSelectionPanelEx.this.isDriveSelected(this.index + 1) ^ true;
                if (DriveSelectionPanelEx.this.selecting) {
                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                    int i = 1;
                    while (i <= 7) {
                        if (i == 7) {
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                        }
                        DriveSelectionPanelEx.this.setDriveSelected(i + (this.index < 7 ? 7 : 0), false);
                        ++i;
                    }
                    DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(true);
                    int i2 = 1;
                    while (i2 <= 7) {
                        if (i2 == 7) {
                            DriveSelectionPanelEx.this.selectionModel.setSelectionIsAdjusting(false);
                        }
                        DriveSelectionPanelEx.this.setDriveSelected(i2 + (this.index < 7 ? 0 : 7), true);
                        ++i2;
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            DriveSelectionPanelEx.this.inDragSelect = false;
        }
    }

    private class SelectionModelListener
    implements DrivePanelListener {
        public void valueChanged(DrivePanelEvent e) {
            DriveSelectionPanelEx.this.paintDriveIcons();
            this.fireValueChanged(e);
        }

        public void driveIconEntered(DrivePanelEvent e) {
        }

        public void driveIconExited(DrivePanelEvent e) {
        }

        public void driveIconClicked(DrivePanelEvent e) {
        }

        private void fireValueChanged(DrivePanelEvent e) {
            Object[] listeners = DriveSelectionPanelEx.this.listenerList.getListenerList();
            ItemEvent itemEvent = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$java$awt$event$ItemListener != null ? class$java$awt$event$ItemListener : DriveSelectionPanelEx.class$("java.awt.event.ItemListener"))) {
                    if (itemEvent == null) {
                        Integer item = new Integer(e.getFirstID());
                        boolean selected = e.getEventID() == 3 ? DriveSelectionPanelEx.this.selectionModel.isDriveSelected(e.getFirstID()) : DriveSelectionPanelEx.this.selectionModel.isArraySelected(e.getFirstID());
                        int state = selected ? 1 : 2;
                        itemEvent = new ItemEvent(DriveSelectionPanelEx.this, 701, item, state);
                    }
                    ((ItemListener)listeners[i + 1]).itemStateChanged(itemEvent);
                }
                if (listeners[i] == (class$com$apple$xsr$DrivePanelListener != null ? class$com$apple$xsr$DrivePanelListener : DriveSelectionPanelEx.class$("com.apple.xsr.DrivePanelListener"))) {
                    ((DrivePanelListener)listeners[i + 1]).valueChanged(e);
                }
                i -= 2;
            }
        }

        SelectionModelListener() {
        }
    }
}

