/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

public class GridBagPanel
extends JPanel {
    private GridBagLayout gbl;
    private GridBagConstraints gbc;

    public GridBagPanel() {
        this(new GridBagConstraints());
    }

    public GridBagPanel(GridBagConstraints gbc) {
        GUIFactory.configureComponentForPlatform(this);
        this.gbc = gbc;
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
    }

    public Component add(Component c) {
        this.add(c, this.gbc);
        ++this.gbc.gridx;
        return c;
    }

    public Component add(Component c, int anchor) {
        int oldAnchor = this.gbc.anchor;
        this.gbc.anchor = anchor;
        this.add(c, this.gbc);
        this.gbc.anchor = oldAnchor;
        return c;
    }

    public Component add(Component c, GridBagConstraints constraints) {
        if (c == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (constraints == null) {
            throw new NullPointerException("constraints cannot be null");
        }
        this.gbl.setConstraints(c, constraints);
        return super.add(c);
    }

    public void add(Component component, GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        super.add(component, constraints);
    }

    public void nextRow() {
        ++this.gbc.gridy;
    }
}

