/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JComponent;

public class LineSeparator
extends JComponent {
    protected boolean mIsHorizontalSeparator;
    protected Color mLineColor;

    public LineSeparator() {
        this(true, Color.black);
    }

    public LineSeparator(boolean isHorizontal) {
        this(isHorizontal, Color.black);
    }

    public LineSeparator(boolean isHorizontal, Color theColor) {
        this.mIsHorizontalSeparator = isHorizontal;
        this.mLineColor = theColor;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double theHeight = this.getHeight();
        double theWidth = this.getWidth();
        g2.setPaint(this.mLineColor);
        if (this.mIsHorizontalSeparator) {
            g2.draw(new Line2D.Double(0.0, theHeight / 2.0, theWidth, theHeight / 2.0));
        } else {
            g2.draw(new Line2D.Double(theWidth / 2.0, 0.0, theWidth / 2.0, theHeight));
        }
    }
}

