/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import com.apple.xsr.som.RaidSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ManagementPerformancePane
extends JPanel {
    static final int CHANNEL_COUNT = 2;
    static final int CONTROL_HSPACE = 5;
    static final int CONTROL_VSPACE = 16;
    static final int GROUP_SPACING = 16;
    private static final Color COLOR_TEXT_DISABLED = new JTextArea().getDisabledTextColor();
    SizeLinkedPanel[] lunGroup = new SizeLinkedPanel[2];
    JCheckBox[] controllerCacheCheckBox = new JCheckBox[2];
    JCheckBox[] syncCacheCheckBox = new JCheckBox[2];
    JCheckBox[] diskCacheCheckBox = new JCheckBox[2];
    JCheckBox[] slowReadBypassCheckBox = new JCheckBox[2];
    RadioButtonGroup[] prefetchGroup = new RadioButtonGroup[2];
    JRadioButton[][] prefetchRadio = new JRadioButton[2][3];
    JTextPane[] diskCacheMessageLabel = new JTextPane[2];
    JTextPane[] syncCacheMessageLabel = new JTextPane[2];
    JTextPane[] slowReadBypassMessageLabel = new JTextPane[2];
    SetupPane parent;
    boolean populated = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementPerformancePane != null ? class$com$apple$xsr$ManagementPerformancePane : (class$com$apple$xsr$ManagementPerformancePane = ManagementPerformancePane.class$("com.apple.xsr.ManagementPerformancePane")));
    static /* synthetic */ Class class$com$apple$xsr$ManagementPerformancePane;

    public ManagementPerformancePane(SetupPane parent) {
        GUIFactory.configureComponentForPlatform(this);
        this.parent = parent;
        1 theActionListener = new 1();
        2 thePropertyChangeListener = new 2();
        Insets zeroInsets = new Insets(0, 0, 0, 0);
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.setLayout(new GridBagLayout());
        GridBagConstraints perfTabConstraints = new GridBagConstraints();
        perfTabConstraints.gridx = 0;
        perfTabConstraints.gridy = 0;
        perfTabConstraints.gridheight = 1;
        perfTabConstraints.gridwidth = 1;
        perfTabConstraints.anchor = 17;
        perfTabConstraints.fill = 0;
        int group = 0;
        while (group < 2) {
            int currentRow = 0;
            this.lunGroup[group] = new SizeLinkedPanel();
            this.lunGroup[group].setFont(GUIFactory.FONT_SMALL);
            String groupTitle = " ";
            groupTitle = String.valueOf(groupTitle) + Resources.getString(group == 0 ? "management.performance.drives1thru7" : "management.performance.drives8thru14");
            groupTitle = String.valueOf(groupTitle) + " ";
            TitledBorder border = BorderFactory.createTitledBorder(groupTitle);
            border.setTitleFont(GUIFactory.FONT_SMALL);
            this.lunGroup[group].setBorder(new CompoundBorder(border, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            this.lunGroup[group].setLayout(new GridBagLayout());
            GridBagConstraints lunGroupConstraints = new GridBagConstraints();
            lunGroupConstraints.anchor = 17;
            lunGroupConstraints.fill = 2;
            this.controllerCacheCheckBox[group] = GUIFactory.newCheckBox(Resources.getString("management.performance.controllerCache"));
            this.controllerCacheCheckBox[group].setFont(GUIFactory.FONT_SMALL);
            this.controllerCacheCheckBox[group].addChangeListener(new 3());
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[group].add((Component)this.controllerCacheCheckBox[group], lunGroupConstraints);
            JTextPane controllerCacheMessageLabel = GUIFactory.newTextPane(Resources.getString("management.performance.controllerCacheMessage"));
            controllerCacheMessageLabel.setFont(GUIFactory.FONT_TINY);
            controllerCacheMessageLabel.setEditable(false);
            controllerCacheMessageLabel.setOpaque(false);
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 8, 0);
            this.lunGroup[group].add((Component)controllerCacheMessageLabel, lunGroupConstraints);
            this.syncCacheCheckBox[group] = GUIFactory.newCheckBox(Resources.getString("management.performance.syncCache"));
            this.syncCacheCheckBox[group].setFont(GUIFactory.FONT_SMALL);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 20, 4, 0);
            this.lunGroup[group].add((Component)this.syncCacheCheckBox[group], lunGroupConstraints);
            this.syncCacheMessageLabel[group] = GUIFactory.newTextPane(Resources.getString("management.performance.syncCacheMessage"));
            this.syncCacheMessageLabel[group].setFont(GUIFactory.FONT_TINY);
            this.syncCacheMessageLabel[group].setEditable(false);
            this.syncCacheMessageLabel[group].setOpaque(false);
            lunGroupConstraints.insets = new Insets(0, 20, 16, 0);
            lunGroupConstraints.gridy = currentRow++;
            this.lunGroup[group].add((Component)this.syncCacheMessageLabel[group], lunGroupConstraints);
            this.diskCacheCheckBox[group] = GUIFactory.newCheckBox(Resources.getString("management.performance.diskCache"));
            this.diskCacheCheckBox[group].setFont(GUIFactory.FONT_SMALL);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[group].add((Component)this.diskCacheCheckBox[group], lunGroupConstraints);
            this.diskCacheMessageLabel[group] = GUIFactory.newTextPane(Resources.getString("management.performance.diskCacheMessage"));
            this.diskCacheMessageLabel[group].setFont(GUIFactory.FONT_TINY);
            this.diskCacheMessageLabel[group].setEditable(false);
            this.diskCacheMessageLabel[group].setOpaque(false);
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 16, 0);
            this.lunGroup[group].add((Component)this.diskCacheMessageLabel[group], lunGroupConstraints);
            this.slowReadBypassCheckBox[group] = GUIFactory.newCheckBox(Resources.getString("management.performance.slowReadBypass"));
            this.slowReadBypassCheckBox[group].setFont(GUIFactory.FONT_SMALL);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 0, 4, 0);
            this.lunGroup[group].add((Component)this.slowReadBypassCheckBox[group], lunGroupConstraints);
            this.slowReadBypassMessageLabel[group] = GUIFactory.newTextPane(Resources.getString("management.performance.slowReadBypassMessage"));
            this.slowReadBypassMessageLabel[group].setFont(GUIFactory.FONT_TINY);
            this.slowReadBypassMessageLabel[group].setEditable(false);
            this.slowReadBypassMessageLabel[group].setOpaque(false);
            lunGroupConstraints.insets = new Insets(0, 0, 16, 0);
            lunGroupConstraints.gridy = currentRow++;
            this.lunGroup[group].add((Component)this.slowReadBypassMessageLabel[group], lunGroupConstraints);
            JLabel prefetchLabel = new JLabel(Resources.getString("management.performance.prefetch"));
            prefetchLabel.setFont(GUIFactory.FONT_SMALL);
            lunGroupConstraints.gridx = 0;
            lunGroupConstraints.gridy = currentRow++;
            lunGroupConstraints.insets = new Insets(0, 4, 8, 5);
            this.lunGroup[group].add((Component)prefetchLabel, lunGroupConstraints);
            lunGroupConstraints.insets = new Insets(0, 0, 0, 0);
            this.prefetchGroup[group] = new RadioButtonGroup();
            int row = 0;
            while (row < 3) {
                String radioTitle = row == 0 ? Resources.getString("management.performance.prefetch.1") : (row == 1 ? Resources.getString("management.performance.prefetch.8") : Resources.getString("management.performance.prefetch.128"));
                this.prefetchRadio[group][row] = GUIFactory.newRadioButton(radioTitle, true);
                this.prefetchRadio[group][row].addActionListener(theActionListener);
                this.prefetchRadio[group][row].setFont(GUIFactory.FONT_SMALL);
                this.prefetchGroup[group].add(this.prefetchRadio[group][row]);
                lunGroupConstraints.gridx = 0;
                lunGroupConstraints.gridy = currentRow++;
                lunGroupConstraints.insets = new Insets(0, 20, row == 2 ? 16 : 0, 0);
                this.lunGroup[group].add((Component)this.prefetchRadio[group][row], lunGroupConstraints);
                ++row;
            }
            perfTabConstraints.gridx = group;
            perfTabConstraints.insets = new Insets(0, group > 0 ? 16 : 0, 0, 0);
            this.add((Component)this.lunGroup[group], perfTabConstraints);
            perfTabConstraints.insets = new Insets(0, 0, 0, 0);
            ++group;
        }
        perfTabConstraints.weightx = 1.0;
        perfTabConstraints.weighty = 1.0;
        perfTabConstraints.gridx = 2;
        perfTabConstraints.gridy = 2;
        this.add(Box.createVerticalStrut(0), perfTabConstraints);
        this.lunGroup[0].linkPanel(this.lunGroup[1]);
    }

    public void populate(ManagementPerformanceModel model) {
        RaidSystem system = model.getRaidSystem();
        int group = 0;
        while (group < 2) {
            boolean slowReadBypassSupported;
            boolean syncCacheSupported;
            boolean diskCacheSupported;
            ManagementPerformanceModel.ManagementPerformanceControllerModel perfModel = group == 0 ? model.getUpperPerformanceModel() : model.getLowerPerformanceModel();
            int controllerCache = perfModel.getControllerCache();
            int syncCache = perfModel.getSyncCache();
            int diskCache = perfModel.getDiskCache();
            int slowReadBypass = perfModel.getSlowReadBypass();
            int prefetch = perfModel.getPrefetch();
            this.controllerCacheCheckBox[group].setSelected(controllerCache == 0);
            this.prefetchRadio[group][prefetch].setSelected(true);
            try {
                diskCacheSupported = OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_DISK_CACHE);
            }
            catch (Exception e) {
                diskCacheSupported = true;
                logger.error(e);
            }
            try {
                syncCacheSupported = OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_SYNC_CACHE);
            }
            catch (Exception e) {
                syncCacheSupported = true;
                logger.error(e);
            }
            try {
                slowReadBypassSupported = OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
            }
            catch (Exception e) {
                slowReadBypassSupported = true;
                logger.error(e);
            }
            this.diskCacheCheckBox[group].setEnabled(diskCacheSupported);
            this.diskCacheMessageLabel[group].setEnabled(diskCacheSupported);
            if (diskCacheSupported) {
                this.diskCacheCheckBox[group].setSelected(diskCache == 0);
            } else if (COLOR_TEXT_DISABLED != null) {
                this.diskCacheMessageLabel[group].setForeground(COLOR_TEXT_DISABLED);
            }
            this.syncCacheCheckBox[group].setEnabled(syncCacheSupported);
            this.syncCacheMessageLabel[group].setEnabled(syncCacheSupported);
            if (syncCacheSupported) {
                this.syncCacheCheckBox[group].setSelected(syncCache == 0);
            } else if (COLOR_TEXT_DISABLED != null) {
                this.syncCacheMessageLabel[group].setForeground(COLOR_TEXT_DISABLED);
            }
            this.slowReadBypassCheckBox[group].setEnabled(slowReadBypassSupported);
            this.slowReadBypassMessageLabel[group].setEnabled(slowReadBypassSupported);
            if (slowReadBypassSupported) {
                this.slowReadBypassCheckBox[group].setSelected(slowReadBypass == 0);
            } else if (COLOR_TEXT_DISABLED != null) {
                this.slowReadBypassMessageLabel[group].setForeground(COLOR_TEXT_DISABLED);
            }
            ++group;
        }
        this.validate(null);
        this.populated = true;
    }

    public boolean validate(ManagementPerformanceModel model) {
        boolean valid = true;
        int tabIndex = this.parent.tabbedPane.indexOfComponent(this);
        if (!valid && this.parent.tabbedPane.getSelectedIndex() != tabIndex) {
            this.parent.tabbedPane.setIconAt(tabIndex, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(tabIndex, null);
        }
        if (valid && model != null) {
            int group = 0;
            while (group < 2) {
                ManagementPerformanceModel.ManagementPerformanceControllerModel perfModel = group == 0 ? model.getUpperPerformanceModel() : model.getLowerPerformanceModel();
                int controllerCache = this.controllerCacheCheckBox[group].isSelected() ? 0 : 1;
                int syncCache = this.syncCacheCheckBox[group].isSelected() ? 0 : 1;
                int diskCache = this.diskCacheCheckBox[group].isSelected() ? 0 : 1;
                int slowReadBypass = this.slowReadBypassCheckBox[group].isSelected() ? 0 : 1;
                int prefetch = this.prefetchGroup[group].getSelectedIndex();
                perfModel.setControllerCache(controllerCache);
                perfModel.setSyncCache(syncCache);
                perfModel.setDiskCache(diskCache);
                perfModel.setSlowReadBypass(slowReadBypass);
                perfModel.setPrefetch(prefetch);
                ++group;
            }
        }
        return valid;
    }

    public SizeLinkedPanel getGroupBox(int group) {
        return this.lunGroup[group];
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (ManagementPerformancePane.this.populated) {
                ManagementPerformancePane.this.validate(null);
                ManagementPerformancePane.this.parent.setModified();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (ManagementPerformancePane.this.populated) {
                ManagementPerformancePane.this.validate(null);
                ManagementPerformancePane.this.parent.setModified();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            int i = source == ManagementPerformancePane.this.controllerCacheCheckBox[0] ? 0 : 1;
            ManagementPerformancePane.this.syncCacheCheckBox[i].setEnabled(source.isSelected());
        }

        /* synthetic */ 3() {
        }
    }
}

