/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.text.RestrictedDocument;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.GridBagPanel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.ManagementSystemPane;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class ManagementSystemPane
extends GridBagPanel {
    public static final int PASSWORD_MAX_BYTES = 31;
    public static final int GRID_BAG_INSET_VALUE = 8;
    public static final int TEXT_FIELD_WIDTH = 285;
    public static final String TITLED_BORDER_SPACING = " ";
    public static final String COMBO_BOX_SPACING = "  ";
    public static final int DONT_SYNC_INDEX = 0;
    public static final int LOCAL_SYNC_INDEX = 1;
    public static final int NTP_SYNC_INDEX = 2;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private SystemInformationPanel mSystemInformationPanel = null;
    private PasswordsPanel mPasswordsPanel = null;
    private OptionsPanel mOptionsPanel = null;
    private SetupPane parent = null;
    private boolean populated = false;

    public ManagementSystemPane(SetupPane parent) {
        this.parent = parent;
        this.mSystemInformationPanel = new SystemInformationPanel();
        this.mPasswordsPanel = new PasswordsPanel();
        this.mOptionsPanel = new OptionsPanel();
        this.mPasswordsPanel.linkPanel(this.mOptionsPanel, 2);
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add(this.mSystemInformationPanel, constraints, 0, 0, 2, 1);
        constraints.insets = new Insets(8, 0, 0, 8);
        this.add(this.mPasswordsPanel, constraints, 0, 1, 1, 1);
        constraints.insets = new Insets(8, 0, 0, 0);
        this.add(this.mOptionsPanel, constraints, 1, 1, 1, 1);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add(Box.createHorizontalStrut(1), constraints, 2, 2, 0, 0);
    }

    public void populate(ManagementSystemModel data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        this.mSystemInformationPanel.populate(data);
        this.mOptionsPanel.populate(data);
        this.populated = true;
    }

    public boolean validate(ManagementSystemModel systemModel) throws NullPointerException, IllegalArgumentException {
        boolean validationSucceeded = true;
        boolean aPanelIsValid = true;
        aPanelIsValid = this.mSystemInformationPanel.checkValidity();
        if (!aPanelIsValid) {
            validationSucceeded = false;
        }
        if (!(aPanelIsValid = this.mOptionsPanel.checkValidity())) {
            validationSucceeded = false;
        }
        if (!(aPanelIsValid = this.mPasswordsPanel.checkValidity())) {
            validationSucceeded = false;
        }
        if (validationSucceeded) {
            this.mSystemInformationPanel.fillInModel(systemModel);
            this.mPasswordsPanel.fillInModel(systemModel);
            this.mOptionsPanel.fillInModel(systemModel);
        }
        int tabIndex = this.parent.tabbedPane.indexOfComponent(this);
        if (!validationSucceeded && this.parent.tabbedPane.getSelectedIndex() != tabIndex) {
            this.parent.tabbedPane.setIconAt(tabIndex, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(tabIndex, null);
        }
        return validationSucceeded;
    }

    public JLabel jlabelWithFont(String labelString, Font theFont) {
        JLabel theJLabel = new JLabel(labelString);
        theJLabel.setFont(theFont);
        return theJLabel;
    }

    static /* synthetic */ boolean access$0(ManagementSystemPane $0) {
        return $0.populated;
    }

    public class SystemInformationPanel
    extends GridBagPanel {
        public static final String TIME_FORMAT_12_HOUR = "12";
        public static final String TIME_FORMAT_24_HOUR = "24";
        private final String DATE_FORMAT_12_HOUR = Resources.getString("eventLog.twelveHourDateFormat");
        private final String DATE_FORMAT_24_HOUR = Resources.getString("eventLog.twentyFourHourDateFormat");
        private JTextField mSystemNameTextField;
        private JTextField mLocationTextField;
        private JTextField mContactTextField;
        private JTextField mNTPServerTextField;
        private JLabel mLocalTimeLabel;
        private JLabel mXserveRAIDTimeLabel;
        private JComboBox mTimeSynchronizeComboBox;
        private JLabel mSystemNameValidateLabel;
        private JLabel mLocationValidateLabel;
        private JLabel mContactValidateLabel;
        private JLabel mNTPServerValidateLabel;
        private JLabel mNTPServerExample;
        private Date mXserveRAIDTime = null;
        private SimpleDateFormat mDateFormat = new SimpleDateFormat(this.DATE_FORMAT_12_HOUR);

        public SystemInformationPanel() {
            TitledBorder systemInfoBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.systemInfoBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            systemInfoBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(systemInfoBorder, new EmptyBorder(8, 12, 12, 12)));
            1 theFocusAdapter = new 1(this);
            2 theCaretListener = new 2(this);
            3 theActionListener = new 3(this);
            JLabel systemNameLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.systemName"), GUIFactory.FONT_SMALL);
            this.mSystemNameTextField = GUIFactory.newTextField(285);
            this.mSystemNameTextField.setFont(GUIFactory.FONT_SMALL);
            this.mSystemNameTextField.addFocusListener(theFocusAdapter);
            this.mSystemNameTextField.addCaretListener(theCaretListener);
            this.mSystemNameTextField.addActionListener(theActionListener);
            JLabel locationLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.location"), GUIFactory.FONT_SMALL);
            this.mLocationTextField = GUIFactory.newTextField(285);
            this.mLocationTextField.setFont(GUIFactory.FONT_SMALL);
            this.mLocationTextField.addFocusListener(theFocusAdapter);
            this.mLocationTextField.addCaretListener(theCaretListener);
            this.mLocationTextField.addActionListener(theActionListener);
            JLabel contactLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.contact"), GUIFactory.FONT_SMALL);
            this.mContactTextField = GUIFactory.newTextField(285);
            this.mContactTextField.setFont(GUIFactory.FONT_SMALL);
            this.mContactTextField.addFocusListener(theFocusAdapter);
            this.mContactTextField.addCaretListener(theCaretListener);
            this.mContactTextField.addActionListener(theActionListener);
            JLabel localTimeLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.localTime"), GUIFactory.FONT_SMALL);
            this.mLocalTimeLabel = ManagementSystemPane.this.jlabelWithFont("", GUIFactory.FONT_SMALL);
            JLabel xserveRaidTimeLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.xServeTime"), GUIFactory.FONT_SMALL);
            this.mXserveRAIDTimeLabel = ManagementSystemPane.this.jlabelWithFont("", GUIFactory.FONT_SMALL);
            JLabel xserveRaidTimeSyncMethodLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.syncMethod"), GUIFactory.FONT_SMALL);
            this.mTimeSynchronizeComboBox = GUIFactory.newComboBox();
            this.mTimeSynchronizeComboBox.setMaximumSize(this.mTimeSynchronizeComboBox.getPreferredSize());
            this.mTimeSynchronizeComboBox.setEditable(false);
            this.mTimeSynchronizeComboBox.setFont(GUIFactory.FONT_SMALL);
            this.mTimeSynchronizeComboBox.addItem(String.valueOf(Resources.getString("management.systemInfo.systemInfoBox.dontSync")) + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addItem(String.valueOf(Resources.getString("management.systemInfo.systemInfoBox.localSync")) + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addItem(String.valueOf(Resources.getString("management.systemInfo.systemInfoBox.ntpSync")) + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addActionListener(theActionListener);
            this.mTimeSynchronizeComboBox.addActionListener(new 4(this));
            this.mNTPServerTextField = GUIFactory.newTextField("");
            this.mNTPServerTextField.setFont(GUIFactory.FONT_SMALL);
            this.mNTPServerTextField.addFocusListener(theFocusAdapter);
            this.mNTPServerTextField.addCaretListener(theCaretListener);
            this.mNTPServerTextField.addActionListener(theActionListener);
            this.mNTPServerTextField.setVisible(false);
            this.mNTPServerTextField.setMinimumSize(this.mNTPServerTextField.getPreferredSize());
            this.mNTPServerExample = ManagementSystemPane.this.jlabelWithFont(ManagementSystemPane.TITLED_BORDER_SPACING, GUIFactory.FONT_TINY);
            Timer theTimer = new Timer(1000, new 5(this));
            theTimer.start();
            ImageIcon validateIcon = new ImageIcon(Resources.getImage("icon.validate"));
            this.mSystemNameValidateLabel = new JLabel(validateIcon);
            this.mLocationValidateLabel = new JLabel(validateIcon);
            this.mContactValidateLabel = new JLabel(validateIcon);
            this.mNTPServerValidateLabel = new JLabel(validateIcon);
            this.mSystemNameValidateLabel.setVisible(false);
            this.mLocationValidateLabel.setVisible(false);
            this.mContactValidateLabel.setVisible(false);
            this.mNTPServerValidateLabel.setVisible(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 16;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            constraints.insets = new Insets(0, 4, 4, 0);
            this.add(this.mSystemNameValidateLabel, constraints, 3, 1, 1, 1);
            this.add(this.mLocationValidateLabel, constraints, 3, 3, 1, 1);
            this.add(this.mContactValidateLabel, constraints, 3, 4, 1, 1);
            this.add(this.mNTPServerValidateLabel, constraints, 3, 7, 1, 1);
            this.add(Box.createHorizontalStrut(16), constraints, 3, 8, 1, 1);
            constraints.insets = new Insets(0, 8, 0, 1);
            constraints.anchor = 17;
            constraints.insets = new Insets(8, 8, 0, 1);
            this.add(this.mLocalTimeLabel, constraints, 1, 5, 2, 1);
            this.add(this.mXserveRAIDTimeLabel, constraints, 1, 6, 2, 1);
            constraints.anchor = 13;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(systemNameLabel, constraints, 0, 1, 1, 1);
            this.add(locationLabel, constraints, 0, 3, 1, 1);
            this.add(contactLabel, constraints, 0, 4, 1, 1);
            this.add(localTimeLabel, constraints, 0, 5, 1, 1);
            this.add(xserveRaidTimeLabel, constraints, 0, 6, 1, 1);
            this.add(xserveRaidTimeSyncMethodLabel, constraints, 0, 7, 1, 1);
            constraints.anchor = 17;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(8, 8, 0, 0);
            constraints.ipadx = 285;
            this.add(this.mSystemNameTextField, constraints, 1, 1, 2, 1);
            this.add(this.mLocationTextField, constraints, 1, 3, 2, 1);
            this.add(this.mContactTextField, constraints, 1, 4, 2, 1);
            constraints.ipadx = 0;
            constraints.fill = 2;
            this.add(this.mTimeSynchronizeComboBox, constraints, 1, 7, 1, 1);
            this.add(this.mNTPServerTextField, constraints, 2, 7, 1, 1);
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add(this.mNTPServerExample, constraints, 2, 8, 1, 1);
            Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
            if (prefs != null) {
                String defaultFormat = Gestalt.timeFormat == 12 ? TIME_FORMAT_12_HOUR : TIME_FORMAT_24_HOUR;
                String format = prefs.getString("TimeFormat", defaultFormat);
                this.setTimeFormat(format);
                prefs.addPreferenceChangeListener(new 6(this));
            }
        }

        public void setTimeFormat(String format) {
            if (!format.equals(TIME_FORMAT_12_HOUR) && !format.equals(TIME_FORMAT_24_HOUR)) {
                throw new IllegalArgumentException("Invalid time format: " + format);
            }
            String formatString = format.equals(TIME_FORMAT_12_HOUR) ? this.DATE_FORMAT_12_HOUR : this.DATE_FORMAT_24_HOUR;
            this.mDateFormat.applyPattern(formatString);
        }

        private void setTheTimeLabels() {
            String localTime = this.mDateFormat.format(new Date());
            String theXserveTime = null;
            theXserveTime = this.mXserveRAIDTime != null ? this.mDateFormat.format(this.mXserveRAIDTime) : Resources.getString("management.systemInfo.systemInfoBox.timeNotSet");
            this.mLocalTimeLabel.setText(localTime);
            this.mXserveRAIDTimeLabel.setText(theXserveTime);
        }

        public void populate(ManagementSystemModel systemModel) {
            this.mSystemNameTextField.setText(systemModel.getSystemName());
            this.mLocationTextField.setText(systemModel.getLocation());
            this.mContactTextField.setText(systemModel.getContact());
            Date theTime = systemModel.getXserveRAIDTime();
            if (this.mXserveRAIDTime != null && theTime != null) {
                this.mXserveRAIDTime.setTime(theTime.getTime());
            } else {
                this.mXserveRAIDTime = this.mXserveRAIDTime == null && theTime != null ? (Date)theTime.clone() : null;
            }
            if (systemModel.getTimeSynchronizationMethod() == 3) {
                this.mTimeSynchronizeComboBox.setSelectedIndex(2);
                this.mNTPServerTextField.setText(systemModel.getNTPServer());
            }
            this.setTheTimeLabels();
        }

        public boolean checkValidity() {
            boolean validationSucceeded = true;
            int selectedIndex = this.mTimeSynchronizeComboBox.getSelectedIndex();
            if (selectedIndex == 2 && this.mNTPServerTextField.getText().trim().equals("")) {
                this.mNTPServerValidateLabel.setVisible(true);
                validationSucceeded = false;
            } else {
                this.mNTPServerValidateLabel.setVisible(false);
            }
            return validationSucceeded;
        }

        public void fillInModel(ManagementSystemModel systemModel) {
            if (systemModel != null) {
                systemModel.setSystemName(this.mSystemNameTextField.getText());
                systemModel.setLocation(this.mLocationTextField.getText());
                systemModel.setContact(this.mContactTextField.getText());
                int selectedIndex = this.mTimeSynchronizeComboBox.getSelectedIndex();
                if (selectedIndex == 2) {
                    systemModel.setTimeSynchronizationMethod(3);
                    systemModel.setNTPServer(this.mNTPServerTextField.getText().trim());
                } else if (selectedIndex == 1) {
                    systemModel.setTimeSynchronizationMethod(2);
                } else {
                    systemModel.setTimeSynchronizationMethod(1);
                }
            }
        }

        static /* synthetic */ ManagementSystemPane access$0(SystemInformationPanel $0) {
            return $0.ManagementSystemPane.this;
        }

        static /* synthetic */ JComboBox access$1(SystemInformationPanel $0) {
            return $0.mTimeSynchronizeComboBox;
        }

        static /* synthetic */ JTextField access$2(SystemInformationPanel $0) {
            return $0.mNTPServerTextField;
        }

        static /* synthetic */ JLabel access$3(SystemInformationPanel $0) {
            return $0.mNTPServerExample;
        }

        static /* synthetic */ void access$4(SystemInformationPanel $0) {
            $0.setTheTimeLabels();
        }

        static /* synthetic */ Date access$5(SystemInformationPanel $0) {
            return $0.mXserveRAIDTime;
        }
    }

    public class PasswordsPanel
    extends SizeLinkedPanel
    implements AquaAlertListener {
        private static final String GUEST_PASSWORD = "GUEST_PASSWORD";
        private static final String ADMIN_PASSWORD = "ADMIN_PASSWORD";
        private String mGuestPassword = null;
        private String mAdminPassword = null;
        private JButton mAdministratorButton = null;
        private JButton mGuestButton = null;
        private PasswordChangeSheet mPasswordSheet = null;

        public PasswordsPanel() {
            this.setLayout(new GridBagLayout());
            TitledBorder passwordsBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.passwordsBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            passwordsBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(passwordsBorder, new EmptyBorder(0, 16, 0, 16)));
            this.mAdministratorButton = GUIFactory.newButton(Resources.getString("management.systemInfo.passwordsBox.change"));
            this.mAdministratorButton.setFont(GUIFactory.FONT_SMALL);
            this.mGuestButton = GUIFactory.newButton(Resources.getString("management.systemInfo.passwordsBox.change"));
            this.mGuestButton.setFont(GUIFactory.FONT_SMALL);
            JLabel administratorLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.passwordsBox.administrator"), GUIFactory.FONT_SMALL);
            JLabel guestLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.passwordsBox.guest"), GUIFactory.FONT_SMALL);
            this.mGuestButton.addActionListener(new 7(this));
            this.mAdministratorButton.addActionListener(new 8(this));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.fill = 0;
            constraints.anchor = 13;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.add((Component)administratorLabel, constraints);
            constraints.insets = new Insets(8, 0, 0, 0);
            ++constraints.gridy;
            this.add((Component)guestLabel, constraints);
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 8, 0, 0);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.add((Component)this.mAdministratorButton, constraints);
            constraints.insets = new Insets(8, 8, 0, 0);
            ++constraints.gridy;
            this.add((Component)this.mGuestButton, constraints);
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            this.mPasswordSheet.getFirstFocus().requestFocus();
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (buttonPressIdentifier == 1) {
                ManagementSystemPane.this.parent.setModified();
                if ((String)contextInfo == GUEST_PASSWORD) {
                    this.mGuestPassword = this.mPasswordSheet.getFirstPasswordString();
                } else if ((String)contextInfo == ADMIN_PASSWORD) {
                    this.mAdminPassword = this.mPasswordSheet.getFirstPasswordString();
                }
            }
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object ignoredContext) {
            boolean allowSheetToBeDismissed = false;
            if (!this.mPasswordSheet.getFirstPasswordString().equals("") && this.mPasswordSheet.getFirstPasswordString().equals(this.mPasswordSheet.getSecondPasswordString()) || buttonPressIdentifier != 1) {
                allowSheetToBeDismissed = true;
            } else if (this.mPasswordSheet.getFirstPasswordString().equals("") && this.mPasswordSheet.getSecondPasswordString().equals("")) {
                AquaAlert passwordsCantBeBlankAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankMessage"), Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
                passwordsCantBeBlankAlert.showDialog(null, Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankTitle"), null, null);
                this.mPasswordSheet.resetPasswordFields();
            } else {
                AquaAlert passwordsDontMatchAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchMessage"), Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
                passwordsDontMatchAlert.showDialog(null, Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchTitle"), null, null);
                this.mPasswordSheet.resetPasswordFields();
            }
            return allowSheetToBeDismissed;
        }

        public void populate(ManagementSystemModel systemModel) {
        }

        public boolean checkValidity() {
            return true;
        }

        public void fillInModel(ManagementSystemModel systemModel) {
            if (systemModel != null) {
                if (this.mGuestPassword != null) {
                    systemModel.setGuestPassword(this.mGuestPassword);
                }
                if (this.mAdminPassword != null) {
                    systemModel.setAdminPassword(this.mAdminPassword);
                }
            }
        }

        static /* synthetic */ ManagementSystemPane access$0(PasswordsPanel $0) {
            return $0.ManagementSystemPane.this;
        }

        static /* synthetic */ PasswordChangeSheet access$1(PasswordsPanel $0) {
            return $0.mPasswordSheet;
        }

        static /* synthetic */ void access$2(PasswordsPanel $0, PasswordChangeSheet $1) {
            $0.mPasswordSheet = $1;
        }
    }

    public class OptionsPanel
    extends SizeLinkedPanel {
        private JCheckBox mEnableAudibleAlertsCheckBox;
        private JCheckBox mRestartAutomaticallyCheckBox;
        private JCheckBox mEnableSnmpCheckBox;

        public OptionsPanel() {
            9 theActionListener = new 9(this);
            this.setLayout(new GridBagLayout());
            TitledBorder optionsBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.optionsBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            optionsBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(optionsBorder, new EmptyBorder(8, 16, 8, 16)));
            this.mEnableAudibleAlertsCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.audibleAlerts"));
            this.mEnableAudibleAlertsCheckBox.addActionListener(theActionListener);
            this.mEnableAudibleAlertsCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.mRestartAutomaticallyCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.autoRestart"));
            this.mRestartAutomaticallyCheckBox.addActionListener(theActionListener);
            this.mRestartAutomaticallyCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.mEnableSnmpCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.snmp"));
            this.mEnableSnmpCheckBox.addActionListener(theActionListener);
            this.mEnableSnmpCheckBox.setFont(GUIFactory.FONT_SMALL);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.mEnableAudibleAlertsCheckBox, constraints);
            constraints.insets = new Insets(8, 0, 0, 0);
            ++constraints.gridy;
            this.add((Component)this.mRestartAutomaticallyCheckBox, constraints);
            ++constraints.gridy;
            this.add((Component)this.mEnableSnmpCheckBox, constraints);
        }

        public void populate(ManagementSystemModel systemModel) {
            this.mEnableAudibleAlertsCheckBox.setSelected(systemModel.getEnableAudibleAlerts());
            this.mRestartAutomaticallyCheckBox.setSelected(systemModel.getRestartAutomatically());
            this.mEnableSnmpCheckBox.setSelected(systemModel.getEnableSnmp());
        }

        public boolean checkValidity() {
            return true;
        }

        public void fillInModel(ManagementSystemModel systemModel) {
            if (systemModel != null) {
                systemModel.setEnableAudibleAlerts(this.mEnableAudibleAlertsCheckBox.isSelected());
                systemModel.setRestartAutomatically(this.mRestartAutomaticallyCheckBox.isSelected());
                systemModel.setEnableSnmp(this.mEnableSnmpCheckBox.isSelected());
            }
        }

        static /* synthetic */ ManagementSystemPane access$0(OptionsPanel $0) {
            return $0.ManagementSystemPane.this;
        }
    }

    public class PasswordChangeSheet
    extends GridBagPanel {
        public static final int PASSWORD_FIELD_WIDTH = 18;
        JPasswordField mFirstPasswordField = null;
        JPasswordField mSecondPasswordField = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;

        public PasswordChangeSheet(String message) {
            Box buttonBox = Box.createHorizontalBox();
            JLabel firstPasswordLabel = new JLabel(Resources.getString("management.systemInfo.passwordsBox.newPassword"));
            JLabel secondPasswordLabel = new JLabel(Resources.getString("management.systemInfo.passwordsBox.confirmPassword"));
            GridBagConstraints constraints = new GridBagConstraints();
            RestrictedDocument doc = new RestrictedDocument();
            doc.setMaxLengthBytes(31);
            this.mFirstPasswordField = new JPasswordField(doc, null, 18);
            this.mSecondPasswordField = new JPasswordField(18);
            if (Gestalt.isMacLookAndFeel) {
                this.mFirstPasswordField.setEchoChar('\u2022');
                this.mSecondPasswordField.setEchoChar('\u2022');
            }
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 8, 0);
            JTextArea messageLabel = new JTextArea(message);
            messageLabel.setFont(GUIFactory.FONT_SMALL);
            messageLabel.setBackground(null);
            messageLabel.setHighlighter(null);
            messageLabel.setEditable(false);
            messageLabel.setLineWrap(true);
            messageLabel.setWrapStyleWord(true);
            messageLabel.setSize(300, 64);
            messageLabel.setMinimumSize(new Dimension(300, 48));
            messageLabel.setMaximumSize(new Dimension(300, 200));
            this.add(messageLabel, constraints, 0, 0, 2, 1);
            firstPasswordLabel.setFont(GUIFactory.FONT_SMALL);
            secondPasswordLabel.setFont(GUIFactory.FONT_SMALL);
            this.mFirstPasswordField.setFont(GUIFactory.FONT_SMALL);
            this.mSecondPasswordField.setFont(GUIFactory.FONT_SMALL);
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.anchor = 17;
            this.add(this.mFirstPasswordField, constraints, 1, 1, 1, 1);
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add(this.mSecondPasswordField, constraints, 1, 2, 1, 1);
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 0, 8, 8);
            this.add(firstPasswordLabel, constraints, 0, 1, 1, 1);
            constraints.insets = new Insets(0, 0, 0, 8);
            this.add(secondPasswordLabel, constraints, 0, 2, 1, 1);
            buttonBox.add(this.mCancelButton);
            buttonBox.add(Box.createHorizontalStrut(8));
            buttonBox.add(this.mOKButton);
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add(buttonBox, constraints, 0, 3, 2, 1);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void resetPasswordFields() {
            ((JTextComponent)this.mFirstPasswordField).setText("");
            ((JTextComponent)this.mSecondPasswordField).setText("");
        }

        public String getFirstPasswordString() {
            return new String(this.mFirstPasswordField.getPassword());
        }

        public String getSecondPasswordString() {
            return new String(this.mSecondPasswordField.getPassword());
        }

        public JComponent getFirstFocus() {
            return this.mFirstPasswordField;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }
    }
}

