/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.Resources;
import com.apple.xsr.StatusIcon;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

class ModuleSelectionPanel
extends JPanel {
    public static final int NOT_INSTALLED = -2;
    static final int NONE = -1;
    static final int BUTTONS_LEFT = 0;
    static final int BUTTONS_RIGHT = 1;
    static final int BATTERY_LEFT = 2;
    static final int BATTERY_RIGHT = 3;
    static final int POWER_LEFT = 4;
    static final int POWER_RIGHT = 5;
    static final int CONTROLLER_TOP = 6;
    static final int CONTROLLER_BOTTOM = 7;
    static final int BLOWER_TOP = 8;
    static final int BLOWER_BOTTOM = 9;
    boolean addNotifyCalled = false;
    int selectedModule = -1;
    boolean inDragSelect = false;
    boolean isActive = false;
    Color hiliteColor = new JTable().getSelectionBackground();
    Color blobColor = Color.black;
    Image[] baseImages;
    Image[] offscreenImages;
    JLabel[] moduleIcons;
    boolean[] modulePresent;
    boolean[] moduleEnabled;
    int[] moduleStatus;

    ModuleSelectionPanel() {
        boolean[] blArray = new boolean[10];
        blArray[0] = true;
        blArray[1] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        this.modulePresent = blArray;
        boolean[] blArray2 = new boolean[10];
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        this.moduleEnabled = blArray2;
        this.moduleStatus = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.baseImages = new Image[10];
        this.offscreenImages = new Image[10];
        this.moduleIcons = new JLabel[10];
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(layout);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        this.addComponent(this.createModuleIcon(2, Resources.getImage("icon.backpanel.battery.left")), this, layout, constraints);
        ++constraints.gridx;
        this.addComponent(this.createModuleIcon(0, Resources.getImage("icon.backpanel.buttons.left")), this, layout, constraints);
        ++constraints.gridx;
        this.addComponent(this.createModuleIcon(6, Resources.getImage("icon.backpanel.controller.top")), this, layout, constraints);
        ++constraints.gridx;
        this.addComponent(this.createModuleIcon(1, Resources.getImage("icon.backpanel.buttons.right")), this, layout, constraints);
        ++constraints.gridx;
        this.addComponent(this.createModuleIcon(3, Resources.getImage("icon.backpanel.battery.right")), this, layout, constraints);
        constraints.gridwidth = 2;
        constraints.gridheight = 3;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.addComponent(this.createModuleIcon(4, Resources.getImage("icon.backpanel.power.left")), this, layout, constraints);
        constraints.gridheight = 1;
        ++constraints.gridx;
        constraints.gridwidth = 2;
        constraints.gridheight = 3;
        constraints.gridx = 3;
        constraints.gridy = 1;
        this.addComponent(this.createModuleIcon(5, Resources.getImage("icon.backpanel.power.right")), this, layout, constraints);
        constraints.gridheight = 1;
        ++constraints.gridx;
        constraints.gridx = 2;
        constraints.gridy = 1;
        this.addComponent(this.createModuleIcon(8, Resources.getImage("icon.backpanel.blower.top")), this, layout, constraints);
        ++constraints.gridy;
        this.addComponent(this.createModuleIcon(9, Resources.getImage("icon.backpanel.blower.bottom")), this, layout, constraints);
        ++constraints.gridy;
        this.addComponent(this.createModuleIcon(7, Resources.getImage("icon.backpanel.controller.bottom")), this, layout, constraints);
        ++constraints.gridy;
        JLabel bottom = new JLabel(new ImageIcon(Resources.getImage("icon.backpanel.bottom")));
        constraints.gridwidth = 5;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 4;
        this.addComponent(bottom, this, layout, constraints);
    }

    private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(component, gbc);
        container.add(component);
    }

    private JLabel createModuleIcon(int index, Image image) {
        MediaTracker tracker;
        MediaTracker mediaTracker = tracker = new MediaTracker(this);
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {}
            tracker.removeImage(image, 0);
        }
        this.baseImages[index] = image;
        this.moduleIcons[index] = new JLabel(new ImageIcon(this.baseImages[index]));
        this.moduleIcons[index].addMouseListener(new ModuleIconListener(index));
        return this.moduleIcons[index];
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        int index = 0;
        while (index < 10) {
            this.updateModuleIcon(index);
            ++index;
        }
    }

    private void selectModuleIcon(int index) {
        if (!this.isActive || !this.moduleEnabled[index]) {
            return;
        }
        if (this.selectedModule != -1) {
            int redraw = this.selectedModule;
            this.selectedModule = -1;
            this.updateModuleIcon(redraw);
        }
        this.selectedModule = index;
        this.updateModuleIcon(this.selectedModule);
        this.firePropertyChange("module", -1, this.selectedModule);
    }

    private void updateModuleIcon(int index) {
        Image base = this.baseImages[index];
        int width = base.getWidth(null);
        int height = base.getHeight(null);
        if (this.offscreenImages[index] == null) {
            this.offscreenImages[index] = this.createImage(width, height);
        }
        Graphics context = this.offscreenImages[index].getGraphics();
        ((Graphics2D)context).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isActive) {
            Composite save;
            AlphaComposite blend;
            context.drawImage(base, 0, 0, null);
            if (!this.modulePresent[index]) {
                blend = AlphaComposite.getInstance(3, 0.6f);
                save = ((Graphics2D)context).getComposite();
                ((Graphics2D)context).setComposite(blend);
                context.setColor(Color.black);
                context.fillRect(1, 1, width - 2, height - 2);
                ((Graphics2D)context).setComposite(save);
            }
            if (index == this.selectedModule) {
                blend = AlphaComposite.getInstance(3, 0.6f);
                save = ((Graphics2D)context).getComposite();
                ((Graphics2D)context).setComposite(blend);
                context.setColor(this.hiliteColor);
                context.fillRect(1, 1, width - 2, height - 2);
                ((Graphics2D)context).setComposite(save);
                context.setColor(this.hiliteColor);
                context.drawRect(1, 1, width - 3, height - 3);
                context.drawRect(2, 2, width - 5, height - 5);
            }
            if (this.moduleStatus[index] != -1) {
                StatusIcon icon = StatusIcon.getSmallStatusIconInstance(this.moduleStatus[index]);
                icon.paintIcon(this, context, 4, height / 2 - 5);
            }
        } else {
            context.drawImage(base, 0, 0, null);
        }
        this.moduleIcons[index].setIcon(new ImageIcon(this.offscreenImages[index]));
    }

    public void setModuleStatus(int index, boolean present, int status) {
        this.modulePresent[index] = present;
        this.moduleStatus[index] = status;
        if (this.addNotifyCalled) {
            this.updateModuleIcon(index);
        }
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (this.addNotifyCalled) {
            int index = 0;
            while (index < 10) {
                this.updateModuleIcon(index);
                ++index;
            }
        }
    }

    class ModuleIconListener
    implements MouseListener {
        int module;

        ModuleIconListener(int index) {
            this.module = index;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            ModuleSelectionPanel.this.selectModuleIcon(this.module);
            ModuleSelectionPanel.this.inDragSelect = true;
        }

        public void mouseReleased(MouseEvent e) {
            ModuleSelectionPanel.this.inDragSelect = false;
        }

        public void mouseEntered(MouseEvent e) {
            if (ModuleSelectionPanel.this.inDragSelect) {
                ModuleSelectionPanel.this.selectModuleIcon(this.module);
            }
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

