/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.DataModel;
import com.apple.xsr.GridBagPanel;
import com.apple.xsr.NotificationsModel;
import com.apple.xsr.NotificationsPane;
import com.apple.xsr.Resources;
import com.apple.xsr.TestEmail;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class NotificationsPane
extends AbstractManagementPane {
    private NotificationsPaneInner mNotificationsPaneInner = null;
    private JButton mApplyButton = null;
    private JButton mCancelButton = null;
    private static final int preferredWidth = 588;
    private static final int preferredHeight = 454;

    public NotificationsPane() {
        super(588, 454);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(0, 8, 0, 8));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 0;
        constraints.ipady = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.mNotificationsPaneInner = new NotificationsPaneInner();
        this.add((Component)this.mNotificationsPaneInner, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add(Box.createVerticalStrut(0), constraints);
        this.mApplyButton = GUIFactory.newOKButton();
        this.mApplyButton.setFont(GUIFactory.FONT_SMALL);
        this.mApplyButton.addActionListener(new 1());
        this.mCancelButton = GUIFactory.newCancelButton();
        this.mCancelButton.setFont(GUIFactory.FONT_SMALL);
        this.mCancelButton.addActionListener(new 2());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(this.mCancelButton);
        buttonBox.add(Box.createHorizontalStrut(12));
        buttonBox.add(this.mApplyButton);
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 14;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)buttonBox, constraints);
    }

    public void populateUI(DataModel data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(data instanceof NotificationsModel)) {
            throw new IllegalArgumentException("illegal data model type " + data.getClass());
        }
        this.mNotificationsPaneInner.populateUI((NotificationsModel)data);
    }

    public boolean validateUI(DataModel data) {
        boolean settingsValid = this.mNotificationsPaneInner.checkValidity();
        if (data != null) {
            if (!(data instanceof NotificationsModel)) {
                throw new IllegalArgumentException("illegal data model type " + data.getClass());
            }
            if (settingsValid) {
                this.mNotificationsPaneInner.fillInModel((NotificationsModel)data);
            }
        }
        return settingsValid;
    }

    public boolean allowAbort() {
        return true;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(NotificationsPane.this, 1001, "APPLY");
            NotificationsPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            ActionEvent event = new ActionEvent(NotificationsPane.this, 1001, "CANCEL");
            NotificationsPane.this.fireActionPerformed(event);
        }

        /* synthetic */ 2() {
        }
    }

    public class NotificationsPaneInner
    extends JPanel
    implements AquaAlertListener {
        public static final int GRID_BAG_INSET_VALUE = 8;
        private static final int TABLE_ROW_HEIGHT = 20;
        private static final int REMOVE_EMAIL_ADDRESS_MODE = 1;
        private static final int SEND_TEST_EMAIL_MODE = 2;
        private EmailTableModel mEmailModel = null;
        private JTable mTable = null;
        private JButton mRemoveEmailButton = null;
        private JButton mEditEmailButton = null;
        private JButton mSendTestEmailButton = null;
        private SMTPPanel mSMTPPanel = null;

        public NotificationsPaneInner() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(8, 0, 8, 0));
            this.mEmailModel = new EmailTableModel();
            this.mTable = GUIFactory.newTable(this.mEmailModel);
            this.mTable.setAutoResizeMode(3);
            this.mTable.addMouseListener(new 3(this));
            this.mRemoveEmailButton = GUIFactory.newButton(Resources.getString("notifications.removeEmailButton"));
            this.mEditEmailButton = GUIFactory.newButton(Resources.getString("notifications.editEmailButton"));
            this.mSendTestEmailButton = GUIFactory.newButton(Resources.getString("notifications.testNotifications"));
            JLabel listOfEmailAddressesLabel = this.jlabelWithFont(Resources.getString("notifications.listOfEmailAddresses"), GUIFactory.FONT_SMALL);
            JLabel emailToLabel = this.jlabelWithFont(Resources.getString("notifications.emailTo"), GUIFactory.FONT_SMALL);
            JScrollPane scrollPane = new JScrollPane(this.mTable);
            JButton addEmailButton = GUIFactory.newButton(Resources.getString("notifications.addEmailButton"));
            scrollPane.addMouseListener(new 4(this));
            addEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mRemoveEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mEditEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mSendTestEmailButton.setFont(GUIFactory.FONT_SMALL);
            this.mRemoveEmailButton.setEnabled(false);
            this.mEditEmailButton.setEnabled(false);
            this.mSendTestEmailButton.setEnabled(false);
            addEmailButton.addActionListener(new 5(this));
            this.mRemoveEmailButton.addActionListener(new 6(this));
            this.mEditEmailButton.addActionListener(new 7(this));
            this.mSendTestEmailButton.addActionListener(new 8(this));
            this.mTable.getSelectionModel().addListSelectionListener(new 9(this));
            this.mTable.setRowHeight(20);
            TableColumn column = this.mTable.getColumnModel().getColumn(0);
            column.setHeaderValue(Resources.getString("notifications.emailHeader"));
            column.setResizable(false);
            column.setCellRenderer(new EmailAddressRenderer());
            HeaderRenderer headerRenderer = new HeaderRenderer();
            headerRenderer.setHorizontalAlignment(2);
            JTableHeader header = this.mTable.getTableHeader();
            header.setDefaultRenderer(headerRenderer);
            header.setFont(GUIFactory.FONT_SMALL);
            header.setReorderingAllowed(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 18;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            this.add((Component)listOfEmailAddressesLabel, constraints);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 5;
            constraints.gridwidth = 3;
            constraints.gridheight = 1;
            this.mSMTPPanel = new SMTPPanel();
            this.add((Component)this.mSMTPPanel, constraints);
            constraints.insets = new Insets(8, 8, 0, 0);
            constraints.fill = 2;
            constraints.gridx = 2;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)addEmailButton, constraints);
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.mRemoveEmailButton, constraints);
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.mEditEmailButton, constraints);
            constraints.insets = new Insets(0, 8, 8, 0);
            constraints.anchor = 16;
            constraints.gridx = 2;
            constraints.gridy = 4;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.mSendTestEmailButton, constraints);
            constraints.fill = 1;
            constraints.insets = new Insets(8, 0, 8, 0);
            constraints.ipadx = 340;
            constraints.ipady = 150;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 4;
            this.add((Component)scrollPane, constraints);
        }

        public void populateUI(NotificationsModel data) {
            ArrayList emailList = data.getEmailAddressList();
            if (emailList != null) {
                this.mEmailModel.setEmailList(emailList);
                this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
            }
            this.mSMTPPanel.populateUI(data);
        }

        public boolean checkValidity() {
            return this.mSMTPPanel.checkValidity();
        }

        public void fillInModel(NotificationsModel data) {
            data.setEmailAddressList(this.mEmailModel.getEmailList());
            this.mSMTPPanel.fillInModel(data);
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            if (contextInfo instanceof EmailAddressSheet) {
                EmailAddressSheet sheet = (EmailAddressSheet)contextInfo;
                sheet.getFirstFocus().requestFocus();
            }
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (contextInfo instanceof Integer && buttonPressIdentifier == 1) {
                Integer sheetMode = (Integer)contextInfo;
                if (sheetMode == 1) {
                    this.handleRemoveEmailAddresses();
                    this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
                } else if (sheetMode == 2) {
                    this.handleSendTestEmail();
                }
            } else if (contextInfo instanceof EmailAddressSheet && buttonPressIdentifier == 1) {
                this.handleAddEmailAddresses((EmailAddressSheet)contextInfo);
                this.mSendTestEmailButton.setEnabled(this.mSMTPPanel.sendTestEmailShouldBeEnabled());
            }
        }

        private void showAddEmailDialog() {
            EmailAddressSheet newAddressSheet = new EmailAddressSheet(Resources.getString("notifications.addEmailAddressDialogMessage"));
            AquaAlert theAlert = new AquaAlert(newAddressSheet, newAddressSheet.getOKButton(), newAddressSheet.getCancelButton(), null);
            theAlert.associateKeyCodeWithButton(46, 4, 2);
            theAlert.associateKeyCodeWithButton(27, 0, 2);
            newAddressSheet.setMode(1);
            theAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, newAddressSheet);
        }

        private void showRemoveEmailDialog() {
            AquaAlert theAlert = AquaAlert.createStandardAquaAlert(Resources.getString("notifications.removeAddressesAlertMessage"), Resources.getString("notifications.removeAddressesAlertExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), Resources.getString("cancel"), null);
            theAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, new Integer(1));
        }

        private void showEditEmailDialog() {
            EmailAddressSheet newAddressSheet = new EmailAddressSheet(Resources.getString("notifications.editEmailAddressDialogMessage"));
            AquaAlert theAlert = new AquaAlert(newAddressSheet, newAddressSheet.getOKButton(), newAddressSheet.getCancelButton(), null);
            theAlert.associateKeyCodeWithButton(46, 4, 2);
            theAlert.associateKeyCodeWithButton(27, 0, 2);
            newAddressSheet.setMode(2);
            int editIndex = this.mTable.getSelectionModel().getMinSelectionIndex();
            newAddressSheet.setEditIndex(editIndex);
            newAddressSheet.setEmailAddressFieldText((String)this.mEmailModel.getValueAt(editIndex, 0));
            theAlert.showSheet((JFrame)this.getTopLevelAncestor(), this, newAddressSheet);
        }

        private void handleRemoveEmailAddresses() {
            int index = this.mEmailModel.getRowCount() - 1;
            while (index >= 0) {
                if (this.mTable.getSelectionModel().isSelectedIndex(index)) {
                    try {
                        this.mEmailModel.removeEmailAddressAtIndex(index);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.mTable.tableChanged(new TableModelEvent(this.mEmailModel));
                    }
                }
                --index;
            }
            this.mTable.tableChanged(new TableModelEvent(this.mEmailModel));
        }

        private void handleSendTestEmail() {
            TestEmail email = new TestEmail(Resources.getString("notifications.testEmail"), this.mSMTPPanel.fromEmailAddress(), this.mSMTPPanel.fromSenderPassword(), this.mSMTPPanel.fromServer(), this.mSMTPPanel.fromSenderUsername(), Resources.getString("notifications.testEmailSubject"), this.mEmailModel.getEmailList());
            ActionEvent event = new ActionEvent(email, 1001, "TEST_EMAIL");
            NotificationsPane.this.fireActionPerformed(event);
        }

        private void handleAddEmailAddresses(EmailAddressSheet emailSheet) {
            int editBegin = 0;
            int editEnd = 0;
            Vector addressVector = emailSheet.getVectorOfEmailAddresses();
            if (emailSheet.getMode() == 1) {
                editBegin = this.mEmailModel.getRowCount();
                int index = 0;
                while (index < addressVector.size()) {
                    this.mEmailModel.addEmailAddress(((String)addressVector.elementAt(index)).trim());
                    ++index;
                }
                editEnd = this.mEmailModel.getRowCount() - 1;
            } else {
                int editIndex;
                editBegin = editIndex = emailSheet.getEditIndex();
                this.mEmailModel.removeEmailAddressAtIndex(editIndex);
                editEnd = editBegin + addressVector.size() - 2;
                int index = addressVector.size() - 1;
                while (index >= 0) {
                    this.mEmailModel.addEmailAddressAtIndex(((String)addressVector.elementAt(index)).trim(), editIndex);
                    --index;
                }
            }
            this.mTable.tableChanged(new TableModelEvent(this.mEmailModel, editBegin, editEnd, -1, 1));
        }

        public boolean allowAquaAlertToBeDismissed(int ignoredButtonIdentifier, Object ignoredContext) {
            return true;
        }

        public JLabel jlabelWithFont(String labelString, Font theFont) {
            JLabel theJLabel = new JLabel(labelString);
            theJLabel.setFont(theFont);
            return theJLabel;
        }

        static /* synthetic */ JTable access$0(NotificationsPaneInner $0) {
            return $0.mTable;
        }

        static /* synthetic */ void access$1(NotificationsPaneInner $0) {
            $0.showEditEmailDialog();
        }

        static /* synthetic */ void access$2(NotificationsPaneInner $0) {
            $0.showAddEmailDialog();
        }

        static /* synthetic */ void access$3(NotificationsPaneInner $0) {
            $0.showRemoveEmailDialog();
        }

        static /* synthetic */ JButton access$4(NotificationsPaneInner $0) {
            return $0.mRemoveEmailButton;
        }

        static /* synthetic */ JButton access$5(NotificationsPaneInner $0) {
            return $0.mEditEmailButton;
        }

        private class EmailTableModel
        extends AbstractTableModel {
            private ArrayList mEmailAddressList = new ArrayList();

            public void setEmailList(ArrayList list) {
                if (list.size() > 0) {
                    this.mEmailAddressList.addAll(list);
                }
            }

            public ArrayList getEmailList() {
                return this.mEmailAddressList;
            }

            public void addEmailAddress(String address) {
                this.mEmailAddressList.add(address);
            }

            public void addEmailAddressAtIndex(String address, int index) {
                this.mEmailAddressList.add(index, address);
            }

            public Object removeEmailAddressAtIndex(int index) throws IndexOutOfBoundsException {
                return this.mEmailAddressList.remove(index);
            }

            public int getRowCount() {
                return this.mEmailAddressList.size();
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int row, int column) {
                return this.mEmailAddressList.get(row);
            }

            public void setValueAt(Object value, int row, int column) {
                this.mEmailAddressList.set(row, value);
            }
        }

        class EmailAddressRenderer
        extends JPanel
        implements TableCellRenderer {
            AquaTableCellBorder border;
            JLabel label;

            public EmailAddressRenderer() {
                this.setLayout(new BoxLayout(this, 0));
                this.border = new AquaTableCellBorder();
                this.setBorder(this.border);
                this.label = new JLabel();
                this.label.setFont(GUIFactory.FONT_SMALL);
                this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                this.add(this.label);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                this.border.setAttributes(isSelected, table.hasFocus(), row);
                this.label.setText((String)value);
                this.label.setForeground(isSelected ? Color.white : Color.black);
                return this;
            }
        }

        class HeaderRenderer
        extends DefaultTableCellRenderer {
            public HeaderRenderer() {
                this.setHorizontalAlignment(0);
                this.setOpaque(true);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public void updateUI() {
                super.updateUI();
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setEnabled(header.isEnabled());
                    this.setComponentOrientation(header.getComponentOrientation());
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                } else {
                    this.setEnabled(true);
                    this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                    this.setForeground(UIManager.getColor("TableHeader.foreground"));
                    this.setBackground(UIManager.getColor("TableHeader.background"));
                    this.setFont(UIManager.getFont("TableHeader.font"));
                }
                this.setValue(value);
                return this;
            }
        }

        public class SMTPPanel
        extends JPanel {
            public static final String TITLED_BORDER_SPACING = " ";
            public static final int TEXT_FIELD_WIDTH = 120;
            public static final int GRID_BAG_COLUMN_SEPERATOR_INSET_VALUE = 20;
            public static final int CHECKBOX_SUBCOMPONENT_OFFSET = 22;
            private JCheckBox mEnableSMTPAuthenticationCheckBox;
            private JTextField mServerTextField;
            private JTextField mEmailAddressTextField;
            private JLabel mSMTPServerValidateLabel;
            private JLabel mSMTPEmailAddressValidateLabel;
            private JLabel mUsernameLabel;
            private JLabel mPasswordLabel;
            private JTextField mUsernameTextField;
            private JPasswordField mPasswordField;
            private JLabel mSMTPUsernameValidateLabel;
            private JLabel mSMTPPasswordValidateLabel;

            public SMTPPanel() {
                10 docListener = new 10(this);
                this.setLayout(new GridBagLayout());
                TitledBorder smtpBorder = BorderFactory.createTitledBorder(TITLED_BORDER_SPACING + Resources.getString("management.network.smtp.title") + TITLED_BORDER_SPACING);
                smtpBorder.setTitleFont(GUIFactory.FONT_SMALL);
                EmptyBorder margin = new EmptyBorder(0, 12, 12, 12);
                this.setBorder(new CompoundBorder(smtpBorder, margin));
                JLabel serverLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.server"), GUIFactory.FONT_SMALL);
                JLabel emailLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.emailAddress"), GUIFactory.FONT_SMALL);
                this.mServerTextField = GUIFactory.newTextField(120);
                this.mServerTextField.setFont(GUIFactory.FONT_SMALL);
                this.mServerTextField.getDocument().addDocumentListener(docListener);
                this.mEmailAddressTextField = GUIFactory.newTextField(120);
                this.mEmailAddressTextField.setFont(GUIFactory.FONT_SMALL);
                this.mEmailAddressTextField.getDocument().addDocumentListener(docListener);
                this.mEnableSMTPAuthenticationCheckBox = GUIFactory.newCheckBox(Resources.getString("management.network.smtp.enableAuthentication"));
                this.mEnableSMTPAuthenticationCheckBox.setFont(GUIFactory.FONT_SMALL);
                this.mEnableSMTPAuthenticationCheckBox.addActionListener(new 11(this));
                ImageIcon validateIcon = new ImageIcon(Resources.getImage("icon.validate"));
                this.mSMTPServerValidateLabel = new JLabel(validateIcon);
                this.mSMTPEmailAddressValidateLabel = new JLabel(validateIcon);
                this.mSMTPServerValidateLabel.setVisible(false);
                this.mSMTPEmailAddressValidateLabel.setVisible(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 0;
                constraints.anchor = 13;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.ipadx = 0;
                constraints.ipady = 0;
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)serverLabel, constraints);
                constraints.ipadx = 120;
                constraints.insets = new Insets(0, 8, 0, 0);
                constraints.anchor = 17;
                constraints.gridx = 1;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mServerTextField, constraints);
                constraints.gridx = 1;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mEmailAddressTextField, constraints);
                constraints.ipadx = 0;
                constraints.insets = new Insets(0, 20, 8, 0);
                constraints.gridx = 3;
                constraints.gridy = 0;
                constraints.gridwidth = 3;
                constraints.gridheight = 1;
                this.add((Component)this.mEnableSMTPAuthenticationCheckBox, constraints);
                constraints.anchor = 13;
                constraints.insets = new Insets(0, 0, 0, 0);
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)emailLabel, constraints);
                constraints.insets = new Insets(0, 4, 4, 0);
                constraints.anchor = 16;
                constraints.gridx = 2;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mSMTPServerValidateLabel, constraints);
                constraints.gridx = 2;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mSMTPEmailAddressValidateLabel, constraints);
                constraints.gridx = 2;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add(Box.createHorizontalStrut(validateIcon.getIconWidth()), constraints);
                this.mUsernameLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.username"), GUIFactory.FONT_SMALL);
                this.mUsernameLabel.setEnabled(false);
                this.mPasswordLabel = NotificationsPaneInner.this.jlabelWithFont(Resources.getString("management.network.smtp.password"), GUIFactory.FONT_SMALL);
                this.mPasswordLabel.setEnabled(false);
                this.mUsernameTextField = GUIFactory.newTextField(120);
                this.mUsernameTextField.setFont(GUIFactory.FONT_SMALL);
                this.mUsernameTextField.setEnabled(false);
                this.mUsernameTextField.getDocument().addDocumentListener(docListener);
                this.mPasswordField = GUIFactory.newPasswordField();
                this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
                this.mPasswordField.setEnabled(false);
                this.mPasswordField.getDocument().addDocumentListener(docListener);
                if (Gestalt.isMacLookAndFeel) {
                    this.mPasswordField.setEchoChar('\u2022');
                }
                this.mSMTPUsernameValidateLabel = new JLabel(validateIcon);
                this.mSMTPPasswordValidateLabel = new JLabel(validateIcon);
                this.mSMTPUsernameValidateLabel.setVisible(false);
                this.mSMTPPasswordValidateLabel.setVisible(false);
                constraints.anchor = 13;
                constraints.insets = new Insets(0, 42, 0, 0);
                constraints.gridx = 3;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mUsernameLabel, constraints);
                constraints.insets = new Insets(8, 42, 0, 0);
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mPasswordLabel, constraints);
                constraints.insets = new Insets(0, 4, 4, 0);
                constraints.anchor = 16;
                constraints.gridx = 5;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mSMTPUsernameValidateLabel, constraints);
                constraints.gridx = 5;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mSMTPPasswordValidateLabel, constraints);
                constraints.gridx = 5;
                constraints.gridy = 3;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add(Box.createHorizontalStrut(validateIcon.getIconWidth()), constraints);
                constraints.anchor = 17;
                constraints.ipadx = 120;
                constraints.insets = new Insets(0, 8, 0, 0);
                constraints.gridx = 4;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mUsernameTextField, constraints);
                constraints.insets = new Insets(8, 8, 0, 0);
                constraints.gridx = 4;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mPasswordField, constraints);
            }

            public String fromServer() {
                return String.valueOf(this.mServerTextField.getText());
            }

            public String fromEmailAddress() {
                return String.valueOf(this.mEmailAddressTextField.getText());
            }

            public String fromSenderUsername() {
                String string = this.mEnableSMTPAuthenticationCheckBox.isSelected() ? String.valueOf(this.mUsernameTextField.getText()) : null;
                return string;
            }

            public String fromSenderPassword() {
                String string = this.mEnableSMTPAuthenticationCheckBox.isSelected() ? String.valueOf(new String(this.mPasswordField.getPassword())) : null;
                return string;
            }

            public void populateUI(NotificationsModel model) {
                boolean checkboxSelected = model.getSMTPServerRequiresAuthentication();
                this.mEnableSMTPAuthenticationCheckBox.setSelected(checkboxSelected);
                this.mServerTextField.setText(model.getSMTPServer());
                this.mEmailAddressTextField.setText(model.getSMTPFromEmailAddress());
                this.mUsernameTextField.setText(model.getSMTPUsername());
                ((JTextComponent)this.mPasswordField).setText(model.getSMTPPassword());
                this.mUsernameTextField.setEnabled(checkboxSelected);
                this.mPasswordField.setEnabled(checkboxSelected);
                NotificationsPane.this.mNotificationsPaneInner.mSendTestEmailButton.setEnabled(this.sendTestEmailShouldBeEnabled());
            }

            public boolean checkValidity() {
                boolean isValid = true;
                if (this.mEnableSMTPAuthenticationCheckBox.isSelected()) {
                    if (this.fromSenderUsername().length() == 0) {
                        this.mSMTPUsernameValidateLabel.setVisible(true);
                        isValid = false;
                    } else {
                        this.mSMTPUsernameValidateLabel.setVisible(false);
                    }
                    if (this.fromSenderPassword().length() == 0) {
                        this.mSMTPPasswordValidateLabel.setVisible(true);
                        isValid = false;
                    } else {
                        this.mSMTPPasswordValidateLabel.setVisible(false);
                    }
                }
                return isValid;
            }

            public void fillInModel(NotificationsModel model) {
                model.setSMTPServer(this.mServerTextField.getText());
                model.setSMTPFromEmailAddress(this.mEmailAddressTextField.getText());
                model.setSMTPServerRequiresAuthentication(this.mEnableSMTPAuthenticationCheckBox.isSelected());
                model.setSMTPUsername(this.mUsernameTextField.getText());
                model.setSMTPPassword(new String(this.mPasswordField.getPassword()));
            }

            public boolean sendTestEmailShouldBeEnabled() {
                boolean value = false;
                if (this.fromServer().length() > 0 && this.fromEmailAddress().length() > 0 && NotificationsPane.this.mNotificationsPaneInner.mEmailModel.getRowCount() > 0) {
                    value = true;
                }
                if (value && this.mEnableSMTPAuthenticationCheckBox.isSelected() && (this.fromSenderUsername().length() == 0 || this.fromSenderPassword().length() == 0)) {
                    value = false;
                }
                return value;
            }

            static /* synthetic */ NotificationsPaneInner access$0(SMTPPanel $0) {
                return $0.NotificationsPaneInner.this;
            }

            static /* synthetic */ JCheckBox access$1(SMTPPanel $0) {
                return $0.mEnableSMTPAuthenticationCheckBox;
            }

            static /* synthetic */ JLabel access$2(SMTPPanel $0) {
                return $0.mUsernameLabel;
            }

            static /* synthetic */ JTextField access$3(SMTPPanel $0) {
                return $0.mUsernameTextField;
            }

            static /* synthetic */ JLabel access$4(SMTPPanel $0) {
                return $0.mPasswordLabel;
            }

            static /* synthetic */ JPasswordField access$5(SMTPPanel $0) {
                return $0.mPasswordField;
            }
        }

        public class EmailAddressSheet
        extends GridBagPanel {
            public static final int ADDRESS_FIELD_WIDTH = 20;
            public static final int ADD_EMAIL_MODE = 1;
            public static final int EDIT_EMAIL_MODE = 2;
            private JTextField mAddressField = null;
            private JButton mOKButton = null;
            private JButton mCancelButton = null;
            private int mMode = 1;
            private int mEditIndex = 0;

            public EmailAddressSheet(String message) {
                Box buttonBox = Box.createHorizontalBox();
                JLabel addressLabel = new JLabel(Resources.getString("notifications.emailSheetLabel"));
                GridBagConstraints constraints = new GridBagConstraints();
                this.mAddressField = GUIFactory.newTextField(20);
                this.mOKButton = GUIFactory.newOKButton();
                this.mCancelButton = GUIFactory.newCancelButton();
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                constraints.anchor = 17;
                constraints.fill = 0;
                constraints.insets = new Insets(0, 0, 8, 0);
                JTextArea messageLabel = new JTextArea(message);
                messageLabel.setFont(GUIFactory.FONT_SMALL);
                messageLabel.setBackground(null);
                messageLabel.setHighlighter(null);
                messageLabel.setEditable(false);
                messageLabel.setLineWrap(true);
                messageLabel.setWrapStyleWord(true);
                messageLabel.setSize(300, 64);
                messageLabel.setMinimumSize(new Dimension(300, 48));
                messageLabel.setMaximumSize(new Dimension(300, 200));
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                this.add((Component)messageLabel, constraints);
                addressLabel.setFont(GUIFactory.FONT_SMALL);
                this.mAddressField.setFont(GUIFactory.FONT_SMALL);
                constraints.insets = new Insets(0, 0, 8, 0);
                constraints.anchor = 17;
                constraints.gridx = 1;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)this.mAddressField, constraints);
                constraints.anchor = 13;
                constraints.insets = new Insets(0, 0, 8, 8);
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)addressLabel, constraints);
                buttonBox.add(this.mCancelButton);
                buttonBox.add(Box.createHorizontalStrut(8));
                buttonBox.add(this.mOKButton);
                constraints.insets = new Insets(8, 0, 0, 0);
                constraints.gridx = 0;
                constraints.gridy = 3;
                constraints.gridwidth = 2;
                constraints.gridheight = 1;
                this.add((Component)buttonBox, constraints);
            }

            public boolean isFocusCycleRoot() {
                return true;
            }

            public int getMode() {
                return this.mMode;
            }

            public void setMode(int mode) {
                this.mMode = mode;
            }

            public JComponent getFirstFocus() {
                return this.mAddressField;
            }

            public Vector getVectorOfEmailAddresses() {
                String addressFieldText = this.mAddressField.getText();
                int lastCommaIndex = 0;
                int nextCommaIndex = 0;
                Vector<String> addressVector = new Vector<String>();
                while (nextCommaIndex >= 0) {
                    nextCommaIndex = addressFieldText.indexOf(Resources.getString("notifications.emailAddressDelimiter"), lastCommaIndex + 1);
                    String address = null;
                    address = lastCommaIndex == 0 && nextCommaIndex == -1 ? addressFieldText.substring(lastCommaIndex, addressFieldText.length()) : (lastCommaIndex == 0 ? addressFieldText.substring(lastCommaIndex, nextCommaIndex) : (nextCommaIndex >= 0 ? addressFieldText.substring(lastCommaIndex + 1, nextCommaIndex) : addressFieldText.substring(lastCommaIndex + 1, addressFieldText.length())));
                    if (!address.trim().equals("")) {
                        addressVector.add(address);
                    }
                    lastCommaIndex = nextCommaIndex;
                }
                return addressVector;
            }

            public void setEmailAddressFieldText(String address) {
                this.mAddressField.setText(address);
            }

            public int getEditIndex() {
                return this.mEditIndex;
            }

            public void setEditIndex(int editIndex) {
                this.mEditIndex = editIndex;
            }

            public JButton getOKButton() {
                return this.mOKButton;
            }

            public JButton getCancelButton() {
                return this.mCancelButton;
            }
        }
    }
}

