/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.VersionNumber;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import java.text.ParseException;
import org.apache.log4j.Logger;

public class OperationManager {
    public static final Operation OP_MONITOR = new Operation("*", "*");
    public static final Operation OP_CREATE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_DELETE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_SLICE_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_EXPAND_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_VERIFY_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_REBUILD_ARRAY = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_LUN_MASKING = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_SYSTEM_SETTINGS = new Operation("*", "*");
    public static final Operation OP_CONFIGURE_NOTIFICATIONS = new Operation("*", "*");
    public static final Operation OP_TOGGLE_SERVICE_ID = new Operation("*", "*");
    public static final Operation OP_CLEAR_EVENT_LOG = new Operation("*", "*");
    public static final Operation OP_CLEAR_ERROR_STATUS = new Operation("*", "*");
    public static final Operation OP_RESTART = new Operation("*", "*");
    public static final Operation OP_SHUTDOWN = new Operation("*", "*");
    public static final Operation OP_RESET_RAID_CONTROLLER = new Operation("*", "1.50+");
    public static final Operation OP_REPAIR_LUN_MAP = new Operation("1.2+", "*");
    public static final Operation OP_UPDATE_FIRMWARE = new Operation("*", "*");
    public static final Operation OP_BACKGROUND_CONDITION = new Operation("1.5b4+", "*");
    public static final Operation OP_DELETE_ORPHAN = new Operation("1.5b4+", "*");
    public static final Operation OP_READ_EVENT_LOG = new Operation("1.2+", "*");
    public static final Operation OP_CONFIGURE_DISK_CACHE = new Operation("*", "*");
    public static final Operation OP_CONFIGURE_SYNC_CACHE = new Operation("1.5b4+", "*");
    public static final Operation OP_CONFIGURE_SLOW_READ_BYPASS = new Operation("1.5b4+", "*");
    private static final boolean DEBUG = true;
    static /* synthetic */ Class class$com$apple$xsr$OperationManager$Operation;

    public static boolean isSupported(RaidSystem system, Operation operation) throws Exception {
        if (system == null) {
            throw new NullPointerException("system cannot be null");
        }
        if (operation == null) {
            throw new NullPointerException("operation cannot be null");
        }
        return operation.isSupported(system);
    }

    public static boolean isSupported(RaidSystem system, int module, Operation operation) throws Exception {
        if (system == null) {
            throw new NullPointerException("system cannot be null");
        }
        if (operation == null) {
            throw new NullPointerException("operation cannot be null");
        }
        return operation.isSupported(system, module);
    }

    public static void main(String[] args) {
        int testIndex = 0;
        try {
            VersionNumber testCoprocessorVersion = VersionNumber.newAppleVersionNumber("1.2.1");
            VersionNumber testControllerVersion = VersionNumber.newAcsVersionNumber("2.1");
            ++testIndex;
            if (!OP_MONITOR.isSupported(testCoprocessorVersion, testControllerVersion)) {
                throw new RuntimeException("Failed unit test " + testIndex + ".");
            }
            ++testIndex;
            if (!OP_CREATE_ARRAY.isSupported(testCoprocessorVersion, testControllerVersion)) {
                throw new RuntimeException("Failed unit test " + testIndex + ".");
            }
            ++testIndex;
            if (!OP_DELETE_ARRAY.isSupported(testCoprocessorVersion, testControllerVersion)) {
                throw new RuntimeException("Failed unit test " + testIndex + ".");
            }
            testCoprocessorVersion = VersionNumber.newAppleVersionNumber("1.1.9");
            ++testIndex;
            if (OP_CREATE_ARRAY.isSupported(testCoprocessorVersion, testControllerVersion)) {
                throw new RuntimeException("Failed unit test " + testIndex + ".");
            }
            ++testIndex;
            if (OP_DELETE_ARRAY.isSupported(testCoprocessorVersion, testControllerVersion)) {
                throw new RuntimeException("Failed unit test " + testIndex + ".");
            }
            System.out.println("ALL TESTS PASSED");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n\nTEST FAILED\n");
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static class Operation {
        public static final int ANY = 0;
        public static final int NONE = 1;
        public static final int EQ = 2;
        public static final int NE = 3;
        public static final int GE = 4;
        public static final int LE = 5;
        public static final int LT = 6;
        public static final int GT = 7;
        public static final int COPROCESSOR = 0;
        public static final int RAID_CONTROLLER = 1;
        private VersionNumber coprocessorVersion;
        private VersionNumber controllerVersion;
        private int coprocessorQualifier;
        private int controllerQualifier;
        private static final Logger logger = Logger.getLogger(class$com$apple$xsr$OperationManager$Operation != null ? class$com$apple$xsr$OperationManager$Operation : (class$com$apple$xsr$OperationManager$Operation = OperationManager.class$("com.apple.xsr.OperationManager$Operation")));

        public Operation(String coprocessorVersion, String raidControllerVersion) {
            if (coprocessorVersion == null) {
                throw new NullPointerException("coprocessor version cannot be null");
            }
            if (coprocessorVersion.length() == 0) {
                throw new IllegalArgumentException("coprocessor version cannot be empty");
            }
            if (raidControllerVersion == null) {
                throw new NullPointerException("RAID controller version cannot be null");
            }
            if (raidControllerVersion.length() == 0) {
                throw new IllegalArgumentException("RAID controller version cannot be empty");
            }
            try {
                this.parseSpecifier(coprocessorVersion, 0);
                this.parseSpecifier(raidControllerVersion, 1);
            }
            catch (ParseException e) {
                this.coprocessorQualifier = 0;
                this.controllerQualifier = 0;
                logger.error(e);
            }
        }

        public boolean isSupported(RaidSystem system) throws Exception {
            RaidController controller;
            SystemController coprocessor;
            if (system == null) {
                throw new NullPointerException("system cannot be null");
            }
            VersionNumber topCoprocessor = null;
            VersionNumber topController = null;
            VersionNumber bottomCoprocessor = null;
            VersionNumber bottomController = null;
            Boolean topSupported = null;
            Boolean bottomSupported = null;
            if (system.isControllerModulePresent(1)) {
                try {
                    coprocessor = system.getSystemController(1);
                    if (coprocessor != null) {
                        topCoprocessor = VersionNumber.newAppleVersionNumber(coprocessor.getSystemVersion());
                    }
                }
                catch (Exception exception) {}
                try {
                    controller = system.getRaidController(1);
                    if (controller != null) {
                        topController = VersionNumber.newAcsVersionNumber(controller.getFirmwareVersion());
                    }
                }
                catch (Exception exception) {}
                topSupported = new Boolean(this.isSupported(topCoprocessor, topController));
            }
            if (system.isControllerModulePresent(2)) {
                try {
                    coprocessor = system.getSystemController(2);
                    if (coprocessor != null) {
                        bottomCoprocessor = VersionNumber.newAppleVersionNumber(coprocessor.getSystemVersion());
                    }
                }
                catch (Exception exception) {}
                try {
                    controller = system.getRaidController(2);
                    if (controller != null) {
                        bottomController = VersionNumber.newAcsVersionNumber(controller.getFirmwareVersion());
                    }
                }
                catch (Exception exception) {}
                bottomSupported = new Boolean(this.isSupported(bottomCoprocessor, bottomController));
            }
            if (topSupported != null && bottomSupported != null) {
                return topSupported != false && bottomSupported != false;
            }
            if (topSupported != null) {
                return topSupported;
            }
            if (bottomSupported != null) {
                return bottomSupported;
            }
            throw new Exception("Unable to determine compatibility. No version information available.");
        }

        public boolean isSupported(RaidSystem system, int module) throws Exception {
            VersionNumber currentController;
            VersionNumber currentCoprocessor;
            block6: {
                RaidController controller;
                if (system == null) {
                    throw new NullPointerException("system cannot be null");
                }
                currentCoprocessor = null;
                currentController = null;
                SystemController coprocessor = system.getSystemController(module);
                if (coprocessor != null) {
                    try {
                        currentCoprocessor = VersionNumber.newAppleVersionNumber(coprocessor.getSystemVersion());
                    }
                    catch (Exception exception) {}
                }
                if ((controller = system.getRaidController(module)) == null) break block6;
                try {
                    currentController = VersionNumber.newAcsVersionNumber(controller.getFirmwareVersion());
                }
                catch (Exception exception) {}
            }
            return this.isSupported(currentCoprocessor, currentController);
        }

        public boolean isSupported(VersionNumber coprocessorVersion, VersionNumber raidControllerVersion) throws Exception {
            boolean coprocessorResult = this.compare(coprocessorVersion, this.coprocessorVersion, this.coprocessorQualifier);
            boolean controllerResult = this.compare(raidControllerVersion, this.controllerVersion, this.controllerQualifier);
            return coprocessorResult && controllerResult;
        }

        public VersionNumber getSupportedVersion(int component) {
            if (component == 0) {
                return this.coprocessorVersion;
            }
            if (component == 1) {
                return this.controllerVersion;
            }
            throw new IllegalArgumentException("Invalid component (" + component + ")");
        }

        public int getQualifier(int component) {
            if (component == 0) {
                return this.coprocessorQualifier;
            }
            if (component == 1) {
                return this.controllerQualifier;
            }
            throw new IllegalArgumentException("Invalid component (" + component + ")");
        }

        public String getQualifierAsString(int component) {
            int qualifier = this.getQualifier(component);
            String s = qualifier == 0 ? "*" : (qualifier == 1 ? "None" : (qualifier == 2 ? "=" : (qualifier == 3 ? "!=" : (qualifier == 4 ? ">=" : (qualifier == 5 ? "<=" : (qualifier == 6 ? "<" : (qualifier == 7 ? ">" : "")))))));
            return s;
        }

        public String toString() {
            String s = "Coprocessor ";
            s = this.coprocessorQualifier != 0 ? String.valueOf(s) + this.getQualifierAsString(0) + this.coprocessorVersion + ", Controller " : String.valueOf(s) + "*, Controller";
            s = this.controllerQualifier != 0 ? String.valueOf(s) + this.getQualifierAsString(1) + this.controllerVersion : String.valueOf(s) + "*";
            return s;
        }

        private boolean compare(VersionNumber installedVersion, VersionNumber supportedVersion, int qualifier) throws Exception {
            boolean result;
            if (qualifier == 0) {
                result = true;
            } else if (qualifier == 1) {
                result = false;
            } else if (qualifier == 2) {
                if (installedVersion == null) {
                    throw new Exception("Error performing EQ comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing EQ comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) == 0;
            } else if (qualifier == 3) {
                if (installedVersion == null) {
                    throw new Exception("Error performing NE comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing NE comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) != 0;
            } else if (qualifier == 4) {
                if (installedVersion == null) {
                    throw new Exception("Error performing GE comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing GE comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) == 0 || installedVersion.compareTo(supportedVersion) > 0;
            } else if (qualifier == 5) {
                if (installedVersion == null) {
                    throw new Exception("Error performing LE comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing LE comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) == 0 || installedVersion.compareTo(supportedVersion) < 0;
            } else if (qualifier == 7) {
                if (installedVersion == null) {
                    throw new Exception("Error performing GT comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing GT comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) > 0;
            } else if (qualifier == 6) {
                if (installedVersion == null) {
                    throw new Exception("Error performing LT comparison: installed version null");
                }
                if (supportedVersion == null) {
                    throw new Exception("Error performing LT comparison: supported version null");
                }
                result = installedVersion.compareTo(supportedVersion) < 0;
            } else {
                throw new IllegalArgumentException("Unrecognized qualifier: " + qualifier);
            }
            return result;
        }

        private void parseSpecifier(String s, int component) throws ParseException {
            int qualifier = -1;
            String version = null;
            if (s.startsWith("*")) {
                if (s.length() > 1) {
                    throw new ParseException("Illegal characters following '*': " + s, 1);
                }
                qualifier = 0;
            }
            if (s.startsWith("+")) {
                if (s.length() < 2) {
                    throw new ParseException("Missing version: " + s, 1);
                }
                qualifier = 7;
                version = s.substring(1);
            }
            if (s.startsWith("-")) {
                if (s.length() < 2) {
                    throw new ParseException("Missing version: " + s, 1);
                }
                qualifier = 6;
                version = s.substring(1);
            }
            if (s.startsWith("!")) {
                if (s.length() < 2) {
                    throw new ParseException("Missing version: " + s, 1);
                }
                qualifier = 3;
                version = s.substring(1);
            }
            if (s.endsWith("+")) {
                if (qualifier != -1) {
                    throw new ParseException("Multiple qualifiers: " + s, 0);
                }
                if (s.length() < 2) {
                    throw new ParseException("Missing version: " + s, 1);
                }
                qualifier = 4;
                version = s.substring(0, s.length() - 1);
            }
            if (s.endsWith("-")) {
                if (qualifier != -1) {
                    throw new ParseException("Multiple qualifiers:" + s, 0);
                }
                if (s.length() < 2) {
                    throw new ParseException("Missing version: " + s, 1);
                }
                qualifier = 5;
                version = s.substring(0, s.length() - 1);
            }
            if (qualifier == -1) {
                if (s.length() == 0) {
                    throw new ParseException("Missing version: " + s, 0);
                }
                qualifier = 2;
                version = s;
            }
            if (component == 0) {
                this.coprocessorQualifier = qualifier;
                if (version != null) {
                    this.coprocessorVersion = VersionNumber.newAppleVersionNumber(version);
                }
            } else if (component == 1) {
                this.controllerQualifier = qualifier;
                if (version != null) {
                    this.controllerVersion = VersionNumber.newAcsVersionNumber(version);
                }
            }
        }
    }
}

