/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class PreferencesWindow
extends JFrame {
    private static PreferencesWindow mPreferencesWindow = null;
    private static JCheckBox useShapesCheckBox = null;
    private static ButtonGroup clockFormatButtonGroup = null;
    private static JCheckBox limitEventLogCheckBox = null;
    private static RestrictedTextField limitEventLogTextField = null;
    private static final String CLOCK_FORMAT_12_HOUR = "12";
    private static final String CLOCK_FORMAT_24_HOUR = "24";

    private PreferencesWindow() {
        this.setTitle(Resources.getString("prefs.title"));
        this.setResizable(false);
        if (Gestalt.isMacOS()) {
            this.setJMenuBar(RaidAdmin.newMenuBar(1));
        }
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        JPanel panel = GUIFactory.newPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(16, 16, 16, 16));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        useShapesCheckBox = GUIFactory.newCheckBox(Resources.getString("prefs.useShapes"));
        if (prefs != null) {
            useShapesCheckBox.setSelected(prefs.getBoolean("UseShapes", false));
        }
        constraints.gridwidth = 3;
        constraints.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)useShapesCheckBox, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        1 shapesCheckboxAction = new 1();
        useShapesCheckBox.addActionListener(shapesCheckboxAction);
        constraints.gridwidth = 3;
        constraints.insets = new Insets(5, 0, 5, 0);
        clockFormatButtonGroup = new ButtonGroup();
        JRadioButton twelveHourRadioButton = GUIFactory.newRadioButton(Resources.getString("prefs.clockFormat.twelveHour"));
        twelveHourRadioButton.setActionCommand(CLOCK_FORMAT_12_HOUR);
        panel.add((Component)twelveHourRadioButton, constraints);
        clockFormatButtonGroup.add(twelveHourRadioButton);
        constraints.insets = new Insets(0, 0, 10, 0);
        ++constraints.gridy;
        JRadioButton twentyFourHourRadioButton = GUIFactory.newRadioButton(Resources.getString("prefs.clockFormat.twentyFourHour"));
        twentyFourHourRadioButton.setActionCommand(CLOCK_FORMAT_24_HOUR);
        panel.add((Component)twentyFourHourRadioButton, constraints);
        clockFormatButtonGroup.add(twentyFourHourRadioButton);
        2 radioButtonAction = new 2();
        twelveHourRadioButton.addActionListener(radioButtonAction);
        twentyFourHourRadioButton.addActionListener(radioButtonAction);
        if (prefs != null) {
            String defaultFormat = Gestalt.timeFormat == 12 ? CLOCK_FORMAT_12_HOUR : CLOCK_FORMAT_24_HOUR;
            String format = prefs.getString("TimeFormat", defaultFormat);
            if (format.equals(CLOCK_FORMAT_12_HOUR)) {
                twelveHourRadioButton.setSelected(true);
            } else {
                twentyFourHourRadioButton.setSelected(true);
            }
        }
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        limitEventLogCheckBox = GUIFactory.newCheckBox(Resources.getString("prefs.limitEventLogTo"));
        if (prefs != null) {
            limitEventLogCheckBox.setSelected(prefs.getBoolean("LimitEventLog", false));
        }
        ++constraints.gridx;
        limitEventLogTextField = GUIFactory.newRestrictedTextField(4);
        limitEventLogTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validNumericCharacters"));
        if (prefs != null) {
            limitEventLogTextField.setText(String.valueOf(prefs.getInteger("LimitEventLogAmount", 100)));
        }
        constraints.insets = new Insets(0, 5, 0, 5);
        constraints.insets = new Insets(0, 0, 0, 0);
        ++constraints.gridx;
        constraints.gridx = 0;
        ++constraints.gridy;
        JButton mOKButton = GUIFactory.newOKButton();
        mOKButton.addActionListener(new 3());
        JButton mCancelButton = GUIFactory.newCancelButton();
        mCancelButton.addActionListener(new 4());
        Box controlBox = Box.createHorizontalBox();
        ((Component)controlBox).setBackground(Color.orange);
        controlBox.add(mCancelButton);
        controlBox.add(Box.createHorizontalStrut(8));
        controlBox.add(mOKButton);
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridwidth = 3;
        constraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add(panel);
        this.pack();
    }

    public static PreferencesWindow getSharedInstance() {
        if (mPreferencesWindow == null) {
            mPreferencesWindow = new PreferencesWindow();
            mPreferencesWindow.setDefaultCloseOperation(0);
            mPreferencesWindow.addWindowListener(new 5());
        }
        return mPreferencesWindow;
    }

    public void pack() {
        String vmVersion = System.getProperty("java.vm.version");
        if (vmVersion != null && vmVersion.startsWith("Blackdown-1.3.1")) {
            ((Component)this).setSize(this.getPreferredSize());
        } else {
            super.pack();
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Preferences p = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
            if (p != null) {
                p.setBoolean("UseShapes", useShapesCheckBox.isSelected());
                p.synchronize();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Preferences p = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
            if (p != null) {
                p.setString("TimeFormat", clockFormatButtonGroup.getSelection().getActionCommand());
                p.synchronize();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Preferences p = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
            if (p != null) {
                p.setBoolean("UseShapes", useShapesCheckBox.isSelected());
                p.setString("TimeFormat", clockFormatButtonGroup.getSelection().getActionCommand());
                p.setBoolean("LimitEventLog", limitEventLogCheckBox.isSelected());
                p.setInteger("LimitEventLogAmount", Integer.parseInt(limitEventLogTextField.getText()));
                p.synchronize();
            }
            mPreferencesWindow.dispose();
            mPreferencesWindow = null;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            mPreferencesWindow.dispose();
            mPreferencesWindow = null;
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            mPreferencesWindow.dispose();
            mPreferencesWindow = null;
        }

        /* synthetic */ 5() {
        }
    }
}

