/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.net.acp.AcpTextRecord;
import com.apple.util.Gestalt;
import com.apple.util.SortedArrayList;
import com.apple.xsr.IconFamily;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.RendezvousPanel;
import com.apple.xsr.Resources;
import com.chaotic.rendezvous.Browser;
import com.chaotic.rendezvous.BrowserListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmdns.ServiceInfo;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class RendezvousPanel
extends JPanel
implements ListSelectionListener {
    public static final String XSERVE_RAID_SERVICE_NAME = new String("_xserveraid._tcp");
    public static final String XSERVE_SERVICE_NAME = new String("_xserve._tcp");
    public static final int XSERVE_RAID_MANGEMENT_USER = 1;
    public static final int XSERVE_RAID_MONITOR_USER = 2;
    private static final Dimension DEFAULT_DIMENSIONS = new Dimension(230, 200);
    private static final Color BOX_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.99f);
    private static final Color SIDE_BORDER_COLOR = Color.lightGray;
    private static final Color TOP_BORDER_COLOR = RendezvousPanel.getRGBColor(124, 124, 124);
    private static final Color BOTTOM_BORDER_COLOR = RendezvousPanel.getRGBColor(207, 207, 207);
    private RendezvousBrowserPanel mPanel;
    private RestrictedTextField mIPAddressTextField;
    private JPasswordField mPassword;
    private JButton mAdd;
    private JButton mCancel;
    private ArrayList mMonitoredMacAddresses = null;
    private ArrayList mMonitoredIPAddresses = null;

    public RendezvousPanel(ArrayList monitoredControllerMacAddresses, ArrayList monitoredIPAddresses) {
        GridBagConstraints constraints = new GridBagConstraints();
        String[] service = new String[]{XSERVE_RAID_SERVICE_NAME};
        String[] icon = new String[]{"icon.xserveraid"};
        this.mMonitoredMacAddresses = monitoredControllerMacAddresses;
        this.mMonitoredIPAddresses = monitoredIPAddresses;
        this.setLayout(new GridBagLayout());
        this.mPanel = new RendezvousBrowserPanel(service, icon);
        this.mPanel.addListSelectionListener(this);
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)this.mPanel, constraints);
        JLabel address = new JLabel(Resources.getString("rendezvousPanel.addressLabel"));
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)address, constraints);
        this.mIPAddressTextField = GUIFactory.newRestrictedTextField(20);
        this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
        this.mIPAddressTextField.setFont(GUIFactory.FONT_SMALL);
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.mIPAddressTextField, constraints);
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)new JLabel(Resources.getString("rendezvousPanel.passwordLabel")), constraints);
        this.mPassword = GUIFactory.newPasswordField(10);
        this.mPassword.setFont(GUIFactory.FONT_SMALL);
        if (Gestalt.isMacLookAndFeel) {
            this.mPassword.setEchoChar('\u2022');
        }
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.mPassword, constraints);
        Box box2 = Box.createHorizontalBox();
        this.mAdd = GUIFactory.newButton(Resources.getString("rendezvousPanel.addButton"));
        this.mCancel = GUIFactory.newCancelButton();
        this.mAdd.setEnabled(false);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.mCancel);
        box2.add(Box.createHorizontalStrut(12));
        box2.add(this.mAdd);
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)box2, constraints);
        this.mIPAddressTextField.getDocument().addDocumentListener(new 1());
        2 caretListener = new 2();
        this.mIPAddressTextField.addCaretListener(caretListener);
        this.mPassword.addCaretListener(caretListener);
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public JButton getAddButton() {
        return this.mAdd;
    }

    public JButton getCancelButton() {
        return this.mCancel;
    }

    public String[] getAddresses() {
        String[] addresses;
        Object[] selectedItems = this.mPanel.mList.getSelectedValues();
        int count = selectedItems.length;
        if (count == 0) {
            addresses = new String[]{this.mIPAddressTextField.getText()};
        } else {
            addresses = new String[count];
            int index = 0;
            while (index < count) {
                addresses[index] = ((RendezvousListItem)selectedItems[index]).getAddress();
                ++index;
            }
        }
        return addresses;
    }

    public String[] getNames() {
        String[] names;
        Object[] selectedItems = this.mPanel.mList.getSelectedValues();
        int count = selectedItems.length;
        if (count == 0) {
            names = new String[]{""};
        } else {
            names = new String[count];
            int index = 0;
            while (index < count) {
                names[index] = ((RendezvousListItem)selectedItems[index]).getName();
                ++index;
            }
        }
        return names;
    }

    public String getPassword() {
        return new String(this.mPassword.getPassword());
    }

    public void resetPassword() {
        ((JTextComponent)this.mPassword).setText("");
    }

    public void beginServices() {
        String[] service = new String[]{XSERVE_RAID_SERVICE_NAME};
        this.mPanel.requestFocus();
        this.mPanel.startRendezvousServices(service);
    }

    public void endServices() {
        this.mPanel.stopRendezvousServices();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof JList) {
            JList list = (JList)e.getSource();
            Object[] selectedItems = list.getSelectedValues();
            int count = selectedItems.length;
            if (count == 1) {
                RendezvousListItem selectedItem = (RendezvousListItem)selectedItems[0];
                this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
                this.mIPAddressTextField.setText(selectedItem.getAddress());
                GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
                ((JTextComponent)this.mPassword).setText("");
            } else if (count > 1) {
                this.mIPAddressTextField.setRestrictedCharacterSet(null);
                this.mIPAddressTextField.setText(Resources.getString("rendezvousPanel.multipleSelection"));
                GUIFactory.configureTextFieldAsLabel(this.mIPAddressTextField);
                ((JTextComponent)this.mPassword).setText("");
            } else if (!this.mIPAddressTextField.hasFocus()) {
                this.mIPAddressTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validDNSCharacters"));
                this.mIPAddressTextField.setText("");
                GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
                this.mIPAddressTextField.requestFocus();
            }
        }
    }

    public static Color getRGBColor(int r, int g, int b) {
        float[] array = new float[3];
        array = Color.RGBtoHSB(r, g, b, array);
        return Color.getHSBColor(array[0], array[1], array[2]);
    }

    private final class 1
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            this.clearRendezvousSelectionIfEditing();
        }

        public void insertUpdate(DocumentEvent e) {
            this.clearRendezvousSelectionIfEditing();
        }

        public void removeUpdate(DocumentEvent e) {
            this.clearRendezvousSelectionIfEditing();
        }

        void clearRendezvousSelectionIfEditing() {
            if (RendezvousPanel.this.mIPAddressTextField.hasFocus()) {
                RendezvousPanel.this.mPanel.mList.clearSelection();
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements CaretListener {
        public void caretUpdate(CaretEvent e) {
            try {
                String ipaddress = new String(RendezvousPanel.this.mIPAddressTextField.getText());
                String password = new String(RendezvousPanel.this.mPassword.getPassword());
                if (ipaddress.length() > 0 && password.length() > 0) {
                    RendezvousPanel.this.mAdd.setEnabled(true);
                } else {
                    RendezvousPanel.this.mAdd.setEnabled(false);
                }
            }
            catch (NullPointerException nullPointerException) {
                RendezvousPanel.this.mAdd.setEnabled(false);
            }
        }

        /* synthetic */ 2() {
        }
    }

    public class RendezvousBrowserPanel
    extends JPanel {
        private JLabel mRendezvousNameLabel = null;
        private JLabel mFirstIPAddressLabel = null;
        private JLabel mSecondIPAddressLabel = null;
        private JLabel mIconLabel = null;
        private JList mList = null;
        private JScrollPane mScrollPane = null;
        private RendezvousListModel mModel = null;

        RendezvousBrowserPanel(String[] serviceTypes, String[] iconNames) {
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            constraints.fill = 2;
            constraints.anchor = 13;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.createListView(serviceTypes, iconNames), constraints);
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.createMoreInfoView(), constraints);
        }

        private JPanel createListView(String[] serviceTypes, String[] iconNames) {
            JPanel panel = GUIFactory.newPanel();
            this.mModel = new RendezvousListModel(serviceTypes, iconNames);
            this.mList = new JList(this.mModel);
            this.mList.setSelectionMode(2);
            this.mList.setCellRenderer(new RendezvousListCellRenderer());
            this.mScrollPane = new JScrollPane(this.mList);
            this.mScrollPane.setMinimumSize(new Dimension(DEFAULT_DIMENSIONS));
            this.mScrollPane.setPreferredSize(new Dimension(DEFAULT_DIMENSIONS));
            this.mList.addMouseListener(new 3(this));
            panel.add(this.mScrollPane);
            return panel;
        }

        public void requestFocus() {
            this.mList.requestFocus();
        }

        public void startRendezvousServices(String[] services) {
            this.mModel.startRendezvousServices(services);
        }

        public void stopRendezvousServices() {
            this.mModel.stopRendezvousServices();
        }

        private JPanel createMoreInfoView() {
            return new MoreInfoPanel();
        }

        public void addListSelectionListener(ListSelectionListener l) {
            this.mList.addListSelectionListener(l);
        }

        public void removeListSelectionListener(ListSelectionListener l) {
            this.mList.removeListSelectionListener(l);
        }

        private class MoreInfoPanel
        extends JPanel
        implements ListSelectionListener {
            MoreInfoPanel() {
                GridBagConstraints constraints = new GridBagConstraints();
                this.setBorder(new EmptyBorder(12, 12, 12, 12));
                this.setMinimumSize(new Dimension(DEFAULT_DIMENSIONS));
                this.setPreferredSize(new Dimension(DEFAULT_DIMENSIONS));
                this.setLayout(new GridBagLayout());
                constraints.fill = 0;
                constraints.anchor = 10;
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 1.0;
                RendezvousBrowserPanel.this.mIconLabel = new JLabel();
                this.add((Component)RendezvousBrowserPanel.this.mIconLabel, constraints);
                constraints.fill = 0;
                constraints.anchor = 10;
                constraints.gridx = 0;
                constraints.gridy = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mRendezvousNameLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mRendezvousNameLabel, constraints);
                constraints.fill = 0;
                constraints.anchor = 10;
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mFirstIPAddressLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mFirstIPAddressLabel, constraints);
                constraints.fill = 0;
                constraints.anchor = 10;
                constraints.gridx = 0;
                constraints.gridy = 3;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 0.0;
                constraints.insets = new Insets(0, 0, 2, 0);
                RendezvousBrowserPanel.this.mSecondIPAddressLabel = new JLabel("");
                this.add((Component)RendezvousBrowserPanel.this.mSecondIPAddressLabel, constraints);
                RendezvousBrowserPanel.this.addListSelectionListener(this);
            }

            public void paint(Graphics g) {
                g.setColor(TOP_BORDER_COLOR);
                g.drawLine(0, 3, this.getWidth() - 1, 3);
                g.setColor(SIDE_BORDER_COLOR);
                g.drawLine(0, 4, this.getWidth() - 1, 4);
                g.setColor(SIDE_BORDER_COLOR);
                g.drawLine(0, 4, 0, this.getHeight() - 3);
                g.drawLine(this.getWidth() - 1, 4, this.getWidth() - 1, this.getHeight() - 3);
                g.setColor(BOTTOM_BORDER_COLOR);
                g.drawLine(0, this.getHeight() - 3, this.getWidth() - 1, this.getHeight() - 3);
                g.setColor(BOX_COLOR);
                g.fillRect(1, 5, this.getWidth() - 2, this.getHeight() - 8);
                this.paintChildren(g);
            }

            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource() instanceof JList) {
                    JList list = (JList)e.getSource();
                    Object[] selectedItems = list.getSelectedValues();
                    int count = selectedItems.length;
                    if (count == 1) {
                        RendezvousListItem selectedItem = (RendezvousListItem)selectedItems[0];
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText(selectedItem.getName());
                        if (selectedItem.getAddress() != null && selectedItem.getAddress() != "") {
                            RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(selectedItem.getAddress());
                        } else {
                            RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(" ");
                        }
                        if (selectedItem.getSecondAddress() != null && selectedItem.getSecondAddress() != "") {
                            RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(selectedItem.getSecondAddress());
                        } else {
                            RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(" ");
                        }
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(selectedItem.getIcon128());
                    } else if (count > 1) {
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(new ImageIcon(Resources.getImage("icon.multiple")));
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText(Resources.getString("rendezvousPanel.multipleSelection"));
                        RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText(" ");
                        RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText(" ");
                    } else {
                        RendezvousBrowserPanel.this.mRendezvousNameLabel.setText("");
                        RendezvousBrowserPanel.this.mFirstIPAddressLabel.setText("");
                        RendezvousBrowserPanel.this.mSecondIPAddressLabel.setText("");
                        RendezvousBrowserPanel.this.mIconLabel.setIcon(null);
                        list.clearSelection();
                    }
                }
            }
        }

        public class RendezvousListModel
        extends AbstractListModel
        implements BrowserListener {
            private SortedArrayList mSystems = new SortedArrayList();
            private SortedArrayList mVisibleSystems = new SortedArrayList();
            private Browser mBrowser = null;
            private HashMap mServiceIconMap = new HashMap();

            RendezvousListModel(String[] serviceTypes, String[] iconNames) {
                this.mBrowser = new Browser(this);
                int i = 0;
                while (i < serviceTypes.length) {
                    this.mServiceIconMap.put(serviceTypes[i], iconNames[i]);
                    ++i;
                }
            }

            public void startRendezvousServices(String[] services) {
                String[] serviceTypes = services;
                try {
                    int i = 0;
                    while (i < serviceTypes.length) {
                        this.mBrowser.startServiceSearch(serviceTypes[i], null);
                        ++i;
                    }
                }
                catch (Exception exception) {}
            }

            public void stopRendezvousServices() {
                try {
                    this.mBrowser.stopServiceSearch();
                }
                catch (IOException iOException) {}
            }

            public void serviceAdded(Browser inBrowser, ServiceInfo inServiceInfo) {
            }

            private boolean shouldDisplayItem(RendezvousListItem item) {
                String compareString;
                ArrayList monitoredMACAddresses = RendezvousPanel.this.mMonitoredMacAddresses;
                ArrayList monitoredIPAddresses = RendezvousPanel.this.mMonitoredIPAddresses;
                boolean shouldDisplayListItem = true;
                if (monitoredMACAddresses != null) {
                    Iterator theMACIter = ((AbstractList)monitoredMACAddresses).iterator();
                    while (theMACIter.hasNext() && shouldDisplayListItem) {
                        compareString = (String)theMACIter.next();
                        if (!item.containsControllerWithMacAddress(compareString = compareString.replace(':', '-'))) continue;
                        shouldDisplayListItem = false;
                        break;
                    }
                }
                if (monitoredIPAddresses != null && shouldDisplayListItem) {
                    Iterator theIPIter = ((AbstractList)monitoredIPAddresses).iterator();
                    while (theIPIter.hasNext() && shouldDisplayListItem) {
                        compareString = (String)theIPIter.next();
                        if (!item.containsControllerWithIPAddress(compareString)) continue;
                        shouldDisplayListItem = false;
                        break;
                    }
                }
                int[] supportedProductIDs = RaidAdmin.getSupportedProductIds();
                boolean supported = false;
                int i = 0;
                while (i < supportedProductIDs.length) {
                    if (item.getProductID() == supportedProductIDs[i]) {
                        supported = true;
                        break;
                    }
                    ++i;
                }
                if (!supported) {
                    shouldDisplayListItem = false;
                }
                return shouldDisplayListItem;
            }

            private void addRecord(ServiceInfo inServiceInfo) {
                RendezvousPanel rendezvousPanel = RendezvousPanel.this;
                rendezvousPanel.getClass();
                ControllerRendezvousRecord newController = rendezvousPanel.new ControllerRendezvousRecord(inServiceInfo);
                String localString = ".local.";
                String type = new String(inServiceInfo.getType());
                type = type.substring(0, type.lastIndexOf(localString));
                String iconFamilyName = (String)this.mServiceIconMap.get(type);
                SortedArrayList sortedArrayList = this.mSystems;
                synchronized (sortedArrayList) {
                    int size = this.mSystems.size();
                    int index = 0;
                    while (index < size) {
                        RendezvousListItem item = (RendezvousListItem)this.mSystems.get(index);
                        if (!item.isFull() && item.containsCompanionOf(newController)) {
                            int i = this.mVisibleSystems.indexOf(item);
                            item.add(newController);
                            if (!this.shouldDisplayItem(item) && i != -1) {
                                SortedArrayList sortedArrayList2 = this.mVisibleSystems;
                                synchronized (sortedArrayList2) {
                                    this.mVisibleSystems.remove(item);
                                    this.intervalRemoved(i, i);
                                }
                            } else if (i != -1) {
                                this.contentsChanged(i, i);
                            }
                            Object var7_13 = null;
                            return;
                        }
                        ++index;
                    }
                    RendezvousPanel rendezvousPanel2 = RendezvousPanel.this;
                    rendezvousPanel2.getClass();
                    RendezvousListItem newItem = rendezvousPanel2.new RendezvousListItem(newController, iconFamilyName);
                    this.mSystems.add(newItem);
                    if (this.shouldDisplayItem(newItem)) {
                        SortedArrayList i = this.mVisibleSystems;
                        synchronized (i) {
                            this.mVisibleSystems.add(newItem);
                            int insertionPoint = this.mVisibleSystems.fastIndexOf(newItem);
                            this.intervalAdded(insertionPoint, insertionPoint);
                        }
                    }
                }
            }

            private void removeRecord(ControllerRendezvousRecord aRecord) {
                SortedArrayList sortedArrayList = this.mSystems;
                synchronized (sortedArrayList) {
                    int index = this.mSystems.size() - 1;
                    while (index >= 0) {
                        RendezvousListItem item = (RendezvousListItem)this.mSystems.get(index);
                        if (item.containsController(aRecord)) {
                            item.remove(aRecord);
                            if (!item.isEmpty()) break;
                            this.mSystems.remove(item);
                            int i = this.mVisibleSystems.indexOf(item);
                            if (i == -1) break;
                            SortedArrayList sortedArrayList2 = this.mVisibleSystems;
                            synchronized (sortedArrayList2) {
                                this.mVisibleSystems.remove(item);
                                this.intervalRemoved(i, i);
                                break;
                            }
                        }
                        --index;
                    }
                }
            }

            public void serviceRemoved(Browser inBrowser, ServiceInfo inServiceInfo) {
                ServiceInfo theServiceInfo = inServiceInfo;
                RendezvousPanel rendezvousPanel = RendezvousPanel.this;
                rendezvousPanel.getClass();
                ControllerRendezvousRecord aRecord = rendezvousPanel.new ControllerRendezvousRecord(theServiceInfo);
                SwingUtilities.invokeLater(new 4(aRecord, this));
            }

            public void serviceResolved(Browser inBrowser, ServiceInfo inServiceInfo) {
                ServiceInfo theServiceInfo = inServiceInfo;
                SwingUtilities.invokeLater(new 5(theServiceInfo, this));
            }

            public void contentsChanged(int index1, int index2) {
                this.fireContentsChanged(this, index1, index2);
            }

            public void intervalAdded(int index1, int index2) {
                this.fireIntervalAdded(this, index1, index2);
            }

            public void intervalRemoved(int index1, int index2) {
                this.fireIntervalRemoved(this, index1, index2);
            }

            public synchronized int getSize() {
                int theSize = 0;
                SortedArrayList sortedArrayList = this.mVisibleSystems;
                synchronized (sortedArrayList) {
                    theSize = this.mVisibleSystems.size();
                }
                return theSize;
            }

            public ImageIcon getIconForObject(Object obj) {
                RendezvousListItem item = null;
                ImageIcon icon = null;
                if (obj != null && obj instanceof RendezvousListItem) {
                    item = (RendezvousListItem)obj;
                    icon = item.getIcon128();
                }
                return icon;
            }

            public Object getElementAt(int index) {
                Comparable theObject = null;
                SortedArrayList sortedArrayList = this.mVisibleSystems;
                synchronized (sortedArrayList) {
                    theObject = this.mVisibleSystems.get(index);
                }
                return theObject;
            }

            static /* synthetic */ void access$0(RendezvousListModel $0, ControllerRendezvousRecord $1) {
                $0.removeRecord($1);
            }

            static /* synthetic */ void access$1(RendezvousListModel $0, ServiceInfo $1) {
                $0.addRecord($1);
            }
        }

        class RendezvousListCellRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RendezvousListItem item = (RendezvousListItem)value;
                this.setIcon(item.getIcon16());
                this.setText(item.getName());
                return retValue;
            }

            RendezvousListCellRenderer() {
            }
        }
    }

    private class ControllerRendezvousRecord {
        public static final int TOP = 0;
        public static final int BOTTOM = 1;
        public static final int UNDETERMINED = -1;
        private static final int TOP_CONTROLLER_MASK = 4096;
        private ServiceInfo serviceInfo;
        private String presentationName;
        private String presentationIP;
        private String presentationEthernet;
        private String companionIP;
        private String companionEthernet;
        private int topOrBottom;
        private int productID;

        public String getName() {
            return this.presentationName;
        }

        public String getIPAddress() {
            return this.presentationIP;
        }

        public String getEthernetAddress() {
            return this.presentationEthernet;
        }

        public String getOtherEthernetAddress() {
            return this.companionEthernet;
        }

        public int getLocation() {
            return this.topOrBottom;
        }

        public int getProductID() {
            return this.productID;
        }

        ControllerRendezvousRecord(ServiceInfo theServiceInfo) {
            AcpTextRecord record = null;
            this.serviceInfo = theServiceInfo;
            try {
                record = new AcpTextRecord(this.serviceInfo.getTextBytes());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (record != null) {
                this.presentationName = record.getPropertyString(AcpPropertyCode.SYS_PRESENTATION_NAME.fourCharCode());
                if (this.presentationName == null) {
                    this.presentationName = this.serviceInfo.getName();
                }
                if (this.presentationName == null) {
                    this.presentationName = Resources.getString("rendezvousPanel.unknownSystemName");
                }
                this.presentationIP = this.serviceInfo.getAddress();
                this.presentationEthernet = record.getPropertyString(AcpPropertyCode.LAN_MAC_ADDRESS.fourCharCode());
                this.companionIP = record.getCompanionPropertyString(AcpPropertyCode.LAN_IP_ADDRESS.fourCharCode());
                this.companionEthernet = record.getCompanionPropertyString(AcpPropertyCode.LAN_MAC_ADDRESS.fourCharCode());
                int flags = record.getPropertyInteger(AcpPropertyCode.SYS_FLAGS.fourCharCode(), 0);
                int companionflags = record.getCompanionPropertyInteger(AcpPropertyCode.SYS_FLAGS.fourCharCode(), 0);
                this.topOrBottom = (flags & 0x1000) != 0 ? 0 : ((companionflags & 0x1000) != 0 ? 1 : -1);
                this.productID = record.getPropertyInteger(AcpPropertyCode.SYS_APPLE_PRODUCT_ID.fourCharCode(), 0);
            }
        }

        public boolean isCompanionOf(ControllerRendezvousRecord aRecord) {
            boolean isCompanion = false;
            if (this.presentationEthernet != null && this.presentationEthernet.equals(aRecord.getOtherEthernetAddress())) {
                isCompanion = true;
            }
            if (this.companionEthernet != null && this.companionEthernet.equals(aRecord.getEthernetAddress())) {
                isCompanion = true;
            }
            return isCompanion;
        }

        public boolean equals(ControllerRendezvousRecord aRecord) {
            boolean isEqual = false;
            if (this.presentationEthernet != null && this.companionEthernet != null) {
                if (this.presentationEthernet.equals(aRecord.getEthernetAddress()) && this.companionEthernet.equals(aRecord.getOtherEthernetAddress())) {
                    isEqual = true;
                }
            } else if (this.presentationEthernet != null) {
                if (this.presentationEthernet.equals(aRecord.getEthernetAddress()) && aRecord.getOtherEthernetAddress() == null) {
                    isEqual = true;
                }
            } else if (this.companionEthernet != null) {
                if (this.companionEthernet.equals(aRecord.getOtherEthernetAddress()) && aRecord.getEthernetAddress() == null) {
                    isEqual = true;
                }
            } else if (this.presentationEthernet == null && this.companionEthernet == null && aRecord.getEthernetAddress() == null && aRecord.getOtherEthernetAddress() == null) {
                isEqual = true;
            }
            return isEqual;
        }
    }

    private class RendezvousListItem
    extends IconFamily
    implements Comparable {
        private ControllerRendezvousRecord mFirstDiscoveredRecord = null;
        private ControllerRendezvousRecord mSecondDiscoveredRecord = null;

        RendezvousListItem(ControllerRendezvousRecord aRecord, String baseIconName) {
            super(baseIconName);
            this.add(aRecord);
        }

        public void add(ControllerRendezvousRecord aRecord) {
            if (this.mFirstDiscoveredRecord == null) {
                this.mFirstDiscoveredRecord = aRecord;
            } else if (this.mSecondDiscoveredRecord == null) {
                if (this.mFirstDiscoveredRecord.getLocation() == 0 || this.mFirstDiscoveredRecord.getLocation() == -1) {
                    this.mSecondDiscoveredRecord = aRecord;
                } else {
                    this.mSecondDiscoveredRecord = this.mFirstDiscoveredRecord;
                    this.mFirstDiscoveredRecord = aRecord;
                }
            }
        }

        public void remove(ControllerRendezvousRecord aRecord) {
            if (this.mFirstDiscoveredRecord != null && aRecord.getEthernetAddress().equals(this.mFirstDiscoveredRecord.getEthernetAddress())) {
                this.mFirstDiscoveredRecord = this.mSecondDiscoveredRecord;
                this.mSecondDiscoveredRecord = null;
            } else if (this.mSecondDiscoveredRecord != null && aRecord.getEthernetAddress().equals(this.mSecondDiscoveredRecord.getEthernetAddress())) {
                this.mSecondDiscoveredRecord = null;
            }
        }

        public boolean isFull() {
            return this.mFirstDiscoveredRecord != null && this.mSecondDiscoveredRecord != null;
        }

        public boolean isEmpty() {
            return this.mFirstDiscoveredRecord == null && this.mSecondDiscoveredRecord == null;
        }

        public int compareTo(Object obj) {
            int compareValue = -1;
            if (!(obj instanceof RendezvousListItem)) {
                throw new ClassCastException("RendezvousListItems must only compared to other RendezvousListItems.");
            }
            RendezvousListItem rItem = (RendezvousListItem)obj;
            if (this.equals(rItem)) {
                compareValue = 0;
            } else if (this.mFirstDiscoveredRecord != null && (compareValue = this.mFirstDiscoveredRecord.getName().compareTo(rItem.getName())) == 0) {
                compareValue = -1;
            }
            return compareValue;
        }

        public boolean containsController(ControllerRendezvousRecord aRecord) {
            boolean containsController = false;
            if (this.mFirstDiscoveredRecord != null && this.mFirstDiscoveredRecord.equals(aRecord)) {
                containsController = true;
            }
            if (this.mSecondDiscoveredRecord != null && this.mSecondDiscoveredRecord.equals(aRecord)) {
                containsController = true;
            }
            return containsController;
        }

        public boolean containsCompanionOf(ControllerRendezvousRecord aRecord) {
            boolean containsCompanion = false;
            if (this.mFirstDiscoveredRecord != null && this.mFirstDiscoveredRecord.isCompanionOf(aRecord)) {
                containsCompanion = true;
            }
            if (this.mSecondDiscoveredRecord != null && this.mSecondDiscoveredRecord.isCompanionOf(aRecord)) {
                containsCompanion = true;
            }
            return containsCompanion;
        }

        public boolean containsControllerWithMacAddress(String macAddress) {
            boolean containsMACAddress = false;
            if (macAddress != null && (macAddress.equals(this.getEthernetAddress()) || macAddress.equals(this.getSecondEthernetAddress()))) {
                containsMACAddress = true;
            }
            return containsMACAddress;
        }

        public boolean containsControllerWithIPAddress(String ipAddress) {
            boolean containsIPAddress = false;
            if (ipAddress != null && (ipAddress.equals(this.getAddress()) || ipAddress.equals(this.getSecondAddress())) && !ipAddress.equals("")) {
                containsIPAddress = true;
            }
            return containsIPAddress;
        }

        public boolean equals(RendezvousListItem item) {
            boolean isEqual = false;
            if (this.mFirstDiscoveredRecord != null && this.mSecondDiscoveredRecord != null) {
                if (this.mFirstDiscoveredRecord.getEthernetAddress().equals(item.getEthernetAddress()) && this.mSecondDiscoveredRecord.getEthernetAddress().equals(item.getSecondEthernetAddress())) {
                    isEqual = true;
                }
            } else if (this.mFirstDiscoveredRecord != null) {
                if (this.mFirstDiscoveredRecord.getEthernetAddress().equals(item.getEthernetAddress()) && item.getSecondEthernetAddress() == null) {
                    isEqual = true;
                }
            } else if (this.mSecondDiscoveredRecord != null) {
                if (this.mSecondDiscoveredRecord.getEthernetAddress().equals(item.getSecondEthernetAddress()) && item.getEthernetAddress() == null) {
                    isEqual = true;
                }
            } else if (this.mFirstDiscoveredRecord == null && this.mSecondDiscoveredRecord == null && item.getEthernetAddress() == null && item.getSecondEthernetAddress() == null) {
                isEqual = true;
            }
            return isEqual;
        }

        public String getName() {
            return this.mFirstDiscoveredRecord.getName();
        }

        public String getAddress() {
            String address = "";
            if (this.mFirstDiscoveredRecord != null) {
                address = this.mFirstDiscoveredRecord.getIPAddress();
            }
            return address;
        }

        public String getSecondAddress() {
            String address = "";
            if (this.mSecondDiscoveredRecord != null) {
                address = this.mSecondDiscoveredRecord.getIPAddress();
            }
            return address;
        }

        public String getEthernetAddress() {
            String address = null;
            if (this.mFirstDiscoveredRecord != null) {
                address = this.mFirstDiscoveredRecord.getEthernetAddress();
            }
            return address;
        }

        public String getSecondEthernetAddress() {
            String address = null;
            if (this.mSecondDiscoveredRecord != null) {
                address = this.mSecondDiscoveredRecord.getEthernetAddress();
            }
            return address;
        }

        public int getProductID() {
            int id1 = 0;
            int id2 = 0;
            if (this.mFirstDiscoveredRecord != null) {
                id1 = this.mFirstDiscoveredRecord.getProductID();
            }
            if (this.mSecondDiscoveredRecord != null) {
                id2 = this.mSecondDiscoveredRecord.getProductID();
            }
            int id = id1 != 0 && id2 != 0 ? (id1 > id2 ? id1 : id2) : (id1 != 0 ? id1 : id2);
            return id;
        }
    }
}

