/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.CapacityConverter;
import com.apple.util.Gestalt;
import com.apple.util.StringUtilities;
import com.apple.xsr.Resources;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.som.SystemElement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SOMLocalizer {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;

    static String getStatusString(int status) {
        String string;
        switch (status) {
            case 0: {
                string = Resources.getString("componentStatus.ok");
                break;
            }
            case 1: {
                string = Resources.getString("componentStatus.warning");
                break;
            }
            case 2: {
                string = Resources.getString("componentStatus.failure");
                break;
            }
            case -1: {
                string = Resources.getString("componentStatus.unknown");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal status code (" + status + ")");
            }
        }
        return string;
    }

    static String getElementStatus(SystemElement element) {
        return SOMLocalizer.getStatusString(element.getStatus());
    }

    static String getElementName(SystemElement element) {
        String string;
        String name = null;
        if (element instanceof Battery) {
            name = Resources.getString("battery");
        } else if (element instanceof Disk) {
            name = Resources.getString("disk");
        } else if (element instanceof DiskSlot) {
            name = Resources.getString("diskSlot");
        } else if (element instanceof Fan) {
            name = Resources.getString("fan");
        } else if (element instanceof FibreChannelInterface) {
            name = Resources.getString("fibrechannelinterface");
        } else if (element instanceof NetworkInterface) {
            name = Resources.getString("networkinterface");
        } else if (element instanceof PowerSupply) {
            name = Resources.getString("powersupply");
        } else if (element instanceof RaidController) {
            name = Resources.getString("raidcontroller");
        } else if (element instanceof RaidSet) {
            name = Resources.getString("raidset");
        } else if (element instanceof RaidSystem) {
            name = Resources.getString("raidsystem");
        }
        if (name != null) {
            string = Resources.getString("som.name");
            string = StringUtilities.replaceAll(string, "{name}", name);
            string = StringUtilities.replaceAll(string, "{number}", String.valueOf(element.getId()));
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getBatteryChargeState(Battery b) {
        String string = b.isCharging() ? Resources.getString("battery.chargeState.charging") : Resources.getString("battery.chargeState.discharging");
        return string;
    }

    static String getBatteryCharge(Battery b) {
        String string = Resources.getString("som.percent");
        string = StringUtilities.replaceAll(string, "{number}", String.valueOf(b.getChargePercent()));
        return string;
    }

    static String getPowerSupplyStatus(PowerSupply p) {
        int status = p.getStatus();
        String string = status == 2 ? Resources.getString("som.power.warning") : SOMLocalizer.getStatusString(status);
        return string;
    }

    static String getDiskState(Disk d) {
        String string;
        switch (d.getState()) {
            case 1: {
                string = Resources.getString("disk.state.online");
                break;
            }
            case 0: {
                string = Resources.getString("disk.state.offline");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskType(Disk d) {
        String string;
        switch (d.getType()) {
            case 0: {
                string = Resources.getString("disk.memberType.spare");
                break;
            }
            case 1: {
                string = Resources.getString("disk.memberType.raidMember");
                break;
            }
            case 3: {
                string = Resources.getString("disk.memberType.jbod");
                break;
            }
            case 4: {
                string = Resources.getString("disk.memberType.orphan");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskOperation(Disk d) {
        String string;
        switch (d.getOperation()) {
            case 0: {
                string = Resources.getString("disk.operation.none");
                break;
            }
            case 1: {
                string = Resources.getString("disk.operation.rebuilding");
                break;
            }
            case 2: {
                string = Resources.getString("disk.operation.formatting");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskHandleState(Disk d) {
        String string;
        switch (d.getHandleState()) {
            case 0: {
                string = Resources.getString("disk.handleState.open");
                break;
            }
            case 1: {
                string = Resources.getString("disk.handleState.closed");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskCapacity(Disk d) {
        long capacity = d.getCapacityBytes();
        String string = Resources.getString("som.bytes");
        string = StringUtilities.replaceAll(string, "{number}", Long.toString(capacity));
        return string;
    }

    static String getDiskCapacityShort(Disk d) {
        String string;
        long capacity = d.getCapacityBytes();
        if (CapacityConverter.toTerabytes(capacity) > 1.0) {
            string = Resources.getString("som.terabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toTerabyteString(capacity));
        } else if (CapacityConverter.toGigabytes(capacity) > 1.0) {
            string = Resources.getString("som.gigabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toGigabyteString(capacity));
        } else {
            string = Resources.getString("som.megabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toMegabyteString(capacity));
        }
        return string;
    }

    static String getDiskPowerOnHoursShort(Disk d) {
        int powerOnHours = d.getPowerOnHours();
        String hours = powerOnHours == -1 ? Resources.getString("componentStatus.unknown") : Integer.toString(powerOnHours);
        return hours;
    }

    static String getDiskCacheState(Disk d) {
        int state = d.getCacheState();
        String string = state == 1 ? Resources.getString("som.enabled") : (state == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getFanStatus(Fan f) {
        int status = f.getStatus();
        String string = status == 2 ? Resources.getString("som.blower.warning") : SOMLocalizer.getStatusString(status);
        return string;
    }

    static String getFanRPM(Fan f) {
        String string;
        int speed = f.getRpm();
        if (speed != -1) {
            string = Resources.getString("som.rpm");
            string = StringUtilities.replaceAll(string, "{number}", String.valueOf(speed));
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getFCTopology(FibreChannelInterface fc) {
        String string;
        switch (fc.getTopology()) {
            case 0: {
                string = Resources.getString("fc.topology.ArbitratedLoop");
                break;
            }
            case 1: {
                string = Resources.getString("fc.topology.PointToPoint");
                break;
            }
            case 2: {
                String actual = null;
                switch (fc.getActualTopology()) {
                    case 0: {
                        actual = Resources.getString("fc.topology.ArbitratedLoop");
                        break;
                    }
                    case 1: {
                        actual = Resources.getString("fc.topology.PointToPoint");
                        break;
                    }
                }
                if (actual == null) {
                    string = Resources.getString("fc.topology.AutoDetect");
                    break;
                }
                string = Resources.getString("som.automatic");
                string = StringUtilities.replaceAll(string, "{actual}", actual);
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getFCSpeed(FibreChannelInterface fc) {
        String string;
        switch (fc.getSpeed()) {
            case 1: {
                string = Resources.getString("fc.speed.1GBPS");
                break;
            }
            case 2: {
                string = Resources.getString("fc.speed.2GBPS");
                break;
            }
            case 0: {
                String actual = null;
                switch (fc.getActualSpeed()) {
                    case 1: {
                        actual = Resources.getString("fc.speed.1GBPS");
                        break;
                    }
                    case 2: {
                        actual = Resources.getString("fc.speed.2GBPS");
                        break;
                    }
                }
                if (actual == null) {
                    string = Resources.getString("fc.speed.AutoDetect");
                    break;
                }
                string = Resources.getString("som.automatic");
                string = StringUtilities.replaceAll(string, "{actual}", actual);
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getFCHardLoopEnabled(FibreChannelInterface fc) {
        int state = fc.getHardLoopIdEnabled();
        String string = state == 1 ? new Integer(fc.getHardLoopId()).toString() : (state == 0 ? Resources.getString("fc.hardLoopDisabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getFCLinkState(FibreChannelInterface fc) {
        String string;
        switch (fc.getLinkState()) {
            case 1: {
                string = Resources.getString("fc.linkStatus.up");
                break;
            }
            case 0: {
                if (fc.getStatus() == 2) {
                    Collection sets;
                    int arrays = 0;
                    RaidController controller = fc.getController();
                    if (controller != null && (sets = controller.getRaidSets()) != null) {
                        arrays = sets.size();
                    }
                    if (arrays == 1) {
                        string = Resources.getString("fc.linkStatus.down.array");
                        break;
                    }
                    string = Resources.getString("fc.linkStatus.down.arrays");
                    string = StringUtilities.replaceAll(string, "{number}", String.valueOf(arrays));
                    break;
                }
                string = Resources.getString("fc.linkStatus.down");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getLunMaskingState(int i) {
        String enabled = i == 1 ? Resources.getString("som.enabled") : (i == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return enabled;
    }

    static String getNetworkLinkState(NetworkInterface n) {
        String string;
        switch (n.getLinkState()) {
            case 1: {
                string = Resources.getString("network.linkStatus.up");
                break;
            }
            case 0: {
                string = Resources.getString("network.linkStatus.down");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getNetworkSpeed(NetworkInterface n) {
        String string;
        switch (n.getSpeed()) {
            case 0: {
                string = Resources.getString("network.speed.10mbps");
                break;
            }
            case 1: {
                string = Resources.getString("network.speed.100mbps");
                break;
            }
            case 2: {
                string = Resources.getString("network.speed.1000mbps");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getConfigurationMethod(NetworkInterface n) {
        String string;
        switch (n.getConfigurationMethod()) {
            case 512: {
                string = Resources.getString("network.configMethod.DHCP");
                break;
            }
            case 1024: {
                string = Resources.getString("network.configMethod.static");
                break;
            }
            case 8192: {
                string = Resources.getString("network.configMethod.BOOTP");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidControllerCacheState(RaidController rc) {
        int state = rc.getWriteCacheState();
        String string = state == 1 ? Resources.getString("som.enabled") : (state == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getRaidControllerPrefetchSetting(RaidController rc) {
        int prefetchSetting = rc.getPrefetchSize();
        String string = prefetchSetting == -1 ? Resources.getString("som.unknown") : ((prefetchSetting = 1 << prefetchSetting) < 8 ? Resources.getString("management.performance.prefetch.1") : (prefetchSetting == 8 ? Resources.getString("management.performance.prefetch.8") : Resources.getString("management.performance.prefetch.128")));
        return string;
    }

    static String getRaidControllerAccessMode(RaidController rc) {
        String string;
        switch (rc.getAccessMode()) {
            case 0: {
                string = Resources.getString("raidcontroller.accessMode.sequential");
                break;
            }
            case 1: {
                string = Resources.getString("raidcontroller.accessMode.random");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidControllerMemorySize(RaidController rc) {
        String string;
        int size = rc.getMemorySize();
        if (size != -1) {
            string = Resources.getString("som.megabytes");
            string = StringUtilities.replaceAll(string, "{number}", String.valueOf(size));
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSetState(RaidSet rs) {
        String string;
        switch (rs.getState()) {
            case 0: {
                string = Resources.getString("raidset.state.online");
                break;
            }
            case 1: {
                string = Resources.getString("raidset.state.offline");
                break;
            }
            case 2: {
                string = Resources.getString("raidset.state.degraded");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetAvailability(RaidSet rs) {
        String string = null;
        if (rs.getOperation() == 1) {
            switch (rs.getInitializationMode()) {
                case 1: {
                    string = Resources.getString("som.yes");
                    break;
                }
                case 0: {
                    string = Resources.getString("som.no");
                    break;
                }
            }
        }
        if (string == null) {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSetLevel(RaidSet rs) {
        String string;
        switch (rs.getRaidLevel()) {
            case 0: {
                string = Resources.getString("som.raidset.raid0");
                break;
            }
            case 1: {
                string = Resources.getString("som.raidset.raid1");
                break;
            }
            case 3: {
                string = Resources.getString("som.raidset.raid3");
                break;
            }
            case 5: {
                string = Resources.getString("som.raidset.raid5");
                break;
            }
            case 6: {
                string = Resources.getString("som.raidset.raid01");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetCapacity(RaidSet rs) {
        String string;
        long capacity = rs.getCapacityBytes();
        if (CapacityConverter.toTerabytes(capacity) > 1.0) {
            string = Resources.getString("som.terabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toTerabyteString(capacity));
        } else {
            string = Resources.getString("som.gigabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toGigabyteString(capacity));
        }
        return string;
    }

    static String getRaidSetSlices(RaidSet rs) {
        String string = String.valueOf(rs.getLiveSliceCount());
        return string;
    }

    static String getRaidSetLuns(RaidSet rs) {
        String string = "";
        String separator = Resources.getString("som.raidset.driveSeparator");
        Collection mappedSlices = rs.getMappedSlices();
        if (mappedSlices.size() > 0) {
            Iterator iter = mappedSlices.iterator();
            while (iter.hasNext()) {
                Slice s = (Slice)iter.next();
                string = String.valueOf(string) + "" + s.getLunId();
                if (!iter.hasNext()) continue;
                string = String.valueOf(string) + separator;
            }
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getJbodLuns(RaidController controller) {
        String s = "";
        String separator = Resources.getString("som.raidset.driveSeparator");
        if (controller != null) {
            int diskCount = controller.getDisks().size();
            int i = 0;
            while (i < diskCount) {
                s = String.valueOf(s) + i + (i < diskCount - 1 ? separator : "");
                ++i;
            }
        }
        return s;
    }

    static String getRaidSetDateCreated(RaidSet rs) {
        DateFormat formatter = DateFormat.getInstance();
        String string = formatter.format(rs.getTimeStamp());
        return string;
    }

    static String getRaidSetLevelAndCapacity(RaidSet rs) {
        String string = Resources.getString("som.raidset.levelCapacity");
        string = StringUtilities.replaceAll(string, "{level}", SOMLocalizer.getRaidSetLevel(rs));
        string = StringUtilities.replaceAll(string, "{capacity}", SOMLocalizer.getRaidSetCapacity(rs));
        return string;
    }

    static String getRaidSetLevelAndDrives(RaidSet rs) {
        String string = Resources.getString("som.raidset.levelDrives");
        string = StringUtilities.replaceAll(string, "{level}", SOMLocalizer.getRaidSetLevel(rs));
        string = StringUtilities.replaceAll(string, "{drives}", SOMLocalizer.getRaidSetDrives(rs));
        return string;
    }

    static String getRaidSetDrives(RaidSet rs) {
        String string = "";
        String separator = Resources.getString("som.raidset.driveSeparator");
        int lowestId = 0;
        int highestId = 0;
        int members = 0;
        Iterator iter = rs.getMembers().iterator();
        while (iter.hasNext()) {
            int id = ((Disk)iter.next()).getId();
            if (lowestId == 0 || id < lowestId) {
                lowestId = id;
            }
            if (id > highestId) {
                highestId = id;
            }
            ++members;
            string = String.valueOf(string) + id;
            if (!iter.hasNext()) continue;
            string = String.valueOf(string) + separator;
        }
        if (members > 1 && members == highestId - lowestId + 1) {
            string = Resources.getString("som.raidset.driveRange");
            string = StringUtilities.replaceAll(string, "{start}", String.valueOf(lowestId));
            string = StringUtilities.replaceAll(string, "{end}", String.valueOf(highestId));
        }
        return string;
    }

    static String getRaidSetOperationStatus(RaidSet rs) {
        String string;
        int operation = rs.getOperation();
        if (operation == -1) {
            string = SOMLocalizer.getRaidSetState(rs);
        } else {
            if (operation == 5 && rs.getBackgroundConditioningState() == 1) {
                string = Resources.getString("som.raidset.status.stateful");
                string = StringUtilities.replaceAll(string, "{state}", Resources.getString("raidset.conditioningState.paused"));
            } else {
                string = Resources.getString("som.raidset.status");
            }
            string = StringUtilities.replaceAll(string, "{operation}", SOMLocalizer.getRaidSetOperation(rs));
            string = StringUtilities.replaceAll(string, "{number}", String.valueOf(rs.getProgress()));
        }
        return string;
    }

    static String getRaidSetOperation(RaidSet rs) {
        String string;
        switch (rs.getOperation()) {
            case 1: {
                string = Resources.getString("raidset.operation.creating");
                break;
            }
            case 2: {
                string = Resources.getString("raidset.operation.rebuilding");
                break;
            }
            case 3: {
                string = Resources.getString("raidset.operation.verifying");
                break;
            }
            case 4: {
                string = Resources.getString("raidset.operation.expanding");
                break;
            }
            case 5: {
                string = Resources.getString("raidset.operation.conditioning");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetInitializationMode(RaidSet rs) {
        String string;
        switch (rs.getInitializationMode()) {
            case 0: {
                string = Resources.getString("raidset.initMode.regular");
                break;
            }
            case 1: {
                string = Resources.getString("raidset.initMode.onTheFly");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getSliceName(Slice s) {
        String string;
        if (s.isMapped()) {
            string = Resources.getString("som.slice.name");
            string = StringUtilities.replaceAll(string, "{index}", String.valueOf(s.getLunId()));
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getSliceDescription(Slice s) {
        String string = Resources.getString("som.slice.description");
        string = StringUtilities.replaceAll(string, "{slice}", String.valueOf(s.getId()));
        string = StringUtilities.replaceAll(string, "{array}", SOMLocalizer.getRaidSetLevelAndDrives(s.getRaidSet()));
        return string;
    }

    static String getCombinedFirmwareVersion(SystemController sc, RaidController rc) {
        String string;
        String rcVersion;
        boolean scKnown = true;
        boolean rcKnown = true;
        String scVersion = sc.getSystemVersion();
        if (scVersion == null || scVersion == "") {
            scKnown = false;
            scVersion = Resources.getString("som.unknown");
        }
        if ((rcVersion = rc.getFirmwareVersion()) == null || rcVersion == "") {
            rcKnown = false;
            rcVersion = Resources.getString("som.unknown");
        }
        if (!scKnown && !rcKnown) {
            string = scVersion;
        } else {
            string = Resources.getString("som.firmware");
            string = StringUtilities.replaceAll(string, "{system}", scVersion);
            string = StringUtilities.replaceAll(string, "{raid}", rcVersion);
        }
        return string;
    }

    static String getPowerState(RaidSystem rs) {
        String string;
        int upsStatus = rs.getUpsStatus();
        if (upsStatus == 0) {
            string = Resources.getString("raidsystem.powerState.upsBackup");
        } else if (upsStatus == 1) {
            string = Resources.getString("raidsystem.powerState.upsBatteryLow");
        } else {
            switch (rs.getPowerState()) {
                case 0: {
                    string = Resources.getString("raidsystem.powerState.off");
                    break;
                }
                case 1: {
                    string = Resources.getString("raidsystem.powerState.on");
                    break;
                }
                default: {
                    string = Resources.getString("som.unknown");
                    break;
                }
            }
        }
        return string;
    }

    static String getRaidSystemServiceIdState(RaidSystem rs) {
        String string;
        switch (rs.getServiceIdState()) {
            case 1: {
                string = Resources.getString("raidsystem.serviceID.on");
                break;
            }
            case 0: {
                string = Resources.getString("raidsystem.serviceID.off");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSystemLockState(RaidSystem rs) {
        String string;
        switch (rs.getLockState()) {
            case 1: {
                string = Resources.getString("raidsystem.lockState.locked");
                break;
            }
            case 0: {
                string = Resources.getString("raidsystem.lockState.unlocked");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSystemUptime(SystemController controller) {
        String string;
        int uptime = controller.getUpTime();
        if (uptime <= 0) {
            string = Resources.getString("som.unknown");
        } else {
            int days = uptime / 86400;
            int hours = uptime / 3600;
            int minutes = uptime / 60;
            if (days > 0) {
                minutes -= days * 24 * 60;
                string = Resources.getString("som.uptime.dhm");
                string = StringUtilities.replaceAll(string, "{days}", String.valueOf(days));
                string = StringUtilities.replaceAll(string, "{hours}", String.valueOf(hours));
                string = StringUtilities.replaceAll(string, "{minutes}", String.valueOf(minutes -= (hours -= days * 24) * 60));
            } else if (hours > 0) {
                string = Resources.getString("som.uptime.hm");
                string = StringUtilities.replaceAll(string, "{hours}", String.valueOf(hours));
                string = StringUtilities.replaceAll(string, "{minutes}", String.valueOf(minutes -= hours * 60));
            } else {
                string = Resources.getString("som.uptime.m");
                string = StringUtilities.replaceAll(string, "{minutes}", String.valueOf(minutes));
            }
        }
        return string;
    }

    static String getRaidSystemAmbientTemperature(SystemController sc) {
        String string;
        int temp = sc.getAmbientTemperature();
        if (temp != -1) {
            if (Gestalt.units == 0) {
                string = Resources.getString("som.celsius");
                string = StringUtilities.replaceAll(string, "{celsius}", String.valueOf(temp));
            } else if (Gestalt.units == 1) {
                string = Resources.getString("som.fahrenheit");
                string = StringUtilities.replaceAll(string, "{fahrenheit}", String.valueOf((int)((double)temp / 5.0 * 9.0 + 32.0)));
            } else {
                string = Resources.getString("som.celsiusAndFahrenheit");
                string = StringUtilities.replaceAll(string, "{celsius}", String.valueOf(temp));
                string = StringUtilities.replaceAll(string, "{fahrenheit}", String.valueOf((int)((double)temp / 5.0 * 9.0 + 32.0)));
            }
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSystemUPSStatus(RaidSystem rs) {
        String string;
        switch (rs.getUpsStatus()) {
            case 0: {
                string = Resources.getString("raidsystem.ups.powerFailure");
                break;
            }
            case 1: {
                string = Resources.getString("raidsystem.ups.lowBattery");
                break;
            }
            case 2: {
                string = Resources.getString("raidsystem.ups.shutdown");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getLocalizedUserMessage(int messageIndex) {
        String localizedString = "";
        switch (messageIndex) {
            case 0: {
                localizedString = "";
                break;
            }
            case 1: {
                localizedString = Resources.getString("userMessage.authenticating");
                break;
            }
            case 2: {
                localizedString = Resources.getString("userMessage.connecting");
                break;
            }
            case 3: {
                localizedString = Resources.getString("userMessage.gathering");
                break;
            }
            case 4: {
                localizedString = Resources.getString("userMessage.connectionFailure");
                break;
            }
            case 5: {
                localizedString = Resources.getString("userMessage.communicationsError");
                break;
            }
            case 6: {
                localizedString = Resources.getString("userMessage.standbyPowerMode");
                break;
            }
            case 7: {
                localizedString = Resources.getString("userMessage.restarting");
                break;
            }
            case 8: {
                localizedString = Resources.getString("userMessage.shuttingDown");
                break;
            }
            case 9: {
                localizedString = Resources.getString("userMessage.poweringOn");
                break;
            }
            case 10: {
                localizedString = Resources.getString("userMessage.controllerNotReady");
                break;
            }
            case 11: {
                localizedString = Resources.getString("userMessage.authenticationFailure");
                break;
            }
            case 12: {
                localizedString = Resources.getString("userMessage.requestingUpdate");
                break;
            }
            case 13: {
                localizedString = Resources.getString("userMessage.clearingEventLog");
                break;
            }
        }
        return localizedString;
    }

    static String getGenericString(String string) {
        if (string == null || string.length() == 0 || string.trim().equals("")) {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static Map toPrefsContainer(RaidSystem rs) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        ArrayList<String> IPs = new ArrayList<String>();
        if (rs == null) {
            throw new NullPointerException("RaidSystem argument may not be null");
        }
        String string = rs.getPrimaryHostAddress();
        if (string != null) {
            IPs.add(string);
        }
        if ((string = rs.getSecondaryHostAddress()) != null) {
            IPs.add(string);
        }
        if (IPs.size() < 1) {
            throw new IllegalArgumentException("RaidSystem argument must have at least one valid IP address");
        }
        string = rs.getMonitoringPassword();
        if (string != null) {
            item.put("Attributes", string);
        }
        item.put("Rate", new Integer(rs.getPollDelay()));
        item.put("Name", rs.getName());
        item.put("IPAddress", IPs);
        return item;
    }
}

