/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

class SizeLinkedPanel
extends JPanel {
    public static final int LINK_WIDTH = 1;
    public static final int LINK_HEIGHT = 2;
    public static final int LINK_BOTH = 3;
    private Vector linkedPanels = new Vector();

    SizeLinkedPanel() {
        GUIFactory.configureComponentForPlatform(this);
    }

    public void linkPanel(SizeLinkedPanel inLinkedPanel) {
        this.linkPanel(inLinkedPanel, 3);
    }

    public void linkPanel(SizeLinkedPanel inLinkedPanel, int inLinkedDimensions) {
        if (inLinkedPanel != null) {
            this.linkedPanels.add(new LinkData(inLinkedPanel, inLinkedDimensions));
            inLinkedPanel.linkPanelNonRecursive(this, inLinkedDimensions);
        }
    }

    public void linkPanelNonRecursive(SizeLinkedPanel inLinkedPanel) {
        this.linkPanelNonRecursive(inLinkedPanel, 3);
    }

    public void linkPanelNonRecursive(SizeLinkedPanel inLinkedPanel, int inLinkedDimensions) {
        if (inLinkedPanel != null) {
            this.linkedPanels.add(new LinkData(inLinkedPanel, inLinkedDimensions));
        }
    }

    public void unlinkPanel(SizeLinkedPanel inLinkedPanel) {
        if (inLinkedPanel != null) {
            this.linkedPanels.remove(inLinkedPanel);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension ownPref = super.getPreferredSize();
        Enumeration e = this.linkedPanels.elements();
        while (e.hasMoreElements()) {
            LinkData ld = (LinkData)e.nextElement();
            Dimension linkedPref = ld.panel.getPreferredSizeFromSuper();
            if ((ld.linkedDimensions & 1) != 0 && linkedPref.width > ownPref.width) {
                ownPref.width = linkedPref.width;
            }
            if ((ld.linkedDimensions & 2) == 0 || linkedPref.height <= ownPref.height) continue;
            ownPref.height = linkedPref.height;
        }
        return ownPref;
    }

    public Dimension getPreferredSizeFromSuper() {
        return super.getPreferredSize();
    }

    private static class LinkData {
        final SizeLinkedPanel panel;
        final int linkedDimensions;

        public LinkData(SizeLinkedPanel panel) {
            this(panel, 3);
        }

        public LinkData(SizeLinkedPanel panel, int linkedDimensions) {
            this.panel = panel;
            this.linkedDimensions = linkedDimensions;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LinkData)) {
                return false;
            }
            LinkData ld = (LinkData)o;
            return ld.panel.equals(this.panel) && ld.linkedDimensions == this.linkedDimensions;
        }

        public int hashCode() {
            int result = 13;
            result = 37 * result + this.panel.hashCode();
            result = 37 * result + this.linkedDimensions;
            return result;
        }
    }
}

