/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class StandardAlertPanel
extends JPanel {
    private JButton theDefaultButton;
    private JButton theAlternateButton;
    private JButton theOtherButton;
    private static final int INTERBUTTON_SPACING = 12;

    public StandardAlertPanel(String message, String explanation, Image icon, String defaultButtonString, String alternateButtonString, String otherButtonString) throws NullPointerException {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        this.setLayout(layout);
        if (icon != null) {
            JLabel iconLabel = new JLabel(new ImageIcon(icon));
            this.addComponent(iconLabel, this, layout, constraints);
        } else {
            JLabel iconLabel = new JLabel();
        }
        JTextArea messageLabel = new JTextArea(message);
        messageLabel.setFont(GUIFactory.FONT_NORMAL_BOLD);
        messageLabel.setBackground(null);
        messageLabel.setHighlighter(null);
        messageLabel.setEditable(false);
        messageLabel.setLineWrap(true);
        messageLabel.setWrapStyleWord(true);
        messageLabel.setSize(300, 64);
        messageLabel.setMargin(new Insets(4, 14, 4, 4));
        messageLabel.setMinimumSize(new Dimension(300, 48));
        messageLabel.setMaximumSize(new Dimension(300, 200));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        this.addComponent(messageLabel, this, layout, constraints);
        JTextArea explanationLabel = new JTextArea(explanation);
        explanationLabel.setFont(GUIFactory.FONT_SMALL);
        explanationLabel.setBackground(null);
        explanationLabel.setHighlighter(null);
        explanationLabel.setEditable(false);
        explanationLabel.setLineWrap(true);
        explanationLabel.setWrapStyleWord(true);
        explanationLabel.setSize(300, 64);
        explanationLabel.setMargin(new Insets(4, 14, 14, 4));
        explanationLabel.setMinimumSize(new Dimension(300, 48));
        explanationLabel.setMaximumSize(new Dimension(300, 200));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        this.addComponent(explanationLabel, this, layout, constraints);
        Box buttonBox = Box.createHorizontalBox();
        if (otherButtonString != null) {
            this.theOtherButton = GUIFactory.newButton(otherButtonString);
            buttonBox.add(this.theOtherButton);
        } else {
            this.theOtherButton = null;
        }
        buttonBox.add(Box.createHorizontalGlue());
        if (alternateButtonString != null) {
            this.theAlternateButton = GUIFactory.newButton(alternateButtonString);
            buttonBox.add(this.theAlternateButton);
            buttonBox.add(Box.createHorizontalStrut(12));
        } else {
            this.theAlternateButton = null;
        }
        if (defaultButtonString == null) {
            throw new NullPointerException("defaultButtonString cannot be null");
        }
        this.theDefaultButton = GUIFactory.newButton(defaultButtonString);
        this.theDefaultButton.setDefaultCapable(true);
        buttonBox.add(this.theDefaultButton);
        constraints.anchor = 13;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        this.addComponent(buttonBox, this, layout, constraints);
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public JButton getDefaultButton() {
        return this.theDefaultButton;
    }

    public JButton getAlternateButton() {
        return this.theAlternateButton;
    }

    public JButton getOtherButton() {
        return this.theOtherButton;
    }

    private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
        gbl.setConstraints(component, gbc);
        container.add(component);
    }
}

