/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.DriveSelectionPanel;
import com.apple.xsr.ModuleSelectionPanel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SelectableLabel;
import com.apple.xsr.SelectableStatusLabel;
import com.apple.xsr.SizeLinkedPanel;
import com.apple.xsr.SystemInfoPane;
import com.apple.xsr.eventlog.EventLogPane;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SystemInfoPane
extends JPanel {
    public static final int SUMMARY_TAB = 0;
    public static final int ARRAYS_DRIVES_TAB = 1;
    public static final int MODULES_TAB = 2;
    public static final int FIBRE_CHANNEL_TAB = 3;
    public static final int NETWORK_TAB = 4;
    public static final int EVENT_LOG_TAB = 5;
    public static final int COLUMN_WIDTH = 250;
    public static final int COMBO_LABEL_WIDTH = 64;
    public static final int COMBO_WIDTH = 150;
    private static final Border TAB_BORDER = new EmptyBorder(10, 10, 0, 10);
    private JTabbedPane tabbedPane;
    private InfoPanel infoPanel;
    private ComponentsPanel componentsPanel;
    private ArrayDrivePanel arraysAndDrivesPanel;
    private FibreChannelPanel fibreChannelPanel;
    private NetworkPanel networkPanel;
    private EventLogPane eventPanel;

    public SystemInfoPane() {
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(GUIFactory.FONT_SMALL);
        this.infoPanel = new InfoPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.summary"), this.infoPanel);
        this.arraysAndDrivesPanel = new ArrayDrivePanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.arraysAndDrives"), this.arraysAndDrivesPanel);
        this.componentsPanel = new ComponentsPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.modules"), this.componentsPanel);
        this.fibreChannelPanel = new FibreChannelPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.fibreChannel"), this.fibreChannelPanel);
        this.networkPanel = new NetworkPanel();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.network"), this.networkPanel);
        this.eventPanel = new EventLogPane();
        this.tabbedPane.addTab(Resources.getString("systemInfo.tab.events"), this.eventPanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    public void setSelectedTab(int tab) {
        if (tab < 0 || tab >= this.tabbedPane.getTabCount()) {
            throw new IllegalArgumentException("Illegal tab: " + tab);
        }
        this.tabbedPane.setSelectedIndex(tab);
    }

    public void setSystem(RaidSystem system) {
        this.infoPanel.updateInfo(system);
        if (system != null && system.getPowerState() == 1) {
            this.componentsPanel.updateInfo(system);
            this.arraysAndDrivesPanel.updateInfo(system);
            this.fibreChannelPanel.updateInfo(system);
            this.networkPanel.updateInfo(system);
            this.eventPanel.updateInfo(system);
        } else {
            this.componentsPanel.updateInfo(null);
            this.arraysAndDrivesPanel.updateInfo(null);
            this.fibreChannelPanel.updateInfo(null);
            this.networkPanel.updateInfo(null);
            this.eventPanel.updateInfo(null);
        }
    }

    public void updateInfo(RaidSystem system) {
        SwingUtilities.invokeLater(new 1(system, this));
    }

    private static final class 1
    implements Runnable {
        private final /* synthetic */ RaidSystem val$system;
        private final /* synthetic */ SystemInfoPane this$0;

        public void run() {
            this.this$0.setSystem(this.val$system);
        }

        /* synthetic */ 1(RaidSystem val$system, SystemInfoPane this$0) {
            this.val$system = val$system;
            this.this$0 = this$0;
        }
    }

    private static class InfoPanel
    extends JPanel {
        private static final int NUM_MODULES = 2;
        private final SelectableLabel name;
        private final SelectableLabel location;
        private final SelectableLabel contact;
        private final SelectableStatusLabel serviceID;
        private final SelectableLabel powerState;
        private final SelectableLabel keyLockStatus;
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] uptime;
        private final SelectableLabel[] serialNumber;
        private final SelectableLabel[] ambientTemp;
        private final SelectableLabel[] writeCache;
        private final SelectableLabel[] prefetchSize;
        private static final String unknown = Resources.noDataLabel();

        public InfoPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints constraints = new GridBagConstraints();
            int y = 0;
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            this.status = new SelectableStatusLabel[2];
            this.uptime = new SelectableLabel[2];
            this.serialNumber = new SelectableLabel[2];
            this.ambientTemp = new SelectableLabel[2];
            this.writeCache = new SelectableLabel[2];
            this.prefetchSize = new SelectableLabel[2];
            this.name = new SelectableLabel();
            this.location = new SelectableLabel();
            this.contact = new SelectableLabel();
            this.keyLockStatus = new SelectableLabel();
            this.serviceID = new SelectableStatusLabel();
            this.powerState = new SelectableLabel();
            JPanel systemInfoPanel = this.createSystemInfoPanel();
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = y++;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            this.add((Component)systemInfoPanel, constraints);
            SizeLinkedPanel lastColumn = null;
            int i = 0;
            while (i < 2) {
                String title = i == 0 ? "systemInfo.summaryPanel.topController" : "systemInfo.summaryPanel.bottomController";
                SizeLinkedColumn column = new SizeLinkedColumn(" " + Resources.getString(title) + " ");
                this.status[i] = new SelectableStatusLabel();
                this.uptime[i] = new SelectableLabel();
                column.addField(Resources.getString("systemInfo.summaryPanel.uptime"), this.uptime[i]);
                this.serialNumber[i] = new SelectableLabel();
                column.addField(Resources.getString("systemInfo.summaryPanel.serialNumber"), this.serialNumber[i]);
                this.ambientTemp[i] = new SelectableLabel();
                column.addField(Resources.getString("systemInfo.summaryPanel.ambientTemp"), this.ambientTemp[i]);
                this.writeCache[i] = new SelectableLabel();
                column.addField(Resources.getString("systemInfo.summaryPanel.writeCache"), this.writeCache[i]);
                this.prefetchSize[i] = new SelectableLabel();
                column.addField(Resources.getString("systemInfo.summaryPanel.prefetch"), this.prefetchSize[i]);
                if (i == 0) {
                    constraints.anchor = 17;
                    constraints.fill = 2;
                    constraints.insets = new Insets(12, 0, 0, 10);
                    constraints.weightx = 1.0;
                    constraints.gridx = 0;
                    constraints.gridy = y;
                    constraints.gridwidth = 1;
                    constraints.gridheight = 1;
                } else if (i == 1) {
                    constraints.anchor = 13;
                    constraints.fill = 2;
                    constraints.insets = new Insets(12, 0, 0, 0);
                    constraints.weightx = 1.0;
                    constraints.gridx = 1;
                    constraints.gridy = y;
                    constraints.gridwidth = 1;
                    constraints.gridheight = 1;
                }
                if (lastColumn != null) {
                    lastColumn.linkPanel(column);
                }
                this.add((Component)column, constraints);
                lastColumn = column;
                ++i;
            }
            ++y;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = ++y;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), constraints);
            this.updateInfo(null);
        }

        private JPanel createSystemInfoPanel() {
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel systemInfoPanel = GUIFactory.newPanel();
            JPanel systemInfoPanelLeft = GUIFactory.newPanel();
            JPanel systemInfoPanelRight = GUIFactory.newPanel();
            systemInfoPanel.setLayout(new GridLayout(1, 2));
            systemInfoPanelLeft.setLayout(new GridBagLayout());
            systemInfoPanelRight.setLayout(new GridBagLayout());
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            JLabel label = new JLabel(Resources.getString("systemInfo.summaryPanel.name"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.name.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)this.name, constraints);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            label = new JLabel(Resources.getString("systemInfo.summaryPanel.location"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.location.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)this.location, constraints);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            label = new JLabel(Resources.getString("systemInfo.summaryPanel.contact"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.contact.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelLeft.add((Component)this.contact, constraints);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            label = new JLabel(Resources.getString("systemInfo.summaryPanel.serviceId"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.serviceID.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)this.serviceID, constraints);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            label = new JLabel(Resources.getString("systemInfo.summaryPanel.powerState"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.powerState.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)this.powerState, constraints);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            label = new JLabel(Resources.getString("systemInfo.summaryPanel.lock"));
            label.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.keyLockStatus.setFont(GUIFactory.FONT_SMALL);
            systemInfoPanelRight.add((Component)this.keyLockStatus, constraints);
            systemInfoPanel.add(systemInfoPanelLeft);
            systemInfoPanel.add(systemInfoPanelRight);
            return systemInfoPanel;
        }

        public void addField(SelectableLabel item, String string, int row, int column) {
            JLabel label = new JLabel(string);
            GridBagConstraints constraints = new GridBagConstraints();
            item.setFont(GUIFactory.FONT_SMALL);
            label.setFont(GUIFactory.FONT_SMALL);
            constraints.anchor = 13;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 0, 12);
            constraints.weightx = 0.0;
            constraints.gridx = column;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)label, constraints);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.weightx = 0.0;
            constraints.gridx = column + 1;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)item, constraints);
        }

        public void updateInfo(RaidSystem system) {
            if (system != null) {
                boolean TOP = false;
                boolean BOTTOM = true;
                this.name.setText(system.getName());
                this.location.setText(SOMLocalizer.getGenericString(system.getLocation()));
                this.contact.setText(SOMLocalizer.getGenericString(system.getContact()));
                this.powerState.setText(SOMLocalizer.getPowerState(system));
                if (system.getPowerState() == 1) {
                    int moduleStatus;
                    RaidController rc;
                    SystemController sc;
                    this.serviceID.setStatus(system.getServiceIdState() == 1 ? 1 : -3);
                    this.serviceID.setText(SOMLocalizer.getRaidSystemServiceIdState(system));
                    this.keyLockStatus.setText(SOMLocalizer.getRaidSystemLockState(system));
                    if (system.isControllerModulePresent(1)) {
                        sc = system.getSystemController(1);
                        rc = system.getRaidController(1);
                        moduleStatus = system.getControllerModuleStatus(1);
                        this.status[0].setText(SOMLocalizer.getStatusString(moduleStatus));
                        this.status[0].setStatus(moduleStatus);
                        this.uptime[0].setText(SOMLocalizer.getRaidSystemUptime(sc));
                        this.serialNumber[0].setText(rc.getSerialNumber());
                        this.ambientTemp[0].setText(SOMLocalizer.getRaidSystemAmbientTemperature(sc));
                        this.writeCache[0].setText(SOMLocalizer.getRaidControllerCacheState(rc));
                        this.prefetchSize[0].setText(SOMLocalizer.getRaidControllerPrefetchSetting(rc));
                    } else {
                        this.defaultControllerModuleFields(0);
                    }
                    if (system.isControllerModulePresent(2)) {
                        sc = system.getSystemController(2);
                        rc = system.getRaidController(2);
                        moduleStatus = system.getControllerModuleStatus(2);
                        this.status[1].setText(SOMLocalizer.getStatusString(moduleStatus));
                        this.status[1].setStatus(moduleStatus);
                        this.uptime[1].setText(SOMLocalizer.getRaidSystemUptime(sc));
                        this.serialNumber[1].setText(rc.getSerialNumber());
                        this.ambientTemp[1].setText(SOMLocalizer.getRaidSystemAmbientTemperature(sc));
                        this.writeCache[1].setText(SOMLocalizer.getRaidControllerCacheState(rc));
                        this.prefetchSize[1].setText(SOMLocalizer.getRaidControllerPrefetchSetting(rc));
                    } else {
                        this.defaultControllerModuleFields(1);
                    }
                } else {
                    this.serviceID.setStatus(-1);
                    this.serviceID.setText(unknown);
                    this.keyLockStatus.setText(unknown);
                    int i = 0;
                    while (i < 2) {
                        this.defaultControllerModuleFields(i);
                        ++i;
                    }
                }
            } else {
                this.name.setText(unknown);
                this.location.setText(unknown);
                this.contact.setText(unknown);
                this.serviceID.setStatus(-1);
                this.serviceID.setText(unknown);
                this.powerState.setText(unknown);
                this.keyLockStatus.setText(unknown);
                int i = 0;
                while (i < 2) {
                    this.defaultControllerModuleFields(i);
                    ++i;
                }
            }
        }

        private void defaultControllerModuleFields(int index) {
            this.uptime[index].setText(unknown);
            this.serialNumber[index].setText(unknown);
            this.ambientTemp[index].setText(unknown);
            this.status[index].setText(unknown);
            this.status[index].setStatus(-3);
            this.writeCache[index].setText(unknown);
            this.prefetchSize[index].setText(unknown);
        }
    }

    private static class ArrayDrivePanel
    extends JPanel {
        private static final int MIN_HEIGHT = 224;
        private DriveSelectionPanel drivePanel;
        private ArraySelectionPanel arrayPanel;
        private JPanel infoPanel;
        private JPanel cardPanel;
        private CardLayout cardLayout;
        private JRadioButton arraysRadioButton;
        private JRadioButton drivesRadioButton;
        private SelectableStatusLabel arrayStatus;
        private SelectableLabel arrayLevel;
        private SelectableLabel arrayCapacity;
        private SelectableLabel arraySlices;
        private SelectableLabel arrayLUNs;
        private JLabel arrayProgressLabel;
        private JProgressBar arrayProgress;
        private JLabel arrayAvailableLabel;
        private SelectableLabel arrayAvailable;
        private MessagePanel messagePanel;
        private SelectableStatusLabel driveStatus;
        private SelectableLabel driveType;
        private SelectableLabel driveModel;
        private SelectableLabel driveFirmware;
        private SelectableLabel driveCapacity;
        private SelectableLabel drivePowerOnHours;
        private SelectableLabel driveCache;
        private int selectedArray = -1;
        private int selectedDrive = -1;
        private RaidSystem system;
        private static final String unknown = Resources.noDataLabel();
        private static final String notInstalled = Resources.getString("systemInfo.modulesPanel.notInstalled");

        public ArrayDrivePanel() {
            GUIFactory.configureComponentForPlatform(this);
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.anchor = 17;
            constraints.fill = 1;
            this.drivePanel = new DriveSelectionPanel(4, null, null, null, null);
            constraints.insets = new Insets(0, 10, 0, 20);
            this.add((Component)this.drivePanel, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            ++constraints.gridy;
            this.drivePanel.addPropertyChangeListener("DriveIndex", new 2(this));
            this.drivePanel.addPropertyChangeListener("ArrayIndex", new 3(this));
            this.drivePanel.addPropertyChangeListener("SelectionMode", new 4(this));
            this.arrayPanel = new ArraySelectionPanel(3);
            constraints.insets = new Insets(0, 10, 0, 20);
            this.add((Component)this.arrayPanel, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            ++constraints.gridy;
            this.arrayPanel.addPropertyChangeListener("ArrayIndex", new 5(this));
            constraints.weighty = 1.0;
            this.add(Box.createVerticalStrut(0), constraints);
            constraints.weighty = 0.0;
            ++constraints.gridx;
            constraints.gridy = 0;
            int COLUMN_WIDTH = 300;
            this.infoPanel = GUIFactory.newPanel();
            GridBagLayout infoLayout = new GridBagLayout();
            GridBagConstraints infoConstraints = new GridBagConstraints();
            this.infoPanel.setLayout(infoLayout);
            infoConstraints.gridx = 0;
            infoConstraints.gridy = 0;
            infoConstraints.gridheight = 1;
            infoConstraints.gridwidth = 1;
            infoConstraints.anchor = 17;
            infoConstraints.fill = 0;
            RadioButtonGroup radioGroup = new RadioButtonGroup();
            JPanel selectPanel = GUIFactory.newPanel();
            JLabel selectLabel = new JLabel(Resources.getString("systemInfo.drivePanel.show"));
            selectLabel.setFont(GUIFactory.FONT_SMALL);
            selectPanel.add(selectLabel);
            this.arraysRadioButton = GUIFactory.newRadioButton(Resources.getString("systemInfo.drivePanel.arrays"), true);
            this.arraysRadioButton.setFont(GUIFactory.FONT_SMALL);
            this.arraysRadioButton.addActionListener(new RadioGroupActionListener(0));
            radioGroup.add(this.arraysRadioButton);
            selectPanel.add(this.arraysRadioButton);
            this.drivesRadioButton = GUIFactory.newRadioButton(Resources.getString("systemInfo.drivePanel.drives"), false);
            this.drivesRadioButton.setFont(GUIFactory.FONT_SMALL);
            this.drivesRadioButton.addActionListener(new RadioGroupActionListener(1));
            radioGroup.add(this.drivesRadioButton);
            selectPanel.add(this.drivesRadioButton);
            this.infoPanel.add((Component)selectPanel, infoConstraints);
            ++infoConstraints.gridy;
            this.cardPanel = GUIFactory.newPanel();
            this.cardLayout = new CardLayout();
            this.cardPanel.setLayout(this.cardLayout);
            infoConstraints.weightx = 1.0;
            infoConstraints.fill = 2;
            this.infoPanel.add((Component)this.cardPanel, infoConstraints);
            infoConstraints.fill = 0;
            infoConstraints.weightx = 0.0;
            ++infoConstraints.gridy;
            String arrayTitle = Resources.getString("systemInfo.drivePanel.arrayInfo");
            SizeLinkedColumn arrayColumn = new SizeLinkedColumn(" " + arrayTitle + " ");
            this.arrayStatus = new SelectableStatusLabel();
            this.arrayLevel = new SelectableLabel();
            this.arrayCapacity = new SelectableLabel();
            this.arraySlices = new SelectableLabel();
            this.arrayLUNs = new SelectableLabel();
            this.arrayProgressLabel = new JLabel(Resources.getString("systemInfo.arrayPanel.progress"));
            this.arrayProgressLabel.setVisible(false);
            this.arrayProgress = new JProgressBar(0, 100);
            CompoundBorder progressBorder = BorderFactory.createCompoundBorder(new EmptyBorder(2, 0, 1, 0), this.arrayProgress.getBorder());
            this.arrayProgress.setBorder(progressBorder);
            this.arrayProgress.setVisible(false);
            this.arrayAvailableLabel = new JLabel(Resources.getString("systemInfo.arrayPanel.available"));
            this.arrayAvailable = new SelectableLabel();
            arrayColumn.addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.arrayStatus);
            arrayColumn.addLabeledComponent(this.arrayProgressLabel, (JComponent)this.arrayProgress);
            arrayColumn.addLabeledComponent(this.arrayAvailableLabel, (JComponent)this.arrayAvailable);
            arrayColumn.addField(Resources.getString("systemInfo.arrayPanel.raid_level"), this.arrayLevel);
            arrayColumn.addField(Resources.getString("systemInfo.arrayPanel.capacity"), this.arrayCapacity);
            arrayColumn.addField(Resources.getString("systemInfo.arrayPanel.slices"), this.arraySlices);
            arrayColumn.addField(Resources.getString("systemInfo.arrayPanel.lun"), this.arrayLUNs);
            this.messagePanel = new MessagePanel();
            this.messagePanel.setVisible(false);
            GridBagConstraints msgConstraints = new GridBagConstraints();
            msgConstraints.gridx = 0;
            msgConstraints.gridy = arrayColumn.getItemCount();
            msgConstraints.gridwidth = 2;
            msgConstraints.gridheight = 1;
            msgConstraints.weightx = 0.0;
            msgConstraints.weighty = 0.0;
            msgConstraints.anchor = 17;
            msgConstraints.fill = 0;
            msgConstraints.insets = new Insets(8, 0, 0, 0);
            msgConstraints.ipadx = 0;
            msgConstraints.ipady = 0;
            arrayColumn.add((Component)this.messagePanel, msgConstraints);
            arrayColumn.padRemainder();
            this.cardPanel.add((Component)arrayColumn, "arrays");
            String driveTitle = Resources.getString("systemInfo.drivePanel.driveInfo");
            SizeLinkedColumn driveColumn = new SizeLinkedColumn(" " + driveTitle + " ");
            this.driveStatus = new SelectableStatusLabel();
            this.driveType = new SelectableLabel();
            this.driveModel = new SelectableLabel();
            this.driveFirmware = new SelectableLabel();
            this.driveCapacity = new SelectableLabel();
            this.drivePowerOnHours = new SelectableLabel();
            this.driveCache = new SelectableLabel();
            driveColumn.addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.driveStatus);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.type"), this.driveType);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.model"), this.driveModel);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.revision"), this.driveFirmware);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.capacity"), this.driveCapacity);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.powerOnHours"), this.drivePowerOnHours);
            driveColumn.addField(Resources.getString("systemInfo.drivePanel.writeCache"), this.driveCache);
            driveColumn.padRemainder();
            this.cardPanel.add((Component)driveColumn, "drives");
            constraints.insets = new Insets(0, 10, 0, 0);
            constraints.gridheight = 3;
            constraints.weightx = 1.0;
            constraints.anchor = 18;
            constraints.fill = 2;
            this.add((Component)this.infoPanel, constraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem system) {
            if (system != null) {
                this.system = system;
                this.drivePanel.setRaidSystem(system);
                this.arrayPanel.configureForRaidSystem(system);
                this.refreshInfoForSelectedArray();
                this.refreshInfoForSelectedDrive();
            } else {
                this.system = null;
                this.drivePanel.setRaidSystem(null);
                this.arrayPanel.resetPanel();
                this.refreshInfoForSelectedArray();
                this.refreshInfoForSelectedDrive();
            }
        }

        public void refreshInfoForSelectedArray() {
            RaidSet[] raidsetArray = this.system != null ? this.system.getRaidSets().toArray(new RaidSet[0]) : null;
            if (raidsetArray != null && this.selectedArray + 1 > 0 && this.selectedArray < raidsetArray.length) {
                String statusLabel;
                RaidSet raidset = raidsetArray[this.selectedArray];
                boolean unmappedSlices = raidset.getMappedSlices().size() != raidset.getLiveSliceCount();
                int status = raidset.getStatus();
                if ((status == 0 || status == -1) && !this.system.isRaidSetBeingCreated(raidset) && unmappedSlices) {
                    status = 1;
                    statusLabel = SOMLocalizer.getStatusString(status);
                } else {
                    statusLabel = SOMLocalizer.getRaidSetOperationStatus(raidset);
                }
                this.arrayStatus.setStatus(status);
                this.arrayStatus.setText(statusLabel);
                int operation = raidset.getOperation();
                if (operation != -1) {
                    this.arrayProgress.setValue(raidset.getProgress());
                    this.arrayProgressLabel.setVisible(true);
                    this.arrayProgress.setVisible(true);
                    if (operation == 1) {
                        this.arrayAvailable.setText(SOMLocalizer.getRaidSetAvailability(raidset));
                        this.arrayAvailableLabel.setVisible(true);
                        this.arrayAvailable.setVisible(true);
                    } else {
                        this.arrayAvailable.setText(unknown);
                        this.arrayAvailableLabel.setVisible(false);
                        this.arrayAvailable.setVisible(false);
                    }
                } else {
                    this.arrayProgressLabel.setVisible(false);
                    this.arrayProgress.setVisible(false);
                    this.arrayProgress.setValue(0);
                    this.arrayAvailableLabel.setVisible(false);
                    this.arrayAvailable.setVisible(false);
                    this.arrayAvailable.setText(unknown);
                }
                this.arrayLevel.setText(SOMLocalizer.getRaidSetLevel(raidset));
                this.arrayCapacity.setText(SOMLocalizer.getRaidSetCapacity(raidset));
                this.arraySlices.setText(SOMLocalizer.getRaidSetSlices(raidset));
                this.arrayLUNs.setText(SOMLocalizer.getRaidSetLuns(raidset));
                if (raidset.getState() == 1) {
                    this.messagePanel.setText(Resources.getString("systemInfo.message.deleteOfflineArray"));
                    this.messagePanel.setVisible(true);
                } else if (unmappedSlices && !this.system.isRaidSetBeingCreated(raidset)) {
                    this.messagePanel.setText(Resources.getString("systemInfo.message.unmapped"));
                    this.messagePanel.setVisible(true);
                } else {
                    this.messagePanel.setVisible(false);
                }
            } else if (this.system != null && DriveSelectionPanel.isJbod(this.selectedArray + 1) && this.drivePanel.jbodExists(this.selectedArray + 1)) {
                this.arrayStatus.setStatus(0);
                this.arrayStatus.setText(Resources.getString("raidset.state.online"));
                this.arrayProgressLabel.setVisible(false);
                this.arrayProgress.setVisible(false);
                this.arrayAvailableLabel.setVisible(false);
                this.arrayAvailable.setVisible(false);
                this.arrayLevel.setText(Resources.getString("management.create.jbod"));
                this.arrayCapacity.setText(Resources.getString("som.jbod.capacity"));
                this.arraySlices.setText(unknown);
                RaidController controller = this.system.getRaidController(this.selectedArray + 1 == -2 ? 1 : 2);
                this.arrayLUNs.setText(SOMLocalizer.getJbodLuns(controller));
                this.messagePanel.setVisible(false);
            } else {
                this.arrayStatus.setStatus(-3);
                this.arrayStatus.setText(unknown);
                this.arrayProgressLabel.setVisible(false);
                this.arrayProgress.setVisible(false);
                this.arrayAvailableLabel.setVisible(false);
                this.arrayAvailable.setVisible(false);
                this.arrayLevel.setText(unknown);
                this.arrayCapacity.setText(unknown);
                this.arraySlices.setText(unknown);
                this.arrayLUNs.setText(unknown);
                this.messagePanel.setVisible(false);
            }
        }

        public void refreshInfoForSelectedDrive() {
            DiskSlot[] slotsArray = this.system != null ? this.system.getDiskSlots().toArray(new DiskSlot[0]) : null;
            if (slotsArray != null && this.selectedDrive > -1 && this.selectedDrive < slotsArray.length) {
                DiskSlot slot = slotsArray[this.selectedDrive];
                if (slot.isPopulated()) {
                    Disk disk = slot.getDisk();
                    int status = disk.getType() != 4 ? disk.getStatus() : 1;
                    this.driveStatus.setStatus(status);
                    this.driveStatus.setText(SOMLocalizer.getStatusString(status));
                    this.driveType.setText(SOMLocalizer.getDiskType(disk));
                    this.driveModel.setText(disk.getModel().trim());
                    this.driveFirmware.setText(disk.getRevision());
                    this.driveCapacity.setText(SOMLocalizer.getDiskCapacityShort(disk));
                    this.drivePowerOnHours.setText(SOMLocalizer.getDiskPowerOnHoursShort(disk));
                    this.driveCache.setText(SOMLocalizer.getDiskCacheState(disk));
                } else {
                    this.driveStatus.setStatus(-2);
                    this.driveStatus.setText(notInstalled);
                    this.driveType.setText(unknown);
                    this.driveModel.setText(unknown);
                    this.driveFirmware.setText(unknown);
                    this.driveCapacity.setText(unknown);
                    this.drivePowerOnHours.setText(unknown);
                    this.driveCache.setText(unknown);
                }
            } else {
                this.driveStatus.setStatus(-3);
                this.driveStatus.setText(unknown);
                this.driveType.setText(unknown);
                this.driveModel.setText(unknown);
                this.driveFirmware.setText(unknown);
                this.driveCapacity.setText(unknown);
                this.drivePowerOnHours.setText(unknown);
                this.driveCache.setText(unknown);
            }
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            return new Dimension(d.width, d.height < 224 ? 224 : d.height);
        }

        static /* synthetic */ int access$0(ArrayDrivePanel $0) {
            return $0.selectedDrive;
        }

        static /* synthetic */ void access$1(ArrayDrivePanel $0, int $1) {
            $0.selectedDrive = $1;
        }

        static /* synthetic */ int access$2(ArrayDrivePanel $0) {
            return $0.selectedArray;
        }

        static /* synthetic */ void access$3(ArrayDrivePanel $0, int $1) {
            $0.selectedArray = $1;
        }

        static /* synthetic */ JRadioButton access$4(ArrayDrivePanel $0) {
            return $0.arraysRadioButton;
        }

        static /* synthetic */ JRadioButton access$5(ArrayDrivePanel $0) {
            return $0.drivesRadioButton;
        }

        class RadioGroupActionListener
        implements ActionListener {
            int show;

            RadioGroupActionListener(int index) {
                this.show = index;
            }

            public void actionPerformed(ActionEvent e) {
                ArrayDrivePanel.this.drivePanel.setSelectionMode(this.show == 0 ? 4 : 3);
                ArrayDrivePanel.this.cardLayout.show(ArrayDrivePanel.this.cardPanel, this.show == 0 ? "arrays" : "drives");
            }
        }

        private static class MessagePanel
        extends JPanel {
            private JLabel icon;
            private JLabel label;

            public MessagePanel() {
                this.setLayout(new GridBagLayout());
                this.setOpaque(false);
                GridBagConstraints gbc = new GridBagConstraints();
                this.icon = new JLabel(new ImageIcon(Resources.getImage("icon.validate")));
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 10;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 0, 0, 5);
                gbc.ipadx = 0;
                gbc.ipady = 0;
                this.add((Component)this.icon, gbc);
                this.label = new JLabel();
                this.label.setFont(GUIFactory.FONT_SMALL);
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 17;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.ipadx = 0;
                gbc.ipady = 0;
                this.add((Component)this.label, gbc);
            }

            public void setText(String s) {
                this.label.setText(s);
            }
        }
    }

    private static class ComponentsPanel
    extends JPanel {
        private ModuleSelectionPanel modulePanel;
        private JPanel infoPanel;
        private CardLayout cardLayout;
        SizeLinkedColumn[] controllerColumn;
        SizeLinkedColumn[] batteryColumn;
        SizeLinkedColumn[] blowerColumn;
        SizeLinkedColumn[] powerColumn;
        private final SelectableStatusLabel[] controllerStatus;
        private final SelectableLabel[] controllerCache;
        private final SelectableLabel[] controllerFirmware;
        private final SelectableStatusLabel[] batteryStatus;
        private final SelectableLabel[] batteryChargeState;
        private final SelectableLabel[] batteryCharge;
        private final SelectableStatusLabel[] blowerStatus;
        private final SelectableLabel[] blowerSpeed;
        private final SelectableStatusLabel[] powerStatus;
        private static final String unknown = Resources.noDataLabel();
        private static final String notInstalled = Resources.getString("systemInfo.modulesPanel.notInstalled");
        private static final int CONTROLLER_COUNT = 2;

        public ComponentsPanel() {
            GUIFactory.configureComponentForPlatform(this);
            this.controllerColumn = new SizeLinkedColumn[2];
            this.batteryColumn = new SizeLinkedColumn[2];
            this.blowerColumn = new SizeLinkedColumn[2];
            this.powerColumn = new SizeLinkedColumn[2];
            this.batteryStatus = new SelectableStatusLabel[2];
            this.batteryChargeState = new SelectableLabel[2];
            this.batteryCharge = new SelectableLabel[2];
            this.controllerStatus = new SelectableStatusLabel[2];
            this.controllerCache = new SelectableLabel[2];
            this.controllerFirmware = new SelectableLabel[2];
            this.blowerStatus = new SelectableStatusLabel[2];
            this.blowerSpeed = new SelectableLabel[2];
            this.powerStatus = new SelectableStatusLabel[2];
            this.setBorder(TAB_BORDER);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(layout);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.anchor = 17;
            constraints.fill = 1;
            this.modulePanel = new ModuleSelectionPanel();
            constraints.insets = new Insets(0, 10, 0, 20);
            this.addComponent(this.modulePanel, this, layout, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            ++constraints.gridx;
            this.modulePanel.addPropertyChangeListener("module", new 6(this));
            this.infoPanel = GUIFactory.newPanel();
            this.cardLayout = new CardLayout();
            this.infoPanel.setLayout(this.cardLayout);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridheight = 2;
            constraints.insets = new Insets(0, 10, 0, 0);
            this.addComponent(this.infoPanel, this, layout, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridheight = 1;
            int index = 0;
            while (index < 2) {
                int COLUMN_WIDTH = 300;
                String controllerTitle = Resources.getString(index == 0 ? "systemInfo.modulesPanel.topController" : "systemInfo.modulesPanel.bottomController");
                this.controllerColumn[index] = new SizeLinkedColumn(" " + controllerTitle + " ");
                this.controllerStatus[index] = new SelectableStatusLabel();
                this.controllerStatus[index].setFont(GUIFactory.FONT_SMALL);
                this.controllerCache[index] = new SelectableLabel();
                this.controllerFirmware[index] = new SelectableLabel();
                this.controllerColumn[index].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.controllerStatus[index]);
                this.controllerColumn[index].addField(Resources.getString("systemInfo.modulesPanel.controllerCache"), this.controllerCache[index]);
                this.controllerColumn[index].addField(Resources.getString("systemInfo.modulesPanel.controllerFirmware"), this.controllerFirmware[index]);
                this.infoPanel.add((Component)this.controllerColumn[index], "controller" + index);
                String batteryTitle = Resources.getString(index == 0 ? "systemInfo.modulesPanel.topBattery" : "systemInfo.modulesPanel.bottomBattery");
                this.batteryColumn[index] = new SizeLinkedColumn(" " + batteryTitle + " ");
                this.batteryStatus[index] = new SelectableStatusLabel();
                this.batteryChargeState[index] = new SelectableLabel();
                this.batteryCharge[index] = new SelectableLabel();
                this.batteryColumn[index].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.batteryStatus[index]);
                this.batteryColumn[index].addField(Resources.getString("systemInfo.modulesPanel.batteryChargeState"), this.batteryChargeState[index]);
                this.batteryColumn[index].addField(Resources.getString("systemInfo.modulesPanel.batteryCharge"), this.batteryCharge[index]);
                this.infoPanel.add((Component)this.batteryColumn[index], "battery" + index);
                String blowerTitle = Resources.getString(index == 0 ? "systemInfo.modulesPanel.topBlower" : "systemInfo.modulesPanel.bottomBlower");
                this.blowerColumn[index] = new SizeLinkedColumn(" " + blowerTitle + " ");
                this.blowerStatus[index] = new SelectableStatusLabel();
                this.blowerSpeed[index] = new SelectableLabel();
                this.blowerColumn[index].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.blowerStatus[index]);
                this.blowerColumn[index].addField(Resources.getString("systemInfo.modulesPanel.blowerSpeed"), this.blowerSpeed[index]);
                this.infoPanel.add((Component)this.blowerColumn[index], "blower" + index);
                String powerTitle = Resources.getString(index == 0 ? "systemInfo.modulesPanel.leftPower" : "systemInfo.modulesPanel.rightPower");
                this.powerColumn[index] = new SizeLinkedColumn(" " + powerTitle + " ");
                this.powerStatus[index] = new SelectableStatusLabel();
                this.powerColumn[index].addLabeledComponent(Resources.getString("systemInfo.status"), (JComponent)this.powerStatus[index]);
                this.infoPanel.add((Component)this.powerColumn[index], "power" + index);
                ++index;
            }
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.weightx = 1.0;
            this.addComponent(Box.createHorizontalStrut(1), this, layout, constraints);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 10;
            constraints.weighty = 1.0;
            this.addComponent(Box.createVerticalStrut(1), this, layout, constraints);
            constraints.weighty = 0.0;
            this.updateInfo(null);
        }

        public void actionPerformed(ActionEvent e) {
        }

        public void updateInfo(RaidSystem system) {
            if (system != null) {
                int index = 0;
                while (index < 2) {
                    int controllerModule;
                    RaidController rc = system.getRaidController(index + 1);
                    SystemController sc = system.getSystemController(index + 1);
                    int module = index == 0 ? 6 : 7;
                    int n = controllerModule = index == 0 ? 1 : 2;
                    if (system.isControllerModulePresent(controllerModule)) {
                        int status = system.getControllerModuleStatus(controllerModule);
                        this.controllerStatus[index].setStatus(status);
                        this.controllerStatus[index].setText(SOMLocalizer.getStatusString(status));
                        this.controllerCache[index].setText(SOMLocalizer.getRaidControllerMemorySize(rc));
                        this.controllerFirmware[index].setText(SOMLocalizer.getCombinedFirmwareVersion(sc, rc));
                        this.modulePanel.setModuleStatus(module, true, status);
                    } else {
                        this.controllerStatus[index].setStatus(-2);
                        this.controllerStatus[index].setText(notInstalled);
                        this.controllerCache[index].setText(unknown);
                        this.controllerFirmware[index].setText(unknown);
                        this.modulePanel.setModuleStatus(module, false, -2);
                    }
                    Battery battery = system.getBattery(2 - index);
                    int n2 = module = index == 0 ? 2 : 3;
                    if (battery != null) {
                        int status = battery.getStatus();
                        this.batteryStatus[index].setStatus(status);
                        this.batteryStatus[index].setText(SOMLocalizer.getElementStatus(battery));
                        this.batteryChargeState[index].setText(SOMLocalizer.getBatteryChargeState(battery));
                        this.batteryCharge[index].setText(SOMLocalizer.getBatteryCharge(battery));
                        this.modulePanel.setModuleStatus(module, true, status);
                    } else {
                        this.batteryStatus[index].setStatus(-2);
                        this.batteryStatus[index].setText(notInstalled);
                        this.batteryChargeState[index].setText(unknown);
                        this.batteryCharge[index].setText(unknown);
                        this.modulePanel.setModuleStatus(module, false, -2);
                    }
                    Fan blower = system.getFan(index + 1);
                    int n3 = module = index == 0 ? 8 : 9;
                    if (blower != null) {
                        int status = blower.getStatus();
                        this.blowerStatus[index].setStatus(status);
                        this.blowerStatus[index].setText(SOMLocalizer.getFanStatus(blower));
                        this.blowerSpeed[index].setText(SOMLocalizer.getFanRPM(blower));
                        this.modulePanel.setModuleStatus(module, true, status);
                    } else {
                        this.blowerStatus[index].setStatus(2);
                        this.blowerStatus[index].setText(notInstalled);
                        this.blowerSpeed[index].setText(unknown);
                        this.modulePanel.setModuleStatus(module, false, 2);
                    }
                    PowerSupply power = system.getPowerSupply(2 - index);
                    int n4 = module = index == 0 ? 4 : 5;
                    if (power != null) {
                        int status = power.getStatus();
                        this.powerStatus[index].setStatus(status);
                        this.powerStatus[index].setText(SOMLocalizer.getPowerSupplyStatus(power));
                        this.modulePanel.setModuleStatus(module, true, status);
                    } else {
                        this.powerStatus[index].setStatus(-2);
                        this.powerStatus[index].setText(notInstalled);
                        this.modulePanel.setModuleStatus(module, false, -2);
                    }
                    ++index;
                }
                this.modulePanel.setActive(true);
            } else {
                this.modulePanel.setActive(false);
                int index = 0;
                while (index < 2) {
                    this.controllerStatus[index].setStatus(-3);
                    this.controllerStatus[index].setText(unknown);
                    this.controllerCache[index].setText(unknown);
                    this.controllerFirmware[index].setText(unknown);
                    this.batteryStatus[index].setStatus(-3);
                    this.batteryStatus[index].setText(unknown);
                    this.batteryCharge[index].setText(unknown);
                    this.blowerStatus[index].setStatus(-3);
                    this.blowerStatus[index].setText(unknown);
                    this.blowerSpeed[index].setText(unknown);
                    this.powerStatus[index].setStatus(-3);
                    this.powerStatus[index].setText(unknown);
                    int module = index == 0 ? 6 : 7;
                    this.modulePanel.setModuleStatus(module, false, -1);
                    module = index == 0 ? 2 : 3;
                    this.modulePanel.setModuleStatus(module, false, -1);
                    module = index == 0 ? 8 : 9;
                    this.modulePanel.setModuleStatus(module, false, -1);
                    module = index == 0 ? 4 : 5;
                    this.modulePanel.setModuleStatus(module, false, -1);
                    ++index;
                }
            }
        }

        private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
            gbl.setConstraints(component, gbc);
            container.add(component);
        }

        static /* synthetic */ CardLayout access$0(ComponentsPanel $0) {
            return $0.cardLayout;
        }

        static /* synthetic */ JPanel access$1(ComponentsPanel $0) {
            return $0.infoPanel;
        }
    }

    private static class FibreChannelPanel
    extends JPanel {
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] topology;
        private final SelectableLabel[] speed;
        private final SelectableLabel[] worldWidePortName;
        private final SelectableLabel[] worldWideNodeName;
        private final SelectableLabel[] lunMaskingStatus;
        private final SelectableLabel[] hardLoopId;
        private static final String unknown = Resources.noDataLabel();
        private static final int FC_INTERFACE_COUNT = 2;

        public FibreChannelPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            SizeLinkedColumn[] column = new SizeLinkedColumn[2];
            this.status = new SelectableStatusLabel[2];
            this.topology = new SelectableLabel[2];
            this.speed = new SelectableLabel[2];
            this.worldWidePortName = new SelectableLabel[2];
            this.worldWideNodeName = new SelectableLabel[2];
            this.lunMaskingStatus = new SelectableLabel[2];
            this.hardLoopId = new SelectableLabel[2];
            int index = 0;
            while (index < 2) {
                column[index] = index == 0 ? new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.topController") + " ") : new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.bottomController") + " ");
                this.status[index] = new SelectableStatusLabel();
                column[index].addLabeledComponent(Resources.getString("systemInfo.fibreChannelPanel.status"), (JComponent)this.status[index]);
                this.speed[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.speed"), this.speed[index]);
                this.topology[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.topology"), this.topology[index]);
                this.lunMaskingStatus[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.lunMaskingStatus"), this.lunMaskingStatus[index]);
                this.hardLoopId[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.hardLoopId"), this.hardLoopId[index]);
                this.worldWideNodeName[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.worldWideNodeName"), this.worldWideNodeName[index]);
                this.worldWidePortName[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.fibreChannelPanel.worldWidePortName"), this.worldWidePortName[index]);
                constraints.anchor = 17;
                constraints.fill = 2;
                constraints.insets = index < 1 ? new Insets(0, 0, 0, 10) : new Insets(0, 0, 0, 0);
                constraints.weightx = 1.0;
                constraints.gridx = index;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)column[index], constraints);
                if (index != 0) {
                    column[index].linkPanel(column[index - 1]);
                }
                ++index;
            }
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), constraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem system) {
            if (system != null) {
                int index = 0;
                while (index < 2) {
                    FibreChannelInterface fcInterface;
                    RaidController rc;
                    if (index == 0) {
                        rc = system.getRaidController(1);
                        fcInterface = (FibreChannelInterface)rc.getHostInterface(1);
                    } else {
                        rc = system.getRaidController(2);
                        fcInterface = (FibreChannelInterface)rc.getHostInterface(1);
                    }
                    if (fcInterface != null) {
                        this.status[index].setStatus(fcInterface.getStatus());
                        this.status[index].setText(SOMLocalizer.getFCLinkState(fcInterface));
                        this.worldWidePortName[index].setText(SOMLocalizer.getGenericString(fcInterface.getWorldWidePortName()));
                        this.worldWideNodeName[index].setText(SOMLocalizer.getGenericString(fcInterface.getWorldWideNodeName()));
                        this.lunMaskingStatus[index].setText(SOMLocalizer.getLunMaskingState(rc.getLunMaskEnabled()));
                        this.topology[index].setText(SOMLocalizer.getFCTopology(fcInterface));
                        this.speed[index].setText(SOMLocalizer.getFCSpeed(fcInterface));
                        this.hardLoopId[index].setText(SOMLocalizer.getFCHardLoopEnabled(fcInterface));
                    } else {
                        this.fillInDefaults(index);
                    }
                    ++index;
                }
            } else {
                int index = 0;
                while (index < 2) {
                    this.fillInDefaults(index);
                    ++index;
                }
            }
        }

        private void fillInDefaults(int fcIndex) {
            this.status[fcIndex].setStatus(-3);
            this.status[fcIndex].setText(unknown);
            this.topology[fcIndex].setText(unknown);
            this.speed[fcIndex].setText(unknown);
            this.worldWidePortName[fcIndex].setText(unknown);
            this.worldWideNodeName[fcIndex].setText(unknown);
            this.lunMaskingStatus[fcIndex].setText(unknown);
            this.hardLoopId[fcIndex].setText(unknown);
        }
    }

    private static class NetworkPanel
    extends JPanel {
        private final SelectableLabel[] address;
        private final SelectableLabel[] macAddress;
        private final SelectableStatusLabel[] status;
        private final SelectableLabel[] speed;
        private final SelectableLabel[] configuredVia;
        private final SelectableLabel[] subnet;
        private final SelectableLabel[] router;
        private final SelectableLabel[] dns1;
        private final SelectableLabel[] dns2;
        private final SelectableLabel[] dns3;
        private final SelectableLabel[] dhcpClientId;
        private static final String unknown = Resources.noDataLabel();
        private static final int NETWORK_INTERFACE_COUNT = 2;
        private static final boolean SHOW_ROUTER_AND_DNS = false;

        public NetworkPanel() {
            GUIFactory.configureComponentForPlatform(this);
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBorder(TAB_BORDER);
            this.setLayout(new GridBagLayout());
            SizeLinkedColumn[] column = new SizeLinkedColumn[2];
            this.address = new SelectableLabel[2];
            this.macAddress = new SelectableLabel[2];
            this.status = new SelectableStatusLabel[2];
            this.speed = new SelectableLabel[2];
            this.configuredVia = new SelectableLabel[2];
            this.subnet = new SelectableLabel[2];
            this.router = new SelectableLabel[2];
            this.dns1 = new SelectableLabel[2];
            this.dns2 = new SelectableLabel[2];
            this.dns3 = new SelectableLabel[2];
            this.dhcpClientId = new SelectableLabel[2];
            int index = 0;
            while (index < 2) {
                column[index] = index == 0 ? new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.topController") + " ") : new SizeLinkedColumn(" " + Resources.getString("systemInfo.summaryPanel.bottomController") + " ");
                this.status[index] = new SelectableStatusLabel();
                column[index].addLabeledComponent(Resources.getString("systemInfo.networkPanel.status"), (JComponent)this.status[index]);
                this.address[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.address"), this.address[index]);
                this.subnet[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.subnet"), this.subnet[index]);
                this.macAddress[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.macAddress"), this.macAddress[index]);
                this.speed[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.speed"), this.speed[index]);
                this.configuredVia[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.configuredVia"), this.configuredVia[index]);
                this.dhcpClientId[index] = new SelectableLabel();
                column[index].addField(Resources.getString("systemInfo.networkPanel.dhcpClientId"), this.dhcpClientId[index]);
                constraints.anchor = 17;
                constraints.fill = 2;
                constraints.insets = index < 1 ? new Insets(0, 0, 0, 10) : new Insets(0, 0, 0, 0);
                constraints.weightx = 1.0;
                constraints.gridx = index;
                constraints.gridy = 0;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                this.add((Component)column[index], constraints);
                if (index != 0) {
                    column[index].linkPanel(column[index - 1]);
                }
                ++index;
            }
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            this.add(Box.createHorizontalStrut(1), constraints);
            this.updateInfo(null);
        }

        public void updateInfo(RaidSystem system) {
            if (system != null) {
                int index = 0;
                while (index < 2) {
                    NetworkInterface networkInterface = index == 0 ? system.getSystemController(1).getNetworkInterface() : system.getSystemController(2).getNetworkInterface();
                    if (networkInterface != null) {
                        this.status[index].setStatus(networkInterface.getStatus());
                        this.status[index].setText(SOMLocalizer.getNetworkLinkState(networkInterface));
                        this.address[index].setText(SOMLocalizer.getGenericString(networkInterface.getAddressString()));
                        this.subnet[index].setText(SOMLocalizer.getGenericString(networkInterface.getSubnetMaskString()));
                        this.macAddress[index].setText(SOMLocalizer.getGenericString(networkInterface.getMacAddressString()));
                        this.speed[index].setText(SOMLocalizer.getNetworkSpeed(networkInterface));
                        this.configuredVia[index].setText(SOMLocalizer.getConfigurationMethod(networkInterface));
                        this.dhcpClientId[index].setText(SOMLocalizer.getGenericString(networkInterface.getDhcpClientId()));
                    } else {
                        this.fillInDefaults(index);
                    }
                    ++index;
                }
            } else {
                int index = 0;
                while (index < 2) {
                    this.fillInDefaults(index);
                    ++index;
                }
            }
        }

        private void fillInDefaults(int networkIndex) {
            this.status[networkIndex].setStatus(-3);
            this.status[networkIndex].setText(unknown);
            this.address[networkIndex].setText(unknown);
            this.subnet[networkIndex].setText(unknown);
            this.macAddress[networkIndex].setText(unknown);
            this.speed[networkIndex].setText(unknown);
            this.configuredVia[networkIndex].setText(unknown);
            this.dhcpClientId[networkIndex].setText(unknown);
        }
    }

    private static class SizeLinkedColumn
    extends SizeLinkedPanel {
        public static final int LEFT_COLUMN = 0;
        public static final int RIGHT_COLUMN = 1;
        public static final int MIDDLE_COLUMN = 2;
        private int mItemCount = 0;
        private final GridBagConstraints mConstraints = new GridBagConstraints();
        private final Insets mInsetsItemSpacing = new Insets(0, 0, 0, 10);
        private final Insets mInsetsNone = new Insets(0, 0, 0, 0);

        public SizeLinkedColumn(String title) {
            this.setFont(GUIFactory.FONT_SMALL);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            border.setTitleFont(GUIFactory.FONT_SMALL);
            EmptyBorder margin = new EmptyBorder(10, 10, 10, 10);
            this.setBorder(new CompoundBorder(border, margin));
            this.setLayout(new GridBagLayout());
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
        }

        public void addField(String string, SelectableLabel item) {
            JLabel label = new JLabel(string);
            label.setFont(GUIFactory.FONT_SMALL);
            label.setHorizontalAlignment(4);
            item.setFont(GUIFactory.FONT_SMALL);
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)label, this.mConstraints);
            this.mConstraints.anchor = 17;
            this.mConstraints.fill = 2;
            this.mConstraints.insets = this.mInsetsNone;
            this.mConstraints.weightx = 1.0;
            this.mConstraints.gridx = 1;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)item, this.mConstraints);
        }

        public void addLabeledComponent(String string, JComponent item) {
            this.addLabeledComponent(new JLabel(string), item);
        }

        public void addLabeledComponent(JLabel label, JComponent item) {
            label.setFont(GUIFactory.FONT_SMALL);
            label.setHorizontalAlignment(4);
            item.setFont(GUIFactory.FONT_SMALL);
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)label, this.mConstraints);
            this.mConstraints.anchor = 17;
            this.mConstraints.fill = 2;
            this.mConstraints.insets = this.mInsetsNone;
            this.mConstraints.weightx = 1.0;
            this.mConstraints.gridx = 1;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add((Component)item, this.mConstraints);
        }

        public void padRemainder() {
            this.mConstraints.anchor = 13;
            this.mConstraints.fill = 0;
            this.mConstraints.insets = this.mInsetsItemSpacing;
            this.mConstraints.weightx = 0.0;
            this.mConstraints.weighty = 1.0;
            this.mConstraints.gridx = 0;
            this.mConstraints.gridy = this.mItemCount++;
            this.mConstraints.gridwidth = 1;
            this.mConstraints.gridheight = 1;
            this.add(Box.createVerticalStrut(0), this.mConstraints);
            this.mConstraints.weighty = 0.0;
        }

        public int getItemCount() {
            return this.mItemCount;
        }
    }
}

