/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.HyperTextPane;
import com.apple.gui.MenuManager;
import com.apple.util.Gestalt;
import com.apple.util.StringUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AbstractAddSystemAction;
import com.apple.xsr.AbstractAdvancedAction;
import com.apple.xsr.AbstractClearErrorAction;
import com.apple.xsr.AbstractClearLogAction;
import com.apple.xsr.AbstractCreateArrayAction;
import com.apple.xsr.AbstractDeleteArrayAction;
import com.apple.xsr.AbstractFirstAidAction;
import com.apple.xsr.AbstractForgetPassAction;
import com.apple.xsr.AbstractNotificationAction;
import com.apple.xsr.AbstractServiceIDAction;
import com.apple.xsr.AbstractSetupAction;
import com.apple.xsr.AbstractUpdateFWAction;
import com.apple.xsr.AbstractUpdateNowAction;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.AuthenticatedMenu;
import com.apple.xsr.DefaultSystemRegistry;
import com.apple.xsr.DeleteSystemAction;
import com.apple.xsr.ManagementController;
import com.apple.xsr.OperationManager;
import com.apple.xsr.RendezvousPanel;
import com.apple.xsr.Resources;
import com.apple.xsr.ShutdownAction;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.SystemMonitorWindow;
import com.apple.xsr.Utilities;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.update.FirmwareUpdater;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InvocationEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class SystemMonitorController
implements Preferences.PreferenceChangeListener {
    private static final SystemMonitorController INSTANCE = new SystemMonitorController();
    public DefaultSystemRegistry registry;
    public SystemMonitorWindow monitorWindow;
    private ManagementController managementController;
    private JMenuBar menuBar;
    private Action addSystem = new AddSystemAction();
    public Action deleteSystem;
    public Action createArray;
    public Action deleteArray;
    public Action setup;
    public Action notifications;
    public Action firstAid;
    public Action advanced;
    private Action clearErrorStatus;
    public Action serviceID;
    public Action forgetPassword;
    public Action updateNow;
    private Action clearEventLog;
    public Action restart;
    public Action shutdown;
    public Action resetUpperRaid;
    public Action resetLowerRaid;
    private Action repairLunMap;
    private Action updateFirmware;
    public Action enterMonitoringPassword;
    private RaidSystem savedSystem;
    private static final int MAX_FAILED_AUTHENTICATIONS_ALLOWED = 3;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController != null ? class$com$apple$xsr$SystemMonitorController : (class$com$apple$xsr$SystemMonitorController = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController")));
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController;
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController$ResetRaidAction;
    static /* synthetic */ Class class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread;

    public static SystemMonitorController getInstance() {
        return INSTANCE;
    }

    private SystemMonitorController() {
        this.addSystem.setEnabled(true);
        this.deleteSystem = new DeleteSystemAction(this);
        this.deleteSystem.setEnabled(false);
        this.createArray = new 1();
        this.createArray.setEnabled(false);
        this.deleteArray = new 2();
        this.deleteArray.setEnabled(false);
        this.setup = new 3();
        this.setup.setEnabled(false);
        this.notifications = new 5();
        this.notifications.setEnabled(false);
        this.firstAid = new 6();
        this.firstAid.setEnabled(false);
        this.advanced = new 8();
        this.advanced.setEnabled(false);
        this.clearErrorStatus = new ClearErrorAction();
        this.clearErrorStatus.setEnabled(false);
        this.serviceID = new ServiceIDAction();
        this.serviceID.setEnabled(false);
        this.forgetPassword = new ForgetPasswordAction();
        this.forgetPassword.setEnabled(false);
        this.updateNow = new UpdateNowAction();
        this.updateNow.setEnabled(false);
        this.clearEventLog = new ClearEventLogAction();
        this.clearEventLog.setEnabled(false);
        this.restart = new RestartAction();
        this.restart.setEnabled(false);
        this.shutdown = new ShutdownAction(this);
        this.shutdown.setEnabled(false);
        this.resetUpperRaid = new ResetRaidAction(1);
        this.resetLowerRaid = new ResetRaidAction(2);
        this.repairLunMap = new RepairLunMapAction();
        this.repairLunMap.setEnabled(false);
        this.updateFirmware = new UpdateFirmwareAction();
        this.updateFirmware.setEnabled(false);
        this.enterMonitoringPassword = new EnterMonitoringPasswordAction();
        this.enterMonitoringPassword.setEnabled(false);
        this.monitorWindow = new SystemMonitorWindow(this);
        this.monitorWindow.setDefaultCloseOperation(2);
        this.monitorWindow.setAddSystemAction(this.addSystem);
        this.monitorWindow.setDeleteSystemAction(this.deleteSystem);
        this.monitorWindow.setCreateArrayAction(this.createArray);
        this.monitorWindow.setDeleteArrayAction(this.deleteArray);
        this.monitorWindow.setSetupAction(this.setup);
        this.monitorWindow.setNotificationsAction(this.notifications);
        this.monitorWindow.setFirstAidAction(this.firstAid);
        this.monitorWindow.setAdvancedAction(this.advanced);
        MenuManager menuMgr = MenuManager.getInstance();
        menuMgr.register("addItem", this.addSystem);
        menuMgr.register("deleteItem", this.deleteSystem);
        menuMgr.register("createArray", this.createArray);
        menuMgr.register("deleteArray", this.deleteArray);
        menuMgr.register("systemSettings", this.setup);
        menuMgr.register("configureNotifications", this.notifications);
        menuMgr.register("advanced", this.advanced);
        menuMgr.register("firstAid", this.firstAid);
        menuMgr.register("application.menu.system.updateNow", this.updateNow);
        menuMgr.register("application.menu.system.serviceID.toggle", this.serviceID);
        menuMgr.register("application.menu.system.clearEventLog", this.clearEventLog);
        menuMgr.register("clearErrorStatus", this.clearErrorStatus);
        menuMgr.register("application.menu.system.forgetPassword", this.forgetPassword);
        menuMgr.register("application.menu.system.restart", this.restart);
        menuMgr.register("application.menu.system.shutdown", this.shutdown);
        menuMgr.register("application.menu.system.reset.upperRAID", this.resetUpperRaid);
        menuMgr.register("application.menu.system.reset.lowerRAID", this.resetLowerRaid);
        menuMgr.register("application.menu.system.repairLunMap", this.repairLunMap);
        menuMgr.register("application.menu.system.updateFirmware", this.updateFirmware);
        this.menuBar = menuMgr.newMenuBar();
        this.monitorWindow.setJMenuBar(this.menuBar);
        this.monitorWindow.addListSelectionListener(new 10());
        this.managementController = new ManagementController();
        this.registry = new DefaultSystemRegistry();
        this.registry.addSystemRegistryListener(this.monitorWindow);
        this.monitorWindow.systemTable.setRegistry(this.registry);
        RaidSystem[] systems = this.monitorWindow.getSelectedSystems();
        this.deleteSystem.setEnabled(systems.length > 0);
        this.updateMenuActionStatus();
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        prefs.addPreferenceChangeListener(this);
        GUIFactory.configureComponentForPlatform(this.monitorWindow);
        ((Component)this.monitorWindow).setVisible(true);
    }

    public SystemMonitorWindow getMonitorWindow() {
        return this.monitorWindow;
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
        if (e.getKey().equals("UseShapes")) {
            this.monitorWindow.systemTable.stopEditing();
            this.monitorWindow.systemTable.repaint();
            RaidSystem[] selected = this.monitorWindow.systemTable.getSelectedSystems();
            if (selected != null && selected.length == 1) {
                this.registry.fireSystemUpdated(selected);
            }
        }
    }

    public void showMonitoringAuthenticationSheet() {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        this.menuBar.setEnabled(false);
        MonitoringAuthenticationSheet authenticationSheet = new MonitoringAuthenticationSheet(this.savedSystem.getName());
        AquaAlert theAlert = new AquaAlert(authenticationSheet, authenticationSheet.getOKButton(), authenticationSheet.getCancelButton(), null);
        theAlert.associateKeyCodeWithButton(46, 4, 2);
        theAlert.associateKeyCodeWithButton(27, 0, 2);
        theAlert.showSheet(this.monitorWindow, new MonitoringAuthenticationListener(authenticationSheet, theAlert), authenticationSheet);
    }

    public void showManagementAuthenticationSheet(String requestedManagementPane) {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        if (this.okToManageNewSystem(requestedManagementPane)) {
            if (this.savedSystem.getManagementPasswordSaved()) {
                this.savedSystem.authenticate(new ManagementSessionAuthenticationListener(requestedManagementPane), "admin", this.savedSystem.getManagementPassword(), false);
            } else {
                this.menuBar.setEnabled(false);
                ManagementAuthenticationSheet authenticationSheet = new ManagementAuthenticationSheet(this.savedSystem.getName());
                authenticationSheet.setRequestedManagementPane(requestedManagementPane);
                AquaAlert theAlert = new AquaAlert(authenticationSheet, authenticationSheet.getOKButton(), authenticationSheet.getCancelButton(), null);
                theAlert.associateKeyCodeWithButton(46, 4, 2);
                theAlert.associateKeyCodeWithButton(27, 0, 2);
                theAlert.associateKeyCodeWithButton(75, 4, authenticationSheet.getSavePasswordCheckbox());
                theAlert.showSheet(this.monitorWindow, new ManagementAuthenticationListener(authenticationSheet, theAlert), authenticationSheet);
            }
        }
    }

    protected void showGlobalDriveCacheNotConfiguredSheet() {
        this.menuBar.setEnabled(false);
        AquaAlert driveCacheAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.driveCachePolicyNotSetMessage"), Resources.getString("systemMonitorController.driveCachePolicyNotSetExplanation"), null, Resources.getString("ok"), Resources.getString("cancel"), Resources.getString("systemMonitorController.createArray"));
        driveCacheAlert.showSheet(this.monitorWindow, new 11(), null);
    }

    public void showManagementAuthenticationSheet(AuthenticatedMenu menuItem) {
        this.savedSystem = this.monitorWindow.getSelectedSystem();
        if (this.savedSystem.getManagementPasswordSaved()) {
            this.savedSystem.authenticate(new ManagementSessionAuthenticationListener(menuItem), "admin", this.savedSystem.getManagementPassword(), false);
        } else {
            this.menuBar.setEnabled(false);
            ManagementAuthenticationSheet authenticationSheet = new ManagementAuthenticationSheet(this.savedSystem.getName());
            authenticationSheet.setAuthenticatedMenuItem(menuItem);
            AquaAlert theAlert = new AquaAlert(authenticationSheet, authenticationSheet.getOKButton(), authenticationSheet.getCancelButton(), null);
            theAlert.associateKeyCodeWithButton(46, 4, 2);
            theAlert.associateKeyCodeWithButton(27, 0, 2);
            theAlert.associateKeyCodeWithButton(75, 4, authenticationSheet.getSavePasswordCheckbox());
            theAlert.showSheet(this.monitorWindow, new ManagementAuthenticationListener(authenticationSheet, theAlert), authenticationSheet);
        }
    }

    private boolean okToManageNewSystem(String requestedPane) {
        boolean okToManageNewSystem = true;
        if (requestedPane == null) {
            throw new NullPointerException("requestedPane may not be null");
        }
        if (this.managementController.aSystemIsBeingManaged()) {
            okToManageNewSystem = false;
            if (this.savedSystem == this.managementController.getManagedSystem()) {
                if (requestedPane.equals(this.managementController.getManagementPaneType())) {
                    this.managementController.managementWindowToFront();
                } else {
                    this.showInformationalAlertSheet(Resources.getString("systemMonitorController.thisSystemAlreadyManagedMessage"), Resources.getString("systemMonitorController.thisSystemAlreadyManagedExplanation"));
                }
            } else {
                this.showInformationalAlertSheet(Resources.getString("systemMonitorController.anotherSystemAlreadyManagedMessage"), Resources.getString("systemMonitorController.anotherSystemAlreadyManagedExplanation"));
            }
        }
        return okToManageNewSystem;
    }

    private void showInformationalAlertSheet(String message, String explanation) {
        this.menuBar.setEnabled(false);
        AquaAlert alert = AquaAlert.createStandardAquaAlert(message, explanation, Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        alert.showSheet(this.monitorWindow, new 12(), null);
    }

    public void updateMenuActionStatus() {
        RaidSystem[] systems = this.monitorWindow.getSelectedSystems();
        int count = systems.length;
        boolean oneSystemSelected = count == 1;
        RaidSystem selectedSystem = null;
        int powerState = -1;
        boolean enabled = false;
        if (!this.menuBar.isEnabled()) {
            return;
        }
        if (oneSystemSelected) {
            selectedSystem = systems[0];
            powerState = selectedSystem.getPowerState();
        }
        if (oneSystemSelected && powerState == 1) {
            enabled = true;
            this.clearErrorStatus.setEnabled(selectedSystem.getEmailNotificationStatus() == 1);
            this.serviceID.putValue("Name", selectedSystem.getServiceIdState() == 1 ? Resources.getString("application.menu.system.serviceID.off") : Resources.getString("application.menu.system.serviceID.on"));
        } else {
            enabled = false;
            this.clearErrorStatus.setEnabled(false);
            this.serviceID.putValue("Name", Resources.getString("application.menu.system.serviceID.toggle"));
        }
        if (powerState == -1) {
            this.shutdown.setEnabled(false);
            this.shutdown.putValue("Name", Resources.getString("application.menu.system.shutdown"));
            this.restart.setEnabled(false);
            this.repairLunMap.setEnabled(false);
            this.updateFirmware.setEnabled(false);
        } else {
            this.shutdown.setEnabled(oneSystemSelected);
            this.shutdown.putValue("Name", powerState == 0 && oneSystemSelected ? Resources.getString("application.menu.system.powerOn") : Resources.getString("application.menu.system.shutdown"));
            this.restart.setEnabled(oneSystemSelected && powerState == 1);
            this.repairLunMap.setEnabled(oneSystemSelected && powerState == 1);
            this.updateFirmware.setEnabled(oneSystemSelected && powerState == 1);
        }
        this.addSystem.setEnabled(true);
        this.deleteSystem.setEnabled(count > 0);
        this.deleteSystem.putValue("Name", count > 1 ? Resources.getString("deleteItems") : Resources.getString("deleteItem"));
        this.createArray.setEnabled(enabled);
        this.deleteArray.setEnabled(enabled);
        this.setup.setEnabled(enabled);
        this.notifications.setEnabled(enabled);
        this.firstAid.setEnabled(enabled);
        this.advanced.setEnabled(enabled);
        this.serviceID.setEnabled(enabled);
        this.clearEventLog.setEnabled(enabled);
        this.restart.setEnabled(enabled);
        this.resetUpperRaid.setEnabled(enabled);
        this.resetLowerRaid.setEnabled(enabled);
        boolean isAvailable = false;
        int i = 0;
        while (i < count) {
            if (systems[i].getPowerState() != -1) {
                isAvailable = true;
                break;
            }
            ++i;
        }
        this.updateNow.setEnabled(isAvailable);
        boolean hasPassword = false;
        int i2 = 0;
        while (i2 < count) {
            if (systems[i2].getManagementPasswordSaved()) {
                hasPassword = true;
                break;
            }
            ++i2;
        }
        this.forgetPassword.setEnabled(hasPassword);
    }

    private void showBadPassword() {
        AquaAlert badPasswordSheet = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.passwordIncorrectMessage"), Resources.getString("systemMonitorController.passwordIncorrectExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        badPasswordSheet.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.passwordIncorrectTitle"), null, null);
    }

    private void showLastChance() {
        AquaAlert lastChanceSheet = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.passwordIncorrectMessage"), Resources.getString("systemMonitorController.passwordIncorrectLastExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        lastChanceSheet.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.passwordIncorrectTitle"), null, null);
    }

    private void showConnectionFailure() {
        AquaAlert connectionFailureSheet = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.connectionFailureMessage"), Resources.getString("systemMonitorController.connectionFailureExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        connectionFailureSheet.showDialog(this.monitorWindow, Resources.getString("systemMonitorController.connectionFailureTitle"), null, null);
    }

    private void showSystemBusySheet() {
        this.menuBar.setEnabled(false);
        AquaAlert systemBusyAlert = AquaAlert.createStandardAquaAlert(Resources.getString("systemMonitorController.cannotUpdateFirmwareMessage"), Resources.getString("systemMonitorController.cannotUpdateFirmwareExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        systemBusyAlert.showSheet(this.monitorWindow, new 18(), null);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    extends AbstractCreateArrayAction {
        public void actionPerformed(ActionEvent e) {
            int flags;
            RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            try {
                if (!OperationManager.isSupported(system, OperationManager.OP_CREATE_ARRAY)) {
                    UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exp) {
                logger.error(exp);
            }
            boolean shouldAuthenticate = true;
            if (system.supportsGlobalDriveCacheFeature() && (flags = system.getDriveCacheFlags()) != 0 && flags != 127) {
                shouldAuthenticate = false;
                SystemMonitorController.this.showGlobalDriveCacheNotConfiguredSheet();
            }
            if (shouldAuthenticate) {
                SystemMonitorController.this.showManagementAuthenticationSheet("create_array_pane");
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends AbstractDeleteArrayAction {
        public void actionPerformed(ActionEvent e) {
            try {
                RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                if (!OperationManager.isSupported(system, OperationManager.OP_DELETE_ARRAY)) {
                    UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exp) {
                logger.error(exp);
            }
            SystemMonitorController.this.showManagementAuthenticationSheet("delete_array_pane");
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AbstractSetupAction {
        public void actionPerformed(ActionEvent e) {
            boolean allOpsSupported;
            RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            try {
                allOpsSupported = OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_DISK_CACHE) && OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_SYNC_CACHE) && OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_SLOW_READ_BYPASS);
            }
            catch (Exception exp) {
                allOpsSupported = true;
                logger.error(exp);
            }
            if (allOpsSupported) {
                SystemMonitorController.this.showManagementAuthenticationSheet("setup_pane");
            } else {
                UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                dialog.addAquaAlertListener(new 4(SystemMonitorController.this));
                dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 5
    extends AbstractNotificationAction {
        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showManagementAuthenticationSheet("notifications_pane");
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends AbstractFirstAidAction {
        public void actionPerformed(ActionEvent e) {
            RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            boolean allOpsSupported = true;
            boolean anyOpsSupported = true;
            try {
                allOpsSupported = OperationManager.isSupported(system, OperationManager.OP_REBUILD_ARRAY) && OperationManager.isSupported(system, OperationManager.OP_VERIFY_ARRAY) && OperationManager.isSupported(system, OperationManager.OP_BACKGROUND_CONDITION) && OperationManager.isSupported(system, OperationManager.OP_DELETE_ORPHAN);
                anyOpsSupported = OperationManager.isSupported(system, OperationManager.OP_REBUILD_ARRAY) || OperationManager.isSupported(system, OperationManager.OP_VERIFY_ARRAY) || OperationManager.isSupported(system, OperationManager.OP_BACKGROUND_CONDITION) || OperationManager.isSupported(system, OperationManager.OP_DELETE_ORPHAN);
            }
            catch (Exception exp) {
                logger.error(exp);
            }
            if (allOpsSupported) {
                SystemMonitorController.this.showManagementAuthenticationSheet("first_aid");
            } else if (anyOpsSupported) {
                UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                dialog.addAquaAlertListener(new 7(SystemMonitorController.this));
                dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
            } else {
                UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 8
    extends AbstractAdvancedAction {
        public void actionPerformed(ActionEvent e) {
            RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            boolean allOpsSupported = true;
            boolean anyOpsSupported = true;
            try {
                allOpsSupported = OperationManager.isSupported(system, OperationManager.OP_SLICE_ARRAY) && OperationManager.isSupported(system, OperationManager.OP_EXPAND_ARRAY) && OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_LUN_MASKING);
                anyOpsSupported = OperationManager.isSupported(system, OperationManager.OP_SLICE_ARRAY) || OperationManager.isSupported(system, OperationManager.OP_EXPAND_ARRAY) || OperationManager.isSupported(system, OperationManager.OP_CONFIGURE_LUN_MASKING);
            }
            catch (Exception exp) {
                logger.error(exp);
            }
            if (allOpsSupported) {
                SystemMonitorController.this.showManagementAuthenticationSheet("advanced_pane");
            } else if (anyOpsSupported) {
                UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this, Resources.getString("someUnsupportedOperationsDialog.message"), UnsupportedOperationDialog.DEFAULT_EXPLANATION, Resources.getString("ok"), null);
                dialog.addAquaAlertListener(new 9(SystemMonitorController.this));
                dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
            } else {
                UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
            }
        }

        /* synthetic */ 8() {
        }
    }

    private final class 10
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            SystemMonitorController.this.updateMenuActionStatus();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements AquaAlertListener {
        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
            if (buttonPressIdentifier == 1) {
                SystemMonitorController.this.showManagementAuthenticationSheet("setup_pane");
            } else if (buttonPressIdentifier == 3) {
                SystemMonitorController.this.showManagementAuthenticationSheet("create_array_pane");
            }
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements AquaAlertListener {
        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        /* synthetic */ 12() {
        }
    }

    private class AddSystemAction
    extends AbstractAddSystemAction
    implements AquaAlertListener,
    CommunicationHandler {
        private final ImageIcon smallIcon = new ImageIcon(Resources.getImage("icon.addItem"));
        private RendezvousPanel panel;
        private AquaAlert logonSheet;
        private int systemsAdded = 0;

        public AddSystemAction() {
            this.putValue("SmallIcon", this.smallIcon);
        }

        public void actionPerformed(ActionEvent e) {
            ArrayList monitoredMACAddresses = this.getMonitoredMACAddresses();
            ArrayList monitoredIPAddresses = this.getMonitoredIPAddresses();
            this.panel = new RendezvousPanel(monitoredMACAddresses, monitoredIPAddresses);
            this.logonSheet = new AquaAlert(this.panel, this.panel.getAddButton(), this.panel.getCancelButton(), null);
            this.logonSheet.associateKeyCodeWithButton(46, 4, 2);
            this.logonSheet.associateKeyCodeWithButton(27, 0, 2);
            SystemMonitorController.this.menuBar.setEnabled(false);
            this.logonSheet.showSheet(SystemMonitorController.this.monitorWindow, this, this.panel);
        }

        protected ArrayList getMonitoredMACAddresses() {
            ArrayList<String> listOfMACAddresses = new ArrayList<String>();
            Iterator systemIter = SystemMonitorController.this.registry.getSystems().iterator();
            while (systemIter.hasNext()) {
                RaidSystem aRaidSystem = (RaidSystem)systemIter.next();
                if (aRaidSystem == null) continue;
                Iterator controllerIter = aRaidSystem.getSystemControllers().iterator();
                while (controllerIter.hasNext()) {
                    String macAddress;
                    NetworkInterface netInterface;
                    SystemController aController = (SystemController)controllerIter.next();
                    if (aController == null || (netInterface = aController.getNetworkInterface()) == null || (macAddress = netInterface.getMacAddress()) == null) continue;
                    listOfMACAddresses.add(macAddress);
                }
            }
            return listOfMACAddresses;
        }

        protected ArrayList getMonitoredIPAddresses() {
            ArrayList<String> listOfIPAddresses = new ArrayList<String>();
            Iterator systemIter = SystemMonitorController.this.registry.getSystems().iterator();
            while (systemIter.hasNext()) {
                RaidSystem aRaidSystem = (RaidSystem)systemIter.next();
                if (aRaidSystem == null) continue;
                String theFirstIPAddress = aRaidSystem.getPrimaryHostAddress();
                String theSecondIPAddress = aRaidSystem.getSecondaryHostAddress();
                if (theFirstIPAddress != null) {
                    listOfIPAddresses.add(theFirstIPAddress);
                }
                if (theSecondIPAddress != null) {
                    listOfIPAddresses.add(theSecondIPAddress);
                }
                Iterator controllerIter = aRaidSystem.getSystemControllers().iterator();
                while (controllerIter.hasNext()) {
                    String ipAddressString;
                    IPAddress ipAddress;
                    NetworkInterface netInterface;
                    SystemController aController = (SystemController)controllerIter.next();
                    if (aController == null || (netInterface = aController.getNetworkInterface()) == null || (ipAddress = netInterface.getAddress()) == null || (ipAddressString = ipAddress.toString()) == null || ipAddressString.equals(theFirstIPAddress) || ipAddressString.equals(theSecondIPAddress)) continue;
                    listOfIPAddresses.add(ipAddressString);
                }
            }
            return listOfIPAddresses;
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            RendezvousPanel panel = (RendezvousPanel)contextInfo;
            panel.beginServices();
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object obj) {
            RendezvousPanel panel = (RendezvousPanel)obj;
            panel.endServices();
            if (buttonPressIdentifier == 1) {
                int count;
                String[] address = panel.getAddresses();
                String[] name = panel.getNames();
                String password = new String(panel.getPassword());
                this.systemsAdded = count = name.length;
                int index = 0;
                while (index < count) {
                    RaidSystem newSystem = new RaidSystem(address[index]);
                    if (name[index] == null) {
                        name[index] = Resources.getString("rendezvousPanel.unknownSystemName");
                    } else if (name[index].equals("")) {
                        name[index] = Resources.getString("rendezvousPanel.unknownSystemName");
                    }
                    newSystem.setName(name[index]);
                    newSystem.setUserMessageIndex(2);
                    SystemMonitorController.this.registry.add(newSystem);
                    newSystem.connect(this, "guest", password, true);
                    ++index;
                }
            } else {
                this.systemsAdded = 0;
            }
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem system, Response response, Object context) {
            int result = response.getResultCode();
            if (result == 0) {
                system.setUserMessageIndex(3);
                SystemMonitorController.this.registry.synchronizePrefs();
            } else if (result == -16 || result == -27 || result == -28) {
                system.setUserMessageIndex(11);
            } else if (result == -101) {
                system.setUserMessageIndex(4);
            }
            if (this.systemsAdded == 1) {
                SystemMonitorController.this.monitorWindow.setSelectedSystem(system);
            }
        }
    }

    private class ClearErrorAction
    extends AbstractClearErrorAction
    implements AuthenticatedMenu {
        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            MessageFactory factory = system.getMessageFactory();
            13 handler = new 13();
            RequestMessage msg = factory.newSystemMonitorResetRequest();
            msg.setTargetController(RequestMessage.Target.COMPANION);
            system.postMessageAsync(null, msg);
            msg.setTargetController(null);
            system.postMessageAsync(handler, msg);
        }

        ClearErrorAction() {
        }
    }

    private class ServiceIDAction
    extends AbstractServiceIDAction
    implements AuthenticatedMenu {
        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            MessageFactory factory = system.getMessageFactory();
            int state = system.getServiceIdState();
            int newState = state == 1 ? 0 : 1;
            RequestMessage msg = state == 0 ? factory.newIlluminateRequest("service", null, "on") : factory.newIlluminateRequest("service", null, "off");
            14 handler = new 14(this);
            msg.setTargetController(RequestMessage.Target.TOP);
            system.postMessageAsync(handler, msg);
            system.setServiceIdState(newState);
        }

        ServiceIDAction() {
        }
    }

    private class ForgetPasswordAction
    extends AbstractForgetPassAction {
        public void actionPerformed(ActionEvent e) {
            RaidSystem[] selectedSystems = SystemMonitorController.this.monitorWindow.getSelectedSystems();
            int i = 0;
            while (i < selectedSystems.length) {
                selectedSystems[i].setManagementPasswordSaved(false);
                ++i;
            }
        }

        ForgetPasswordAction() {
        }
    }

    private class UpdateNowAction
    extends AbstractUpdateNowAction {
        public void actionPerformed(ActionEvent e) {
            RaidSystem[] selectedSystems = SystemMonitorController.this.monitorWindow.getSelectedSystems();
            int i = 0;
            while (i < selectedSystems.length) {
                RaidSystem system = selectedSystems[i];
                int powerState = system.getPowerState();
                if (powerState != -1) {
                    system.updateImmediately(true);
                }
                ++i;
            }
        }

        UpdateNowAction() {
        }
    }

    private class ClearEventLogAction
    extends AbstractClearLogAction
    implements AuthenticatedMenu {
        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            system.setUserMessageIndex(13);
            MessageFactory factory = system.getMessageFactory();
            RequestMessage msg = factory.newClearEventLogRequest();
            if (system.isControllerModulePresent(1)) {
                system.postMessageAsync(null, msg, 1, null);
            }
            if (system.isControllerModulePresent(2)) {
                system.postMessageAsync(null, msg, 2, null);
            }
            system.getEventLog().clearEvents();
        }

        ClearEventLogAction() {
        }
    }

    private class RestartAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "restart_system";

        public RestartAction() {
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("Name", Resources.getString("application.menu.system.restart"));
            this.putValue("MnemonicKey", null);
        }

        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            int mask = 15;
            InvocationEvent completionTask = new InvocationEvent((Object)SystemMonitorController.this, new 15(system));
            system.setUserMessageIndex(7);
            ManagementController.Restarter restarter = new ManagementController.Restarter(system, mask, true, completionTask);
            new Thread(restarter).start();
        }
    }

    private class ResetRaidAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "reset_raid";
        public static final int OK_BUTTON_IDENTIFIER = 2;
        protected int controllerID;
        private final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController$ResetRaidAction != null ? class$com$apple$xsr$SystemMonitorController$ResetRaidAction : (class$com$apple$xsr$SystemMonitorController$ResetRaidAction = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController$ResetRaidAction")));

        public ResetRaidAction(int controllerID) {
            this.controllerID = controllerID;
            String name = controllerID == 1 ? Resources.getString("application.menu.system.reset.upperRAID") : Resources.getString("application.menu.system.reset.lowerRAID");
            this.putValue("ActionCommandKey", COMMAND_KEY);
            this.putValue("Name", name);
            this.putValue("MnemonicKey", null);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                if (!OperationManager.isSupported(system, OperationManager.OP_RESET_RAID_CONTROLLER)) {
                    UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exp) {
                this.logger.error(exp);
            }
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            new ConfirmDialog(SystemMonitorController.this.monitorWindow, new 16(system, this));
        }

        class ResetThread
        extends Thread {
            private RaidSystem system;
            private int controllerID;
            private final Logger logger = Logger.getLogger(class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread != null ? class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread : (class$com$apple$xsr$SystemMonitorController$ResetRaidAction$ResetThread = SystemMonitorController.class$("com.apple.xsr.SystemMonitorController$ResetRaidAction$ResetThread")));

            public ResetThread(RaidSystem system, int controllerID) {
                this.system = system;
                this.controllerID = controllerID;
            }

            public void run() {
                MessageFactory factory = this.system.getMessageFactory();
                RequestMessage msg = factory.newResetControllerNvramRequest();
                try {
                    this.system.postMessage(msg, this.controllerID);
                    this.logger.info("Waiting for RAID controller " + this.controllerID + " to restart...");
                    this.system.waitForRaidControllerOnline(this.controllerID);
                    this.logger.info("RAID controller " + this.controllerID + " is online");
                }
                catch (Exception e) {
                    this.logger.error(e);
                }
                new ManagementController.LunMapRepairer(this.system, new int[]{this.controllerID}).run();
            }
        }

        class ConfirmDialog {
            public ConfirmDialog(JFrame parentFrame, AquaAlertListener listener) {
                AquaAlert sheet = AquaAlert.createStandardAquaAlert(Resources.getString("resetRaidDialog.message"), Resources.getString("resetRaidDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("cancel"), Resources.getString("ok"), null);
                sheet.associateKeyCodeWithButton(46, 4, 1);
                sheet.associateKeyCodeWithButton(27, 0, 1);
                sheet.showSheet(parentFrame, listener, null);
            }
        }
    }

    private class RepairLunMapAction
    extends AbstractAction
    implements AuthenticatedMenu {
        public static final String COMMAND_KEY = "repair_lun_map";
        public static final int OK_BUTTON_IDENTIFIER = 2;

        public RepairLunMapAction() {
            this.putValue("Name", Resources.getString("application.menu.system.repairLunMap"));
            this.putValue("MnemonicKey", null);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
                if (!OperationManager.isSupported(system, OperationManager.OP_REPAIR_LUN_MAP)) {
                    UnsupportedOperationDialog dialog = new UnsupportedOperationDialog(SystemMonitorController.this);
                    dialog.showAsSheet(SystemMonitorController.this.monitorWindow);
                    return;
                }
            }
            catch (Exception exp) {
                logger.error(exp);
            }
            SystemMonitorController.this.showManagementAuthenticationSheet(this);
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            new ConfirmDialog(SystemMonitorController.this.monitorWindow, new 17(system));
        }

        class ConfirmDialog {
            public ConfirmDialog(JFrame parentFrame, AquaAlertListener listener) {
                AquaAlert sheet = AquaAlert.createStandardAquaAlert(Resources.getString("repairLunMapDialog.message"), Resources.getString("repairLunMapDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("cancel"), Resources.getString("ok"), null);
                sheet.associateKeyCodeWithButton(46, 4, 1);
                sheet.associateKeyCodeWithButton(27, 0, 1);
                sheet.showSheet(parentFrame, listener, null);
            }
        }
    }

    private class UpdateFirmwareAction
    extends AbstractUpdateFWAction
    implements AuthenticatedMenu {
        public void actionPerformed(ActionEvent e) {
            RaidSystem system = SystemMonitorController.this.monitorWindow.getSelectedSystem();
            if (system.isBusy()) {
                SystemMonitorController.this.showSystemBusySheet();
            } else {
                SystemMonitorController.this.showManagementAuthenticationSheet(this);
            }
        }

        public void performMenuSelection(RaidSystem system, String pass) {
            new FirmwareUpdater(SystemMonitorController.this.monitorWindow, system, pass);
        }

        UpdateFirmwareAction() {
        }
    }

    private final class 18
    implements AquaAlertListener {
        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        /* synthetic */ 18() {
        }
    }

    private class EnterMonitoringPasswordAction
    extends AbstractAction {
        public static final String COMMAND_KEY = "enter_monitoring_password";

        public EnterMonitoringPasswordAction() {
            this.putValue("Name", Resources.getString("application.menu.system.reenterPassword"));
            this.putValue("MnemonicKey", null);
            this.putValue("ActionCommandKey", COMMAND_KEY);
        }

        public void actionPerformed(ActionEvent e) {
            SystemMonitorController.this.showMonitoringAuthenticationSheet();
        }
    }

    private static class MonitoringAuthenticationSheet
    extends JPanel {
        public static final int ADDRESS_FIELD_WIDTH = 20;
        private JPasswordField mPasswordField = null;
        private JCheckBox mSavePasswordCheckbox = null;
        private AquaProgressClock mProgress = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;
        private String mRequestedPane = null;
        private AuthenticatedMenu mMenuItem = null;

        public MonitoringAuthenticationSheet(String name) {
            String message = Resources.getString("monitoring.authenticationSheet.message");
            message = StringUtilities.replaceAll(message, "{name}", name);
            this.setLayout(new GridBagLayout());
            Box buttonBox = Box.createHorizontalBox();
            JLabel passwordLabel = new JLabel(Resources.getString("management.authenticationSheet.passwordLabel"));
            GridBagConstraints constraints = new GridBagConstraints();
            this.mPasswordField = GUIFactory.newPasswordField(20);
            this.mProgress = new AquaProgressClock();
            this.mProgress.setVisible(false);
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            JTextArea messageLabel = new JTextArea(message);
            messageLabel.setFont(GUIFactory.FONT_SMALL);
            messageLabel.setBackground(null);
            messageLabel.setHighlighter(null);
            messageLabel.setEditable(false);
            messageLabel.setLineWrap(true);
            messageLabel.setWrapStyleWord(true);
            messageLabel.setSize(300, 64);
            messageLabel.setMinimumSize(new Dimension(300, 48));
            messageLabel.setMaximumSize(new Dimension(300, 200));
            this.add((Component)messageLabel, constraints);
            passwordLabel.setFont(GUIFactory.FONT_SMALL);
            this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
            if (Gestalt.isMacLookAndFeel) {
                this.mPasswordField.setEchoChar('\u2022');
            }
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            this.add((Component)this.mPasswordField, constraints);
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 0, 8, 8);
            constraints.gridx = 0;
            this.add((Component)passwordLabel, constraints);
            buttonBox.add(Box.createHorizontalStrut(1));
            buttonBox.add(this.mProgress);
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(this.mCancelButton);
            buttonBox.add(Box.createHorizontalStrut(8));
            buttonBox.add(this.mOKButton);
            constraints.insets = new Insets(8, 0, 0, 0);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            this.add((Component)buttonBox, constraints);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }

        public String getPassword() {
            return new String(this.mPasswordField.getPassword());
        }

        public void resetPassword() {
            ((JTextComponent)this.mPasswordField).setText("");
        }

        public AquaProgressClock getProgressClock() {
            return this.mProgress;
        }

        public JComponent getFirstFocus() {
            return this.mPasswordField;
        }
    }

    private class MonitoringAuthenticationListener
    implements AquaAlertListener,
    CommunicationHandler {
        private int numFailedAuthentications = 0;
        private MonitoringAuthenticationSheet authenticationPanel;
        private AquaAlert authenticationAlert;

        public MonitoringAuthenticationListener(MonitoringAuthenticationSheet authenticationPanel, AquaAlert authenticationAlert) {
            this.authenticationPanel = authenticationPanel;
            this.authenticationAlert = authenticationAlert;
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            MonitoringAuthenticationSheet sheet = (MonitoringAuthenticationSheet)contextInfo;
            sheet.getFirstFocus().requestFocus();
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (buttonPressIdentifier == 1) {
                String monitoringUser = "guest";
                MonitoringAuthenticationSheet sheet = (MonitoringAuthenticationSheet)contextInfo;
                String password = sheet.getPassword();
                AquaProgressClock progress = sheet.getProgressClock();
                progress.setVisible(true);
                progress.startAnimation();
                SystemMonitorController.this.savedSystem.authenticate(this, monitoringUser, password, true);
                return false;
            }
            return true;
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            this.numFailedAuthentications = 0;
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem system, Response response, Object context) {
            AquaProgressClock progress = this.authenticationPanel.getProgressClock();
            progress.setVisible(false);
            progress.stopAnimation();
            int result = response.getResultCode();
            if (result == 0) {
                try {
                    system.setMonitoringPassword(Utilities.crypt(this.authenticationPanel.getPassword()));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e);
                }
                system.setUserMessageIndex(3);
                this.authenticationAlert.dismissSheetOrDialog(1);
            } else if (result == -16 || result == -27 || result == -28) {
                ++this.numFailedAuthentications;
                SwingUtilities.invokeLater(new 19(this));
                if (this.numFailedAuthentications >= 3) {
                    SystemMonitorController.this.showLastChance();
                    this.authenticationAlert.dismissSheetOrDialog(2);
                } else {
                    SystemMonitorController.this.showBadPassword();
                }
            } else if (result == -101) {
                SystemMonitorController.this.showConnectionFailure();
                this.authenticationAlert.dismissSheetOrDialog(2);
            }
        }

        static /* synthetic */ MonitoringAuthenticationSheet access$0(MonitoringAuthenticationListener $0) {
            return $0.authenticationPanel;
        }
    }

    private static class ManagementAuthenticationSheet
    extends JPanel {
        public static final int ADDRESS_FIELD_WIDTH = 20;
        private JPasswordField mPasswordField = null;
        private JCheckBox mSavePasswordCheckbox = null;
        private AquaProgressClock mProgress = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;
        private String mRequestedPane = null;
        private AuthenticatedMenu mMenuItem = null;

        public ManagementAuthenticationSheet(String name) {
            String message = Resources.getString("management.authenticationSheet.message");
            message = StringUtilities.replaceAll(message, "{name}", name);
            this.setLayout(new GridBagLayout());
            Box buttonBox = Box.createHorizontalBox();
            JLabel passwordLabel = new JLabel(Resources.getString("management.authenticationSheet.passwordLabel"));
            GridBagConstraints constraints = new GridBagConstraints();
            this.mPasswordField = GUIFactory.newPasswordField(20);
            this.mSavePasswordCheckbox = GUIFactory.newCheckBox(Resources.getString("management.authenticationSheet.savePasswordCheckbox"));
            this.mSavePasswordCheckbox.addActionListener(new 20(this));
            this.mProgress = new AquaProgressClock();
            this.mProgress.setVisible(false);
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 17;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            constraints.gridheight = 1;
            JTextArea messageLabel = new JTextArea(message);
            messageLabel.setFont(GUIFactory.FONT_SMALL);
            messageLabel.setBackground(null);
            messageLabel.setHighlighter(null);
            messageLabel.setEditable(false);
            messageLabel.setLineWrap(true);
            messageLabel.setWrapStyleWord(true);
            messageLabel.setSize(300, 64);
            messageLabel.setMinimumSize(new Dimension(300, 48));
            messageLabel.setMaximumSize(new Dimension(300, 200));
            this.add((Component)messageLabel, constraints);
            passwordLabel.setFont(GUIFactory.FONT_SMALL);
            this.mPasswordField.setFont(GUIFactory.FONT_SMALL);
            if (Gestalt.isMacLookAndFeel) {
                this.mPasswordField.setEchoChar('\u2022');
            }
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            this.add((Component)this.mPasswordField, constraints);
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 0, 8, 8);
            constraints.gridx = 0;
            this.add((Component)passwordLabel, constraints);
            this.mSavePasswordCheckbox.setFont(GUIFactory.FONT_SMALL);
            constraints.insets = new Insets(0, 0, 8, 0);
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 2;
            this.add((Component)this.mSavePasswordCheckbox, constraints);
            buttonBox.add(Box.createHorizontalStrut(1));
            buttonBox.add(this.mProgress);
            buttonBox.add(Box.createHorizontalGlue());
            buttonBox.add(this.mCancelButton);
            buttonBox.add(Box.createHorizontalStrut(8));
            buttonBox.add(this.mOKButton);
            constraints.insets = new Insets(8, 0, 0, 0);
            constraints.anchor = 17;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            this.add((Component)buttonBox, constraints);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void setRequestedManagementPane(String requestedPane) {
            this.mRequestedPane = requestedPane;
        }

        public String getRequestedManagementPane() {
            return this.mRequestedPane;
        }

        public void setAuthenticatedMenuItem(AuthenticatedMenu menuItem) {
            this.mMenuItem = menuItem;
        }

        public AuthenticatedMenu getAuthenticatedMenuItem() {
            return this.mMenuItem;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }

        public String getPassword() {
            return new String(this.mPasswordField.getPassword());
        }

        public void resetPassword() {
            ((JTextComponent)this.mPasswordField).setText("");
        }

        public boolean getSavePassword() {
            return this.mSavePasswordCheckbox.isSelected();
        }

        public JCheckBox getSavePasswordCheckbox() {
            return this.mSavePasswordCheckbox;
        }

        public AquaProgressClock getProgressClock() {
            return this.mProgress;
        }

        public JComponent getFirstFocus() {
            return this.mPasswordField;
        }

        static /* synthetic */ JPasswordField access$0(ManagementAuthenticationSheet $0) {
            return $0.mPasswordField;
        }
    }

    private class ManagementAuthenticationListener
    implements AquaAlertListener,
    CommunicationHandler {
        private int numFailedAuthentications = 0;
        private ManagementAuthenticationSheet authenticationPanel;
        private AquaAlert authenticationAlert;

        public ManagementAuthenticationListener(ManagementAuthenticationSheet authenticationPanel, AquaAlert authenticationAlert) {
            this.authenticationPanel = authenticationPanel;
            this.authenticationAlert = authenticationAlert;
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
            ManagementAuthenticationSheet sheet = (ManagementAuthenticationSheet)contextInfo;
            sheet.getFirstFocus().requestFocus();
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (buttonPressIdentifier == 1) {
                String managementUser = "admin";
                ManagementAuthenticationSheet sheet = (ManagementAuthenticationSheet)contextInfo;
                String password = sheet.getPassword();
                AquaProgressClock progress = sheet.getProgressClock();
                progress.setVisible(true);
                progress.startAnimation();
                SystemMonitorController.this.savedSystem.authenticate(this, managementUser, password, true);
                return false;
            }
            return true;
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (buttonPressIdentifier == 1) {
                AuthenticatedMenu item = null;
                item = ((ManagementAuthenticationSheet)contextInfo).getAuthenticatedMenuItem();
                if (item != null) {
                    try {
                        String pass = Utilities.crypt(this.authenticationPanel.getPassword());
                        item.performMenuSelection(SystemMonitorController.this.savedSystem, pass);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error(e);
                    }
                } else if (((ManagementAuthenticationSheet)contextInfo).getRequestedManagementPane() != null && this.numFailedAuthentications < 3) {
                    SystemMonitorController.this.managementController.showManagementWindow(SystemMonitorController.this.savedSystem, ((ManagementAuthenticationSheet)contextInfo).getRequestedManagementPane(), SystemMonitorController.this.monitorWindow);
                }
            }
            this.numFailedAuthentications = 0;
            SystemMonitorController.this.menuBar.setEnabled(true);
            SystemMonitorController.this.updateMenuActionStatus();
        }

        public void handleResponse(RaidSystem system, Response response, Object context) {
            AquaProgressClock progress = this.authenticationPanel.getProgressClock();
            progress.setVisible(false);
            progress.stopAnimation();
            int result = response.getResultCode();
            if (result == 0) {
                if (this.authenticationPanel.getSavePassword()) {
                    try {
                        system.setManagementPassword(Utilities.crypt(this.authenticationPanel.getPassword()));
                        system.setManagementPasswordSaved(true);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error(e);
                    }
                }
                this.authenticationAlert.dismissSheetOrDialog(1);
            } else if (result == -16 || result == -27 || result == -28) {
                ++this.numFailedAuthentications;
                SwingUtilities.invokeLater(new 21(this));
                if (this.numFailedAuthentications >= 3) {
                    SystemMonitorController.this.showLastChance();
                    this.authenticationAlert.dismissSheetOrDialog(2);
                } else {
                    SystemMonitorController.this.showBadPassword();
                }
            } else if (result == -101) {
                SystemMonitorController.this.showConnectionFailure();
                this.authenticationAlert.dismissSheetOrDialog(2);
            }
        }

        static /* synthetic */ ManagementAuthenticationSheet access$0(ManagementAuthenticationListener $0) {
            return $0.authenticationPanel;
        }
    }

    private class ManagementSessionAuthenticationListener
    implements CommunicationHandler {
        String requestedManagementPane = null;
        AuthenticatedMenu authenticatedMenu = null;

        ManagementSessionAuthenticationListener(String requestedManagementPane) {
            this.requestedManagementPane = requestedManagementPane;
        }

        ManagementSessionAuthenticationListener(AuthenticatedMenu authenticatedMenu) {
            this.authenticatedMenu = authenticatedMenu;
        }

        public void handleResponse(RaidSystem system, Response response, Object context) {
            int result = response.getResultCode();
            if (result == 0) {
                if (this.authenticatedMenu != null) {
                    this.authenticatedMenu.performMenuSelection(system, system.getManagementPassword());
                } else if (this.requestedManagementPane != null) {
                    SystemMonitorController.this.managementController.showManagementWindow(system, this.requestedManagementPane, SystemMonitorController.this.monitorWindow);
                }
            } else if (result == -16 || result == -27 || result == -28) {
                system.setManagementPasswordSaved(false);
            } else if (result == -101) {
                SystemMonitorController.this.showConnectionFailure();
            }
        }
    }

    protected static class UnsupportedOperationDialog
    extends JPanel
    implements AquaAlertListener,
    HyperlinkListener {
        static final String DEFAULT_MESSAGE = Resources.getString("unsupportedOperationDialog.message");
        static final String DEFAULT_EXPLANATION = Resources.getString("unsupportedOperationDialog.explanation");
        static final String DEFAULT_ACTION_BTN_TITLE = Resources.getString("cancel");
        private static final int BUTTON_SPACING = 12;
        private AquaAlert alert;
        private SystemMonitorController monitorController;
        private JButton defaultButton;
        private JButton altButton;
        private JButton updateButton;
        private String url;

        public UnsupportedOperationDialog(SystemMonitorController monitorController) {
            this(monitorController, DEFAULT_MESSAGE, DEFAULT_EXPLANATION, DEFAULT_ACTION_BTN_TITLE, null);
        }

        public UnsupportedOperationDialog(SystemMonitorController monitorController, String message, String explanation, String defaultButtonTitle, String altButtonTitle) {
            this.monitorController = monitorController;
            Image icon = Resources.getImage("icon.application");
            String updateButtonTitle = Resources.getString("unsupportedOperationDialog.updateButton");
            this.url = Resources.getString("unsupportedOperationDialog.url");
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            this.setLayout(gbl);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)new JLabel(new ImageIcon(icon)), gbc);
            JTextArea messageLabel = new JTextArea(message);
            messageLabel.setFont(GUIFactory.FONT_NORMAL_BOLD);
            messageLabel.setBackground(null);
            messageLabel.setHighlighter(null);
            messageLabel.setEditable(false);
            messageLabel.setLineWrap(false);
            messageLabel.setMargin(new Insets(0, 14, 4, 4));
            messageLabel.setMinimumSize(new Dimension(300, 48));
            messageLabel.setMaximumSize(new Dimension(300, 200));
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)messageLabel, gbc);
            HyperTextPane explanationLabel = new HyperTextPane(explanation);
            explanationLabel.setFont(GUIFactory.FONT_SMALL);
            explanationLabel.setMargin(new Insets(4, 14, 20, 4));
            explanationLabel.setMinimumSize(new Dimension(300, 48));
            explanationLabel.setMaximumSize(new Dimension(300, 200));
            explanationLabel.addHyperlinkListener(this);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 0;
            this.add((Component)explanationLabel, gbc);
            Box buttonBox = Box.createHorizontalBox();
            this.updateButton = GUIFactory.newButton(updateButtonTitle);
            buttonBox.add(this.updateButton);
            buttonBox.add(Box.createHorizontalGlue());
            if (altButtonTitle != null) {
                buttonBox.add(Box.createHorizontalStrut(12));
                this.altButton = GUIFactory.newButton(altButtonTitle);
                buttonBox.add(this.altButton);
            }
            this.defaultButton = GUIFactory.newButton(defaultButtonTitle);
            this.defaultButton.setDefaultCapable(true);
            buttonBox.add(this.defaultButton);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 13;
            gbc.fill = 2;
            this.add((Component)buttonBox, gbc);
            this.alert = new AquaAlert(this, this.defaultButton, this.altButton, this.updateButton);
        }

        public void showAsSheet(JFrame parentFrame) {
            this.alert.showSheet(parentFrame, this, null);
        }

        public void addAquaAlertListener(AquaAlertListener listener) {
            if (listener != null) {
                this.alert.addAquaAlertListener(listener);
            }
        }

        public void removeAquaAlertListener(AquaAlertListener listener) {
            if (this.alert != null && listener != null) {
                this.alert.removeAquaAlertListener(listener);
            }
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            block2: {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block2;
                try {
                    BrowserLauncher.openURL(this.url);
                }
                catch (Exception exception) {}
            }
        }

        public void aquaAlertDismissed(int buttonPressIdentifier, Object contextInfo) {
            if (buttonPressIdentifier == 3) {
                this.monitorController.updateFirmware.actionPerformed(new ActionEvent(this.monitorController.monitorWindow, 1001, ""));
            }
        }

        public boolean allowAquaAlertToBeDismissed(int buttonPressIdentifier, Object contextInfo) {
            return true;
        }

        public void aquaAlertWillBeShown(Object contextInfo) {
        }

        public void aquaAlertSheetVisible(Object contextInfo) {
        }

        public void aquaAlertResized(Object contextInfo) {
        }
    }
}

