/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AquaToolBar;
import com.apple.xsr.AquaToolBarButton;
import com.apple.xsr.Resources;
import com.apple.xsr.SystemInfoPane;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.SystemTable;
import com.apple.xsr.som.RaidSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;

public class SystemMonitorWindow
extends JFrame
implements SystemRegistryListener {
    private static final int WIDTH = 700;
    private static final int HEIGHT = 520;
    private SystemMonitorController controller;
    public SystemTable systemTable;
    private SystemInfoPane systemInfoPane;
    private AquaToolBar toolbar;
    private Action addSystemAction;
    private Action deleteSystemAction;
    private Action createArrayAction;
    private Action deleteArrayAction;
    private Action setupAction;
    private Action notificationsAction;
    private Action firstAidAction;
    private Action advancedAction;
    private AquaToolBarButton addSystemBtn;
    private AquaToolBarButton deleteSystemBtn;
    private AquaToolBarButton createArrayBtn;
    private AquaToolBarButton deleteArrayBtn;
    private AquaToolBarButton setupBtn;
    private AquaToolBarButton notificationsBtn;
    private AquaToolBarButton firstAidBtn;
    private AquaToolBarButton advancedBtn;
    private static final Dimension TOOLBAR_SEPARATOR_SIZE = new Dimension(16, 0);

    public SystemMonitorWindow(SystemMonitorController controller) {
        this.controller = controller;
        this.setTitle(Resources.getString("appName"));
        ((Component)this).setSize(700, 520);
        this.toolbar = new AquaToolBar();
        this.addSystemBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.addSystemBtn);
        this.deleteSystemBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.deleteSystemBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.createArrayBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.createArrayBtn);
        this.deleteArrayBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.deleteArrayBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.setupBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.setupBtn);
        this.notificationsBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.notificationsBtn);
        this.firstAidBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.firstAidBtn);
        if (Gestalt.isMacLookAndFeel) {
            this.toolbar.addSeparator();
        } else {
            this.toolbar.addSeparator(TOOLBAR_SEPARATOR_SIZE);
        }
        this.advancedBtn = new AquaToolBarButton();
        this.toolbar.addButton(this.advancedBtn);
        this.systemTable = new SystemTable(this.controller);
        this.systemTable.addListSelectionListener(new 1());
        this.systemTable.addStatusIndicatorListener(new 2());
        this.systemTable.addStatusIndicatorMouseListener(new 3());
        this.systemInfoPane = new SystemInfoPane();
        JComponent contentPane = this.createContentPane(this.systemTable, this.systemInfoPane);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.addWindowListener(new 4());
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (prefs.exists("MonitoringWindowLeft")) {
            int left = prefs.getInteger("MonitoringWindowLeft", 0);
            int top = prefs.getInteger("MonitoringWindowTop", 0);
            int width = prefs.getInteger("MonitoringWindowWidth", 800);
            int height = prefs.getInteger("MonitoringWindowHeight", 578);
            ((Component)this).setLocation(left, top);
            ((Component)this).setSize(width, height);
        } else {
            ((Component)this).setSize(800, 578);
        }
    }

    public void toggleToolbar() {
        this.toolbar.setVisible(this.toolbar.isVisible() ^ true);
    }

    public boolean isToolbarVisible() {
        return this.toolbar.isVisible();
    }

    public void updatePreferences() {
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        prefs.setInteger("MonitoringWindowLeft", this.getX());
        prefs.setInteger("MonitoringWindowTop", this.getY());
        prefs.setInteger("MonitoringWindowWidth", this.getWidth());
        prefs.setInteger("MonitoringWindowHeight", this.getHeight());
        prefs.synchronize();
    }

    public void registryChanged(SystemRegistryEvent e) {
        if (e.getType() == 2) {
            RaidSystem[] systems = this.getSelectedSystems();
            RaidSystem updateMe = null;
            if (systems == null) {
                return;
            }
            if (systems.length != 1) {
                return;
            }
            updateMe = systems[0];
            systems = e.getSystems();
            int i = 0;
            while (i < systems.length) {
                if (updateMe == systems[i]) {
                    if (updateMe.getPowerState() == 1) {
                        this.systemInfoPane.updateInfo(updateMe);
                        this.controller.updateMenuActionStatus();
                        break;
                    }
                    if (updateMe.getUserMessageIndex() != 11) break;
                    this.controller.updateMenuActionStatus();
                    break;
                }
                ++i;
            }
        }
    }

    public void setSelectedSystem(RaidSystem system) {
        this.systemTable.setSelectedSystem(system);
    }

    public RaidSystem getSelectedSystem() {
        return this.systemTable.getSelectedSystem();
    }

    public RaidSystem[] getSelectedSystems() {
        return this.systemTable.getSelectedSystems();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.systemTable.addListSelectionListener(listener);
    }

    void setAddSystemAction(Action a) {
        this.addSystemAction = a;
        this.addSystemBtn.setAction(a);
    }

    void setDeleteSystemAction(Action a) {
        this.deleteSystemAction = a;
        this.deleteSystemBtn.setAction(a);
    }

    void setCreateArrayAction(Action a) {
        this.createArrayAction = a;
        this.createArrayBtn.setAction(a);
    }

    void setDeleteArrayAction(Action a) {
        this.deleteArrayAction = a;
        this.deleteArrayBtn.setAction(a);
    }

    void setSetupAction(Action a) {
        this.setupAction = a;
        this.setupBtn.setAction(a);
    }

    void setNotificationsAction(Action a) {
        this.notificationsAction = a;
        this.notificationsBtn.setAction(a);
    }

    void setFirstAidAction(Action a) {
        this.firstAidAction = a;
        this.firstAidBtn.setAction(a);
    }

    void setAdvancedAction(Action a) {
        this.advancedAction = a;
        this.advancedBtn.setAction(a);
    }

    private JComponent createContentPane(SystemTable tablePane, SystemInfoPane infoPane) {
        JSplitPane pane = this.createSplitContentPane(tablePane, infoPane);
        return pane;
    }

    private JSplitPane createSplitContentPane(JComponent topComponent, JComponent bottomComponent) {
        int dividerMargin = 12;
        SplitPane contentPane = new SplitPane(0, true);
        contentPane.setBorder(null);
        contentPane.setResizeWeight(1.0);
        contentPane.setOneTouchExpandable(false);
        topComponent.setBorder(BorderFactory.createEmptyBorder(12, 20, 12, 20));
        bottomComponent.setBorder(BorderFactory.createEmptyBorder(12, 16, 20, 16));
        contentPane.setTopComponent(topComponent);
        contentPane.setBottomComponent(bottomComponent);
        return contentPane;
    }

    private JPanel createStandardContentPane(JComponent topComponent, JComponent bottomComponent) {
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPane = GUIFactory.newPanel(gbl);
        contentPane.setBorder(BorderFactory.createEmptyBorder(12, 20, 20, 20));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        contentPane.add((Component)topComponent, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 0, 0, 0);
        contentPane.add((Component)bottomComponent, gbc);
        return contentPane;
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            boolean selected;
            RaidSystem[] systems = SystemMonitorWindow.this.systemTable.getSelectedSystems();
            boolean bl = selected = systems.length > 0;
            if (SystemMonitorWindow.this.deleteSystemAction != null) {
                SystemMonitorWindow.this.deleteSystemAction.setEnabled(selected);
            }
            if (systems.length == 1) {
                SystemMonitorWindow.this.systemInfoPane.setSystem(systems[0]);
            } else {
                SystemMonitorWindow.this.systemInfoPane.setSystem(null);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("status_indicator_pressed")) {
                SystemMonitorWindow.this.systemInfoPane.setSelectedTab(0);
            } else if (cmd.equals("modules_indicator_pressed")) {
                SystemMonitorWindow.this.systemInfoPane.setSelectedTab(2);
            } else if (cmd.equals("arrays_drives_indicator_pressed")) {
                SystemMonitorWindow.this.systemInfoPane.setSelectedTab(1);
            } else if (cmd.equals("fibre_channel_indicator_pressed")) {
                SystemMonitorWindow.this.systemInfoPane.setSelectedTab(3);
            } else if (cmd.equals("network_indicator_pressed")) {
                SystemMonitorWindow.this.systemInfoPane.setSelectedTab(4);
            } else if (cmd.equals("message_button_pressed")) {
                SystemMonitorWindow.this.controller.showMonitoringAuthenticationSheet();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseInputAdapter {
        public void mouseReleased(MouseEvent e) {
            SystemMonitorWindow.this.systemTable.stopEditing();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends WindowAdapter {
        public void windowClosed(WindowEvent e) {
            SystemMonitorWindow.this.updatePreferences();
            System.exit(0);
        }

        /* synthetic */ 4() {
        }
    }

    static class SplitPane
    extends JSplitPane {
        SplitPane(int orientation, boolean continuousLayout) {
            super(orientation, continuousLayout);
        }

        public int getDividerSize() {
            if (Gestalt.isJava141OrLater) {
                return super.getDividerSize();
            }
            return 9;
        }
    }
}

