/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.xsr.AquaProgressClock;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.StatusIndicator;
import com.apple.xsr.SystemMonitorController;
import com.apple.xsr.SystemRegistry;
import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.SystemTable;
import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.RaidSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.UnknownHostException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SystemTable
extends JPanel {
    public static final int STATUS_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int ADDRESS_COLUMN = 2;
    public static final int INFO_COLUMN = 3;
    public static final int MESSAGE_COLUMN = 4;
    public static final String STATUS_INDICATOR_PRESSED = "status_indicator_pressed";
    public static final String MODULES_INDICATOR_PRESSED = "modules_indicator_pressed";
    public static final String ARRAYS_DRIVES_INDICATOR_PRESSED = "arrays_drives_indicator_pressed";
    public static final String FIBRE_CHANNEL_INDICATOR_PRESSED = "fibre_channel_indicator_pressed";
    public static final String NETWORK_INDICATOR_PRESSED = "network_indicator_pressed";
    public static final String MESSAGE_BUTTON_PRESSED = "message_button_pressed";
    private static final int TABLE_ROW_HEIGHT = 20;
    private static final int STATUS_COLUMN_WIDTH = 20;
    private static final int NAME_COLUMN_MIN_WIDTH = 200;
    private static final int ADDRESS_COLUMN_MIN_WIDTH = 115;
    private static final int MESSAGE_COLUMN_MIN_WIDTH = 200;
    private static final Dimension minimumSize = new Dimension(100, 152);
    private final String[] COLUMNS = new String[]{" ", Resources.getString("systemTable.nameColumn"), Resources.getString("systemTable.addressColumn"), " ", Resources.getString("systemTable.messageColumn")};
    private ContextualMenuAwareTable table;
    private JScrollPane tableScrollPane;
    private SystemMonitorController controller;
    public Model tableModel;
    private StatusEditor statusEditor;
    private InfoEditor infoEditor;
    private MessageEditor messageEditor;
    private Timer timer = null;
    private AquaProgressClock progress = new AquaProgressClock();
    TableColumn messageColumn = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public SystemTable(SystemMonitorController controller) {
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.tableModel = new Model();
        this.table = new ContextualMenuAwareTable(this.tableModel);
        this.table.setRowHeight(20);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setAutoResizeMode(0);
        JTableHeader header = this.table.getTableHeader();
        header.setFont(GUIFactory.FONT_SMALL);
        this.statusEditor = new StatusEditor();
        this.infoEditor = new InfoEditor();
        this.messageEditor = new MessageEditor(this.progress);
        TableColumn statusColumn = this.table.getColumnModel().getColumn(0);
        statusColumn.setMinWidth(20);
        statusColumn.setMaxWidth(20);
        statusColumn.setResizable(false);
        statusColumn.setCellRenderer(new StatusRenderer());
        statusColumn.setCellEditor(this.statusEditor);
        IconHeaderRenderer statusColumnHeaderRenderer = new IconHeaderRenderer(Resources.getImage("icon.status.header"));
        statusColumnHeaderRenderer.setToolTipText(Resources.getString("systemTable.infoColumn"));
        statusColumn.setHeaderRenderer(statusColumnHeaderRenderer);
        TableColumn nameColumn = this.table.getColumnModel().getColumn(1);
        nameColumn.setMinWidth(200);
        nameColumn.setCellRenderer(new StringRenderer());
        TableColumn addressColumn = this.table.getColumnModel().getColumn(2);
        addressColumn.setMinWidth(115);
        addressColumn.setCellRenderer(new StringRenderer());
        TableColumn infoColumn = this.table.getColumnModel().getColumn(3);
        infoColumn.setResizable(false);
        infoColumn.setCellRenderer(new InfoRenderer());
        infoColumn.setCellEditor(this.infoEditor);
        IconHeaderRenderer infoColumnHeaderRenderer = new IconHeaderRenderer(Resources.getImage("icon.info.header"));
        infoColumnHeaderRenderer.setToolTipText(String.valueOf(Resources.getString("systemInfo.tab.arraysAndDrives")) + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.modules") + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.fibreChannel") + Resources.getString("som.raidset.driveSeparator") + Resources.getString("systemInfo.tab.network"));
        infoColumn.setHeaderRenderer(infoColumnHeaderRenderer);
        this.messageColumn = this.table.getColumnModel().getColumn(4);
        this.messageColumn.setMinWidth(200);
        this.messageColumn.setCellRenderer(new MessageRenderer(this.progress));
        this.messageColumn.setCellEditor(this.messageEditor);
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tableScrollPane.setHorizontalScrollBarPolicy(32);
        this.add((Component)this.tableScrollPane, "Center");
        this.tableScrollPane.addComponentListener(new 1());
        this.table.addComponentListener(new 2());
        this.table.getColumnModel().addColumnModelListener(new 3());
        this.table.getSelectionModel().addListSelectionListener(new 4());
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setRegistry(SystemRegistry registry) {
        if (registry != null) {
            registry.addSystemRegistryListener(this.tableModel);
            this.tableModel.addAll(registry.getSystems());
        }
    }

    public Dimension getMinimumSize() {
        return minimumSize;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void addStatusIndicatorListener(ActionListener listener) {
        this.statusEditor.addActionListener(listener);
        this.infoEditor.addActionListener(listener);
        this.messageEditor.addActionListener(listener);
    }

    public void addStatusIndicatorMouseListener(MouseListener listener) {
        this.statusEditor.addMouseListener(listener);
        this.infoEditor.addMouseListener(listener);
        this.messageEditor.addMouseListener(listener);
    }

    public boolean isSystemSelected() {
        return this.table.getRowCount() > 0 && this.table.getSelectedRow() != -1;
    }

    public RaidSystem[] getSelectedSystems() {
        RaidSystem[] systems;
        if (this.table.getRowCount() > 0) {
            int[] rows = this.table.getSelectedRows();
            systems = new RaidSystem[rows.length];
            int i = 0;
            while (i < rows.length) {
                systems[i] = this.tableModel.getSystem(rows[i]);
                ++i;
            }
        } else {
            systems = new RaidSystem[]{};
        }
        return systems;
    }

    public RaidSystem getSelectedSystem() {
        int row;
        RaidSystem system = null;
        if (this.table.getRowCount() > 0 && (row = this.table.getSelectedRow()) != -1) {
            system = this.tableModel.getSystem(row);
        }
        return system;
    }

    public void setSelectedSystem(RaidSystem system) {
        if (this.table.getEditingRow() != -1) {
            this.table.getCellEditor().stopCellEditing();
        }
        if (system == null) {
            this.table.setRowSelectionInterval(-1, -1);
        } else {
            int rowCount = this.table.getRowCount();
            if (rowCount > 0) {
                int i = 0;
                while (i < rowCount) {
                    RaidSystem rs = this.tableModel.getSystem(i);
                    if (rs == system) {
                        this.table.setRowSelectionInterval(i, i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public void stopEditing() {
        if (this.table.getEditingRow() != -1) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    private void autoResizeMessageColumn() {
        int tableWidth = this.tableScrollPane.getViewport().getWidth();
        int totalWidth = this.table.getColumnModel().getTotalColumnWidth();
        if (totalWidth != tableWidth) {
            this.messageColumn.setPreferredWidth(this.messageColumn.getWidth() + tableWidth - totalWidth);
        }
    }

    private void updateAnimation() {
        if (this.table == null) {
            return;
        }
        int rowCount = this.table.getRowCount();
        if (rowCount > 0) {
            int i = 0;
            while (i < rowCount) {
                RaidSystem rs = this.tableModel.getSystem(i);
                if (rs.getUserMessageIsAsync()) {
                    this.startAnimation();
                    return;
                }
                ++i;
            }
        }
        this.stopAnimation();
    }

    private synchronized void startAnimation() {
        if (this.timer == null) {
            this.timer = new Timer(66, new 5());
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private void stopAnimation() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    class Model
    extends AbstractTableModel
    implements SystemRegistryListener {
        private List systemList;
        private SystemComparator comparator = new SystemComparator(0);

        public Model() {
            this.systemList = new ArrayList();
        }

        public void addAll(Collection systems) {
            this.systemList.addAll(systems);
            this.sort();
            SwingUtilities.invokeLater(new 6(this));
        }

        public void add(RaidSystem[] systems) {
            int i = 0;
            while (i < systems.length) {
                this.systemList.add(systems[i]);
                ++i;
            }
            this.sort();
            SwingUtilities.invokeLater(new 7(this));
        }

        public void remove(RaidSystem[] systems) {
            int i = 0;
            while (i < systems.length) {
                this.systemList.remove(systems[i]);
                ++i;
            }
            this.sort();
            SwingUtilities.invokeLater(new 8(this));
        }

        public void update(RaidSystem[] systems) {
            this.sort();
            SwingUtilities.invokeLater(new 9(systems, this));
        }

        public int getRowCount() {
            return this.systemList.size();
        }

        public int getColumnCount() {
            return SystemTable.this.COLUMNS.length;
        }

        public Class getColumnClass(int column) {
            Class columnClass = null;
            switch (column) {
                case 0: {
                    columnClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = SystemTable.class$("java.lang.Object"));
                    break;
                }
                case 1: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SystemTable.class$("java.lang.String"));
                    break;
                }
                case 2: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SystemTable.class$("java.lang.String"));
                    break;
                }
                case 3: {
                    columnClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = SystemTable.class$("java.lang.Object"));
                    break;
                }
                case 4: {
                    columnClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = SystemTable.class$("java.lang.Object"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return columnClass;
        }

        public String getColumnName(int column) {
            if (column >= SystemTable.this.COLUMNS.length) {
                throw new IllegalArgumentException("Illegal column: " + column);
            }
            return SystemTable.this.COLUMNS[column];
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            if (colIndex == 0 || colIndex == 3) {
                return true;
            }
            return colIndex == 4 && this.getSystem(rowIndex).getUserMessageIndex() == 11;
        }

        public Object getValueAt(int row, int column) {
            Object value = null;
            RaidSystem system = (RaidSystem)this.systemList.get(row);
            if (system != null) {
                switch (column) {
                    case 0: 
                    case 3: 
                    case 4: {
                        value = system;
                        break;
                    }
                    case 1: {
                        value = system.getName();
                        break;
                    }
                    case 2: {
                        value = system.getHostAddress();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column: " + column);
                    }
                }
            }
            return value;
        }

        public RaidSystem getSystem(int index) {
            return (RaidSystem)this.systemList.get(index);
        }

        public void registryChanged(SystemRegistryEvent e) {
            int type = e.getType();
            if (type == 0) {
                this.add(e.getSystems());
            } else if (type == 1) {
                this.remove(e.getSystems());
            } else if (type == 2) {
                this.update(e.getSystems());
            }
            SystemTable.this.updateAnimation();
        }

        public void sort() {
            Collections.sort(this.systemList, this.comparator);
        }

        static /* synthetic */ List access$0(Model $0) {
            return $0.systemList;
        }

        class SystemComparator
        implements Comparator {
            public static final int SORT_KEY_NAME = 0;
            public static final int SORT_KEY_IP_ADDRESS = 1;
            public static final int SORT_KEY_STATUS = 2;
            private int sortKey = 0;
            private Collator collator = Collator.getInstance();

            public SystemComparator(int sortKey) {
                this.sortKey = sortKey;
            }

            public synchronized void setSortKey(int key) {
                this.sortKey = key;
            }

            public synchronized int compare(Object o1, Object o2) {
                return this.compare((RaidSystem)o1, (RaidSystem)o2);
            }

            public synchronized int compare(RaidSystem system1, RaidSystem system2) {
                int value = 1;
                if (this.sortKey == 0) {
                    value = this.collator.compare(system1.getName(), system2.getName());
                } else if (this.sortKey == 1) {
                    try {
                        IPAddress ip1 = new IPAddress(system1.getPrimaryHostAddress());
                        IPAddress ip2 = new IPAddress(system2.getPrimaryHostAddress());
                        value = ip1.compareTo(ip2);
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else {
                    value = this.sortKey == 2 ? system1.getStatus() - system2.getStatus() : this.collator.compare(system1.getName(), system2.getName());
                }
                return value;
            }
        }
    }

    static class IconHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        public IconHeaderRenderer(Image image) {
            JLabel icon = new JLabel();
            icon.setIcon(new ImageIcon(image));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add(icon);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            return this;
        }
    }

    static class StatusRenderer
    extends JPanel
    implements TableCellRenderer {
        AquaTableCellBorder border;
        StatusIndicator indicator;

        public StatusRenderer() {
            this.setLayout(new GridLayout(1, 4, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.indicator = new StatusIndicator();
            this.indicator.setActionCommand(SystemTable.STATUS_INDICATOR_PRESSED);
            this.indicator.setStatus(-1);
            this.add(this.indicator);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            RaidSystem system = (RaidSystem)value;
            if (system.getPowerState() == 1) {
                this.indicator.setStatusAndSelectedState(system.getStatus(), isSelected);
            } else {
                this.indicator.setStatusAndSelectedState(-1, isSelected);
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            return this;
        }
    }

    static class StatusEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        StatusRenderer renderer = new StatusRenderer();
        RaidSystem value;

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.value = (RaidSystem)value;
            table.setRowSelectionInterval(row, row);
            return this.renderer.getTableCellRendererComponent(table, value, true, true, row, col);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener listener) {
            this.renderer.indicator.addActionListener(listener);
        }

        public void addMouseListener(MouseListener listener) {
            this.renderer.indicator.addMouseListener(listener);
        }
    }

    static class InfoRenderer
    extends JPanel
    implements TableCellRenderer {
        private StatusIndicator modulesIndicator;
        private StatusIndicator arraysAndDrivesIndicator;
        private StatusIndicator fibreIndicator;
        private StatusIndicator networkIndicator;
        AquaTableCellBorder border;

        public InfoRenderer() {
            this.setLayout(new GridLayout(1, 4, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.arraysAndDrivesIndicator = new StatusIndicator();
            this.arraysAndDrivesIndicator.setActionCommand(SystemTable.ARRAYS_DRIVES_INDICATOR_PRESSED);
            this.add(this.arraysAndDrivesIndicator);
            this.modulesIndicator = new StatusIndicator();
            this.modulesIndicator.setActionCommand(SystemTable.MODULES_INDICATOR_PRESSED);
            this.add(this.modulesIndicator);
            this.fibreIndicator = new StatusIndicator();
            this.fibreIndicator.setActionCommand(SystemTable.FIBRE_CHANNEL_INDICATOR_PRESSED);
            this.add(this.fibreIndicator);
            this.networkIndicator = new StatusIndicator();
            this.networkIndicator.setActionCommand(SystemTable.NETWORK_INDICATOR_PRESSED);
            this.add(this.networkIndicator);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            RaidSystem system = (RaidSystem)value;
            if (system.getPowerState() == 1) {
                this.arraysAndDrivesIndicator.setStatusAndSelectedState(system.getGeneralRaidSetAndDiskStatus(), isSelected);
                this.modulesIndicator.setStatusAndSelectedState(system.getGeneralComponentStatus(), isSelected);
                this.fibreIndicator.setStatusAndSelectedState(system.getGeneralHostInterfaceStatus(), isSelected);
                this.networkIndicator.setStatusAndSelectedState(system.getGeneralNetworkInterfaceStatus(), isSelected);
            } else {
                this.arraysAndDrivesIndicator.setStatusAndSelectedState(-1, isSelected);
                this.modulesIndicator.setStatusAndSelectedState(-1, isSelected);
                this.fibreIndicator.setStatusAndSelectedState(-1, isSelected);
                this.networkIndicator.setStatusAndSelectedState(-1, isSelected);
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            return this;
        }

        public void addActionListener(ActionListener listener) {
            this.modulesIndicator.addActionListener(listener);
            this.arraysAndDrivesIndicator.addActionListener(listener);
            this.fibreIndicator.addActionListener(listener);
            this.networkIndicator.addActionListener(listener);
        }

        public void addMouseListener(MouseListener listener) {
            this.modulesIndicator.addMouseListener(listener);
            this.arraysAndDrivesIndicator.addMouseListener(listener);
            this.fibreIndicator.addMouseListener(listener);
            this.networkIndicator.addMouseListener(listener);
        }
    }

    static class InfoEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        InfoRenderer renderer = new InfoRenderer();
        RaidSystem value;

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.value = (RaidSystem)value;
            table.setRowSelectionInterval(row, row);
            return this.renderer.getTableCellRendererComponent(table, value, true, false, row, col);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener listener) {
            this.renderer.addActionListener(listener);
        }

        public void addMouseListener(MouseListener listener) {
            this.renderer.modulesIndicator.addMouseListener(listener);
            this.renderer.arraysAndDrivesIndicator.addMouseListener(listener);
            this.renderer.fibreIndicator.addMouseListener(listener);
            this.renderer.networkIndicator.addMouseListener(listener);
        }
    }

    static class MessageRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final int BUTTON_HEIGHT = 18;
        AquaTableCellBorder border;
        AquaProgressClock progress;
        JLabel label;
        JLabel badge;
        JButton button;

        public MessageRenderer(AquaProgressClock progress) {
            this.setLayout(new GridBagLayout());
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.progress = progress;
            this.progress.setOpaque(false);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.badge = new JLabel();
            this.badge.setIcon(new ImageIcon(Resources.getImage("icon.status.adminpassword")));
            this.button = GUIFactory.newButton(Resources.getString("systemTable.messageButton"));
            this.button.setFont(GUIFactory.FONT_SMALL);
            this.button.setOpaque(false);
            this.button.setMinimumSize(new Dimension(this.button.getMinimumSize().width, 18));
            this.button.setActionCommand(SystemTable.MESSAGE_BUTTON_PRESSED);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.anchor = 17;
            constraints.fill = 1;
            constraints.insets = new Insets(0, 4, 0, 4);
            this.add((Component)this.progress, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.fill = 0;
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            this.add((Component)this.label, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            ++constraints.gridx;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.badge, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            ++constraints.gridx;
            constraints.anchor = 11;
            constraints.fill = 0;
            constraints.insets = new Insets(0, 2, 0, 2);
            this.add((Component)this.button, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
        }

        private void addComponent(Component component, Container container, GridBagLayout gbl, GridBagConstraints gbc) {
            gbl.setConstraints(component, gbc);
            container.add(component);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            RaidSystem system = (RaidSystem)value;
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            this.progress.setVisible(system.getUserMessageIsAsync());
            this.progress.setSelected(isSelected);
            this.label.setText(SOMLocalizer.getLocalizedUserMessage(system.getUserMessageIndex()));
            this.label.setForeground(isSelected ? Color.white : Color.black);
            this.badge.setVisible(system.getManagementPasswordSaved());
            this.button.setVisible(system.getUserMessageIndex() == 11);
            return this;
        }
    }

    static class MessageEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        MessageRenderer renderer;
        RaidSystem value;

        public MessageEditor(AquaProgressClock progress) {
            this.renderer = new MessageRenderer(progress);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.value = (RaidSystem)value;
            table.setRowSelectionInterval(row, row);
            return this.renderer.getTableCellRendererComponent(table, value, true, false, row, col);
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void addActionListener(ActionListener listener) {
            this.renderer.button.addActionListener(listener);
        }

        public void addMouseListener(MouseListener listener) {
            this.renderer.button.addMouseListener(listener);
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        AquaTableCellBorder border;
        JLabel label;

        public StringRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            this.label.setText((String)value);
            this.label.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    public class ContextualMenuAwareTable
    extends AlternatingTable {
        private JPopupMenu popup = null;
        private int locX;
        private int locY;

        ContextualMenuAwareTable(Model model) {
            super(model);
        }

        public void processMouseEvent(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int hitRow = SystemTable.this.table.rowAtPoint(e.getPoint());
                if (hitRow != -1 && !SystemTable.this.table.isCellSelected(hitRow, 0)) {
                    super.processMouseEvent(e);
                }
                this.cancelPopup();
                this.popup = this.buildContextualMenu(SystemTable.this.getSelectedSystems());
                if (this.popup != null) {
                    this.locX = e.getX() + 3;
                    this.locY = e.getY() - 3;
                    this.popup.show(e.getComponent(), this.locX, this.locY);
                }
            } else {
                int hitRow;
                if (e.getID() == 501 && this.popup != null) {
                    this.cancelPopup();
                }
                if (e.getID() == 502 && this.popup != null) {
                    JMenuItem hit = (JMenuItem)this.popup.findComponentAt(e.getX() - this.locX, e.getY() - this.locY);
                    if (hit != null) {
                        hit.doClick();
                        this.cancelPopup();
                    }
                } else {
                    super.processMouseEvent(e);
                }
                if (e.getID() == 500 && e.getClickCount() == 2 && (hitRow = SystemTable.this.table.rowAtPoint(e.getPoint())) != -1) {
                    RaidSystem system = SystemTable.this.tableModel.getSystem(hitRow);
                    if (system.getUserMessageIndex() == 11) {
                        SystemTable.this.controller.showMonitoringAuthenticationSheet();
                    } else {
                        system.updateImmediately(false);
                    }
                }
            }
        }

        public void cancelPopup() {
            if (this.popup != null) {
                this.popup.setVisible(false);
                this.popup = null;
            }
        }

        private JPopupMenu buildContextualMenu(RaidSystem[] systems) {
            if (systems == null || systems.length == 0) {
                return null;
            }
            JPopupMenu popup = new JPopupMenu();
            int itemsAdded = 0;
            if (systems.length == 1) {
                if (systems[0].getPowerState() == -1) {
                    JMenuItem menuItem;
                    if (systems[0].getUserMessageIndex() == 11) {
                        menuItem = new JMenuItem(Resources.getString("application.menu.system.reenterPassword"));
                        menuItem.addActionListener(((SystemTable)SystemTable.this).controller.enterMonitoringPassword);
                        popup.add(menuItem);
                        ++itemsAdded;
                        popup.addSeparator();
                    }
                    menuItem = new JMenuItem(Resources.getString("deleteItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    popup.add(menuItem);
                    ++itemsAdded;
                } else if (systems[0].getPowerState() == 0) {
                    JMenuItem menuItem = new JMenuItem(Resources.getString("application.menu.system.powerOn"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.shutdown);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("deleteItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    popup.add(menuItem);
                    ++itemsAdded;
                } else {
                    JMenuItem menuItem = new JMenuItem(Resources.getString("application.menu.system.updateNow"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.updateNow);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("createArray.menuItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.createArray);
                    popup.add(menuItem);
                    ++itemsAdded;
                    menuItem = new JMenuItem(Resources.getString("deleteArray.menuItem"));
                    menuItem.setEnabled(systems[0].getRaidSets().size() > 0);
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteArray);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("systemSettings.menuItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.setup);
                    popup.add(menuItem);
                    ++itemsAdded;
                    menuItem = new JMenuItem(Resources.getString("configureNotifications.menuItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.notifications);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("advanced.menuItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.advanced);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = systems[0].getServiceIdState() == 0 ? new JMenuItem(Resources.getString("application.menu.system.serviceID.on")) : new JMenuItem(Resources.getString("application.menu.system.serviceID.off"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.serviceID);
                    popup.add(menuItem);
                    ++itemsAdded;
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("application.menu.system.shutdown"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.shutdown);
                    popup.add(menuItem);
                    ++itemsAdded;
                    if (systems[0].getManagementPasswordSaved()) {
                        popup.addSeparator();
                        menuItem = new JMenuItem(Resources.getString("application.menu.system.forgetPassword"));
                        menuItem.addActionListener(((SystemTable)SystemTable.this).controller.forgetPassword);
                        popup.add(menuItem);
                        ++itemsAdded;
                    }
                    popup.addSeparator();
                    menuItem = new JMenuItem(Resources.getString("deleteItem"));
                    menuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                    popup.add(menuItem);
                    ++itemsAdded;
                }
            } else {
                JMenuItem menuItem = new JMenuItem(Resources.getString("deleteItems"));
                menuItem.addActionListener(((SystemTable)SystemTable.this).controller.deleteSystem);
                popup.add(menuItem);
                ++itemsAdded;
            }
            return popup;
        }
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            SystemTable.this.autoResizeMessageColumn();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentShown(ComponentEvent e) {
            SystemTable.this.autoResizeMessageColumn();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements TableColumnModelListener {
        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            SystemTable.this.tableScrollPane.repaint();
        }

        public void columnMarginChanged(ChangeEvent e) {
            SystemTable.this.tableScrollPane.repaint();
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            SystemTable.this.table.cancelPopup();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            SystemTable.this.progress.advanceFrame();
            SystemTable.this.repaint();
        }

        /* synthetic */ 5() {
        }
    }
}

