/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.net.acp.AcpPropertyCode;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;

public class AcpPropertyMap {
    private static final AcpPropertyMap INSTANCE = new AcpPropertyMap();
    private Hashtable map = new Hashtable();

    private AcpPropertyMap() {
        this.init();
    }

    public static AcpPropertyMap getInstance() {
        return INSTANCE;
    }

    public AcpPropertyCode get(String property) {
        return (AcpPropertyCode)this.map.get(property);
    }

    public boolean containsKey(String property) {
        return this.map.containsKey(property);
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    private void init() {
        this.map.put("name", AcpPropertyCode.SYS_NAME);
        this.map.put("password", AcpPropertyCode.SYS_PASSWORD_RW);
        this.map.put("contact", AcpPropertyCode.SYS_CONTACT);
        this.map.put("location", AcpPropertyCode.SYS_LOCATION);
        this.map.put("description", AcpPropertyCode.SYS_DESCRIPTION);
        this.map.put("version", AcpPropertyCode.SYS_VERSION);
        this.map.put("ipconfig_method", AcpPropertyCode.LAN_CONFIGURE_VIA);
        this.map.put("ip_address", AcpPropertyCode.LAN_IP_ADDRESS);
        this.map.put("subnet", AcpPropertyCode.LAN_SUBNET_MASK);
        this.map.put("router", AcpPropertyCode.LAN_ROUTER_ADDRESS);
        this.map.put("mac_address", AcpPropertyCode.LAN_MAC_ADDRESS);
        this.map.put("server_mode", AcpPropertyCode.SERVER_MODE);
    }
}

