/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import com.apple.xsr.cli.OptionTokenizer;
import java.util.Hashtable;

public class OptionSet {
    private Hashtable options;

    public OptionSet() {
        this.options = new Hashtable();
    }

    public OptionSet(String[] args, String optstring) throws MissingArgumentException {
        if (args == null) {
            throw new NullPointerException("Args cannot be null");
        }
        if (optstring == null) {
            throw new NullPointerException("optstring cannot be null");
        }
        this.options = new Hashtable();
        this.parseArgs(args, optstring);
    }

    public CommandLineOption get(String optionName) throws OptionException {
        if (optionName == null) {
            throw new NullPointerException("Option name cannot be null");
        }
        CommandLineOption option = (CommandLineOption)this.options.get(optionName);
        if (option == null) {
            option = new CommandLineOption(optionName);
        }
        return option;
    }

    public void put(CommandLineOption option) {
        if (option == null) {
            throw new NullPointerException("Option cannot be null");
        }
        this.options.put(option.getName(), option);
    }

    public boolean contains(String optionName) {
        return this.options.containsKey(optionName);
    }

    private void parseArgs(String[] args, String optstring) throws MissingArgumentException {
        if (args == null) {
            throw new NullPointerException("Args cannot be null");
        }
        if (optstring == null) {
            throw new NullPointerException("Optstring cannot be null");
        }
        OptionTokenizer getopt = new OptionTokenizer(args, optstring);
        while (true) {
            try {
                CommandLineOption option;
                while ((option = getopt.nextOption()) != null) {
                    this.put(option);
                }
            }
            catch (IllegalOptionException illegalOptionException) {
                continue;
            }
            break;
        }
    }
}

