/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.net.acp.AcpEventLog;
import com.apple.util.StringUtilities;
import com.apple.xsr.Resources;
import com.apple.xsr.eventlog.EventLogConstants;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

class EventLocalizer {
    static final String UPPER_CONTROLLER_STRING = Resources.getString("eventLog.upperController");
    static final String LOWER_CONTROLLER_STRING = Resources.getString("eventLog.lowerController");
    static final String PRIORITY_LEVEL_INFO_STRING = Resources.getString("eventLog.priorityLevel.info");
    static final String PRIORITY_LEVEL_WARNING_STRING = Resources.getString("eventLog.priorityLevel.warning");
    static final String PRIORITY_LEVEL_ERROR_STRING = Resources.getString("eventLog.priorityLevel.error");
    static final String PRIORITY_LEVEL_UNKNOWN_STRING = Resources.getString("eventLog.priorityLevel.unknown");
    private HashMap map = new HashMap();
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$eventlog$EventLocalizer != null ? class$com$apple$xsr$eventlog$EventLocalizer : (class$com$apple$xsr$eventlog$EventLocalizer = EventLocalizer.class$("com.apple.xsr.eventlog.EventLocalizer")));
    static /* synthetic */ Class class$com$apple$xsr$eventlog$EventLocalizer;

    public EventLocalizer() {
        this.map.put(new Integer(1), new EventData("Powered On", "event.powerOn"));
        this.map.put(new Integer(2), new EventData("Online", "event.online"));
        this.map.put(new Integer(3), new EventData("Offline", "event.offline"));
        this.map.put(new Integer(4), new EventData("Restart", "event.restart"));
        this.map.put(new Integer(5), new EventData("User %q Login", "event.login", "user"));
        this.map.put(new Integer(6), new EventData("User %q Logout", "event.logout", "user"));
        this.map.put(new Integer(8), new EventData("Location Changed", "event.locationChanged"));
        this.map.put(new Integer(9), new EventData("Contact Changed", "event.contactChanged"));
        this.map.put(new Integer(10), new EventData("Date/Time Changed", "event.dateTimeChanged"));
        this.map.put(new Integer(11), new EventData("%q Password Changed", "event.passwordChanged", "user"));
        this.map.put(new Integer(12), new EventData("Audible Alert State Changed", "event.audibleAlertStateChanged"));
        this.map.put(new Integer(13), new EventData("Auto-Restart State Changed", "event.autoRestartStateChanged"));
        this.map.put(new Integer(14), new EventData("Network Settings Changed", "event.networkSettingsChanged"));
        this.map.put(new Integer(15), new EventData("Event Notification Sent (%d)", "event.eventNotificationSent", "status"));
        this.map.put(new Integer(16), new EventData("Event Log Cleared", "event.eventLogCleared"));
        this.map.put(new Integer(17), new EventData("Firmware V%s Update Started", "event.firmwareUpdateStarted", "version"));
        this.map.put(new Integer(18), new EventData("Firmware V%s Update Complete (%d)", "event.firmwareUpdateComplete", "version,status"));
        this.map.put(new Integer(19), new EventData("Coprocessor %d Communication Failure", "event.coprocessorCommFailure", "id"));
        this.map.put(new Integer(109), new EventData("Coprocessor %d Temperature Problem Occurred", "event.coprocessorOverTemp", "id"));
        this.map.put(new Integer(20), new EventData("Network Link Up", "event.networkLinkUp"));
        this.map.put(new Integer(21), new EventData("Network Link Down", "event.networkLinkDown"));
        this.map.put(new Integer(22), new EventData("Network Address Changed", "event.networkAddressChanged"));
        this.map.put(new Integer(104), new EventData("Time Synchronized with %q", "event.networkTimeSyncSuccess", "host"));
        this.map.put(new Integer(105), new EventData("Time Synchronization Failure with %q (%d)", "event.networkTimeSyncFailure", "host,status"));
        this.map.put(new Integer(106), new EventData("Ambient Temperature Problem Occurred", "event.ambientOverTemp"));
        this.map.put(new Integer(125), new EventData("Coprocessor Settings Synchronized", "event.coprocessor.settingsSynchronized"));
        this.map.put(new Integer(23), new EventData("Enclosure Powered On", "event.enclosure.powerOn"));
        this.map.put(new Integer(24), new EventData("Enclosure Powered Off", "event.enclosure.powerOff"));
        this.map.put(new Integer(25), new EventData("Power Supply %d Inserted", "event.enclosure.powerSupplyInserted", "id"));
        this.map.put(new Integer(26), new EventData("Power Supply %d Removed", "event.enclosure.powerSupplyRemoved", "id"));
        this.map.put(new Integer(27), new EventData("Power Supply %d Failed", "event.enclosure.powerSupplyFailure", "id"));
        this.map.put(new Integer(28), new EventData("Fan %d Inserted", "event.enclosure.fanInserted", "id"));
        this.map.put(new Integer(29), new EventData("Fan %d Removed", "event.enclosure.fanRemoved", "id"));
        this.map.put(new Integer(103), new EventData("Fan %d Failure", "event.enclosure.fanFailure", "id"));
        this.map.put(new Integer(30), new EventData("Service ID Turned On", "event.enclosure.serviceIdTurnedOn"));
        this.map.put(new Integer(31), new EventData("Service ID Turned Off", "event.enclosure.serviceIdTurnedOff"));
        this.map.put(new Integer(32), new EventData("Service ID Reset", "event.enclosure.serviceIdReset"));
        this.map.put(new Integer(33), new EventData("Locked", "event.enclosure.locked"));
        this.map.put(new Integer(34), new EventData("Unlocked", "event.enclosure.unlocked"));
        this.map.put(new Integer(35), new EventData("RAID Set %d Offline", "event.raidSet.offline", "id"));
        this.map.put(new Integer(36), new EventData("RAID Set %d Online", "event.raidSet.online", "id"));
        this.map.put(new Integer(37), new EventData("RAID Set %d Degraded", "event.raidSet.degraded", "id"));
        this.map.put(new Integer(38), new EventData("RAID Set %d Creation Started", "event.raidSet.creationStarted", "id"));
        this.map.put(new Integer(39), new EventData("RAID Set %d Creation Complete (%d)", "event.raidSet.creationComplete", "id,status"));
        this.map.put(new Integer(40), new EventData("RAID Set %d Initialization Started", "event.raidSet.initializationStarted", "id"));
        this.map.put(new Integer(41), new EventData("RAID Set %d Initialization Complete (%d)", "event.raidSet.initializationComplete", "id,status"));
        this.map.put(new Integer(42), new EventData("RAID Set %d Deleted", "event.raidSet.deleted", "id"));
        this.map.put(new Integer(43), new EventData("RAID Set %d Partition %d Creation Started", "event.raidSet.partitionCreationStarted", "rs_id,partition_id"));
        this.map.put(new Integer(44), new EventData("RAID Set %d Partition %d Creation Complete (%d)", "event.raidSet.partitionCreationComplete", "rs_id,partition_id,status"));
        this.map.put(new Integer(45), new EventData("RAID Set %d Partition %d Deleted", "event.raidSet.partitionDeleted", "rs_id,partition_id"));
        this.map.put(new Integer(46), new EventData("RAID Set %d Rebuild Started", "event.raidSet.rebuildStarted", "id"));
        this.map.put(new Integer(47), new EventData("RAID Set %d Rebuild Complete (%d)", "event.raidSet.rebuildComplete", "id,status"));
        this.map.put(new Integer(48), new EventData("RAID Set %d Verify Started", "event.raidSet.verifyStarted", "id"));
        this.map.put(new Integer(49), new EventData("RAID Set %d Verify Complete (%d)", "event.raidSet.verifyComplete", "id,status"));
        this.map.put(new Integer(50), new EventData("RAID Set %d Expansion Started", "event.raidSet.expansionStarted", "id"));
        this.map.put(new Integer(51), new EventData("RAID Set %d Expansion Complete (%d)", "event.raidSet.expansionComplete", "id,status"));
        this.map.put(new Integer(52), new EventData("RAID Set %d LUN Changed", "event.raidSet.lunChanged", "id"));
        this.map.put(new Integer(117), new EventData("JBOD Created", "event.jbod.created"));
        this.map.put(new Integer(118), new EventData("JBOD Deleted", "event.jbod.deleted"));
        this.map.put(new Integer(53), new EventData("Disk %d Handle Opened", "event.disk.handleOpened", "id"));
        this.map.put(new Integer(54), new EventData("Disk %d Handle Closed", "event.disk.handleClosed", "id"));
        this.map.put(new Integer(55), new EventData("Disk %d Inserted", "event.disk.inserted", "id"));
        this.map.put(new Integer(56), new EventData("Disk %d Removed", "event.disk.removed", "id"));
        this.map.put(new Integer(57), new EventData("Disk %d Online", "event.disk.online", "id"));
        this.map.put(new Integer(58), new EventData("Disk %d Offline", "event.disk.offline", "id"));
        this.map.put(new Integer(59), new EventData("Disk %d Failed", "event.disk.failed", "id"));
        this.map.put(new Integer(60), new EventData("Disk %d Cache Enabled", "event.disk.cacheEnabled", "id"));
        this.map.put(new Integer(61), new EventData("Disk %d Cache Disabled", "event.disk.cacheDisabled", "id"));
        this.map.put(new Integer(62), new EventData("Disk %d Block Reassigned", "event.disk.blockReassigned", "id"));
        this.map.put(new Integer(63), new EventData("Disk %d Slow Read Detected", "event.disk.slowReadDetected", "id"));
        this.map.put(new Integer(64), new EventData("Disk %d SMART Failure", "event.disk.smartFailure", "id"));
        this.map.put(new Integer(107), new EventData("Disk %d Temperature Problem Occurred", "event.disk.overTemp", "id"));
        this.map.put(new Integer(65), new EventData("RAID Controller %d Inserted", "event.raidController.inserted", "id"));
        this.map.put(new Integer(66), new EventData("RAID Controller %d Removed", "event.raidController.removed", "id"));
        this.map.put(new Integer(67), new EventData("RAID Controller %d Restart", "event.raidController.restart", "id"));
        this.map.put(new Integer(68), new EventData("RAID Controller %d Online", "event.raidController.online", "id"));
        this.map.put(new Integer(69), new EventData("RAID Controller %d Offline", "event.raidController.offline", "id"));
        this.map.put(new Integer(70), new EventData("RAID Controller %d Disk %d Detected", "event.raidController.diskDetected", "controller_id,disk_id"));
        this.map.put(new Integer(71), new EventData("RAID Controller %d Spare %d Detected", "event.raidController.spareAdded", "controller_id,disk_id"));
        this.map.put(new Integer(72), new EventData("RAID Controller %d Spare %d Activated", "event.raidController.spareActivated", "controller_id,disk_id"));
        this.map.put(new Integer(73), new EventData("RAID Controller %d Failover", "event.raidController.failover", "id"));
        this.map.put(new Integer(74), new EventData("RAID Controller %d Failback", "event.raidController.failback", "id"));
        this.map.put(new Integer(75), new EventData("RAID Controller %d Active-Active Enabled", "event.raidController.activeActiveEnabled", "id"));
        this.map.put(new Integer(76), new EventData("RAID Controller %d Write Cache State Changed", "event.raidController.writeCacheStateChanged", "id"));
        this.map.put(new Integer(77), new EventData("RAID Controller %d Read Prefetch Changed", "event.raidController.readPrefetchChanged", "id"));
        this.map.put(new Integer(78), new EventData("RAID Controller %d Incomplete RAID Set Detected", "event.raidController.incompleteRaidSetDetected", "id"));
        this.map.put(new Integer(79), new EventData("RAID Controller %d Cache Restored", "event.raidController.cacheRestored", "id"));
        this.map.put(new Integer(80), new EventData("RAID Controller %d WWN Changed", "event.raidController.wwnChanged", "id"));
        this.map.put(new Integer(81), new EventData("RAID Controller %d Firmware V%s Update Started", "event.raidController.firmwareUpdateStarted", "id,version"));
        this.map.put(new Integer(82), new EventData("RAID Controller %d Firmware V%s Update Complete (%d)", "event.raidController.firmwareUpdateComplete", "id,version,status"));
        this.map.put(new Integer(83), new EventData("RAID Controller %d Memory Failure", "event.raidController.memoryFailure", "id"));
        this.map.put(new Integer(84), new EventData("RAID Controller %d Diagnostic Failure", "event.raidController.diagnosticFailure", "id"));
        this.map.put(new Integer(85), new EventData("RAID Controller %d Incompatible Disk %d Meta Data", "event.raidController.incompatibleMetaData", "controller_id,disk_id"));
        this.map.put(new Integer(86), new EventData("RAID Controller %d Fibre Speed Changed", "event.raidController.fibreSpeedChanged", "id"));
        this.map.put(new Integer(87), new EventData("RAID Controller %d Fibre Topology Changed", "event.raidController.fibreTopologyChanged", "id"));
        this.map.put(new Integer(88), new EventData("RAID Controller %d Fibre Hard Loop ID Changed", "event.raidController.fibreHardLoopIdChanged", "id"));
        this.map.put(new Integer(89), new EventData("RAID Controller %d Fibre LUN Masking Settings Changed", "event.raidController.fibreLunMaskSettingsChanged", "id"));
        this.map.put(new Integer(90), new EventData("RAID Controller %d Fibre Channel Link Up", "event.raidController.fibreLinkUp", "id"));
        this.map.put(new Integer(91), new EventData("RAID Controller %d Fibre Channel Link Down", "event.raidController.fibreLinkDown", "id"));
        this.map.put(new Integer(92), new EventData("RAID Controller %d Fibre Channel LIP", "event.raidController.fibreLip", "id"));
        this.map.put(new Integer(93), new EventData("RAID Controller %d Communication Failure", "event.raidController.commFailure", "id"));
        this.map.put(new Integer(108), new EventData("RAID Controller %d Temperature Problem Occurred", "event.raidController.overTemp", "id"));
        this.map.put(new Integer(112), new EventData("Disk %d Reported An Error. COMMAND:0x%X ERROR:0x%X STATUS:0x%X LBA:%s", "event.disk.commandError", "id,command,error,status,lba"));
        this.map.put(new Integer(113), new EventData("Disk %d Failed To Respond. Retrying. RETRY COUNT:%d LBA:%s", "event.disk.commandTimeoutRetry", "id,retry,lba"));
        this.map.put(new Integer(114), new EventData("Disk %d Failed To Respond. Data Recovered From Parity. LBA:%s", "event.disk.commandTimeout", "id,lba"));
        this.map.put(new Integer(115), new EventData("Disk %d Failed To Recover After Reset. Retrying. RETRY COUNT:%d", "event.disk.resetFailureRetry", "id,retry"));
        this.map.put(new Integer(116), new EventData("Disk %d Failed To Recover After Reset.", "event.disk.resetFailure", "id"));
        this.map.put(new Integer(119), new EventData("RAID Controller Task Canceled Because of Coprocessor Reset", "event.raidController.taskCanceled"));
        this.map.put(new Integer(120), new EventData("Drive Conditioning Started", "event.raidController.bgrwStarted"));
        this.map.put(new Integer(121), new EventData("Drive Conditioning Stopped", "event.raidController.bgrwStopped"));
        this.map.put(new Integer(122), new EventData("Drive Conditioning Paused", "event.raidController.bgrwPaused"));
        this.map.put(new Integer(123), new EventData("Drive Conditioning Resumed", "event.raidController.bgrwResumed"));
        this.map.put(new Integer(124), new EventData("Drive Conditioning Is Complete", "event.raidController.bgrwCompleted"));
        this.map.put(new Integer(126), new EventData("Data Was Lost During A Rebuild Operation", "event.raidController.dataLostDuringRebuild"));
        this.map.put(new Integer(94), new EventData("Battery %d Inserted", "event.battery.inserted", "id"));
        this.map.put(new Integer(95), new EventData("Battery %d Removed", "event.battery.removed", "id"));
        this.map.put(new Integer(96), new EventData("Battery %d Charge Complete", "event.battery.chargeComplete", "id"));
        this.map.put(new Integer(97), new EventData("Battery %d Low Charge", "event.battery.lowCharge", "id"));
        this.map.put(new Integer(98), new EventData("Battery %d Failed", "event.battery.failed", "id"));
        this.map.put(new Integer(99), new EventData("Battery %d Temperature Warning", "event.battery.temperatureWarning", "id"));
        this.map.put(new Integer(100), new EventData("UPS Line Power Down", "event.ups.linePowerDown"));
        this.map.put(new Integer(101), new EventData("UPS Line Power Restored", "event.ups.linePowerRestored"));
        this.map.put(new Integer(102), new EventData("UPS Battery Low", "event.ups.batteryLow"));
    }

    public String localize(AcpEventLog.Event event) {
        String localized = null;
        int type = event.getType();
        EventData eventData = (EventData)this.map.get(new Integer(type));
        if (eventData != null) {
            try {
                Object[] replacementData = StringUtilities.sscanf(eventData.eventFormatString, event.getMessage());
                localized = Resources.getStringWithReplacement(eventData.resourceKey, eventData.tokens, replacementData);
            }
            catch (Exception e) {
                localized = event.getMessage();
                logger.error("Error parsing event message replacement data: " + e + "\nEvent: " + event + "\nExpected: " + eventData.eventFormatString);
            }
            event.setDescription(Resources.getString(String.valueOf(eventData.resourceKey) + ".desc"));
        } else {
            localized = event.getMessage();
            logger.error("No match found for event type " + type);
        }
        event.setLocalizedMessage(localized);
        return localized;
    }

    public static String getControllerString(int controllerId) {
        String s = controllerId == 1 ? UPPER_CONTROLLER_STRING : (controllerId == 2 ? LOWER_CONTROLLER_STRING : "");
        return s;
    }

    public static String getPriorityLevelString(int priority) {
        int status = EventLogConstants.eventPriorityToElementStatus(priority);
        String s = status == 0 ? PRIORITY_LEVEL_INFO_STRING : (status == 1 ? PRIORITY_LEVEL_WARNING_STRING : (status == 2 ? PRIORITY_LEVEL_ERROR_STRING : PRIORITY_LEVEL_UNKNOWN_STRING));
        return s;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static class EventData {
        String eventFormatString;
        String resourceKey;
        String[] tokens;

        public EventData(String eventFormatString, String resourceKey) {
            this.eventFormatString = eventFormatString;
            this.resourceKey = resourceKey;
        }

        public EventData(String eventFormatString, String resourceKey, String tokenList) {
            this.eventFormatString = eventFormatString;
            this.resourceKey = resourceKey;
            this.tokens = this.parseTokens(tokenList);
        }

        private String[] parseTokens(String tokenList) {
            StringTokenizer tokenizer = new StringTokenizer(tokenList, ",");
            String[] tokens = new String[tokenizer.countTokens()];
            int i = 0;
            while (i < tokens.length) {
                tokens[i] = tokenizer.nextToken();
                ++i;
            }
            return tokens;
        }
    }
}

