/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.net.acp.AcpEventLog;
import com.apple.util.plist.PropertyListUtilities;
import com.apple.xsr.eventlog.EventLocalizer;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class EventLog
extends AcpEventLog
implements ListModel {
    protected Comparator comparator;
    protected EventLocalizer localizer = new EventLocalizer();
    protected EventListenerList listenerList = new EventListenerList();
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$eventlog$EventLog != null ? class$com$apple$xsr$eventlog$EventLog : (class$com$apple$xsr$eventlog$EventLog = EventLog.class$("com.apple.xsr.eventlog.EventLog")));
    static /* synthetic */ Class class$com$apple$xsr$eventlog$EventLog;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public EventLog() {
    }

    public EventLog(EventLog eventLog) {
        this.comparator = eventLog.comparator;
        this.events = (ArrayList)eventLog.events.clone();
    }

    public EventLog(String inXML, int inControllerId) throws Exception {
        List array = (List)PropertyListUtilities.readXML(new StringReader(inXML));
        Iterator iter = array.iterator();
        while (iter.hasNext()) {
            AcpEventLog.Event event = new AcpEventLog.Event((String)iter.next(), inControllerId);
            this.events.add(event);
        }
        this.sort();
    }

    public EventLog(Iterator inIterator, int inControllerId) throws Exception {
        this.appendEvents(inIterator, inControllerId);
    }

    public synchronized void setSortOrder(Comparator c) {
        this.comparator = c;
    }

    public synchronized void appendEvents(Iterator inIterator) throws Exception {
        this.appendEvents(inIterator, -1);
    }

    public synchronized void appendEvents(Iterator inIterator, int inControllerId) throws Exception {
        while (inIterator.hasNext()) {
            String eventString = (String)inIterator.next();
            try {
                AcpEventLog.Event event = new AcpEventLog.Event(eventString, inControllerId);
                this.localizer.localize(event);
                this.events.add(event);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                logger.error("Unable to parse event \"" + eventString + "\". Possibly using old event format.");
            }
        }
        this.sort();
        this.fireListDataContentsChanged();
    }

    public synchronized AcpEventLog.Event getLastEvent(int controllerId) {
        if (this.events.isEmpty()) {
            return null;
        }
        Iterator iter = ((AbstractList)this.events).iterator();
        while (iter.hasNext()) {
            AcpEventLog.Event event = (AcpEventLog.Event)iter.next();
            if (event.getControllerId() != controllerId) continue;
            return event;
        }
        return null;
    }

    public synchronized void clearEvents() {
        super.clearEvents();
        this.fireListDataContentsChanged();
    }

    public void addListDataListener(ListDataListener listener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : (class$javax$swing$event$ListDataListener = EventLog.class$("javax.swing.event.ListDataListener")), listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : (class$javax$swing$event$ListDataListener = EventLog.class$("javax.swing.event.ListDataListener")), listener);
    }

    public int getSize() {
        return this.getEventCount();
    }

    public Object getElementAt(int index) {
        return this.events.get(index);
    }

    protected void fireListDataContentsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent event = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ListDataListener != null ? class$javax$swing$event$ListDataListener : EventLog.class$("javax.swing.event.ListDataListener"))) {
                if (event == null) {
                    event = new ListDataEvent(this, 0, -1, -1);
                }
                ((ListDataListener)listeners[i + 1]).contentsChanged(event);
            }
            i -= 2;
        }
    }

    protected void fireListDataIntervalAdded() {
        this.fireListDataContentsChanged();
    }

    protected void fireListDataIntervalRemoved() {
        this.fireListDataContentsChanged();
    }

    private void sort() {
        if (this.comparator == null) {
            Collections.sort(this.events);
        } else {
            Collections.sort(this.events, this.comparator);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

