/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.mrj.MRJFileUtils;
import com.apple.net.acp.AcpEventLog;
import com.apple.util.Gestalt;
import com.apple.util.ImageUtilities;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.StatusIndicator;
import com.apple.xsr.Utilities;
import com.apple.xsr.eventlog.EventLog;
import com.apple.xsr.eventlog.EventLogConstants;
import com.apple.xsr.eventlog.EventLogPane;
import com.apple.xsr.eventlog.EventPropertySheet;
import com.apple.xsr.som.RaidSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class EventLogPane
extends JPanel {
    public static final int TIME_FORMAT_12_HOUR = 12;
    public static final int TIME_FORMAT_24_HOUR = 24;
    public static final int COLUMN_PRIORITY = 0;
    public static final int COLUMN_CONTROLLER = 1;
    public static final int COLUMN_TIME = 2;
    public static final int COLUMN_EVENT = 3;
    private final String[] COLUMNS = new String[]{" ", " ", Resources.getString("eventLog.column.time"), Resources.getString("eventLog.column.event")};
    private static final int TABLE_ROW_HEIGHT = 20;
    private static final int COLUMN_WIDTH_PRIORITY = 20;
    private static final int COLUMN_WIDTH_CONTROLLER = 20;
    private static final String PRIORITY_LEVEL_INFO_STRING = Resources.getString("eventLog.priorityLevel.info");
    private static final String PRIORITY_LEVEL_WARNING_STRING = Resources.getString("eventLog.priorityLevel.warning");
    private static final String PRIORITY_LEVEL_ERROR_STRING = Resources.getString("eventLog.priorityLevel.error");
    private static final String PRIORITY_LEVEL_UNKNOWN_STRING = Resources.getString("eventLog.priorityLevel.unknown");
    private static final String UPPER_CONTROLLER_STRING = Resources.getString("eventLog.upperController");
    private static final String LOWER_CONTROLLER_STRING = Resources.getString("eventLog.lowerController");
    private static final String DATE_FORMAT_12_HOUR = Resources.getString("eventLog.twelveHourDateFormat");
    private static final String DATE_FORMAT_24_HOUR = Resources.getString("eventLog.twentyFourHourDateFormat");
    private static final String SHOW_INSPECTOR_KEY = "apple.showInspector";
    private static final String DESELECT_KEY = "apple.deselectRow";
    private RaidSystem system;
    private Model model;
    private AlternatingTable table;
    private JScrollPane scrollPane;
    private JFrame inspectorWindow;
    private EventPropertySheet propertySheet;
    private JButton printButton = GUIFactory.newButton(Resources.getString("eventLog.printButtonLabel"));
    private JButton saveButton = GUIFactory.newButton(Resources.getString("eventLog.saveButtonLabel"));
    private SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_12_HOUR);
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$eventlog$EventLogPane != null ? class$com$apple$xsr$eventlog$EventLogPane : (class$com$apple$xsr$eventlog$EventLogPane = EventLogPane.class$("com.apple.xsr.eventlog.EventLogPane")));
    static /* synthetic */ Class class$com$apple$xsr$eventlog$EventLogPane;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public EventLogPane() {
        GUIFactory.configureComponentForPlatform(this);
        this.model = new Model();
        this.table = new AlternatingTable(this.model);
        this.table.getSelectionModel().setSelectionMode(0);
        TableColumn priorityColumn = this.table.getColumnModel().getColumn(0);
        priorityColumn.setMinWidth(20);
        priorityColumn.setMaxWidth(20);
        priorityColumn.setResizable(false);
        priorityColumn.setCellRenderer(new PriorityRenderer());
        priorityColumn.setHeaderRenderer(new IconHeaderRenderer(Resources.getImage("icon.status.header")));
        TableColumn controllerColumn = this.table.getColumnModel().getColumn(1);
        controllerColumn.setMinWidth(20);
        controllerColumn.setMaxWidth(20);
        controllerColumn.setResizable(false);
        controllerColumn.setCellRenderer(new ControllerRenderer());
        controllerColumn.setHeaderRenderer(new IconHeaderRenderer(Resources.getImage("icon.controller.header")));
        TableColumn timeColumn = this.table.getColumnModel().getColumn(2);
        timeColumn.setMinWidth(135);
        timeColumn.setCellRenderer(new StringRenderer(this.dateFormat));
        TableColumn descriptionColumn = this.table.getColumnModel().getColumn(3);
        descriptionColumn.setMinWidth(250);
        descriptionColumn.setCellRenderer(new StringRenderer());
        GridBagLayout gbl = new GridBagLayout();
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 6, 16));
        this.setLayout(gbl);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        JPanel tablePanel = GUIFactory.newPanel(new BorderLayout());
        tablePanel.add((Component)this.scrollPane, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.add((Component)tablePanel, gbc);
        JPanel buttonPanel = this.createButtonPanel();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(8, 0, 2, 0);
        this.add((Component)buttonPanel, gbc);
        this.table.getSelectionModel().addListSelectionListener(new 1());
        this.scrollPane.addComponentListener(new 2());
        this.saveButton.addActionListener(new SaveAction());
        this.printButton.addActionListener(new PrintAction());
        this.setButtonsEnabled(false);
        ShowInspectorAction showInspectorAction = new ShowInspectorAction();
        DeselectAction deselectAction = new DeselectAction();
        ActionMap tableActionMap = this.table.getActionMap();
        InputMap tableInputMap = this.table.getInputMap(1);
        if (tableActionMap != null && tableInputMap != null) {
            tableActionMap.put(SHOW_INSPECTOR_KEY, showInspectorAction);
            tableInputMap.put(KeyStroke.getKeyStroke(10, 0), SHOW_INSPECTOR_KEY);
            tableActionMap.put(DESELECT_KEY, deselectAction);
            tableInputMap.put(KeyStroke.getKeyStroke(27, 0), DESELECT_KEY);
        }
        this.table.addMouseListener(showInspectorAction);
        Preferences prefs = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (prefs != null) {
            String defaultFormat = Gestalt.timeFormat == 12 ? "12" : "24";
            String format = prefs.getString("TimeFormat", defaultFormat);
            this.setTimeFormat(format);
            prefs.addPreferenceChangeListener(new 3());
        }
    }

    public void updateInfo(RaidSystem system) {
        this.system = system;
        if (system != null) {
            if (this.model.log != system.getEventLog()) {
                this.model.setEventLog(system.getEventLog());
            }
        } else {
            this.model.setEventLog(null);
            if (this.propertySheet != null) {
                this.propertySheet.setEvent(null);
            }
        }
    }

    public void setTimeFormat(int format) {
        if (format != 12 && format != 24) {
            throw new IllegalArgumentException("Invalid time format: " + format);
        }
        String formatString = format == 12 ? DATE_FORMAT_12_HOUR : DATE_FORMAT_24_HOUR;
        this.dateFormat.applyPattern(formatString);
        if (this.propertySheet != null) {
            this.propertySheet.setDateFormatString(formatString);
        }
    }

    public void setTimeFormat(String format) {
        if (format.equals("12")) {
            this.setTimeFormat(12);
        } else {
            this.setTimeFormat(24);
        }
    }

    private void displayInspectorWindow(int index) {
        AcpEventLog.Event event = this.model.getEvent(index);
        if (this.inspectorWindow == null) {
            this.propertySheet = new EventPropertySheet();
            Frame owner = (Frame)SwingUtilities.getWindowAncestor(this);
            this.inspectorWindow = new InspectorWindow(owner, this.propertySheet);
        }
        this.propertySheet.setEvent(event);
        this.inspectorWindow.show();
    }

    private void setButtonsEnabled(boolean state) {
        this.saveButton.setEnabled(state);
        this.printButton.setEnabled(state);
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = GUIFactory.newPanel();
        BoxLayout layout = new BoxLayout(buttonPanel, 0);
        buttonPanel.setLayout(layout);
        this.saveButton.setFont(GUIFactory.FONT_SMALL);
        this.printButton.setFont(GUIFactory.FONT_SMALL);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.saveButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        buttonPanel.add(this.printButton);
        return buttonPanel;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (EventLogPane.this.propertySheet != null) {
                int index = EventLogPane.this.table.getSelectedRow();
                EventLogPane.this.propertySheet.setEvent(EventLogPane.this.model.getEvent(index));
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            int tableWidth = EventLogPane.this.scrollPane.getViewport().getWidth();
            int totalWidth = EventLogPane.this.table.getColumnModel().getTotalColumnWidth();
            if (totalWidth != tableWidth) {
                TableColumn column = EventLogPane.this.table.getColumnModel().getColumn(3);
                column.setPreferredWidth(column.getWidth() + tableWidth - totalWidth);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Preferences.PreferenceChangeListener {
        public void preferenceChanged(Preferences.PreferenceChangeEvent e) {
            if (e.getKey().equals("TimeFormat")) {
                EventLogPane.this.setTimeFormat((String)e.getNewValue());
                EventLogPane.this.repaint();
            } else if (e.getKey().equals("UseShapes")) {
                EventLogPane.this.repaint();
            }
        }

        /* synthetic */ 3() {
        }
    }

    private class Model
    extends AbstractTableModel
    implements ListDataListener {
        EventLog log;

        public void setEventLog(EventLog log) {
            if (this.log != null) {
                this.log.removeListDataListener(this);
            }
            this.log = log;
            this.fireTableDataChanged();
            EventLogPane.this.setButtonsEnabled(this.log != null && this.log.getEventCount() > 0);
            if (log != null) {
                log.addListDataListener(this);
            }
        }

        public EventLog getEventLog() {
            return this.log;
        }

        public int getRowCount() {
            if (this.log == null) {
                return 0;
            }
            return this.log.getEventCount();
        }

        public int getColumnCount() {
            return EventLogPane.this.COLUMNS.length;
        }

        public AcpEventLog.Event getEvent(int row) {
            AcpEventLog.Event event = null;
            if (row != -1 && this.log != null) {
                event = this.log.getEvent(row);
            }
            return event;
        }

        public Object getValueAt(int row, int column) {
            Object value = null;
            if (this.log != null) {
                AcpEventLog.Event event = this.log.getEvent(row);
                switch (column) {
                    case 0: {
                        value = new Integer(event.getPriority());
                        break;
                    }
                    case 1: {
                        value = new Integer(event.getControllerId());
                        break;
                    }
                    case 2: {
                        value = event.getTime();
                        break;
                    }
                    case 3: {
                        value = event.getLocalizedMessage();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal column: " + column);
                    }
                }
            }
            return value;
        }

        public String getColumnName(int column) {
            if (column >= EventLogPane.this.COLUMNS.length) {
                throw new IllegalArgumentException("Illegal column: " + column);
            }
            return EventLogPane.this.COLUMNS[column];
        }

        public Class getColumnClass(int column) {
            Class columnClass = null;
            switch (column) {
                case 0: {
                    columnClass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = EventLogPane.class$("java.lang.Object"));
                    break;
                }
                case 1: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EventLogPane.class$("java.lang.String"));
                    break;
                }
                case 2: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EventLogPane.class$("java.lang.String"));
                    break;
                }
                case 3: {
                    columnClass = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = EventLogPane.class$("java.lang.String"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + column);
                }
            }
            return columnClass;
        }

        public void contentsChanged(ListDataEvent e) {
            SwingUtilities.invokeLater(new 4(this));
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }

        static /* synthetic */ EventLogPane access$0(Model $0) {
            return $0.EventLogPane.this;
        }
    }

    static class IconHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        public IconHeaderRenderer(Image image) {
            JLabel icon = new JLabel();
            icon.setIcon(new ImageIcon(image));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add(icon);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            return this;
        }
    }

    class PriorityRenderer
    extends JPanel
    implements TableCellRenderer {
        AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        StatusIndicator indicator = new StatusIndicator();

        public PriorityRenderer() {
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.setBorder(this.border);
            this.indicator.setStatus(-1);
            this.add(this.indicator);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            int status = EventLogConstants.eventPriorityToElementStatus((Integer)value);
            this.indicator.setStatus(status);
            if (status == 0) {
                this.setToolTipText(PRIORITY_LEVEL_INFO_STRING);
            } else if (status == 1) {
                this.setToolTipText(PRIORITY_LEVEL_WARNING_STRING);
            } else if (status == 64) {
                this.setToolTipText(PRIORITY_LEVEL_ERROR_STRING);
            } else {
                this.setToolTipText(PRIORITY_LEVEL_UNKNOWN_STRING);
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            return this;
        }
    }

    static class ControllerRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        private static final ImageIcon upper = new ImageIcon(Resources.getImage("icon.controller.upper"));
        private static final ImageIcon lower = new ImageIcon(Resources.getImage("icon.controller.lower"));
        private final ImageIcon upperSelected = new ImageIcon(this.createImage(new FilteredImageSource(upper.getImage().getSource(), ImageUtilities.getWhiteningFilterInstance())));
        private final ImageIcon lowerSelected = new ImageIcon(this.createImage(new FilteredImageSource(lower.getImage().getSource(), ImageUtilities.getWhiteningFilterInstance())));

        public ControllerRenderer() {
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.setBorder(this.border);
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            int id = (Integer)value;
            if (id == 1) {
                this.label.setIcon(isSelected ? this.upperSelected : upper);
                this.setToolTipText(UPPER_CONTROLLER_STRING);
            } else if (id == 2) {
                this.label.setIcon(isSelected ? this.lowerSelected : lower);
                this.setToolTipText(LOWER_CONTROLLER_STRING);
            } else {
                this.label.setIcon(null);
                this.setToolTipText("");
            }
            this.label.setForeground(isSelected ? Color.white : Color.black);
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            return this;
        }
    }

    static class StringRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label = new JLabel();
        private AlternatingTable.CellBorder border = new AlternatingTable.CellBorder();
        private Format formatter;

        public StringRenderer() {
            this((Format)null);
        }

        public StringRenderer(Format formatter) {
            this.formatter = formatter;
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(this.border);
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value == null) {
                return this;
            }
            this.border.setAttributes(isSelected, table.hasFocus(), row);
            if (this.formatter != null) {
                this.label.setText(this.formatter.format(value));
            } else {
                this.label.setText((String)value);
            }
            this.label.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    class SaveAction
    implements ActionListener {
        private final String ENCODING = "UTF-16";
        private final String DELIMITER = Resources.getString("eventLog.saveToFile.fieldDelimiter");

        public void actionPerformed(ActionEvent e) {
            String file = this.showSaveDialog();
            if (file != null) {
                this.saveLog(file);
            }
        }

        private String showSaveDialog() {
            String path = null;
            FileDialog dialog = this.createFileDialog();
            dialog.show();
            if (dialog.getDirectory() != null && dialog.getFile() != null) {
                path = String.valueOf(dialog.getDirectory()) + dialog.getFile();
            }
            dialog.dispose();
            return path;
        }

        private FileDialog createFileDialog() {
            Component root;
            String title = "";
            String startDir = null;
            if (Gestalt.isMacOS()) {
                try {
                    startDir = MRJFileUtils.findFolder(MRJFileUtils.kDesktopFolderType).getPath();
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            if ((root = SwingUtilities.getRoot(EventLogPane.this)) == null || !(root instanceof Frame)) {
                throw new NullPointerException("Could not find root frame for " + EventLogPane.this.getName());
            }
            FileDialog dialog = new FileDialog((Frame)root, title, 1);
            String filename = Resources.getStringWithReplacement("eventLog.saveToFile.defaultFilename", new Object[]{"system_name", EventLogPane.this.system.getName()});
            dialog.setFile(filename);
            if (startDir != null) {
                dialog.setDirectory(startDir);
            }
            return dialog;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void saveLog(String file) {
            EventLog log = EventLogPane.this.system.getEventLog();
            if (log.getEventCount() <= 0) return;
            BufferedWriter out = null;
            try {
                try {
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-16"));
                    Iterator iter = log.getEvents();
                    while (iter.hasNext()) {
                        AcpEventLog.Event event = (AcpEventLog.Event)iter.next();
                        String line = "";
                        int status = EventLogConstants.eventPriorityToElementStatus(event.getPriority());
                        line = status == 0 ? String.valueOf(line) + " " : (status == 1 ? String.valueOf(line) + PRIORITY_LEVEL_WARNING_STRING : (status == 64 ? String.valueOf(line) + PRIORITY_LEVEL_ERROR_STRING : String.valueOf(line) + " "));
                        line = String.valueOf(line) + this.DELIMITER;
                        line = event.getControllerId() == 1 ? String.valueOf(line) + UPPER_CONTROLLER_STRING : String.valueOf(line) + LOWER_CONTROLLER_STRING;
                        line = String.valueOf(line) + this.DELIMITER;
                        line = String.valueOf(line) + EventLogPane.this.dateFormat.format(event.getTime()) + this.DELIMITER;
                        line = String.valueOf(line) + event.getLocalizedMessage();
                        out.write(line);
                        out.newLine();
                    }
                }
                catch (IOException iOException) {
                }
                Object var5_8 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
                return;
            }
            catch (IOException iOException) {}
        }

        SaveAction() {
        }
    }

    class PrintAction
    implements ActionListener,
    Printable {
        private final String COLUMN_HEADING_PRIORITY = Resources.getString("eventLog.print.column.priority");
        private final String COLUMN_HEADING_CONTROLLER = Resources.getString("eventLog.print.column.controller");
        private final String COLUMN_HEADING_TIME = Resources.getString("eventLog.print.column.time");
        private final String COLUMN_HEADING_EVENT = Resources.getString("eventLog.print.column.event");
        private final int HEADER_HEIGHT = 45;
        private final int FOOTER_HEIGHT = 0;
        private final int[] COLUMN_OFFSETS;
        private final Font font;
        private final float fontSize;
        private final Color color;
        private EventLog log;

        public void actionPerformed(ActionEvent e) {
            block3: {
                this.log = EventLogPane.this.system.getEventLog();
                if (this.log == null) break block3;
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPrintable(this);
                try {
                    if (job.printDialog()) {
                        job.print();
                    }
                }
                catch (PrinterException printerException) {}
            }
        }

        public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
            double bodyHeight = pageFormat.getImageableHeight() - 45.0 - 0.0;
            int eventsPerPage = (int)(bodyHeight / (double)this.fontSize) - (bodyHeight % (double)this.fontSize > 0.0 ? 1 : 0);
            int count = this.log.getEventCount();
            int pages = count / eventsPerPage + (count % eventsPerPage > 0 ? 1 : 0);
            if (pageIndex > pages - 1) {
                return 1;
            }
            logger.info("Printing event log page index " + pageIndex + ". Count = " + count + " Pages = " + pages);
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g.setFont(this.font);
            g.setColor(this.color);
            this.renderHeader(g2, pageFormat, pageIndex);
            this.renderBody(g2, pageFormat, pageIndex);
            this.renderFooter(g2, pageFormat, pageIndex);
            return 0;
        }

        private void renderBody(Graphics2D g, PageFormat pageFormat, int pageIndex) {
            int x = 0;
            int y = 45;
            double bodyHeight = pageFormat.getImageableHeight() - 45.0 - 0.0;
            int eventsPerPage = (int)(bodyHeight / (double)this.fontSize) - (bodyHeight % (double)this.fontSize > 0.0 ? 1 : 0);
            int count = 0;
            Iterator iter = this.log.getEvents(eventsPerPage * pageIndex);
            while (iter.hasNext() && count < eventsPerPage) {
                AcpEventLog.Event event = (AcpEventLog.Event)iter.next();
                int status = EventLogConstants.eventPriorityToElementStatus(event.getPriority());
                String field = status == 0 ? " " : (status == 1 ? PRIORITY_LEVEL_WARNING_STRING : (status == 64 ? PRIORITY_LEVEL_ERROR_STRING : " "));
                g.drawString(field, x + this.COLUMN_OFFSETS[0], y);
                field = event.getControllerId() == 1 ? UPPER_CONTROLLER_STRING : LOWER_CONTROLLER_STRING;
                g.drawString(field, x + this.COLUMN_OFFSETS[1], y);
                field = EventLogPane.this.dateFormat.format(event.getTime());
                g.drawString(field, x + this.COLUMN_OFFSETS[2], y);
                field = event.getLocalizedMessage();
                g.drawString(field, x + this.COLUMN_OFFSETS[3], y);
                y = (int)((float)y + this.fontSize);
                ++count;
            }
        }

        private void renderHeader(Graphics2D g, PageFormat pageFormat, int pageIndex) {
            int x = 0;
            int y = (int)this.fontSize;
            double pageWidth = pageFormat.getImageableWidth();
            FontRenderContext context = g.getFontRenderContext();
            String title = Resources.getStringWithReplacement("eventLog.print.pageTitle", new Object[]{"system_name", EventLogPane.this.system.getName()});
            Rectangle2D bounds = this.font.getStringBounds(title, context);
            g.setFont(this.font.deriveFont(1));
            g.drawString(title, (float)(pageWidth / 2.0 - bounds.getWidth() / 2.0), (float)y);
            g.setFont(this.font);
            y = (int)((float)y + this.fontSize * 2.0f);
            g.drawString(this.COLUMN_HEADING_PRIORITY, x + this.COLUMN_OFFSETS[0], y);
            g.drawString(this.COLUMN_HEADING_CONTROLLER, x + this.COLUMN_OFFSETS[1], y);
            g.drawString(this.COLUMN_HEADING_TIME, x + this.COLUMN_OFFSETS[2], y);
            g.drawString(this.COLUMN_HEADING_EVENT, x + this.COLUMN_OFFSETS[3], y);
            String page = Resources.getStringWithReplacement("eventLog.print.pageNumber", new Object[]{"page", String.valueOf(pageIndex + 1)});
            bounds = this.font.getStringBounds(page, context);
            g.drawString(page, (int)(pageWidth - bounds.getWidth()), y);
            y = (int)((float)y + this.fontSize / 2.0f);
            g.drawLine(x, y, (int)pageWidth, y);
        }

        private void renderFooter(Graphics2D g, PageFormat pageFormat, int pageIndex) {
        }

        PrintAction() {
            int[] nArray = new int[4];
            nArray[1] = 50;
            nArray[2] = 140;
            nArray[3] = 250;
            this.COLUMN_OFFSETS = nArray;
            this.font = GUIFactory.FONT_PRINT;
            this.fontSize = this.font.getSize();
            this.color = Color.black;
        }
    }

    private class DeselectAction
    extends AbstractAction {
        public DeselectAction() {
            this.putValue("ActionCommandKey", EventLogPane.DESELECT_KEY);
            this.putValue("LongDescription", "");
            this.putValue("ShortDescription", "");
            this.putValue("SmallIcon", null);
        }

        public void actionPerformed(ActionEvent e) {
            EventLogPane.this.table.clearSelection();
        }
    }

    private class ShowInspectorAction
    extends AbstractAction
    implements MouseListener {
        public ShowInspectorAction() {
            this.putValue("ActionCommandKey", EventLogPane.SHOW_INSPECTOR_KEY);
            this.putValue("LongDescription", "");
            this.putValue("ShortDescription", "");
            this.putValue("SmallIcon", null);
        }

        public void actionPerformed(ActionEvent e) {
            int row = EventLogPane.this.table.getSelectedRow();
            this.showInspector(row);
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = EventLogPane.this.table.rowAtPoint(e.getPoint());
                this.showInspector(row);
            }
        }

        private void showInspector(int row) {
            if (row >= 0 && row <= EventLogPane.this.table.getRowCount()) {
                EventLogPane.this.displayInspectorWindow(row);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class InspectorWindow
    extends JFrame {
        private static final int WIDTH = 450;
        private static final int HEIGHT = 350;

        public InspectorWindow(Frame owner, EventPropertySheet propertySheet) {
            propertySheet.setBorder(BorderFactory.createEmptyBorder(20, 20, 28, 20));
            Container c = this.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)propertySheet, "Center");
            this.setTitle(Resources.getString("eventLog.propertiesDialog.windowTitle"));
            this.setJMenuBar(RaidAdmin.newMenuBar(1));
            this.setDefaultCloseOperation(2);
            ((Component)this).setSize(450, 350);
            this.setResizable(false);
            Utilities.setWindowLocationRelativeToComponent(this, owner);
            propertySheet.addActionListener(new 5(this));
        }

        static /* synthetic */ EventLogPane access$0(InspectorWindow $0) {
            return $0.EventLogPane.this;
        }
    }
}

