/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.eventlog;

import com.apple.gui.GUIFactory;
import com.apple.net.acp.AcpEventLog;
import com.apple.xsr.Resources;
import com.apple.xsr.eventlog.EventLocalizer;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class EventPropertySheet
extends JPanel {
    public static final String ACTION_PREVIOUS = "PREVIOUS";
    public static final String ACTION_NEXT = "NEXT";
    public static final String ACTION_COPY = "COPY";
    public static final String ACTION_OK = "OK";
    private SimpleDateFormat fullDateFormat;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private AcpEventLog.Event event;
    private static final String DATE_HEADING = Resources.getString("eventLog.propertiesDialog.dateLabel");
    private static final String TIME_HEADING = Resources.getString("eventLog.propertiesDialog.timeLabel");
    private static final String TIMESTAMP_HEADING = Resources.getString("eventLog.propertiesDialog.timestampLabel");
    private static final String PRIORITY_HEADING = Resources.getString("eventLog.propertiesDialog.priorityLabel");
    private static final String CONTROLLER_HEADING = Resources.getString("eventLog.propertiesDialog.controllerLabel");
    private static final String TYPE_HEADING = Resources.getString("eventLog.propertiesDialog.typeLabel");
    private static final String EVENT_ID_HEADING = Resources.getString("eventLog.propertiesDialog.sequenceIdLabel");
    private static final String MESSAGE_HEADING = Resources.getString("eventLog.propertiesDialog.message");
    private static final String DESCRIPTION_HEADING = Resources.getString("eventLog.propertiesDialog.descriptionLabel");
    private static final String UNKNOWN = Resources.getString("som.unknown");
    private final JLabel dateLabel = new JLabel();
    private final JLabel timeLabel = new JLabel();
    private final JLabel priorityLabel = new JLabel();
    private final JLabel controllerLabel = new JLabel();
    private final JLabel typeLabel = new JLabel();
    private final JLabel idLabel = new JLabel();
    private final JButton previousBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.previous")));
    private final JButton nextBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.next")));
    private final JButton copyBtn = GUIFactory.newButton(new ImageIcon(Resources.getImage("icon.eventProperty.copy")));
    private final JButton okBtn = GUIFactory.newOKButton();
    private final JTextPane messageText = GUIFactory.newTextPane();
    private final JTextPane descText = GUIFactory.newTextPane();
    private static final String DELIMITER = "\t";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Insets noInsets = new Insets(0, 0, 0, 0);

    public EventPropertySheet() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.createInfoPanel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 12;
        gbc.fill = 0;
        this.add((Component)this.createButtonPanel(), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.add((Component)this.createMessagePanel(), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.createDescriptionPanel(), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 0, 0, 0);
        this.setDateFormatString(Resources.getString("eventLog.twelveHourDateFormat"));
    }

    public void setEvent(AcpEventLog.Event event) {
        boolean btnsEnabled;
        this.event = event;
        if (event != null) {
            this.setDateTime(event.getTime());
            this.setPriority(EventLocalizer.getPriorityLevelString(event.getPriority()));
            this.setController(EventLocalizer.getControllerString(event.getControllerId()));
            this.setType(String.valueOf(event.getType()));
            this.setEventId(String.valueOf(event.getSequenceId()));
            this.setMessage(event.getLocalizedMessage());
            this.setDescription(event.getDescription());
            btnsEnabled = true;
        } else {
            this.setDateTime(null);
            this.setPriority(UNKNOWN);
            this.setController(UNKNOWN);
            this.setType(UNKNOWN);
            this.setEventId(UNKNOWN);
            this.setMessage(UNKNOWN);
            this.setDescription(UNKNOWN);
            btnsEnabled = false;
        }
        this.previousBtn.setEnabled(btnsEnabled);
        this.nextBtn.setEnabled(btnsEnabled);
        this.copyBtn.setEnabled(btnsEnabled);
    }

    public void setDateTime(Date date) {
        if (date != null) {
            this.dateLabel.setText(this.dateFormat.format(date));
            this.timeLabel.setText(this.timeFormat.format(date));
        } else {
            this.dateLabel.setText(UNKNOWN);
            this.timeLabel.setText(UNKNOWN);
        }
    }

    public void setPriority(String priority) {
        this.priorityLabel.setText(priority);
    }

    public void setController(String controller) {
        this.controllerLabel.setText(controller);
    }

    public void setType(String type) {
        this.typeLabel.setText(type);
    }

    public void setEventId(String id) {
        this.idLabel.setText(id);
    }

    public void setMessage(String message) {
        this.messageText.setText(message);
    }

    public void setDescription(String description) {
        this.descText.setText(description);
    }

    public void setDateFormatString(String formatString) {
        this.fullDateFormat = new SimpleDateFormat(formatString);
        this.splitDateFormatString(formatString);
        if (this.event != null) {
            this.setDateTime(this.event.getTime());
        }
    }

    public void addActionListener(ActionListener l) {
        this.previousBtn.addActionListener(l);
        this.nextBtn.addActionListener(l);
        this.okBtn.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.previousBtn.removeActionListener(l);
        this.nextBtn.removeActionListener(l);
        this.okBtn.removeActionListener(l);
    }

    private String eventToString(AcpEventLog.Event event) {
        String s = "";
        s = String.valueOf(s) + TIMESTAMP_HEADING + DELIMITER + this.fullDateFormat.format(event.getTime()) + NEWLINE;
        s = String.valueOf(s) + PRIORITY_HEADING + DELIMITER + EventLocalizer.getPriorityLevelString(event.getPriority()) + NEWLINE;
        s = String.valueOf(s) + CONTROLLER_HEADING + DELIMITER + EventLocalizer.getControllerString(event.getControllerId()) + NEWLINE;
        s = String.valueOf(s) + TYPE_HEADING + DELIMITER + event.getType() + NEWLINE;
        s = String.valueOf(s) + EVENT_ID_HEADING + DELIMITER + event.getSequenceId() + NEWLINE;
        s = String.valueOf(s) + MESSAGE_HEADING + DELIMITER + event.getLocalizedMessage() + NEWLINE;
        s = String.valueOf(s) + DESCRIPTION_HEADING + DELIMITER + event.getDescription() + NEWLINE;
        return s;
    }

    private void splitDateFormatString(String formatString) {
        char[] splitChars = new char[]{'h', 'H', 'k', 'K'};
        int pos = -1;
        int i = 0;
        while (i < splitChars.length) {
            pos = formatString.indexOf(splitChars[i]);
            if (pos != -1) break;
            ++i;
        }
        this.dateFormat = new SimpleDateFormat(formatString.substring(0, pos));
        this.timeFormat = new SimpleDateFormat(formatString.substring(pos));
    }

    private JPanel createInfoPanel() {
        int minColWidth = 25;
        JPanel panel = GUIFactory.newPanel(new GridBagLayout());
        int col = 0;
        int row = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        Insets headInsets = new Insets(4, 0, 4, 8);
        Insets lblInsets = new Insets(4, 0, 4, 14);
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 4, 8);
        JLabel dateHeading = new JLabel(DATE_HEADING);
        dateHeading.setFont(GUIFactory.FONT_SMALL);
        dateHeading.setHorizontalAlignment(4);
        panel.add((Component)dateHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 4, 14);
        gbc.ipadx = minColWidth;
        this.dateLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.dateLabel, gbc);
        gbc.ipadx = 0;
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.weightx = 0.0;
        gbc.insets = headInsets;
        JLabel timeHeading = new JLabel(TIME_HEADING);
        timeHeading.setFont(GUIFactory.FONT_SMALL);
        timeHeading.setHorizontalAlignment(4);
        panel.add((Component)timeHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = lblInsets;
        this.timeLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.timeLabel, gbc);
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.weightx = 0.0;
        gbc.insets = headInsets;
        JLabel priorityHeading = new JLabel(PRIORITY_HEADING);
        priorityHeading.setFont(GUIFactory.FONT_SMALL);
        priorityHeading.setHorizontalAlignment(4);
        panel.add((Component)priorityHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = lblInsets;
        this.priorityLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.priorityLabel, gbc);
        headInsets = new Insets(4, 0, 4, 8);
        lblInsets = new Insets(4, 0, 4, 0);
        row = 0;
        gbc.gridx = col += 2;
        gbc.gridy = row++;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 4, 8);
        JLabel controllerHeading = new JLabel(CONTROLLER_HEADING);
        controllerHeading.setFont(GUIFactory.FONT_SMALL);
        controllerHeading.setHorizontalAlignment(4);
        panel.add((Component)controllerHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 4, 0);
        gbc.ipadx = minColWidth;
        this.controllerLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.controllerLabel, gbc);
        gbc.ipadx = 0;
        gbc.gridx = col;
        gbc.gridy = row++;
        gbc.weightx = 0.0;
        gbc.insets = headInsets;
        JLabel typeHeading = new JLabel(TYPE_HEADING);
        typeHeading.setFont(GUIFactory.FONT_SMALL);
        typeHeading.setHorizontalAlignment(4);
        panel.add((Component)typeHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = lblInsets;
        this.typeLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.typeLabel, gbc);
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.weightx = 0.0;
        gbc.insets = headInsets;
        JLabel idHeading = new JLabel(EVENT_ID_HEADING);
        idHeading.setFont(GUIFactory.FONT_SMALL);
        idHeading.setHorizontalAlignment(4);
        panel.add((Component)idHeading, gbc);
        gbc.gridx = col + 1;
        gbc.weightx = 1.0;
        gbc.insets = lblInsets;
        this.idLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)this.idLabel, gbc);
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = GUIFactory.newPanel(new GridLayout(3, 1, 0, 4));
        this.previousBtn.setActionCommand(ACTION_PREVIOUS);
        this.nextBtn.setActionCommand(ACTION_NEXT);
        this.copyBtn.setActionCommand(ACTION_COPY);
        this.copyBtn.setToolTipText(Resources.getString("eventLog.propertiesDialog.copyTip"));
        this.copyBtn.addActionListener(new 1());
        panel.add(this.previousBtn);
        panel.add(this.nextBtn);
        panel.add(this.copyBtn);
        return panel;
    }

    private JPanel createMessagePanel() {
        JPanel panel = GUIFactory.newPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 4, 0);
        JLabel titleLabel = new JLabel(MESSAGE_HEADING);
        titleLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)titleLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.messageText.setFont(GUIFactory.FONT_SMALL);
        this.messageText.setEditable(false);
        this.messageText.setBorder(BorderFactory.createBevelBorder(1));
        panel.add((Component)this.messageText, gbc);
        return panel;
    }

    private JPanel createDescriptionPanel() {
        JPanel panel = GUIFactory.newPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 4, 0);
        JLabel titleLabel = new JLabel(DESCRIPTION_HEADING);
        titleLabel.setFont(GUIFactory.FONT_SMALL);
        panel.add((Component)titleLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.descText.setFont(GUIFactory.FONT_SMALL);
        this.descText.setEditable(false);
        this.descText.setBorder(BorderFactory.createBevelBorder(1));
        panel.add((Component)this.descText, gbc);
        return panel;
    }

    private JPanel createOkButtonPanel() {
        JPanel panel = GUIFactory.newPanel(new FlowLayout(2, 0, 0));
        this.okBtn.setFont(GUIFactory.FONT_SMALL);
        this.okBtn.setActionCommand(ACTION_OK);
        panel.add(this.okBtn);
        return panel;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            StringSelection eventData = new StringSelection(EventPropertySheet.this.eventToString(EventPropertySheet.this.event));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(eventData, eventData);
        }

        /* synthetic */ 1() {
        }
    }
}

