/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.Resources;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.som.RaidSet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class ConditionPane
extends AbstractFirstAidPane {
    public static final String TAG = "CONDITION_PANE";
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();
    private static final String START;
    private static final String PAUSE;
    private static final String RESUME;
    private static final String STOP;
    private static final String CONFIRM_DEFAULT;
    private static final String CONFIRM_START;
    private static final String CONFIRM_PAUSE;
    private static final String CONFIRM_RESUME;
    private static final String CONFIRM_STOP;
    private static final String BUTTON_START;
    private static final String BUTTON_PAUSE;
    private static final String BUTTON_RESUME;
    private static final String BUTTON_STOP;
    private static final int[] PRIORITIES;
    private JComboBox actionCombo;
    private JComboBox priorityCombo;
    private int operation = 2;

    static {
        ConditionPane.props.icon = new ImageIcon(Resources.getImage("icon.condition"));
        ConditionPane.props.title = Resources.getString("firstAid.condition");
        ConditionPane.props.explanation = Resources.getString("firstAid.conditionExplanation");
        ConditionPane.props.tag = TAG;
        ConditionPane.props.headerText = Resources.getString("firstAid.condition.selectArray");
        ConditionPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        ConditionPane.props.confirmTitle = Resources.getString("firstAid.condition.confirmation");
        ConditionPane.props.confirmText = Resources.getString("firstAid.condition.iUnderstand.start");
        ConditionPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        ConditionPane.props.summaryText = Resources.getString("firstAid.condition.summary.cannot.general");
        ConditionPane.props.actionButtonText = Resources.getString("firstAid.condition.actionButton.start");
        ConditionPane.props.driveSelectionMode = 10;
        ConditionPane.props.arraySelectionMode = 1;
        START = Resources.getString("firstAid.condition.start");
        PAUSE = Resources.getString("firstAid.condition.pause");
        RESUME = Resources.getString("firstAid.condition.resume");
        STOP = Resources.getString("firstAid.condition.stop");
        CONFIRM_DEFAULT = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_START = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_PAUSE = Resources.getString("firstAid.condition.iUnderstand.pause");
        CONFIRM_RESUME = Resources.getString("firstAid.condition.iUnderstand.start");
        CONFIRM_STOP = Resources.getString("firstAid.condition.iUnderstand.stop");
        BUTTON_START = Resources.getString("firstAid.condition.actionButton.start");
        BUTTON_PAUSE = Resources.getString("firstAid.condition.actionButton.pause");
        BUTTON_RESUME = Resources.getString("firstAid.condition.actionButton.resume");
        BUTTON_STOP = Resources.getString("firstAid.condition.actionButton.stop");
        PRIORITIES = new int[]{50, 75, 100};
    }

    public ConditionPane(AbstractChooserMgmtPane parent) {
        super(parent, props);
        1 selectionListener = new 1();
        this.driveSelectionPanel.addPropertyChangeListener("ArrayIndex", selectionListener);
        this.legend.addPropertyChangeListener("ArrayIndex", selectionListener);
    }

    public void populateUI(DataModel data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(data instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
        }
        FirstAidDataModel model = (FirstAidDataModel)data;
        this.system = model.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
        int priority = model.getConditioningPriority();
        int index = 0;
        int i = PRIORITIES.length - 1;
        while (i >= 0) {
            if (priority >= PRIORITIES[i]) {
                index = i;
                break;
            }
            --i;
        }
        this.priorityCombo.setSelectedIndex(index);
    }

    public boolean validateUI(DataModel data) {
        if (data != null && AbstractFirstAidPane.paneExecuted.equals(TAG)) {
            if (!(data instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
            }
            FirstAidDataModel model = (FirstAidDataModel)data;
            model.setArrayID(this.driveSelectionPanel.getSelectedArray());
            model.setOperation(this.operation);
            int popUpIndex = this.priorityCombo.getSelectedIndex();
            if (popUpIndex >= PRIORITIES.length || popUpIndex < 0) {
                throw new IllegalStateException("Illegal priority pop up index returned!");
            }
            model.setConditioningPriority(PRIORITIES[popUpIndex]);
        }
        return true;
    }

    protected void addSteps() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.addStep(this.getNextStep(), Resources.getString("firstAid.condition.optionsTitle"));
        this.actionCombo = new JComboBox<String>(new String[]{START});
        this.actionCombo.setFont(GUIFactory.FONT_SMALL);
        this.actionCombo.setRequestFocusEnabled(false);
        this.actionCombo.addActionListener(new ActionComboListener());
        optionsPanel.add(this.actionCombo);
        this.priorityCombo = new JComboBox<String>(new String[]{Resources.getString("firstAid.condition.priorityLow"), Resources.getString("firstAid.condition.priorityMedium"), Resources.getString("firstAid.condition.priorityHigh")});
        this.priorityCombo.setFont(GUIFactory.FONT_SMALL);
        this.priorityCombo.setRequestFocusEnabled(false);
        optionsPanel.add(this.priorityCombo);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this.getCurrentRow();
        gbc.insets = new Insets(0, 20, 15, 0);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        this.add((Component)optionsPanel, gbc);
        this.setCurrentRow(gbc.gridy + 1);
    }

    private void updateControlsForRaidSet(int raidSetId) {
        RaidSet rs;
        boolean inProgress = false;
        int state = -1;
        if (this.system != null && raidSetId > 0 && (rs = this.system.getRaidSet(raidSetId)) != null) {
            inProgress = rs.getOperation() == 5;
            state = rs.getBackgroundConditioningState();
        }
        if (inProgress) {
            if (this.actionCombo.getItemCount() == 2) {
                return;
            }
            this.actionCombo.removeAllItems();
            this.actionCombo.addItem(state == 1 ? RESUME : PAUSE);
            this.actionCombo.addItem(STOP);
        } else {
            if (this.actionCombo.getItemCount() == 1) {
                return;
            }
            this.actionCombo.removeAllItems();
            this.actionCombo.addItem(START);
        }
    }

    static /* synthetic */ int access$3(ConditionPane $0) {
        return $0.operation;
    }

    private class ActionComboListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (ConditionPane.this.actionCombo.getItemCount() == 0) {
                return;
            }
            Object action = ConditionPane.this.actionCombo.getSelectedItem();
            boolean priorityEnabled = true;
            if (action.equals(START)) {
                ConditionPane.this.operation = 2;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(10);
                ConditionPane.this.buttons.okButton.setText(BUTTON_START);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_START);
            } else if (action.equals(PAUSE)) {
                ConditionPane.this.operation = 3;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(11);
                ConditionPane.this.buttons.okButton.setText(BUTTON_PAUSE);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_PAUSE);
                priorityEnabled = false;
            } else if (action.equals(RESUME)) {
                ConditionPane.this.operation = 4;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(12);
                ConditionPane.this.buttons.okButton.setText(BUTTON_RESUME);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_RESUME);
            } else if (action.equals(STOP)) {
                ConditionPane.this.operation = 5;
                ConditionPane.this.driveSelectionPanel.setSelectionMode(13);
                ConditionPane.this.buttons.okButton.setText(BUTTON_STOP);
                ConditionPane.this.confirmCheckBox.setText(CONFIRM_STOP);
                priorityEnabled = false;
            }
            ConditionPane.this.priorityCombo.setEnabled(priorityEnabled);
        }

        ActionComboListener() {
        }
    }

    private final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            int value = (Integer)e.getNewValue();
            ConditionPane.this.updateControlsForRaidSet(value);
        }

        /* synthetic */ 1() {
        }
    }
}

