/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInfoPanelController;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DriveSelectionPanelEx;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;

class ManageOrphansPane
extends AbstractFirstAidPane {
    public static final String TAG = "MANAGE_ORPHANS_PANE";
    private static final Image IMG_VALIDATE_OK = Resources.getImage("icon.step.four");
    private static final Image IMG_VALIDATE_ERROR = Resources.getImage("icon.step.five");
    private static final String SUMMARY_CAN = Resources.getString("firstAid.manageOrphans.summary.can");
    private static final String SUMMARY_CANNOT = Resources.getString("firstAid.manageOrphans.summary.cannot.general");
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();

    static {
        ManageOrphansPane.props.icon = new ImageIcon(Resources.getImage("icon.manageOrphans"));
        ManageOrphansPane.props.title = Resources.getString("firstAid.manageOrphans");
        ManageOrphansPane.props.explanation = Resources.getString("firstAid.manageOrphansExplanation");
        ManageOrphansPane.props.tag = TAG;
        ManageOrphansPane.props.headerText = Resources.getString("firstAid.manageOrphans.selectArray");
        ManageOrphansPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        ManageOrphansPane.props.confirmTitle = Resources.getString("firstAid.manageOrphans.confirmation");
        ManageOrphansPane.props.confirmText = Resources.getString("firstAid.manageOrphans.iUnderstand");
        ManageOrphansPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        ManageOrphansPane.props.actionButtonText = Resources.getString("firstAid.manageOrphans.actionButton");
        ManageOrphansPane.props.driveSelectionMode = 1;
        ManageOrphansPane.props.arraySelectionMode = 0;
    }

    public ManageOrphansPane(AbstractChooserMgmtPane parent) {
        super(parent, props);
    }

    public void populateUI(DataModel data) {
        if (data == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(data instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
        }
        FirstAidDataModel model = (FirstAidDataModel)data;
        this.system = model.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
    }

    public boolean validateUI(DataModel data) {
        if (data != null && AbstractFirstAidPane.paneExecuted.equals(TAG)) {
            if (!(data instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + data.getClass() + "\"");
            }
            FirstAidDataModel model = (FirstAidDataModel)data;
            model.setOperation(6);
            Object[] selected = ((DriveSelectionPanelEx)this.driveSelectionPanel).getSelectedObjects();
            int driveID = (Integer)selected[0];
            model.setDriveID(driveID);
            model.setControllerID(this.system.getDisk(driveID).getRaidController().getId());
        }
        return true;
    }

    protected final JPanel createDrivePanel(int selectionMode, StepByStepPanel summaryHeader, JTextPane summaryLabel, JButton okButton) {
        JPanel drivePanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInfo = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanelEx(selectionMode);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).setSelectionPolicy(new DrivePanel.DefaultSelectionPolicy(1, 4));
        DriveInfoPanelController infoController = new DriveInfoPanelController(driveInfo);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(infoController);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 20);
        drivePanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 6, 0);
        drivePanel.add((Component)driveInfo, gbc);
        return drivePanel;
    }

    protected void addSteps() {
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addItemListener(new 1());
        this.confirmCheckBox.addActionListener(new 2());
        this.summaryLabel.setText(SUMMARY_CANNOT);
        this.buttons.okButton.setEnabled(false);
    }

    private void setPaneValid(boolean valid) {
        this.buttons.okButton.setEnabled(valid);
        this.summaryHeader.setIcon(valid ? IMG_VALIDATE_OK : IMG_VALIDATE_ERROR);
        this.summaryLabel.setText(valid ? SUMMARY_CAN : SUMMARY_CANNOT);
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            Object[] selected = e.getItemSelectable().getSelectedObjects();
            boolean checked = ManageOrphansPane.this.confirmCheckBox.isSelected();
            boolean valid = checked & selected.length > 0;
            ManageOrphansPane.this.setPaneValid(valid);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            boolean checked = ((AbstractButton)e.getSource()).isSelected();
            Object[] selected = ((DriveSelectionPanelEx)ManageOrphansPane.this.driveSelectionPanel).getSelectedObjects();
            boolean valid = checked && selected.length > 0;
            ManageOrphansPane.this.setPaneValid(valid);
        }

        /* synthetic */ 2() {
        }
    }
}

