/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.RequestMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public abstract class AbstractRequestMessage
implements RequestMessage {
    protected String path = "";
    protected String command;
    protected RequestMessage.Target xsyncTarget;
    protected int timeout = 0;
    protected String user;
    protected String password;
    protected boolean shutdown = false;
    protected int restart = -1;
    protected HashMap properties = new HashMap();

    public AbstractRequestMessage() {
    }

    public AbstractRequestMessage(RequestMessage.Target target, int timeout, String path) {
        this(target, timeout, path, null);
    }

    public AbstractRequestMessage(RequestMessage.Target target, int timeout, String path, String command) {
        this.xsyncTarget = target;
        this.timeout = timeout;
        this.path = path;
        this.command = command;
    }

    public RequestMessage.Target getTargetController() {
        return this.xsyncTarget;
    }

    public void setTargetController(RequestMessage.Target target) {
        this.xsyncTarget = target;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    public String getPath() {
        return this.path;
    }

    public String getCommand() {
        return this.command;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setShutdownConnection(boolean on) {
        this.shutdown = on;
    }

    public boolean getShutdownConnection() {
        return this.shutdown;
    }

    public void setRestartConnection(boolean on, int delay) {
        if (delay < 0) {
            delay = 0;
        }
        this.restart = on ? delay : -1;
    }

    public int getRestartConnection() {
        return this.restart;
    }

    public void setRequestProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getRequestProperty(String key) {
        return (String)this.properties.get(key);
    }

    public String[] getRequestProperties() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Path: " + this.path + "\n");
        s.append("Command: " + this.command + "\n");
        s.append("Xsync Target: " + this.xsyncTarget + "\n");
        s.append("Timeout: " + this.timeout + "\n");
        s.append("User: " + this.user + "\n");
        s.append("Password: " + this.password + "\n");
        return s.toString();
    }

    public Object clone() {
        try {
            AbstractRequestMessage result = (AbstractRequestMessage)super.clone();
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }
}

