/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.net.acp.SimpleCryptInputStream;
import com.apple.net.acp.SimpleCryptOutputStream;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpRequest;
import com.apple.xsr.net.HttpResponse;
import com.apple.xsr.net.RequestMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class AcpxConnection {
    public static final String PLIST_EXCEPTION = "PropertyListException";
    private static final boolean DEFAULT_PERSISTENT_CONNECTION_STATE = true;
    private static final boolean DEFAULT_ENCRYPTION_STATE = false;
    protected static final String CONTENT_TYPE = "text/xml";
    protected static final String USER_AGENT = "Apple-Xserve_RAID_Admin/1.5.0";
    protected static final String APPLE_XSYNC = "Apple-Xsync";
    protected String host;
    protected boolean persistent = true;
    protected boolean encrypted = false;
    protected HttpConnection connection;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$AcpxConnection != null ? class$com$apple$xsr$net$AcpxConnection : (class$com$apple$xsr$net$AcpxConnection = AcpxConnection.class$("com.apple.xsr.net.AcpxConnection")));
    static /* synthetic */ Class class$com$apple$xsr$net$AcpxConnection;

    public AcpxConnection(String host) throws IOException {
        if (host == null) {
            throw new NullPointerException("Host cannot be null");
        }
        this.host = host;
        this.createConnection();
    }

    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void disconnect() throws IOException {
        this.close();
    }

    public PropertyList send(RequestMessage request) throws IOException {
        boolean close2;
        PropertyList response;
        block10: {
            if (request == null) {
                throw new NullPointerException("request cannot be null");
            }
            if (this.connection == null) {
                this.createConnection();
            }
            response = null;
            OutputStream out = null;
            InputStream in = null;
            try {
                try {
                    HttpRequest httpRequest = this.connection.newRequest(request.getPath());
                    this.addHeaders(httpRequest, request);
                    this.connection.setTimeout(request.getTimeout());
                    out = this.encrypted ? new SimpleCryptOutputStream(httpRequest.getOutputStream()) : httpRequest.getOutputStream();
                    request.writeTo(out);
                    out.close();
                    logger.debug("Request sent (" + httpRequest.getContentLength() + " bytes) " + "command=\"" + request.getCommand() + "\" " + "target=\"" + request.getTargetController() + "\"");
                    HttpResponse httpResponse = this.connection.getResponse();
                    in = this.encrypted ? new SimpleCryptInputStream(httpResponse.getInputStream()) : httpResponse.getInputStream();
                    if (in.available() != 0) {
                        response = new PropertyList(in);
                    }
                    logger.debug("Response read (" + httpResponse.getContentLength() + " bytes)");
                }
                catch (PropertyListException e) {
                    logger.error(e);
                    throw new IOException("PropertyListException: " + e.getMessage());
                }
                Object var6_10 = null;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                boolean close2;
                Object var6_11 = null;
                if (in != null) {
                    in.close();
                }
                boolean bl = close2 = request.getShutdownConnection() || request.getRestartConnection() != -1;
                if (!this.persistent || close2) {
                    this.connection.disconnect();
                    this.connection = null;
                }
                throw throwable;
            }
            in.close();
        }
        boolean bl = close2 = request.getShutdownConnection() || request.getRestartConnection() != -1;
        if (!this.persistent || close2) {
            this.connection.disconnect();
            this.connection = null;
        }
        return response;
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getHost() {
        return this.getHostAddress();
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setEncrypted(boolean encrypt) {
        this.encrypted = encrypt;
    }

    private void createConnection() throws IOException {
        if (this.connection == null) {
            this.connection = new HttpConnection(this.host);
            this.connection.setPersistent(this.persistent);
            this.connection.open();
        } else {
            logger.warn("Attempt to create a connection with an existing connection open");
        }
    }

    private void addHeaders(HttpRequest httpRequest, RequestMessage acpxRequest) {
        String[] props;
        RequestMessage.Target target;
        boolean close;
        httpRequest.setHeaderField("User-Agent", USER_AGENT);
        boolean bl = close = acpxRequest.getShutdownConnection() || acpxRequest.getRestartConnection() != -1;
        if (!this.persistent || close) {
            httpRequest.setHeaderField("Connection", "close");
        }
        String user = acpxRequest.getUser();
        String password = acpxRequest.getPassword();
        if (user != null) {
            httpRequest.setHeaderField("ACP-User", user);
        }
        if (password != null) {
            httpRequest.setHeaderField("ACP-Password", password);
        }
        if ((target = acpxRequest.getTargetController()) != null) {
            httpRequest.setHeaderField(APPLE_XSYNC, String.valueOf(String.valueOf(target)));
        }
        if (this.encrypted) {
            httpRequest.setHeaderField("Content-Encoding", "acp-crypt");
        }
        if ((props = acpxRequest.getRequestProperties()).length > 0) {
            int i = 0;
            while (i < props.length) {
                logger.info("Adding request property \"" + props[i] + "\" value = \"" + acpxRequest.getRequestProperty(props[i]) + "\"");
                httpRequest.setHeaderField(props[i], acpxRequest.getRequestProperty(props[i]));
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

