/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.net.acp.SimpleCryptCoder;
import com.apple.util.Base64Utilities;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.TestEmail;
import com.apple.xsr.net.AbstractRequestMessage;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.UpdateFirmwareRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AcpxMessageFactory
implements MessageFactory {
    public static final int OUTBAND = 0;
    public static final int INBAND = 1;
    private static final String URL_ACP_GET = "/cgi-bin/acp-get";
    private static final String URL_ACP_SET = "/cgi-bin/acp-set";
    private static final String URL_ACP_ACTION = "/cgi-bin/acp-action";
    private static final String URL_RSP_ACTION = "/cgi-bin/rsp-action";
    private static final String URL_PERFORM_ACTION = "/cgi-bin/perform";
    private static final String URL_NOOP = "/cgi-bin/noop";
    private static final String URL_DIAGNOSTIC_ACTION = "/cgi-bin/diagnostic-action";
    private static final String ILLUMINATE = "led";
    private static final String CREATE_ARRAY = "create-array";
    private static final String DELETE_ARRAY = "delete-array";
    private static final String POWER = "power";
    private static final String GET_POWER_STATE = "power-state-get";
    private static final String RESTART_SYSTEM = "restart";
    private static final String MORSE_CODE = "morse-code";
    private static final String GET_CONTROLLER_PAGE = "get-page";
    private static final String GET_TIME = "get-rtc";
    private static final String SET_TIME = "set-rtc";
    private static final String SET_FIBRE_CHANNEL_SPEED = "set-fibre-channel-speed";
    private static final String JBOD_MASK_ENABLE = "jbod-mask-enable";
    private static final String CLEAR_EVENT_LOG = "clear-log";
    private static final String RESET_CONTROLLER_NVRAM = "raid-reset-nvram";
    private static final String RECALCULATE_CHECK_DATA = "recalculate-check-data";
    private static final String RESTART_CONTROLLER = "restart-controller";
    private static final String GET_POST_RESULTS = "boot-check-results-get";
    private static final String LED_DIAGNOSTIC = "led-test";
    private static final String DISK_DIAGNOSTIC = "drive-test";
    private static final String CONTROLLER_CACHE_DIAGNOSTIC = "dram-test";
    private static final String FIBRE_CHANNEL_DIAGNOSTIC = "fibre-channel-test";
    private static final String SERIAL_INTERFACE_DIAGNOSTIC = "serial-port-test";
    private static final String WRITE_SIGNATURE = "write-signature";
    private static final String READ_SIGNATURE = "read-signature";
    private static final String METHOD_SYSTEM_GET_EVENT_LOG = "/system/get-event-log";
    private static final String METHOD_SYSTEM_CLEAR_EVENT_LOG = "/system/clear-event-log";
    private static final String METHOD_SYSTEM_GET_SYSTEM_STATUS = "/system/get-system-status";
    private static final String METHOD_SYSTEM_MONITOR_RESET = "/system/monitor-reset";
    private static final String METHOD_SYSTEM_SEND_EMAIL = "/system/send-email";
    private static final String METHOD_SYSTEM_SET_LED = "/system/set-led";
    private static final String METHOD_RAID_ARRAY_BGRW = "/raid/array/background-raid-read-and-write";
    private static final String METHOD_RAID_ARRAY_CREATE = "/raid/array/create";
    private static final String METHOD_RAID_ARRAY_EXPAND = "/raid/array/expand";
    private static final String METHOD_RAID_ARRAY_SET_SLICE_SIZE = "/raid/array/set-slice-size";
    private static final String METHOD_RAID_ARRAY_VERIFY_CHECK_DATA = "/raid/array/verify-check-data";
    private static final String METHOD_RAID_FIBRE_TOPOLOGY_CONTROL = "/raid/fibre/topology-control";
    private static final String METHOD_RAID_FIBRE_HARD_LOOP_ID_CONTROL = "/raid/fibre/hard-loop-id-control";
    private static final String METHOD_RAID_FIBRE_HARD_LOOP_ID_SET = "/raid/fibre/hard-loop-id-set";
    private static final String METHOD_RAID_LUN_MASK_CONTROL = "/raid/lun/mask-control";
    private static final String METHOD_RAID_LUN_MASK_SET = "/raid/lun/mask-set";
    private static final String METHOD_RAID_LUN_ASSIGN = "/raid/lun/assign";
    private static final String METHOD_RAID_CACHE_CONTROL = "/raid/cache-control";
    private static final String METHOD_RAID_DRIVE_CACHE_CONTROL = "/raid/drive/cache-control";
    private static final String METHOD_RAID_FLUSH_NVRAM = "/raid/flush-nvram";
    private static final String METHOD_RAID_SET_PREFETCH_SIZE = "/raid/set-prefetch-size";
    private static final String METHOD_RAID_SET_BGRW_THRESHOLD = "/raid/set-background-raid-read-and-write-threshold";
    private static final String METHOD_RAID_SET_SYNCHRONIZE_CACHE = "/raid/set-synchronize-cache";
    private static final String METHOD_RAID_SLOW_READ_BYPASS_MODE_ENABLE = "/raid/real-time-slow-read-bypass-mode-enable";
    private static final String METHOD_RAID_DELETE_BROKEN_RAID_MEMBER = "/raid/delete-broken-raid-member";
    private static final String METHOD_RAID_CHANGE_BROKEN_RAID_ID = "/raid/change-broken-raid-id";
    private static final String GET_TEMPERATURE = "get-temperature";
    private static final String GET_DEVICE_PROPERTIES = "get-device-properties";
    private static final String TIMEOUT = "timeout";
    private static final String DEVICE = "name";
    private static final String DEVICE_ID = "id";
    private static final String DRIVE_ID = "drive-id";
    private static final String ARRAY_ID = "array-id";
    private static final String SLICE_ID = "slice-id";
    private static final String STATE = "state";
    private static final String ACTION = "action";
    private static final String PASSES = "passes";
    private static final String MODE = "mode";
    private static final String PAGE_ID = "page-id";
    private static final String GET_EVENT_LOG_DATE = "date";
    private static final String DATE = "rtc";
    private static final String ENABLE_DISABLE = "enable-disable";
    private static final String SIZE = "size";
    private static final String HOST_INTERFACE = "host-interface-id";
    private static final String SPEED = "speed";
    private static final String TOPOLOGY = "topology";
    private static final String HARD_LOOP_ID = "hard-loop-id";
    private static final String LUN_MASKS = "lun-masks";
    private static final String LUN_ID = "lun-id";
    private static final String SETTINGS = "settings";
    private static final String JBOD_MASK_ENABLED = "enable";
    private static final String JBOD_MASK_DISABLED = "disable";
    private static final String THRESHOLD = "threshold";
    private static final String RAID_LEVEL = "raid-level";
    private static final String STRIPE_SIZE = "stripe-size";
    private static final String MEMBERS = "drive-ids";
    private static final String RAID_TYPE = "raid-type";
    private static final String RPC_ARRAY_ID = "array-id";
    private static final String RPC_RAID_LEVEL = "raid-level";
    private static final String RPC_MEMBERS = "drives";
    private static final String RPC_RAID_TYPE = "raid-type";
    private static final String RPC_RAID_DISK_CACHE_CONTROL = "drive-cache-control";
    private static final String RPC_RAID_DISK_CACHE_ENABLE = "enable";
    private static final String RPC_RAID_DISK_CACHE_DISABLE = "disable";
    private static final String COUNT = "count";
    private static final String SLICE_SIZE_MB = "slice-size-mb";
    private static final String FLAG = "flag";
    private static final String MESSAGE = "message";
    private static final String LED_TYPE = "led-type";
    private static final String DISK = "drive-id";
    private static final String CYLINDER_COUNT = "cylinder-count";
    private static final String PORT1 = "port-1-id";
    private static final String PORT2 = "port-2-id";
    private static final String SIGNATURE = "signature";
    private static final String SIGNATURE_BLOCK_NUMBER = "block-number";
    private static final String SIGNATURE_MAX_SIZE = "max-size";
    private int channel = 0;
    private RequestMessage.Target defaultXsyncTarget;
    private int defaultTimeout = 0;
    private String defaultUser;
    private String defaultPassword;

    public AcpxMessageFactory() {
    }

    public AcpxMessageFactory(int communicationChannel) {
        this.channel = communicationChannel;
    }

    public RequestMessage.Target getDefaultTargetController() {
        return this.defaultXsyncTarget;
    }

    public void setDefaultTargetController(RequestMessage.Target target) {
        this.defaultXsyncTarget = target;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int timeout) {
        this.defaultTimeout = timeout;
    }

    public void setDefaultUser(String user) {
        this.defaultUser = user;
    }

    public void setDefaultPassword(String password) {
        this.setDefaultPassword(password, false);
    }

    public void setDefaultPassword(String password, boolean encrypt) {
        String encrypted = null;
        if (encrypt) {
            try {
                byte[] bytes = SimpleCryptCoder.crypt(password.getBytes("UTF-8"));
                encrypted = Base64Utilities.encode(bytes);
            }
            catch (Exception exception) {}
        } else {
            encrypted = password;
        }
        this.defaultPassword = encrypted;
    }

    public RequestMessage newNoOpRequest() {
        return new 1(this.defaultXsyncTarget, this.defaultTimeout, URL_NOOP);
    }

    public RequestMessage newGetPropertyRequest(String property) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        ArrayList<String> array = new ArrayList<String>();
        array.add(property);
        PropertyList plist = new PropertyList(array);
        return new AcpxRequestMessage(plist, URL_ACP_GET);
    }

    public RequestMessage newGetPropertyRequest(AcpPropertyCode property) {
        if (property == null) {
            throw new NullPointerException("property cannot be null");
        }
        return this.newGetPropertyRequest(property.toString());
    }

    public RequestMessage newGetPropertiesRequest(String[] properties) {
        if (properties == null) {
            throw new NullPointerException("Properties cannot be null");
        }
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < properties.length) {
            if (properties[i] != null) {
                array.add(properties[i]);
            }
            ++i;
        }
        PropertyList plist = new PropertyList(array);
        return new AcpxRequestMessage(plist, URL_ACP_GET);
    }

    public RequestMessage newGetPropertiesRequest(AcpPropertyCode[] properties) {
        if (properties == null) {
            throw new NullPointerException("properties cannot be null");
        }
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < properties.length) {
            if (properties[i] != null) {
                array.add(properties[i].toString());
            }
            ++i;
        }
        PropertyList plist = new PropertyList(array);
        return new AcpxRequestMessage(plist, URL_ACP_GET);
    }

    public RequestMessage newSetPropertyRequest(String property, Object value) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (!PropertyList.isValidElement(value)) {
            throw new IllegalArgumentException("illegal property list element " + value.getClass());
        }
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put(property, value);
        PropertyList plist = new PropertyList(dict);
        return new AcpxRequestMessage(plist, URL_ACP_SET);
    }

    public RequestMessage newSetPropertiesRequest(Map properties) {
        if (properties == null) {
            throw new NullPointerException("Properties cannot be null");
        }
        HashMap dict = new HashMap();
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String property = (String)i.next();
            if (property == null) continue;
            Object value = properties.get(property);
            if (value == null) {
                throw new NullPointerException("Value for \"" + property + "\" cannot be null");
            }
            if (!PropertyList.isValidElement(value)) {
                throw new ClassCastException("Illegal property list element \"" + value.getClass() + "\"");
            }
            dict.put(property, value);
        }
        PropertyList plist = new PropertyList(dict);
        return new AcpxRequestMessage(plist, URL_ACP_SET);
    }

    public RequestMessage newGetStatusRequest() {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_SYSTEM_GET_SYSTEM_STATUS);
        return request;
    }

    public RequestMessage newGetControllerPageRequest(Integer page) {
        AcpxRequestMessage request = new AcpxRequestMessage(GET_CONTROLLER_PAGE, URL_RSP_ACTION);
        request.appendParam(PAGE_ID, page, new Integer(0));
        return request;
    }

    public RequestMessage newGetEventLogRequest(Date date) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_SYSTEM_GET_EVENT_LOG);
        if (date != null) {
            request.appendParam(GET_EVENT_LOG_DATE, date);
        }
        return request;
    }

    public RequestMessage newClearEventLogRequest() {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_SYSTEM_CLEAR_EVENT_LOG);
        return request;
    }

    public RequestMessage newGetTimeRequest() {
        return new AcpxRequestMessage(GET_TIME, URL_RSP_ACTION);
    }

    public RequestMessage newSetTimeRequest(Date date) {
        AcpxRequestMessage request = new AcpxRequestMessage(SET_TIME, URL_RSP_ACTION);
        request.appendParam(DATE, date, new Date());
        return request;
    }

    public RequestMessage newGetTemperatureRequest(String device) {
        AcpxRequestMessage request = new AcpxRequestMessage(GET_TEMPERATURE, URL_DIAGNOSTIC_ACTION);
        request.appendParam(DEVICE, device, "emu");
        return request;
    }

    public RequestMessage newGetDevicePropertiesRequest(String device, Integer id) {
        AcpxRequestMessage request = new AcpxRequestMessage(GET_DEVICE_PROPERTIES, URL_DIAGNOSTIC_ACTION);
        request.appendParam(DEVICE, device, "emu");
        if (id != null) {
            request.appendParam(DEVICE_ID, id, null);
        }
        return request;
    }

    public RequestMessage newIlluminateRequest(String device, Integer id, String state) {
        AcpxRequestMessage request = new AcpxRequestMessage(ILLUMINATE, URL_ACP_ACTION);
        request.appendParam(DEVICE, device, "service");
        if (id != null) {
            request.appendParam(DEVICE_ID, id, null);
        }
        request.appendParam(STATE, state, "on");
        return request;
    }

    public RequestMessage newSystemMonitorResetRequest() {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_SYSTEM_MONITOR_RESET);
        return request;
    }

    public RequestMessage newSetDriveCacheControlRequest(int driveID, boolean enable) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_DRIVE_CACHE_CONTROL);
        request.appendParam("drive-id", new Integer(driveID));
        request.appendParam(STATE, enable ? "enable" : "disable");
        return request;
    }

    public RequestMessage newSetRAIDCacheControlRequest(boolean enable) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_CACHE_CONTROL);
        request.appendParam(STATE, enable ? "enable" : "disable");
        return request;
    }

    public RequestMessage newSetSynchronizeCacheRequest(int state) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_SET_SYNCHRONIZE_CACHE);
        request.appendParam(ENABLE_DISABLE, new Integer(state));
        return request;
    }

    public RequestMessage newSlowReadBypassModeControlRequest(boolean enable) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_SLOW_READ_BYPASS_MODE_ENABLE);
        request.appendParam(ENABLE_DISABLE, new Integer(enable ? 1 : 2));
        return request;
    }

    public RequestMessage newSetRAIDPrefetchSizeRequest(int prefetchSize) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_SET_PREFETCH_SIZE);
        request.appendParam(SIZE, new Integer(prefetchSize));
        return request;
    }

    public RequestMessage newSetFibreChannelSpeedRequest(Integer hostInterface, String speed) {
        AcpxRequestMessage request = new AcpxRequestMessage(SET_FIBRE_CHANNEL_SPEED, URL_RSP_ACTION);
        request.appendParam(HOST_INTERFACE, hostInterface, new Integer(1));
        request.appendParam(SPEED, speed, "auto-negotiated");
        return request;
    }

    public RequestMessage newSetFibreChannelTopologyRequest(String topology) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_FIBRE_TOPOLOGY_CONTROL);
        request.appendParam(TOPOLOGY, topology, "auto");
        return request;
    }

    public RequestMessage newSetFibreChannelHardLoopIDEnableRequest(boolean enable) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_FIBRE_HARD_LOOP_ID_CONTROL);
        request.appendParam(STATE, enable ? "enable" : "disable");
        return request;
    }

    public RequestMessage newSetFibreChannelHardLoopIDRequest(Integer id) {
        if (id < 0 || id > 128) {
            throw new IllegalArgumentException("Illegal hard loop id value = " + id);
        }
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_FIBRE_HARD_LOOP_ID_SET);
        request.appendParam(HARD_LOOP_ID, id);
        return request;
    }

    public RequestMessage newSetFibreChannelLUNMaskEnableRequest(boolean enable) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_LUN_MASK_CONTROL);
        request.appendParam(STATE, enable ? "enable" : "disable");
        return request;
    }

    public RequestMessage newSetFibreChannelLUNMaskRequest(ArrayList lunMaskSettings) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_LUN_MASK_SET);
        request.appendParam(LUN_MASKS, lunMaskSettings);
        return request;
    }

    public RequestMessage newLUNAssignmentRequest(Integer arrayID, Integer sliceID, Integer lunID) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_LUN_ASSIGN);
        request.appendParam("array-id", arrayID);
        request.appendParam(SLICE_ID, sliceID);
        request.appendParam(LUN_ID, lunID);
        return request;
    }

    public RequestMessage newSendEmailRequest(TestEmail email) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_SYSTEM_SEND_EMAIL);
        request.appendParam(SETTINGS, email.toMap());
        return request;
    }

    public RequestMessage newJbodMaskEnableRequest(Boolean enabled) {
        AcpxRequestMessage request = new AcpxRequestMessage(JBOD_MASK_ENABLE, URL_RSP_ACTION);
        String arg = null;
        if (enabled != null) {
            arg = enabled != false ? "enable" : "disable";
        }
        request.appendParam(ENABLE_DISABLE, arg, "enable");
        return request;
    }

    public RequestMessage newFlushRaidControllerNvramRequest() {
        return new RpcRequestMessage(METHOD_RAID_FLUSH_NVRAM);
    }

    public RequestMessage newResetControllerNvramRequest() {
        return new AcpxRequestMessage(RESET_CONTROLLER_NVRAM, URL_ACP_ACTION);
    }

    public RequestMessage newCreateArrayRequest(Integer arrayId, String raidLevel, Integer[] members, String raidType) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_ARRAY_CREATE);
        request.appendParam("array-id", arrayId, new Integer(0));
        request.appendParam("raid-level", raidLevel, "5");
        request.appendParam("raid-type", raidType, "raid-now");
        ArrayList<Integer> memberArray = new ArrayList<Integer>();
        if (members != null) {
            int i = 0;
            while (i < members.length) {
                if (members[i] != null) {
                    memberArray.add(members[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 7) {
                memberArray.add(new Integer(i + 1));
                ++i;
            }
        }
        request.appendParam(RPC_MEMBERS, memberArray);
        request.appendParam(RPC_RAID_DISK_CACHE_CONTROL, "enable", "enable");
        return request;
    }

    public RequestMessage newCreateArrayAcpxRequest(Integer arrayId, String raidLevel, Integer stripeSize, Integer[] members, String raidType) {
        AcpxRequestMessage request = new AcpxRequestMessage(CREATE_ARRAY, URL_ACP_ACTION);
        request.appendParam("array-id", arrayId, new Integer(0));
        request.appendParam("raid-level", raidLevel, "5");
        if (stripeSize != null) {
            request.appendParam(STRIPE_SIZE, stripeSize, AcpxConstants.STRIPE_SIZE_128);
        }
        request.appendParam("raid-type", raidType, "raid-now");
        ArrayList<Integer> memberArray = new ArrayList<Integer>();
        if (members != null) {
            int i = 0;
            while (i < members.length) {
                if (members[i] != null) {
                    memberArray.add(members[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 7) {
                memberArray.add(new Integer(i + 1));
                ++i;
            }
        }
        request.appendParam(MEMBERS, memberArray);
        return request;
    }

    public RequestMessage newDeleteArrayRequest(Integer arrayId) {
        AcpxRequestMessage request = new AcpxRequestMessage(DELETE_ARRAY, URL_ACP_ACTION);
        request.appendParam("array-id", arrayId, new Integer(0));
        return request;
    }

    public RequestMessage newExpandArrayRequest(Integer arrayId, Integer diskCount) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_ARRAY_EXPAND);
        request.appendParam("array-id", arrayId, new Integer(0));
        request.appendParam(COUNT, diskCount, new Integer(0));
        return request;
    }

    public RequestMessage newSetSliceSizeRequest(Integer arrayId, Integer sliceId, Integer sliceSize) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_ARRAY_SET_SLICE_SIZE);
        request.appendParam("array-id", arrayId, new Integer(0));
        request.appendParam(SLICE_ID, sliceId);
        request.appendParam(SLICE_SIZE_MB, sliceSize);
        return request;
    }

    public RequestMessage newVerifyCheckDataRequest(Integer arrayId, String action) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_ARRAY_VERIFY_CHECK_DATA);
        request.appendParam("array-id", arrayId, new Integer(0));
        Integer flag = action.equals("start") ? new Integer(1) : new Integer(2);
        request.appendParam(FLAG, flag, new Integer(1));
        return request;
    }

    public RequestMessage newRecalculateCheckDataRequest(Integer arrayId, String action) {
        AcpxRequestMessage request = new AcpxRequestMessage(RECALCULATE_CHECK_DATA, URL_RSP_ACTION);
        request.appendParam("array-id", arrayId, new Integer(1));
        request.appendParam(ACTION, action, "start");
        return request;
    }

    public RequestMessage newBackgroundReadWriteScanRequest(int arrayId, int actionFlag) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_ARRAY_BGRW);
        request.appendParam("array-id", new Integer(arrayId));
        request.appendParam(FLAG, new Integer(actionFlag));
        return request;
    }

    public RequestMessage newSetBackgroundReadWriteScanThresholdRequest(Integer threshold) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_SET_BGRW_THRESHOLD);
        request.appendParam(THRESHOLD, threshold, new Integer(0));
        return request;
    }

    public RequestMessage newDeleteBrokenRaidMemberRequest(int driveID) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_DELETE_BROKEN_RAID_MEMBER);
        request.appendParam("drive-id", new Integer(driveID));
        return request;
    }

    public RequestMessage newChangeBrokenRaidIdRequest(int driveID, int arrayID) {
        RpcRequestMessage request = new RpcRequestMessage(METHOD_RAID_CHANGE_BROKEN_RAID_ID);
        request.appendParam("drive-id", new Integer(driveID));
        request.appendParam("array-id", new Integer(arrayID));
        return request;
    }

    public RequestMessage newPowerRequest(String action) {
        AcpxRequestMessage request = new AcpxRequestMessage(POWER, URL_ACP_ACTION);
        request.appendParam(ACTION, action, "on");
        return request;
    }

    public RequestMessage newGetPowerStateRequest() {
        return new AcpxRequestMessage(GET_POWER_STATE, URL_ACP_ACTION);
    }

    public RequestMessage newRestartSystemRequest() {
        AcpxRequestMessage request = new AcpxRequestMessage(RESTART_SYSTEM, URL_ACP_ACTION);
        request.setShutdownConnection(true);
        return request;
    }

    public RequestMessage newRestartRaidControllerRequest() {
        return new AcpxRequestMessage(RESTART_CONTROLLER, URL_RSP_ACTION);
    }

    public RequestMessage newClearRaidControllerEventLogRequest() {
        return new AcpxRequestMessage(CLEAR_EVENT_LOG, URL_RSP_ACTION);
    }

    public RequestMessage newMorseCodeRequest(String device, String message) {
        AcpxRequestMessage request = new AcpxRequestMessage(MORSE_CODE, URL_ACP_ACTION);
        request.appendParam(DEVICE, device, "buzzer");
        request.appendParam(MESSAGE, message, "lucy");
        return request;
    }

    public RequestMessage newUpdateFirmwareRequest(int controllerType, int flashType, String imageFile) throws FileNotFoundException {
        return new UpdateFirmwareRequest(this.defaultXsyncTarget, controllerType, flashType, imageFile);
    }

    public RequestMessage newLedDiagnosticRequest(String ledType, String action, Integer passes) {
        AcpxRequestMessage request = new AcpxRequestMessage(LED_DIAGNOSTIC, URL_ACP_ACTION);
        request.appendParam(LED_TYPE, ledType, "drive");
        request.appendParam(ACTION, action, "start");
        request.appendParam(PASSES, passes, new Integer(1));
        return request;
    }

    public RequestMessage newDiskDiagnosticRequest(Integer disk, String action, String mode, Integer cylinderCount, Integer passes) {
        AcpxRequestMessage request = new AcpxRequestMessage(DISK_DIAGNOSTIC, URL_RSP_ACTION);
        request.appendParam("drive-id", disk, new Integer(1));
        request.appendParam(ACTION, action, "start");
        request.appendParam(MODE, mode, "sequential-compare");
        request.appendParam(CYLINDER_COUNT, cylinderCount, new Integer(0));
        request.appendParam(PASSES, passes, new Integer(1));
        return request;
    }

    public RequestMessage newControllerCacheDiagnosticRequest(String mode, Integer passes) {
        AcpxRequestMessage request = new AcpxRequestMessage(CONTROLLER_CACHE_DIAGNOSTIC, URL_RSP_ACTION);
        request.appendParam(MODE, mode, "normal");
        request.appendParam(PASSES, passes, new Integer(1));
        return request;
    }

    public RequestMessage newFibreChannelDiagnosticRequest(String action, Integer passes) {
        AcpxRequestMessage request = new AcpxRequestMessage(FIBRE_CHANNEL_DIAGNOSTIC, URL_RSP_ACTION);
        request.appendParam(ACTION, action, "start");
        request.appendParam(PASSES, passes, new Integer(1));
        return request;
    }

    public RequestMessage newSerialInterfaceDiagnosticRequest(Integer port1, Integer port2, String action, Integer passes) {
        AcpxRequestMessage request = new AcpxRequestMessage(SERIAL_INTERFACE_DIAGNOSTIC, URL_RSP_ACTION);
        request.appendParam(PORT1, port1, new Integer(1));
        request.appendParam(PORT2, port2, new Integer(2));
        request.appendParam(ACTION, action, "start");
        request.appendParam(PASSES, passes, new Integer(1));
        return request;
    }

    public RequestMessage newGetPostResultsRequest() {
        AcpxRequestMessage request = new AcpxRequestMessage(GET_POST_RESULTS, URL_RSP_ACTION);
        return request;
    }

    public RequestMessage newWriteSignatureRequest(Integer block, String signature) {
        AcpxRequestMessage request = new AcpxRequestMessage(WRITE_SIGNATURE, URL_RSP_ACTION);
        request.appendParam(SIGNATURE_BLOCK_NUMBER, block, new Integer(32768));
        byte[] bytes = null;
        try {
            if (signature != null) {
                int size = 0;
                do {
                    if ((size = (signature.getBytes("UTF-8").length + 2) / 3 * 4) <= 512) continue;
                    signature = signature.substring(0, signature.length() - 1);
                } while (size > 512);
                bytes = signature.getBytes("UTF-8");
            } else {
                bytes = new String("LCM+SBH").getBytes("UTF-8");
            }
            request.appendParam(SIGNATURE, bytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return request;
    }

    public RequestMessage newReadSignatureRequest(Integer block, Integer maxSize) {
        AcpxRequestMessage request = new AcpxRequestMessage(READ_SIGNATURE, URL_RSP_ACTION);
        request.appendParam(SIGNATURE_BLOCK_NUMBER, block, new Integer(32768));
        request.appendParam(SIGNATURE_MAX_SIZE, maxSize, new Integer(512));
        return request;
    }

    private final class 1
    extends AbstractRequestMessage {
        public void writeTo(OutputStream stream) {
        }

        /* synthetic */ 1(RequestMessage.Target $0, int $1, String $2) {
            super($0, $1, $2);
        }
    }

    private static abstract class AcpxRequestTemplate
    extends AbstractRequestMessage {
        PropertyList plist;
        Map paramDict;

        public AcpxRequestTemplate(RequestMessage.Target target, int timeout, String path) {
            super(target, timeout, path);
        }

        public AcpxRequestTemplate(RequestMessage.Target target, int timeout, String path, String command) {
            super(target, timeout, path, command);
        }

        public void writeTo(OutputStream stream) throws IOException {
            if (stream == null) {
                throw new NullPointerException("OutputStream cannot be null");
            }
            if (this.plist == null) {
                throw new NullPointerException("Request message PList is null");
            }
            try {
                this.plist.writeTo(stream);
            }
            catch (PropertyListException e) {
                throw new IOException("Error parsing property list to XML: " + e.getMessage());
            }
        }

        public void appendParam(String param, String value, String defaultValue) {
            if (param == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (value == null && defaultValue == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (value != null) {
                this.paramDict.put(param, value);
            } else {
                this.paramDict.put(param, defaultValue);
            }
        }

        public void appendParam(String param, Integer value, Integer defaultValue) {
            if (param == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (value == null && defaultValue == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (value != null) {
                this.paramDict.put(param, value);
            } else {
                this.paramDict.put(param, defaultValue);
            }
        }

        public void appendParam(String param, Date value, Date defaultValue) {
            if (param == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (value == null && defaultValue == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (value != null) {
                this.paramDict.put(param, value);
            } else {
                this.paramDict.put(param, defaultValue);
            }
        }

        public void appendParam(String param, Object value) {
            if (param == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (value == null) {
                throw new NullPointerException("Value cannot be null");
            }
            if (!PropertyList.isValidElement(value)) {
                throw new IllegalArgumentException("illegal plist element " + value.getClass());
            }
            this.paramDict.put(param, value);
        }

        public String toString() {
            String s = String.valueOf(super.toString()) + "\nContent:\n" + this.plist.toString();
            return s;
        }

        public Object clone() {
            AcpxRequestTemplate result = (AcpxRequestTemplate)super.clone();
            return result;
        }
    }

    private class AcpxRequestMessage
    extends AcpxRequestTemplate {
        public AcpxRequestMessage(String command, String path) {
            this(command, path, true);
        }

        public AcpxRequestMessage(String command, String path, boolean appendCommonParams) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, path, command);
            if (command == null) {
                throw new NullPointerException("command cannot be null");
            }
            if (path == null) {
                throw new NullPointerException("path cannot be null");
            }
            this.paramDict = new HashMap();
            if (appendCommonParams && this.timeout != 0) {
                this.paramDict.put(AcpxMessageFactory.TIMEOUT, new Integer(this.timeout));
            }
            HashMap<String, Map> commandDict = new HashMap<String, Map>();
            commandDict.put(this.command, this.paramDict);
            this.plist = new PropertyList(commandDict);
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public AcpxRequestMessage(PropertyList plist, String path) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, path);
            if (plist == null) {
                throw new NullPointerException("PropertyList cannot be null");
            }
            this.plist = plist;
            this.path = path;
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public Object clone() {
            HashMap root;
            AcpxRequestMessage result = (AcpxRequestMessage)super.clone();
            result.plist = new PropertyList(this.plist);
            if (result.paramDict != null && result.plist != null && (root = (HashMap)result.plist.getRootElement()) != null) {
                result.paramDict = (Map)root.get(this.command);
            }
            return result;
        }
    }

    private class RpcRequestMessage
    extends AcpxRequestTemplate {
        public RpcRequestMessage(String method) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, AcpxMessageFactory.URL_PERFORM_ACTION, method);
            if (method == null) {
                throw new NullPointerException("method cannot be null");
            }
            this.paramDict = new HashMap();
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("method", method);
            request.put("inputs", this.paramDict);
            ArrayList<HashMap<String, Object>> requestsArray = new ArrayList<HashMap<String, Object>>();
            requestsArray.add(request);
            HashMap<String, ArrayList<HashMap<String, Object>>> rootDict = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            rootDict.put("requests", requestsArray);
            this.plist = new PropertyList(rootDict);
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public Object clone() {
            RpcRequestMessage result = (RpcRequestMessage)super.clone();
            return result;
        }
    }
}

